/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.person;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.address.IPostalAddress;
import com.helger.masterdata.address.PostalAddress;
import com.helger.masterdata.person.Person;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PersonAddress
extends PostalAddress {
    private Person m_aOwner;

    public PersonAddress() {
    }

    public PersonAddress(@Nonnull Person person) {
        this.setOwner(person);
    }

    public PersonAddress(@Nonnull Person person, @Nonnull IPostalAddress iPostalAddress, @Nonnull Locale locale) {
        super(iPostalAddress, locale);
        this.setOwner(person);
    }

    @Nullable
    public Person getOwner() {
        return this.m_aOwner;
    }

    public final void setOwner(@Nonnull Person person) {
        ValueEnforcer.notNull((Object)person, (String)"Owner");
        this.m_aOwner = person;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        PersonAddress personAddress = (PersonAddress)object;
        return EqualsHelper.equals((Object)this.m_aOwner, (Object)personAddress.m_aOwner);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aOwner).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("owner", (Object)this.m_aOwner).getToString();
    }
}

