/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.person;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.masterdata.person.IPersonName;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PersonNameHelper {
    public static final boolean DEFAULT_COMPLEX_NAME_HANDLING = false;
    public static final boolean DEFAULT_FIRST_NAME_FIRST = true;
    private static final String[] NOBILIARY_PARTICLES = new String[]{"aw", "da", "dalla", "de", "degli", "del", "dem", "der", "di", "du", "of", "ter", "thoe", "tot", "und", "v.", "van", "vom", "von", "zu", "zum"};
    private static final AtomicBoolean s_aComplexNameHandlingEnabled = new AtomicBoolean(false);
    private static final AtomicBoolean s_aFirstNameFirst = new AtomicBoolean(true);

    private PersonNameHelper() {
    }

    public static void setComplexNameHandlingEnabled(boolean bl) {
        s_aComplexNameHandlingEnabled.set(bl);
    }

    public static boolean isComplexNameHandlingEnabled() {
        return s_aComplexNameHandlingEnabled.get();
    }

    public static void setFirstNameFirst(boolean bl) {
        s_aFirstNameFirst.set(bl);
    }

    public static boolean isFirstNameFirst() {
        return s_aFirstNameFirst.get();
    }

    @Nullable
    private static String _unifySinglePart(@Nonnull String string, @Nonnull Locale locale) {
        String string2 = string.trim();
        int n = string2.length();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return string2.toUpperCase(locale);
        }
        if (ArrayHelper.contains((Object[])NOBILIARY_PARTICLES, (Object)(string2 = string2.substring(0, 1).toUpperCase(locale) + string2.substring(1).toLowerCase(locale)))) {
            string2 = string2.toLowerCase(locale);
        }
        return string2;
    }

    @Nullable
    public static String unifyName(@Nullable String string, @Nonnull Locale locale) {
        if (string == null) {
            return null;
        }
        if (!PersonNameHelper.isComplexNameHandlingEnabled()) {
            if (string.length() <= 1) {
                return string.toUpperCase(locale);
            }
            return string.substring(0, 1).toUpperCase(locale) + string.substring(1);
        }
        String string2 = PersonNameHelper._unifySinglePart(string, locale);
        if (string2 == null) {
            return null;
        }
        for (char c : new char[]{' ', '-'}) {
            String[] stringArray = StringHelper.getExplodedArray((char)c, (String)string2);
            if (stringArray.length <= 1) continue;
            StringBuilder stringBuilder = new StringBuilder(string2.length());
            for (String string3 : stringArray) {
                String string4 = PersonNameHelper._unifySinglePart(string3, locale);
                if (string4 == null) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(c);
                }
                stringBuilder.append(string4);
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    @Nonnull
    public static String getAsDisplayNameFirstNameFirst(@Nonnull IPersonName iPersonName) {
        return StringHelper.getImplodedNonEmpty((char)' ', (String[])new String[]{iPersonName.getFirstName(), iPersonName.getMiddleName(), iPersonName.getLastName()});
    }

    @Nonnull
    public static String getAsDisplayNameLastNameFirst(@Nonnull IPersonName iPersonName) {
        return StringHelper.getImplodedNonEmpty((char)' ', (String[])new String[]{iPersonName.getLastName(), iPersonName.getFirstName(), iPersonName.getMiddleName()});
    }

    @Nonnull
    public static String getAsDisplayName(@Nonnull IPersonName iPersonName) {
        if (PersonNameHelper.isFirstNameFirst()) {
            return PersonNameHelper.getAsDisplayNameFirstNameFirst(iPersonName);
        }
        return PersonNameHelper.getAsDisplayNameLastNameFirst(iPersonName);
    }

    @Nonnull
    public static String getAsCompleteDisplayNameFirstNameFirst(@Nonnull IPersonName iPersonName) {
        return StringHelper.getImplodedNonEmpty((char)' ', (String[])new String[]{iPersonName.getPrefixTitle(), iPersonName.getFirstName(), iPersonName.getMiddleName(), iPersonName.getLastName(), iPersonName.getSuffixTitle()});
    }

    @Nonnull
    public static String getAsCompleteDisplayNameLastNameFirst(@Nonnull IPersonName iPersonName) {
        return StringHelper.getImplodedNonEmpty((char)' ', (String[])new String[]{iPersonName.getPrefixTitle(), iPersonName.getLastName(), iPersonName.getFirstName(), iPersonName.getMiddleName(), iPersonName.getSuffixTitle()});
    }

    @Nonnull
    public static String getAsCompleteDisplayName(@Nonnull IPersonName iPersonName) {
        if (PersonNameHelper.isFirstNameFirst()) {
            return PersonNameHelper.getAsCompleteDisplayNameFirstNameFirst(iPersonName);
        }
        return PersonNameHelper.getAsCompleteDisplayNameLastNameFirst(iPersonName);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getAllNobiliaryParticles() {
        return new CommonsArrayList((Object[])NOBILIARY_PARTICLES);
    }
}

