/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.address;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.masterdata.address.EPostalAddressText;
import com.helger.masterdata.address.IPostalAddressType;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EPostalAddressType implements IPostalAddressType
{
    PERSONAL("pers", EPostalAddressText.MSG_TYPE_PERSONAL),
    PERSONAL2("pers2", EPostalAddressText.MSG_TYPE_PERSONAL2),
    OFFICE("off", EPostalAddressText.MSG_TYPE_OFFICE),
    OFFICE2("off2", EPostalAddressText.MSG_TYPE_OFFICE2),
    OTHER("oth", EPostalAddressText.MSG_TYPE_OTHER);

    private final String m_sID;
    private final IHasDisplayText m_aText;

    private EPostalAddressType(String string2, EPostalAddressText ePostalAddressText) {
        this.m_sID = string2;
        this.m_aText = ePostalAddressText;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aText.getDisplayText(locale);
    }

    @Nullable
    public static EPostalAddressType getFromIDOrNull(@Nullable String string) {
        return (EPostalAddressType)EnumHelper.getFromIDOrNull(EPostalAddressType.class, (Object)string);
    }

    @Nullable
    public static EPostalAddressType getFromIDOrDefault(@Nullable String string, @Nullable EPostalAddressType ePostalAddressType) {
        return (EPostalAddressType)EnumHelper.getFromIDOrDefault(EPostalAddressType.class, (Object)string, (Enum)ePostalAddressType);
    }
}

