/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.nuts;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.name.IHasDisplayName;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.nuts.ENutsLevel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class LauItem
implements IHasID<String>,
IHasDisplayName {
    public static final int ID_MIN_LENGTH = 1;
    public static final int ID_MAX_LENGTH = 13;
    private final String m_sLau;
    private final String m_sNuts;
    private final String m_sDisplayName;
    private final String m_sLatinDisplayName;

    public LauItem(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nullable String string4) {
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"LAU");
        ValueEnforcer.isTrue(() -> string2.length() >= 1 && string2.length() <= 13, () -> "Odd LAU length of '" + string2 + "'");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"NUTS");
        ValueEnforcer.isTrue(() -> string.length() <= ENutsLevel.NUTS3.getCharCount(), (String)("() ->Odd NUTS length of '" + string + "'"));
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"Name");
        this.m_sLau = string2;
        this.m_sNuts = string;
        this.m_sDisplayName = string3;
        this.m_sLatinDisplayName = StringHelper.hasText((String)string4) ? string4 : string3;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sNuts + this.m_sLau;
    }

    @Nonnull
    @Nonempty
    public String getLauCode() {
        return this.m_sLau;
    }

    @Nonnull
    @Nonempty
    public String getCountryCode() {
        return this.m_sNuts.substring(0, 2);
    }

    @Nonnull
    @Nonempty
    public String getNutsCode() {
        return this.m_sNuts;
    }

    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nonnull
    @Nonempty
    public String getLatinDisplayName() {
        return this.m_sLatinDisplayName;
    }

    public String toString() {
        return new ToStringGenerator(null).append("ID", (Object)this.m_sLau).append("Nuts3", (Object)this.m_sNuts).append("DisplayName", (Object)this.m_sDisplayName).append("LatinDisplayName", (Object)this.m_sLatinDisplayName).getToString();
    }
}

