/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.postal;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

enum EPostalCodeFormatElement {
    LETTER("A", "[a-zA-Z]", "A"),
    NUMBER("N", "[0-9]", "1"),
    COUNTRY_CODE("CC", null, null),
    SPACE(" ", " ", " "),
    DASH("-", "\\-", "-");

    private final String m_sToken;
    private final String m_sRegEx;
    private final String m_sExample;

    private EPostalCodeFormatElement(@Nullable String string2, String string3, String string4) {
        this.m_sToken = string2;
        this.m_sRegEx = string3;
        this.m_sExample = string4;
    }

    @Nonnull
    @Nonempty
    public String getToken() {
        return this.m_sToken;
    }

    @Nonnegative
    public int getTokenLength() {
        return this.m_sToken.length();
    }

    @Nullable
    public String getRegEx() {
        return this.m_sRegEx;
    }

    @Nullable
    public String getExample() {
        return this.m_sExample;
    }

    @Nullable
    public static EPostalCodeFormatElement getFromString(@Nullable String string, int n) {
        if (StringHelper.hasText((String)string)) {
            for (EPostalCodeFormatElement ePostalCodeFormatElement : EPostalCodeFormatElement.values()) {
                if (!string.substring(n, n + ePostalCodeFormatElement.getTokenLength()).equals(ePostalCodeFormatElement.getToken())) continue;
                return ePostalCodeFormatElement;
            }
        }
        return null;
    }
}

