/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.price;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.currency.ECurrency;
import com.helger.masterdata.price.IMutablePrice;
import com.helger.masterdata.price.IMutablePriceGraduation;
import com.helger.masterdata.price.IMutablePriceGraduationItem;
import com.helger.masterdata.price.IPriceGraduationItem;
import com.helger.masterdata.price.Price;
import com.helger.masterdata.price.PriceGraduationItem;
import com.helger.masterdata.vat.IVATItem;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PriceGraduation
implements IMutablePriceGraduation,
Serializable {
    private final ECurrency m_eCurrency;
    private final ICommonsList<IMutablePriceGraduationItem> m_aItems = new CommonsArrayList();

    public PriceGraduation(@Nonnull ECurrency eCurrency) {
        this.m_eCurrency = (ECurrency)((Object)ValueEnforcer.notNull((Object)((Object)eCurrency), (String)"Currency"));
    }

    @Override
    @Nonnull
    public final ECurrency getCurrency() {
        return this.m_eCurrency;
    }

    @Override
    @Nullable
    public IMutablePriceGraduationItem getSmallestMinimumQuantityItem() {
        return (IMutablePriceGraduationItem)this.m_aItems.getFirstOrNull();
    }

    @Override
    @Nullable
    public IMutablePriceGraduationItem getLargestMinimumQuantityItem() {
        return (IMutablePriceGraduationItem)this.m_aItems.getLastOrNull();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<? extends IMutablePriceGraduationItem> getAllItems() {
        return (ICommonsList)this.m_aItems.getClone();
    }

    @Override
    @Nullable
    public IMutablePriceGraduationItem getItemOfIndex(@Nonnegative int n) {
        return (IMutablePriceGraduationItem)this.m_aItems.getAtIndex(n);
    }

    @Nonnull
    private IMutablePriceGraduationItem _getItemOfQuantity(@Nonnegative int n) {
        IMutablePriceGraduationItem iMutablePriceGraduationItem;
        ValueEnforcer.isGT0((int)n, (String)"Quantity");
        IMutablePriceGraduationItem iMutablePriceGraduationItem2 = null;
        Iterator iterator = this.m_aItems.iterator();
        while (iterator.hasNext() && (iMutablePriceGraduationItem = (IMutablePriceGraduationItem)iterator.next()).getMinimumQuantity() <= n) {
            iMutablePriceGraduationItem2 = iMutablePriceGraduationItem;
        }
        if (iMutablePriceGraduationItem2 == null) {
            throw new IllegalStateException("Failed to resolve item of quantity " + n + " in " + this.toString());
        }
        return iMutablePriceGraduationItem2;
    }

    @Nonnull
    private IMutablePrice _createPrice(@Nonnull BigDecimal bigDecimal, @Nonnull IVATItem iVATItem) {
        return new Price(this.m_eCurrency, bigDecimal, iVATItem);
    }

    @Override
    @Nonnull
    public IMutablePrice getPrice(@Nonnull IPriceGraduationItem iPriceGraduationItem, @Nonnull IVATItem iVATItem) {
        ValueEnforcer.notNull((Object)iPriceGraduationItem, (String)"Item");
        ValueEnforcer.notNull((Object)iVATItem, (String)"VATItem");
        if (!this.m_aItems.contains((Object)iPriceGraduationItem)) {
            throw new IllegalArgumentException("passed item is not contained in this price graduation: " + iPriceGraduationItem);
        }
        return this._createPrice(iPriceGraduationItem.getUnitNetAmount(), iVATItem);
    }

    @Override
    @Nonnull
    public IMutablePrice getSinglePriceOfQuantity(@Nonnegative int n, @Nonnull IVATItem iVATItem) {
        ValueEnforcer.notNull((Object)iVATItem, (String)"VATItem");
        return this._createPrice(this._getItemOfQuantity(n).getUnitNetAmount(), iVATItem);
    }

    @Override
    @Nonnull
    public IMutablePrice getTotalPriceOfQuantity(@Nonnegative int n, @Nonnull IVATItem iVATItem) {
        return this.getSinglePriceOfQuantity(n, iVATItem).getMultiplied(n);
    }

    @Override
    @Nonnull
    public EChange addItem(@Nonnegative int n, @Nonnull BigDecimal bigDecimal) {
        return this.addItem(new PriceGraduationItem(n, bigDecimal));
    }

    @Override
    @Nonnull
    public EChange addItem(@Nonnull IMutablePriceGraduationItem iMutablePriceGraduationItem) {
        ValueEnforcer.notNull((Object)iMutablePriceGraduationItem, (String)"Item");
        int n = 0;
        int n2 = iMutablePriceGraduationItem.getMinimumQuantity();
        for (IMutablePriceGraduationItem iMutablePriceGraduationItem2 : this.m_aItems) {
            int n3 = iMutablePriceGraduationItem2.getMinimumQuantity();
            if (n3 == n2) {
                throw new IllegalArgumentException("Another item with the exact same quantity is already contained: " + n3);
            }
            if (n2 <= n3) continue;
            ++n;
        }
        this.m_aItems.add(n, (Object)iMutablePriceGraduationItem);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAll() {
        return this.m_aItems.removeAll();
    }

    public boolean isEmpty() {
        return this.m_aItems.isEmpty();
    }

    @Nonnegative
    public int size() {
        return this.m_aItems.size();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PriceGraduation priceGraduation = (PriceGraduation)object;
        return EqualsHelper.equals((Object)((Object)this.m_eCurrency), (Object)((Object)priceGraduation.m_eCurrency)) && this.m_aItems.equals(priceGraduation.m_aItems);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eCurrency).append(this.m_aItems).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("currency", (Enum)this.m_eCurrency).append("items", this.m_aItems).getToString();
    }

    @Nonnull
    public static IMutablePriceGraduation createSimple(@Nonnull IMutablePrice iMutablePrice) {
        PriceGraduation priceGraduation = new PriceGraduation(iMutablePrice.getCurrency());
        priceGraduation.addItem(new PriceGraduationItem(1, iMutablePrice.getNetAmount().getValue()));
        return priceGraduation;
    }
}

