/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.vat;

import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.period.LocalDatePeriod;
import com.helger.masterdata.vat.EVATItemText;
import com.helger.masterdata.vat.EVATItemType;
import com.helger.masterdata.vat.IVATItem;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class VATItem
implements IVATItem,
Serializable {
    private final String m_sID;
    private final Locale m_aCountry;
    private final EVATItemType m_eType;
    private final BigDecimal m_aPercentage;
    private final BigDecimal m_aPercentageFactor;
    private final BigDecimal m_aMultiplicationFactorNetToGross;
    private final boolean m_bDeprecated;
    private final LocalDatePeriod m_aPeriod;

    public VATItem(@Nonnull @Nonempty String string, @Nullable Locale locale, @Nonnull EVATItemType eVATItemType, @Nonnull @Nonnegative BigDecimal bigDecimal, boolean bl, @Nullable LocalDate localDate, @Nullable LocalDate localDate2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        ValueEnforcer.notNull((Object)((Object)eVATItemType), (String)"Type");
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Percentage");
        ValueEnforcer.isBetweenInclusive((BigDecimal)bigDecimal, (String)"Percentage", (BigDecimal)BigDecimal.ZERO, (BigDecimal)CGlobal.BIGDEC_100);
        if (localDate != null && localDate2 != null && localDate2.isBefore(localDate)) {
            throw new IllegalArgumentException("ValidFrom date must be <= validTo date");
        }
        this.m_sID = string;
        this.m_aCountry = CountryCache.getInstance().getCountry(locale);
        this.m_eType = eVATItemType;
        this.m_aPercentage = bigDecimal;
        this.m_aPercentageFactor = this.m_aPercentage.divide(CGlobal.BIGDEC_100);
        this.m_aMultiplicationFactorNetToGross = BigDecimal.ONE.add(this.m_aPercentageFactor);
        this.m_bDeprecated = bl;
        this.m_aPeriod = new LocalDatePeriod(localDate, localDate2);
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nullable
    public Locale getCountry() {
        return this.m_aCountry;
    }

    @Override
    @Nonnull
    public EVATItemType getType() {
        return this.m_eType;
    }

    @Override
    @Nonnull
    @Nonnegative
    public BigDecimal getPercentage() {
        return this.m_aPercentage;
    }

    @Override
    @Nonnull
    @Nonnegative
    public BigDecimal getPercentageFactor() {
        return this.m_aPercentageFactor;
    }

    @Override
    @Nonnull
    @Nonnegative
    public BigDecimal getMultiplicationFactorNetToGross() {
        return this.m_aMultiplicationFactorNetToGross;
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return EVATItemText.VAT_PERC.getDisplayTextWithArgs(locale, new Object[]{this.m_aPercentage});
    }

    @Override
    public boolean isDeprecated() {
        return this.m_bDeprecated;
    }

    @Nonnull
    public LocalDatePeriod getPeriod() {
        return this.m_aPeriod;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        VATItem vATItem = (VATItem)object;
        return this.m_sID.equals(vATItem.m_sID) && EqualsHelper.equals((Object)this.m_aCountry, (Object)vATItem.m_aCountry) && this.m_eType.equals((Object)vATItem.m_eType) && EqualsHelper.equals((Object)this.m_aPercentage, (Object)vATItem.m_aPercentage) && this.m_bDeprecated == vATItem.m_bDeprecated && this.m_aPeriod.equals((Object)vATItem.m_aPeriod);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).append((Object)this.m_aCountry).append((Enum)this.m_eType).append((Object)this.m_aPercentage).append(this.m_bDeprecated).append((Object)this.m_aPeriod).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("Country", (Object)this.m_aCountry).append("Type", (Enum)this.m_eType).append("Percentage", (Object)this.m_aPercentage).append("PercentageFactor", (Object)this.m_aPercentageFactor).append("MultiplicationFactorNetToGross", (Object)this.m_aMultiplicationFactorNetToGross).append("Deprecated", this.m_bDeprecated).append("Period", (Object)this.m_aPeriod).getToString();
    }

    @Nonnull
    public static VATItem createTestItem(@Nullable Locale locale, @Nonnull EVATItemType eVATItemType, @Nonnull @Nonnegative BigDecimal bigDecimal) {
        String string = (locale != null ? locale.getCountry().toLowerCase(Locale.US) : "zero") + "." + bigDecimal.intValue() + "/" + GlobalIDFactory.getNewStringID();
        return new VATItem(string, locale, eVATItemType, bigDecimal, false, null, null);
    }
}

