/*
 * Copyright (C) 2014-2024 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.tenancy.datetime;

import javax.annotation.Nullable;

import com.helger.commons.string.StringHelper;
import com.helger.datetime.domain.IHasDeletionDateTime;

/**
 * Base interface for an object that has a date time and a user ID.
 *
 * @author Philip Helger
 */
public interface IHasDeletionInfo extends IHasDeletionDateTime
{
  /**
   * @return The user ID who deleted the object or <code>null</code> if this
   *         object has not yet been deleted.
   */
  @Nullable
  String getDeletionUserID ();

  /**
   * @return <code>true</code> if a deletion user is present, <code>false</code>
   *         if not.
   * @since 6.1.1
   */
  default boolean hasDeletionUserID ()
  {
    return StringHelper.hasText (getDeletionUserID ());
  }
}
