/*
 * Copyright (C) 2014-2024 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.tenancy.tenant;

import javax.annotation.concurrent.Immutable;

import com.helger.commons.annotation.PresentForCodeCoverage;

/**
 * Constants for tenants etc.
 *
 * @author Philip Helger
 */
@Immutable
public final class CTenant
{
  public static final String GLOBAL_TENANT_ID = "$";
  public static final String GLOBAL_TENANT_NAME = "$system tenant$";

  @PresentForCodeCoverage
  private static final CTenant INSTANCE = new CTenant ();

  private CTenant ()
  {}
}
