/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.mjiip.v_4_0;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Mojo(name="help", requiresProject=false, threadSafe=true)
public class HelpMojo
extends AbstractMojo {
    @Parameter(property="detail", defaultValue="false")
    private boolean detail;
    @Parameter(property="goal")
    private String goal;
    @Parameter(property="lineLength", defaultValue="80")
    private int lineLength;
    @Parameter(property="indentSize", defaultValue="2")
    private int indentSize;
    private static final String PLUGIN_HELP_PATH = "/META-INF/maven/com.helger.maven/jaxb40-maven-plugin/plugin-help.xml";
    private static final int DEFAULT_LINE_LENGTH = 80;

    private Document build() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"load plugin-help.xml: /META-INF/maven/com.helger.maven/jaxb40-maven-plugin/plugin-help.xml");
        InputStream inputStream = null;
        try {
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(PLUGIN_HELP_PATH);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (IOException iOException) {
            throw new MojoExecutionException(iOException.getMessage(), (Exception)iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MojoExecutionException(parserConfigurationException.getMessage(), (Exception)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new MojoExecutionException(sAXException.getMessage(), (Exception)sAXException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new MojoExecutionException(iOException.getMessage(), (Exception)iOException);
                }
            }
        }
    }

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        Document document = this.build();
        StringBuilder stringBuilder = new StringBuilder();
        Node node = this.getSingleChild(document, "plugin");
        String string = this.getValue(node, "name");
        String string2 = this.getValue(node, "version");
        String string3 = this.getValue(node, "groupId") + ":" + this.getValue(node, "artifactId") + ":" + string2;
        if (HelpMojo.isNotEmpty(string) && !string.contains(string3)) {
            this.append(stringBuilder, string + " " + string2, 0);
        } else if (HelpMojo.isNotEmpty(string)) {
            this.append(stringBuilder, string, 0);
        } else {
            this.append(stringBuilder, string3, 0);
        }
        this.append(stringBuilder, this.getValue(node, "description"), 1);
        this.append(stringBuilder, "", 0);
        String string4 = this.getValue(node, "goalPrefix");
        Node node2 = this.getSingleChild(node, "mojos");
        List<Node> list = this.findNamedChild(node2, "mojo");
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(stringBuilder, "This plugin has " + list.size() + (list.size() > 1 ? " goals:" : " goal:"), 0);
            this.append(stringBuilder, "", 0);
        }
        for (Node node3 : list) {
            this.writeGoal(stringBuilder, string4, (Element)node3);
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)stringBuilder.toString());
        }
    }

    private static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    private String getValue(Node node, String string) throws MojoExecutionException {
        return this.getSingleChild(node, string).getTextContent();
    }

    private Node getSingleChild(Node node, String string) throws MojoExecutionException {
        List<Node> list = this.findNamedChild(node, string);
        if (list.isEmpty()) {
            throw new MojoExecutionException("Could not find " + string + " in plugin-help.xml");
        }
        if (list.size() > 1) {
            throw new MojoExecutionException("Multiple " + string + " in plugin-help.xml");
        }
        return list.get(0);
    }

    private List<Node> findNamedChild(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!string.equals(node2.getNodeName())) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    private Node findSingleChild(Node node, String string) throws MojoExecutionException {
        List<Node> list = this.findNamedChild(node, string);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new MojoExecutionException("Multiple " + string + "in plugin-help.xml");
        }
        return list.get(0);
    }

    private void writeGoal(StringBuilder stringBuilder, String string, Element element) throws MojoExecutionException {
        String string2 = this.getValue(element, "goal");
        Node node = this.findSingleChild(element, "configuration");
        Node node2 = this.findSingleChild(element, "description");
        if (this.goal == null || this.goal.length() <= 0 || string2.equals(this.goal)) {
            this.append(stringBuilder, string + ":" + string2, 0);
            Node node3 = this.findSingleChild(element, "deprecated");
            if (node3 != null && HelpMojo.isNotEmpty(node3.getTextContent())) {
                this.append(stringBuilder, "Deprecated. " + node3.getTextContent(), 1);
                if (this.detail && node2 != null) {
                    this.append(stringBuilder, "", 0);
                    this.append(stringBuilder, node2.getTextContent(), 1);
                }
            } else if (node2 != null) {
                this.append(stringBuilder, node2.getTextContent(), 1);
            }
            this.append(stringBuilder, "", 0);
            if (this.detail) {
                Node node4 = this.getSingleChild(element, "parameters");
                List<Node> list = this.findNamedChild(node4, "parameter");
                this.append(stringBuilder, "Available parameters:", 1);
                this.append(stringBuilder, "", 0);
                for (Node node5 : list) {
                    this.writeParameter(stringBuilder, node5, node);
                }
            }
        }
    }

    private void writeParameter(StringBuilder stringBuilder, Node node, Node node2) throws MojoExecutionException {
        String string = this.getValue(node, "name");
        String string2 = this.getValue(node, "description");
        Element element = null;
        if (node2 != null) {
            element = (Element)this.findSingleChild(node2, string);
        }
        Object object = "";
        if (element != null && element.hasAttribute("default-value")) {
            object = " (Default: " + element.getAttribute("default-value") + ")";
        }
        this.append(stringBuilder, string + (String)object, 2);
        Node node3 = this.findSingleChild(node, "deprecated");
        if (node3 != null && HelpMojo.isNotEmpty(node3.getTextContent())) {
            this.append(stringBuilder, "Deprecated. " + node3.getTextContent(), 3);
            this.append(stringBuilder, "", 0);
        }
        this.append(stringBuilder, string2, 3);
        if ("true".equals(this.getValue(node, "required"))) {
            this.append(stringBuilder, "Required: Yes", 3);
        }
        if (element != null && HelpMojo.isNotEmpty(element.getTextContent())) {
            String string3 = this.getPropertyFromExpression(element.getTextContent());
            this.append(stringBuilder, "User property: " + string3, 3);
        }
        this.append(stringBuilder, "", 0);
    }

    private static String repeat(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(n * string.length());
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private void append(StringBuilder stringBuilder, String string, int n) {
        for (String string2 : HelpMojo.toLines(string, n, this.indentSize, this.lineLength)) {
            stringBuilder.append(string2).append('\n');
        }
    }

    private static List<String> toLines(String string, int n, int n2, int n3) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = HelpMojo.repeat("\t", n);
        for (String string3 : stringArray = string.split("(\r\n)|(\r)|(\n)")) {
            HelpMojo.toLines(arrayList, string2 + string3, n2, n3);
        }
        return arrayList;
    }

    private static void toLines(List<String> list, String string, int n, int n2) {
        String[] stringArray;
        int n3 = HelpMojo.getIndentLevel(string);
        StringBuilder stringBuilder = new StringBuilder(256);
        for (String string2 : stringArray = string.split(" +")) {
            if (stringBuilder.length() > 0) {
                if (stringBuilder.length() + string2.length() >= n2) {
                    list.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    stringBuilder.append(HelpMojo.repeat(" ", n3 * n));
                } else {
                    stringBuilder.append(' ');
                }
            }
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c == '\t') {
                    stringBuilder.append(HelpMojo.repeat(" ", n - stringBuilder.length() % n));
                    continue;
                }
                if (c == '\u00a0') {
                    stringBuilder.append(' ');
                    continue;
                }
                stringBuilder.append(c);
            }
        }
        list.add(stringBuilder.toString());
    }

    private static int getIndentLevel(String string) {
        int n;
        int n2 = 0;
        for (n = 0; n < string.length() && string.charAt(n) == '\t'; ++n) {
            ++n2;
        }
        for (n = n2 + 1; n <= n2 + 4 && n < string.length(); ++n) {
            if (string.charAt(n) != '\t') continue;
            ++n2;
            break;
        }
        return n2;
    }

    private String getPropertyFromExpression(String string) {
        if (string != null && string.startsWith("${") && string.endsWith("}") && !string.substring(2).contains("${")) {
            return string.substring(2, string.length() - 1);
        }
        return null;
    }
}

