/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.mjiip.v_4_0;

import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.api.SpecVersion;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.text.MessageFormat;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.jvnet.jaxb2.maven2.IOptionsFactory;
import org.jvnet.jaxb2.maven2.OptionsConfiguration;
import org.jvnet.jaxb2.maven2.util.StringUtils;
import org.xml.sax.InputSource;

public class OptionsFactory
implements IOptionsFactory<Options> {
    public Options createOptions(OptionsConfiguration optionsConfiguration) throws MojoExecutionException {
        Options options = new Options();
        options.verbose = optionsConfiguration.isVerbose();
        options.debugMode = optionsConfiguration.isDebugMode();
        options.classpaths.addAll(optionsConfiguration.getPlugins());
        options.target = SpecVersion.V3_0;
        String string = optionsConfiguration.getEncoding();
        if (string != null) {
            options.encoding = this.createEncoding(string);
        }
        options.setSchemaLanguage(this.createLanguage(optionsConfiguration.getSchemaLanguage()));
        options.entityResolver = optionsConfiguration.getEntityResolver();
        for (InputSource inputSource : optionsConfiguration.getGrammars()) {
            options.addGrammar(inputSource);
        }
        for (InputSource inputSource : optionsConfiguration.getBindFiles()) {
            options.addBindFile(inputSource);
        }
        options.defaultPackage = optionsConfiguration.getGeneratePackage();
        options.targetDir = optionsConfiguration.getGenerateDirectory();
        options.strictCheck = optionsConfiguration.isStrict();
        options.readOnly = optionsConfiguration.isReadOnly();
        options.packageLevelAnnotations = optionsConfiguration.isPackageLevelAnnotations();
        options.noFileHeader = optionsConfiguration.isNoFileHeader();
        options.enableIntrospection = optionsConfiguration.isEnableIntrospection();
        options.disableXmlSecurity = optionsConfiguration.isDisableXmlSecurity();
        if (optionsConfiguration.getAccessExternalSchema() != null) {
            System.setProperty("javax.xml.accessExternalSchema", optionsConfiguration.getAccessExternalSchema());
        }
        if (optionsConfiguration.getAccessExternalDTD() != null) {
            System.setProperty("javax.xml.accessExternalDTD", optionsConfiguration.getAccessExternalDTD());
        }
        if (optionsConfiguration.isEnableExternalEntityProcessing()) {
            System.setProperty("enableExternalEntityProcessing", Boolean.TRUE.toString());
        }
        options.contentForWildcard = optionsConfiguration.isContentForWildcard();
        if (optionsConfiguration.isExtension()) {
            options.compatibilityMode = 2;
        }
        List list = optionsConfiguration.getArguments();
        try {
            options.parseArguments(list.toArray(new String[list.size()]));
        }
        catch (BadCommandLineException badCommandLineException) {
            throw new MojoExecutionException("Error parsing the command line [" + (List)list + "]", (Exception)((Object)badCommandLineException));
        }
        return options;
    }

    private String createEncoding(String string) throws MojoExecutionException {
        if (string == null) {
            return null;
        }
        try {
            if (!Charset.isSupported(string)) {
                throw new MojoExecutionException(MessageFormat.format("Unsupported encoding [{0}].", string));
            }
            return string;
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new MojoExecutionException(MessageFormat.format("Unsupported encoding [{0}].", string));
        }
    }

    private Language createLanguage(String string) throws MojoExecutionException {
        if (StringUtils.isEmptyTrimmed((String)string)) {
            return null;
        }
        if ("AUTODETECT".equalsIgnoreCase(string)) {
            return null;
        }
        if ("XMLSCHEMA".equalsIgnoreCase(string)) {
            return Language.XMLSCHEMA;
        }
        if ("DTD".equalsIgnoreCase(string)) {
            return Language.DTD;
        }
        if ("WSDL".equalsIgnoreCase(string)) {
            return Language.WSDL;
        }
        throw new MojoExecutionException("Unknown schemaLanguage [" + string + "].");
    }
}

