/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxws;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.mojo.jaxws.Invoker;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

abstract class AbstractJaxwsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="false")
    protected boolean verbose;
    @Parameter(defaultValue="true")
    protected boolean keep;
    @Parameter(defaultValue="false")
    private boolean extension;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter
    private List<String> args;
    @Parameter
    private List<String> vmArgs;
    @Parameter
    private File executable;
    @Parameter(defaultValue="${plugin}", readonly=true)
    protected PluginDescriptor pluginDescriptor;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="false")
    private boolean useJdkToolchainExecutable;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    private static final List<String> METRO_22 = new ArrayList<String>();
    private static final List<String> METRO_221 = new ArrayList<String>();
    private static final List<String> METRO_23 = new ArrayList<String>();

    AbstractJaxwsMojo() {
    }

    protected abstract String getMain();

    protected abstract String getToolName();

    protected abstract File getDestDir();

    protected abstract File getSourceDestDir();

    protected void addSourceRoot(String string) {
        if (!this.project.getCompileSourceRoots().contains(string)) {
            this.getLog().debug((CharSequence)("adding src root: " + string));
            this.project.addCompileSourceRoot(string);
        } else {
            this.getLog().debug((CharSequence)("existing src root: " + string));
        }
    }

    protected abstract File getDefaultSrcOut();

    protected abstract boolean isXnocompile();

    protected String getExtraClasspath() {
        return null;
    }

    protected boolean isExtensionOn() {
        return this.extension;
    }

    protected List<String> getCommonArgs() throws MojoExecutionException {
        File file;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.isDefaultSrc(this.getSourceDestDir()) || this.keep) {
            arrayList.add("-keep");
            arrayList.add("-s");
            arrayList.add("'" + this.getSourceDestDir().getAbsolutePath() + "'");
            if (!this.getSourceDestDir().mkdirs() && !this.getSourceDestDir().exists()) {
                this.getLog().warn((CharSequence)("Cannot create directory: " + this.getSourceDestDir().getAbsolutePath()));
            }
            this.addSourceRoot(this.getSourceDestDir().getAbsolutePath());
        }
        if (!(file = this.getDestDir()).mkdirs() && !file.exists()) {
            this.getLog().warn((CharSequence)("Cannot create directory: " + file.getAbsolutePath()));
        }
        arrayList.add("-d");
        arrayList.add("'" + file.getAbsolutePath() + "'");
        if (this.verbose) {
            arrayList.add("-verbose");
        }
        if (this.isArgSupported("-encoding")) {
            if (this.encoding != null) {
                this.maybeUnsupportedOption("-encoding", this.encoding, arrayList);
            } else {
                this.getLog().warn((CharSequence)("Using platform encoding (" + System.getProperty("file.encoding") + "), build is platform dependent!"));
            }
        }
        if (this.isExtensionOn()) {
            arrayList.add("-extension");
        }
        if (this.isXnocompile()) {
            arrayList.add("-Xnocompile");
        }
        if (this.args != null) {
            for (String string : this.args) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    protected boolean isArgSupported(String string) throws MojoExecutionException {
        ArtifactVersion artifactVersion;
        List<String> list = METRO_23;
        Artifact artifact = (Artifact)this.pluginDescriptor.getArtifactMap().get("org.glassfish.metro:webservices-tools");
        String string2 = null;
        if (artifact != null) {
            artifactVersion = AbstractJaxwsMojo.getSelectedVersion(artifact);
            string2 = artifactVersion.toString();
            if (artifactVersion.getMajorVersion() == 2 && artifactVersion.getMinorVersion() == 2) {
                list = artifactVersion.getIncrementalVersion() == 0 ? METRO_22 : METRO_221;
            }
        } else {
            artifact = (Artifact)this.pluginDescriptor.getArtifactMap().get("com.sun.xml.ws:jaxws-tools");
            artifactVersion = AbstractJaxwsMojo.getSelectedVersion(artifact);
            string2 = artifactVersion.toString();
            if (artifactVersion.getMajorVersion() == 2 && artifactVersion.getMinorVersion() == 2) {
                if (artifactVersion.getIncrementalVersion() == 6) {
                    list = METRO_22;
                } else if (artifactVersion.getIncrementalVersion() == 7) {
                    list = METRO_221;
                }
            }
        }
        boolean bl = list.contains(string);
        if (!bl) {
            this.getLog().warn((CharSequence)("'" + string + "' is not supported by " + artifact.getArtifactId() + ":" + string2));
        }
        return bl;
    }

    private static ArtifactVersion getSelectedVersion(Artifact artifact) throws MojoExecutionException {
        try {
            return artifact.getSelectedVersion();
        }
        catch (OverConstrainedVersionException overConstrainedVersionException) {
            throw new MojoExecutionException(overConstrainedVersionException.getMessage(), (Exception)((Object)overConstrainedVersionException));
        }
    }

    private boolean isDefaultSrc(File file) {
        return file.equals(this.getDefaultSrcOut());
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.executable == null && this.getJdkToolchain() != null && this.useJdkToolchainExecutable) {
            this.executable = new File(this.getJdkToolchain().findTool(this.getToolName()));
        }
        this.executeJaxws();
    }

    public abstract void executeJaxws() throws MojoExecutionException, MojoFailureException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void exec(List<String> list) throws MojoExecutionException {
        Object object;
        String string = "";
        Commandline commandline = new Commandline();
        if (this.executable != null) {
            string = this.executable.getName();
            if (!this.executable.isFile() || !this.executable.canExecute()) throw new MojoExecutionException("Cannot execute: " + this.executable.getAbsolutePath());
            commandline.setExecutable(this.executable.getAbsolutePath());
            if (this.getExtraClasspath() != null) {
                commandline.createArg().setLine("-cp");
                commandline.createArg().setValue(this.getExtraClasspath());
            }
        } else {
            string = this.getMain();
            if (this.getJdkToolchain() == null) {
                commandline.setExecutable(new File(new File(System.getProperty("java.home"), "bin"), this.getJavaExec()).getAbsolutePath());
            } else {
                commandline.setExecutable(this.getJdkToolchain().findTool("java"));
            }
            if (this.vmArgs != null) {
                for (String string2 : this.vmArgs) {
                    commandline.createArg().setLine(string2);
                }
            }
            object = this.getInvokerCP();
            if (!this.isModular()) {
                commandline.createArg().setValue("-Xbootclasspath/p:" + ((InvokerCP)object).ecp);
            }
            commandline.createArg().setValue("-cp");
            commandline.createArg().setValue(((InvokerCP)object).invokerPath);
            commandline.createArg().setLine(Invoker.class.getCanonicalName());
            commandline.createArg().setLine(this.getMain());
            String string3 = this.getExtraClasspath();
            String string4 = (string3 != null ? string3 + File.pathSeparator : "") + ((InvokerCP)object).cp;
            try {
                File file = this.createPathFile(string4);
                commandline.createArg().setLine("-pathfile '" + file.getAbsolutePath() + "'");
            }
            catch (IOException iOException) {
                commandline.createArg().setValue("-cp");
                commandline.createArg().setValue(string4);
            }
        }
        commandline.setWorkingDirectory(this.project.getBasedir());
        for (String string5 : list) {
            commandline.createArg().setLine(string5);
        }
        try {
            object = commandline.toString();
            if (this.isWindows() && 8191 <= ((String)object).length()) {
                this.getLog().warn((CharSequence)("Length of Windows command line is limited to 8191 characters, but current command has " + ((String)object).length() + " characters:"));
                this.getLog().warn((CharSequence)object);
            } else {
                this.getLog().debug((CharSequence)object);
            }
            StreamConsumer streamConsumer = new StreamConsumer(){

                public void consumeLine(String string) {
                    System.out.println(string);
                }
            };
            if (CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)streamConsumer, (StreamConsumer)streamConsumer) == 0) return;
            throw new MojoExecutionException("Invocation of " + string + " failed - check output");
        }
        catch (CommandLineException commandLineException) {
            throw new MojoExecutionException(commandLineException.getMessage(), (Exception)((Object)commandLineException));
        }
    }

    private boolean isModular() {
        try {
            Class<?> clazz = Class.forName("java.lang.Module");
            return clazz != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    protected void maybeUnsupportedOption(String string, String string2, List<String> list) {
        if (this.executable == null) {
            list.add(string);
            if (string2 != null) {
                list.add(string2);
            }
        } else {
            this.getLog().warn((CharSequence)(string + " may not supported on older JDKs.\nUse <args> to bypass this warning if you really want to use it."));
        }
    }

    private InvokerCP getInvokerCP() {
        Object object2;
        HashSet<Artifact> hashSet = new HashSet<Artifact>();
        HashMap<String, Artifact> hashMap = new HashMap<String, Artifact>();
        for (Object object2 : this.pluginDescriptor.getArtifacts()) {
            this.addArtifactToCp((Artifact)object2, hashMap, hashSet);
        }
        StringBuilder stringBuilder = new StringBuilder(this.getCPasString(hashMap.values()));
        object2 = new StringBuilder(this.getCPasString(hashSet));
        String string = null;
        try {
            string = Invoker.class.getProtectionDomain().getCodeSource().getLocation().toExternalForm();
            string = new URI(string.substring(5)).getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(File.pathSeparator);
        }
        stringBuilder.append(string);
        String string2 = this.getJavaHome();
        File file = new File(string2, "../lib/tools.jar");
        if (!file.exists()) {
            file = new File(string2, "lib/tools.jar");
        }
        if (file.exists()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(file.getAbsolutePath());
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("getInvokerCP():\n    endorsed: " + this.toString(hashSet) + "\n    classpath: " + this.toString(hashMap.values()) + "\n    ecp: " + object2 + "\n    cp: " + stringBuilder + "\n    invokerPath: " + string));
        }
        return new InvokerCP(((StringBuilder)object2).toString(), stringBuilder.toString(), string);
    }

    private String getJavaExec() {
        return this.isWindows() ? "java.exe" : "java";
    }

    private String getJavaHome() {
        String string = System.getProperty("java.home");
        if (this.getJdkToolchain() != null) {
            File file = new File(this.getJdkToolchain().findTool("java"));
            string = file.getParentFile().getParent();
        }
        return string;
    }

    private File createPathFile(String string) throws IOException {
        File file = File.createTempFile("jax-ws-mvn-plugin-cp", ".txt");
        if (file.exists() && file.isFile() && !file.delete()) {
            this.getLog().warn((CharSequence)("cannot remove obsolete classpath setting file: " + file.getAbsolutePath()));
        }
        Properties properties = new Properties();
        properties.put("cp", string.replace(File.separatorChar, '/'));
        this.getLog().debug((CharSequence)("stored classpath: " + string.replace(File.separatorChar, '/')));
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            properties.store(fileOutputStream, null);
        }
        catch (IOException iOException) {
            this.getLog().error((Throwable)iOException);
        }
        return file;
    }

    private boolean isWindows() {
        return Os.isFamily((String)"windows");
    }

    protected String getCPasString(Collection<Artifact> collection) {
        return collection.stream().map(artifact -> artifact.getFile().getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
    }

    private String toString(Collection<Artifact> collection) {
        return collection.stream().map(artifact -> String.join((CharSequence)":", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion())).collect(Collectors.joining(" "));
    }

    private void addArtifactToCp(Artifact artifact, Map<String, Artifact> map, Set<Artifact> set) {
        if (!this.isModular() && this.isEndorsedArtifact(artifact)) {
            set.add(artifact);
        } else if ("compile".equals(artifact.getScope()) || "runtime".equals(artifact.getScope())) {
            map.put(artifact.getGroupId() + ":" + artifact.getArtifactId(), artifact);
        }
    }

    protected void addVmArg(String string) {
        if (this.vmArgs == null) {
            this.vmArgs = new ArrayList<String>();
        }
        this.vmArgs.add(string);
    }

    private boolean isEndorsedArtifact(Artifact artifact) {
        return "jaxws-api".equals(artifact.getArtifactId()) || "jaxb-api".equals(artifact.getArtifactId()) || "saaj-api".equals(artifact.getArtifactId()) || "jsr181-api".equals(artifact.getArtifactId()) || "javax.annotation".equals(artifact.getArtifactId()) || "javax.annotation-api".equals(artifact.getArtifactId()) || "webservices-api".equals(artifact.getArtifactId()) || artifact.getArtifactId().startsWith("javax.xml.ws") || artifact.getArtifactId().startsWith("javax.xml.bind");
    }

    private Toolchain getJdkToolchain() {
        Toolchain toolchain = null;
        if (this.toolchainManager != null) {
            toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return toolchain;
    }

    static {
        METRO_22.add("-encoding");
        METRO_22.add("-clientjar");
        METRO_22.add("-generateJWS");
        METRO_22.add("-implDestDir");
        METRO_22.add("-implServiceName");
        METRO_22.add("-implPortName");
        METRO_221.addAll(METRO_22);
        METRO_221.add("-XdisableAuthenticator");
        METRO_23.addAll(METRO_221);
        METRO_23.add("-x");
    }

    private static class InvokerCP {
        public final String ecp;
        public final String cp;
        public final String invokerPath;

        public InvokerCP(String string, String string2, String string3) {
            this.ecp = string;
            this.cp = string2;
            this.invokerPath = string3;
        }
    }
}

