/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.LegacyGrammarDirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractPreprocessorMojo
extends AbstractMojo {
    private MavenProject project;

    protected abstract File getSourceDirectory();

    protected abstract String[] getIncludes();

    protected abstract String[] getExcludes();

    protected abstract File getOutputDirectory();

    protected abstract File getTimestampDirectory();

    protected abstract int getStaleMillis();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().warn((CharSequence)"This goal has been deprecated. Please update your plugin configuration.");
        GrammarInfo[] grammarInfoArray = this.scanForGrammars();
        if (grammarInfoArray == null) {
            this.getLog().info((CharSequence)("Skipping non-existing source directory: " + this.getSourceDirectory()));
            return;
        }
        if (grammarInfoArray.length <= 0) {
            this.getLog().info((CharSequence)"Skipping - all parsers are up to date");
        } else {
            if (!this.getTimestampDirectory().exists()) {
                this.getTimestampDirectory().mkdirs();
            }
            for (GrammarInfo grammarInfo : grammarInfoArray) {
                this.processGrammar(grammarInfo);
            }
            this.getLog().info((CharSequence)("Processed " + grammarInfoArray.length + " grammar" + (grammarInfoArray.length != 1 ? "s" : "")));
        }
        this.addCompileSourceRoot();
    }

    protected abstract void processGrammar(GrammarInfo var1) throws MojoExecutionException, MojoFailureException;

    private GrammarInfo[] scanForGrammars() throws MojoExecutionException {
        GrammarInfo[] grammarInfoArray;
        if (!this.getSourceDirectory().isDirectory()) {
            return null;
        }
        this.getLog().debug((CharSequence)("Scanning for grammars: " + this.getSourceDirectory()));
        try {
            LegacyGrammarDirectoryScanner legacyGrammarDirectoryScanner = new LegacyGrammarDirectoryScanner();
            legacyGrammarDirectoryScanner.setSourceDirectory(this.getSourceDirectory());
            legacyGrammarDirectoryScanner.setIncludes(this.getIncludes());
            legacyGrammarDirectoryScanner.setExcludes(this.getExcludes());
            legacyGrammarDirectoryScanner.setOutputDirectory(this.getTimestampDirectory());
            legacyGrammarDirectoryScanner.setStaleMillis(this.getStaleMillis());
            legacyGrammarDirectoryScanner.scan();
            grammarInfoArray = legacyGrammarDirectoryScanner.getIncludedGrammars();
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Failed to scan for grammars: " + this.getSourceDirectory(), exception);
        }
        this.getLog().debug((CharSequence)("Found grammars: " + Arrays.asList(grammarInfoArray)));
        return grammarInfoArray;
    }

    protected void createTimestamp(GrammarInfo grammarInfo) {
        File file = grammarInfo.getGrammarFile();
        File file2 = new File(this.getTimestampDirectory(), grammarInfo.getRelativeGrammarFile());
        try {
            FileUtils.copyFile((File)file, (File)file2);
        }
        catch (Exception exception) {
            this.getLog().warn((CharSequence)("Failed to create copy for timestamp check: " + file), (Throwable)exception);
        }
    }

    protected void addCompileSourceRoot() {
        if (this.project != null) {
            this.getLog().debug((CharSequence)("Adding compile source root: " + this.getOutputDirectory()));
            this.project.addCompileSourceRoot(this.getOutputDirectory().getAbsolutePath());
        }
    }
}

