/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import com.helger.commons.state.ESuccess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.mojo.javacc.ForkedJvmPGCC;
import org.codehaus.mojo.javacc.ToolFacade;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

class JTB
extends ToolFacade {
    private static final String SYNTAX_TREE = "syntaxtree";
    private static final String VISITOR = "visitor";
    private File inputFile;
    private File outputDirectory;
    private File nodeDirectory;
    private File visitorDirectory;
    private String packageName;
    private String nodePackageName;
    private String visitorPackageName;
    private Boolean supressErrorChecking;
    private Boolean javadocFriendlyComments;
    private Boolean descriptiveFieldNames;
    private String nodeParentClass;
    private Boolean parentPointers;
    private Boolean specialTokens;
    private Boolean scheme;
    private Boolean printer;

    public void setInputFile(File file) {
        if (file != null && !file.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + file);
        }
        this.inputFile = file;
    }

    public void setOutputDirectory(File file) {
        if (file != null && !file.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + file);
        }
        this.outputDirectory = file;
    }

    public File getOutputFile() {
        File file = null;
        if (this.outputDirectory != null && this.inputFile != null) {
            String string = FileUtils.removeExtension((String)this.inputFile.getName()) + ".jj";
            file = new File(this.outputDirectory, string);
        }
        return file;
    }

    public void setNodeDirectory(File file) {
        if (file != null && !file.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + file);
        }
        this.nodeDirectory = file;
    }

    private File getEffectiveNodeDirectory() {
        if (this.nodeDirectory != null) {
            return this.nodeDirectory;
        }
        if (this.outputDirectory != null) {
            return new File(this.outputDirectory, this.getLastPackageName(this.getEffectiveNodePackageName()));
        }
        return null;
    }

    public void setVisitorDirectory(File file) {
        if (file != null && !file.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + file);
        }
        this.visitorDirectory = file;
    }

    private File getEffectiveVisitorDirectory() {
        if (this.visitorDirectory != null) {
            return this.visitorDirectory;
        }
        if (this.outputDirectory != null) {
            return new File(this.outputDirectory, this.getLastPackageName(this.getEffectiveVisitorPackageName()));
        }
        return null;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public void setNodePackageName(String string) {
        this.nodePackageName = string;
    }

    private String getEffectiveNodePackageName() {
        if (this.packageName != null) {
            return this.packageName.length() <= 0 ? SYNTAX_TREE : this.packageName + '.' + SYNTAX_TREE;
        }
        if (this.nodePackageName != null) {
            return this.nodePackageName;
        }
        return SYNTAX_TREE;
    }

    public void setVisitorPackageName(String string) {
        this.visitorPackageName = string;
    }

    private String getEffectiveVisitorPackageName() {
        if (this.packageName != null) {
            return this.packageName.length() <= 0 ? VISITOR : this.packageName + '.' + VISITOR;
        }
        if (this.visitorPackageName != null) {
            return this.visitorPackageName;
        }
        return VISITOR;
    }

    public void setSupressErrorChecking(Boolean bl) {
        this.supressErrorChecking = bl;
    }

    public void setJavadocFriendlyComments(Boolean bl) {
        this.javadocFriendlyComments = bl;
    }

    public void setDescriptiveFieldNames(Boolean bl) {
        this.descriptiveFieldNames = bl;
    }

    public void setNodeParentClass(String string) {
        this.nodeParentClass = string;
    }

    public void setParentPointers(Boolean bl) {
        this.parentPointers = bl;
    }

    public void setSpecialTokens(Boolean bl) {
        this.specialTokens = bl;
    }

    public void setScheme(Boolean bl) {
        this.scheme = bl;
    }

    public void setPrinter(Boolean bl) {
        this.printer = bl;
    }

    @Override
    protected ESuccess execute() throws Exception {
        String[] stringArray = this.generateArguments();
        if (this.outputDirectory != null && !this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            this.getLog().error((CharSequence)("Failed to create output directory " + this.outputDirectory));
            return ESuccess.FAILURE;
        }
        ForkedJvmPGCC forkedJvmPGCC = new ForkedJvmPGCC();
        forkedJvmPGCC.setMainClass(EDU.purdue.jtb.JTB.class);
        forkedJvmPGCC.addArguments(stringArray);
        forkedJvmPGCC.setSystemOut(new MojoLogStreamConsumer(false));
        forkedJvmPGCC.setSystemErr(new MojoLogStreamConsumer(true));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Forking: " + forkedJvmPGCC));
        }
        int n = forkedJvmPGCC.run();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Finished forking");
        }
        this.moveJavaFiles();
        return ESuccess.valueOf((n == 0 ? 1 : 0) != 0);
    }

    private String[] generateArguments() {
        File file;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-np");
        arrayList.add(this.getEffectiveNodePackageName());
        arrayList.add("-vp");
        arrayList.add(this.getEffectiveVisitorPackageName());
        if (this.supressErrorChecking != null && this.supressErrorChecking.booleanValue()) {
            arrayList.add("-e");
        }
        if (this.javadocFriendlyComments != null && this.javadocFriendlyComments.booleanValue()) {
            arrayList.add("-jd");
        }
        if (this.descriptiveFieldNames != null && this.descriptiveFieldNames.booleanValue()) {
            arrayList.add("-f");
        }
        if (this.nodeParentClass != null) {
            arrayList.add("-ns");
            arrayList.add(this.nodeParentClass);
        }
        if (this.parentPointers != null && this.parentPointers.booleanValue()) {
            arrayList.add("-pp");
        }
        if (this.specialTokens != null && this.specialTokens.booleanValue()) {
            arrayList.add("-tk");
        }
        if (this.scheme != null && this.scheme.booleanValue()) {
            arrayList.add("-scheme");
        }
        if (this.printer != null && this.printer.booleanValue()) {
            arrayList.add("-printer");
        }
        if ((file = this.getOutputFile()) != null) {
            arrayList.add("-o");
            arrayList.add(file.getAbsolutePath());
        }
        if (this.inputFile != null) {
            arrayList.add(this.inputFile.getAbsolutePath());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getLastPackageName(String string) {
        if (string != null) {
            return string.substring(string.lastIndexOf(46) + 1);
        }
        return null;
    }

    private void moveJavaFiles() throws IOException {
        File file = new File(this.getLastPackageName(this.getEffectiveNodePackageName())).getAbsoluteFile();
        File file2 = this.getEffectiveNodeDirectory();
        this.moveDirectory(file, file2);
        File file3 = new File(this.getLastPackageName(this.getEffectiveVisitorPackageName())).getAbsoluteFile();
        File file4 = this.getEffectiveVisitorDirectory();
        this.moveDirectory(file3, file4);
    }

    private void moveDirectory(File file, File file2) throws IOException {
        this.getLog().debug((CharSequence)("Moving JTB output files: " + file + " -> " + file2));
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file3 : fileArray) {
            File file4 = file3;
            if (!file4.isFile() || !file4.getName().endsWith(".java")) continue;
            try {
                this.getLog().debug((CharSequence)("  Moving JTB output file: " + file4 + " -> " + file2));
                FileUtils.copyFileToDirectory((File)file4, (File)file2);
                if (file4.delete()) continue;
                this.getLog().error((CharSequence)("Failed to delete original JTB output file: " + file4));
            }
            catch (Exception exception) {
                throw new IOException("Failed to move JTB output file: " + file4 + " -> " + file2);
            }
        }
        if (file.list().length <= 0) {
            if (!file.delete()) {
                this.getLog().error((CharSequence)("Failed to delete original JTB output directory: " + file));
            }
        } else {
            this.getLog().debug((CharSequence)("Keeping non empty JTB output directory: " + file));
        }
    }

    public String toString() {
        return Arrays.asList(this.generateArguments()).toString();
    }

    class MojoLogStreamConsumer
    implements StreamConsumer {
        private static final String INFO_PREFIX = "JTB: ";
        private final boolean err;

        public MojoLogStreamConsumer(boolean bl) {
            this.err = bl;
        }

        public void consumeLine(String string) {
            if (string.startsWith("JTB version")) {
                JTB.this.getLog().debug((CharSequence)string);
            } else if (string.startsWith(INFO_PREFIX)) {
                JTB.this.getLog().debug((CharSequence)string.substring(INFO_PREFIX.length()));
            } else if (this.err && string.length() > 0) {
                JTB.this.getLog().error((CharSequence)string);
            } else {
                JTB.this.getLog().debug((CharSequence)string);
            }
        }
    }
}

