/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import com.helger.commons.state.ESuccess;
import com.helger.pgcc.parser.Main;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.mojo.javacc.ToolFacade;
import org.codehaus.plexus.util.StringUtils;

class JavaCC
extends ToolFacade {
    private File inputFile;
    private File outputDirectory;
    private String grammarEncoding;
    private String outputEncoding;
    private String jdkVersion;
    private Integer lookAhead;
    private Integer choiceAmbiguityCheck;
    private Integer otherAmbiguityCheck;
    private Boolean debugParser;
    private Boolean debugLookAhead;
    private Boolean debugTokenManager;
    private Boolean errorReporting;
    private Boolean javaUnicodeEscape;
    private Boolean unicodeInput;
    private Boolean ignoreCase;
    private Boolean commonTokenAction;
    private Boolean userTokenManager;
    private Boolean userCharStream;
    private Boolean buildParser;
    private Boolean buildTokenManager;
    private Boolean tokenManagerUsesParser;
    private String tokenExtends;
    private String tokenFactory;
    private Boolean sanityCheck;
    private Boolean forceLaCheck;
    private Boolean cacheTokens;
    private Boolean keepLineColumn;
    private Boolean supportClassVisibilityPublic;
    private String javaTemplateType;

    JavaCC() {
    }

    public void setInputFile(File file) {
        if (file != null && !file.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + file);
        }
        this.inputFile = file;
    }

    public void setOutputDirectory(File file) {
        if (file != null && !file.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + file);
        }
        this.outputDirectory = file;
    }

    public void setGrammarEncoding(String string) {
        this.grammarEncoding = string;
    }

    public void setOutputEncoding(String string) {
        this.outputEncoding = string;
    }

    public void setJdkVersion(String string) {
        this.jdkVersion = string;
    }

    public void setLookAhead(Integer n) {
        this.lookAhead = n;
    }

    public void setChoiceAmbiguityCheck(Integer n) {
        this.choiceAmbiguityCheck = n;
    }

    public void setOtherAmbiguityCheck(Integer n) {
        this.otherAmbiguityCheck = n;
    }

    public void setDebugParser(Boolean bl) {
        this.debugParser = bl;
    }

    public void setDebugLookAhead(Boolean bl) {
        this.debugLookAhead = bl;
    }

    public void setDebugTokenManager(Boolean bl) {
        this.debugTokenManager = bl;
    }

    public void setErrorReporting(Boolean bl) {
        this.errorReporting = bl;
    }

    public void setJavaUnicodeEscape(Boolean bl) {
        this.javaUnicodeEscape = bl;
    }

    public void setUnicodeInput(Boolean bl) {
        this.unicodeInput = bl;
    }

    public void setIgnoreCase(Boolean bl) {
        this.ignoreCase = bl;
    }

    public void setCommonTokenAction(Boolean bl) {
        this.commonTokenAction = bl;
    }

    public void setUserTokenManager(Boolean bl) {
        this.userTokenManager = bl;
    }

    public void setUserCharStream(Boolean bl) {
        this.userCharStream = bl;
    }

    public void setBuildParser(Boolean bl) {
        this.buildParser = bl;
    }

    public void setBuildTokenManager(Boolean bl) {
        this.buildTokenManager = bl;
    }

    public void setTokenManagerUsesParser(Boolean bl) {
        this.tokenManagerUsesParser = bl;
    }

    public void setTokenExtends(String string) {
        this.tokenExtends = string;
    }

    public void setTokenFactory(String string) {
        this.tokenFactory = string;
    }

    public void setSanityCheck(Boolean bl) {
        this.sanityCheck = bl;
    }

    public void setForceLaCheck(Boolean bl) {
        this.forceLaCheck = bl;
    }

    public void setCacheTokens(Boolean bl) {
        this.cacheTokens = bl;
    }

    public void setKeepLineColumn(Boolean bl) {
        this.keepLineColumn = bl;
    }

    public void setSupportClassVisibilityPublic(Boolean bl) {
        this.supportClassVisibilityPublic = bl;
    }

    public void setJavaTemplateType(String string) {
        this.javaTemplateType = string;
    }

    @Override
    protected ESuccess execute() throws Exception {
        String[] stringArray = this.generateArguments();
        if (this.outputDirectory != null && !this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            this.getLog().error((CharSequence)("Failed to create output directory " + this.outputDirectory));
            return ESuccess.FAILURE;
        }
        return Main.mainProgram((String[])stringArray);
    }

    private String[] generateArguments() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.grammarEncoding)) {
            arrayList.add("-GRAMMAR_ENCODING=" + this.grammarEncoding);
        }
        if (StringUtils.isNotEmpty((String)this.outputEncoding)) {
            arrayList.add("-OUTPUT_ENCODING=" + this.outputEncoding);
        }
        if (StringUtils.isNotEmpty((String)this.jdkVersion)) {
            arrayList.add("-JDK_VERSION=" + this.jdkVersion);
        }
        if (this.lookAhead != null) {
            arrayList.add("-LOOKAHEAD=" + this.lookAhead);
        }
        if (this.choiceAmbiguityCheck != null) {
            arrayList.add("-CHOICE_AMBIGUITY_CHECK=" + this.choiceAmbiguityCheck);
        }
        if (this.otherAmbiguityCheck != null) {
            arrayList.add("-OTHER_AMBIGUITY_CHECK=" + this.otherAmbiguityCheck);
        }
        if (this.debugParser != null) {
            arrayList.add("-DEBUG_PARSER=" + this.debugParser);
        }
        if (this.debugLookAhead != null) {
            arrayList.add("-DEBUG_LOOKAHEAD=" + this.debugLookAhead);
        }
        if (this.debugTokenManager != null) {
            arrayList.add("-DEBUG_TOKEN_MANAGER=" + this.debugTokenManager);
        }
        if (this.errorReporting != null) {
            arrayList.add("-ERROR_REPORTING=" + this.errorReporting);
        }
        if (this.javaUnicodeEscape != null) {
            arrayList.add("-JAVA_UNICODE_ESCAPE=" + this.javaUnicodeEscape);
        }
        if (this.unicodeInput != null) {
            arrayList.add("-UNICODE_INPUT=" + this.unicodeInput);
        }
        if (this.ignoreCase != null) {
            arrayList.add("-IGNORE_CASE=" + this.ignoreCase);
        }
        if (this.commonTokenAction != null) {
            arrayList.add("-COMMON_TOKEN_ACTION=" + this.commonTokenAction);
        }
        if (this.userTokenManager != null) {
            arrayList.add("-USER_TOKEN_MANAGER=" + this.userTokenManager);
        }
        if (this.userCharStream != null) {
            arrayList.add("-USER_CHAR_STREAM=" + this.userCharStream);
        }
        if (this.buildParser != null) {
            arrayList.add("-BUILD_PARSER=" + this.buildParser);
        }
        if (this.buildTokenManager != null) {
            arrayList.add("-BUILD_TOKEN_MANAGER=" + this.buildTokenManager);
        }
        if (this.tokenManagerUsesParser != null) {
            arrayList.add("-TOKEN_MANAGER_USES_PARSER=" + this.tokenManagerUsesParser);
        }
        if (StringUtils.isNotEmpty((String)this.tokenExtends)) {
            arrayList.add("-TOKEN_EXTENDS=" + this.tokenExtends);
        }
        if (StringUtils.isNotEmpty((String)this.tokenFactory)) {
            arrayList.add("-TOKEN_FACTORY=" + this.tokenFactory);
        }
        if (this.sanityCheck != null) {
            arrayList.add("-SANITY_CHECK=" + this.sanityCheck);
        }
        if (this.forceLaCheck != null) {
            arrayList.add("-FORCE_LA_CHECK=" + this.forceLaCheck);
        }
        if (this.cacheTokens != null) {
            arrayList.add("-CACHE_TOKENS=" + this.cacheTokens);
        }
        if (this.keepLineColumn != null) {
            arrayList.add("-KEEP_LINE_COLUMN=" + this.keepLineColumn);
        }
        if (this.supportClassVisibilityPublic != null) {
            arrayList.add("-SUPPORT_CLASS_VISIBILITY_PUBLIC=" + this.supportClassVisibilityPublic);
        }
        if (this.outputDirectory != null) {
            arrayList.add("-OUTPUT_DIRECTORY=" + this.outputDirectory.getAbsolutePath());
        }
        if (StringUtils.isNotEmpty((String)this.javaTemplateType)) {
            arrayList.add("-JAVA_TEMPLATE_TYPE=" + this.javaTemplateType);
        }
        if (this.inputFile != null) {
            arrayList.add(this.inputFile.getAbsolutePath());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String toString() {
        return Arrays.asList(this.generateArguments()).toString();
    }
}

