/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import com.helger.commons.state.ESuccess;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

abstract class ToolFacade {
    private Log m_aLog;

    ToolFacade() {
    }

    public void setLog(Log log) {
        this.m_aLog = log;
    }

    protected Log getLog() {
        if (this.m_aLog == null) {
            this.m_aLog = new SystemStreamLog();
        }
        return this.m_aLog;
    }

    protected String getToolName() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    @Nonnull
    protected abstract ESuccess execute() throws Exception;

    public void run() throws MojoExecutionException, MojoFailureException {
        ESuccess eSuccess;
        try {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Running " + this.getToolName() + ": " + this));
            }
            eSuccess = this.execute();
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Failed to execute " + this.getToolName(), exception);
        }
        if (eSuccess.isFailure()) {
            throw new MojoFailureException(this.getToolName() + " reported failure: " + this);
        }
    }
}

