/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsLinkedHashSet;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.javacc.GrammarDirectoryScanner;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JavaCC;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.SelectorUtils;

public abstract class AbstractJavaCCMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    private Collection<File> nonGeneratedSourceRoots;
    @Parameter(property="jdkVersion")
    private String jdkVersion;
    @Parameter(property="lookAhead")
    private Integer lookAhead;
    @Parameter(property="choiceAmbiguityCheck")
    private Integer choiceAmbiguityCheck;
    @Parameter(property="otherAmbiguityCheck")
    private Integer otherAmbiguityCheck;
    @Parameter(property="debugParser")
    private Boolean debugParser;
    @Parameter(property="debugLookAhead")
    private Boolean debugLookAhead;
    @Parameter(property="debugTokenManager")
    private Boolean debugTokenManager;
    @Parameter(property="errorReporting")
    private Boolean errorReporting;
    @Parameter(property="javaUnicodeEscape")
    private Boolean javaUnicodeEscape;
    @Parameter(property="unicodeInput")
    private Boolean unicodeInput;
    @Parameter(property="ignoreCase")
    private Boolean ignoreCase;
    @Parameter(property="commonTokenAction")
    private Boolean commonTokenAction;
    @Parameter(property="userTokenManager")
    private Boolean userTokenManager;
    @Parameter(property="userCharStream")
    private Boolean userCharStream;
    @Parameter(property="buildParser")
    private Boolean buildParser;
    @Parameter(property="buildTokenManager")
    private Boolean buildTokenManager;
    @Parameter(property="tokenManagerUsesParser")
    private Boolean tokenManagerUsesParser;
    @Parameter(property="tokenExtends")
    private String tokenExtends;
    @Parameter(property="tokenFactory")
    private String tokenFactory;
    @Parameter(property="sanityCheck")
    private Boolean sanityCheck;
    @Parameter(property="forceLaCheck")
    private Boolean forceLaCheck;
    @Parameter(property="cacheTokens")
    private Boolean cacheTokens;
    @Parameter(property="keepLineColumn")
    private Boolean keepLineColumn;
    @Parameter(property="supportClassVisibilityPublic")
    private Boolean supportClassVisibilityPublic;
    @Parameter(property="grammarEncoding", defaultValue="${project.build.sourceEncoding}")
    private String grammarEncoding;
    @Parameter(property="outputEncoding", defaultValue="${project.build.sourceEncoding}")
    private String outputEncoding;
    @Parameter(property="classic")
    private String javaTemplateType;

    protected String getGrammarEncoding() {
        return this.grammarEncoding;
    }

    protected String getOutputEncoding() {
        return this.outputEncoding;
    }

    protected String getJdkVersion() {
        return this.jdkVersion;
    }

    protected String getJavaTemplateType() {
        return this.javaTemplateType;
    }

    protected abstract File getSourceDirectory();

    protected abstract String[] getIncludes();

    protected abstract String[] getExcludes();

    protected abstract File getOutputDirectory();

    protected abstract int getStaleMillis();

    protected abstract File[] getCompileSourceRoots();

    /*
     * WARNING - void declaration
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        GrammarInfo[] grammarInfoArray = this._scanForGrammars();
        if (grammarInfoArray == null) {
            this.getLog().info((CharSequence)("Skipping non-existing source directory: " + String.valueOf(this.getSourceDirectory())));
        } else {
            GrammarInfo[] grammarInfoArray2;
            if (grammarInfoArray.length <= 0) {
                this.getLog().info((CharSequence)"Skipping - all parsers are up to date");
            } else {
                void file;
                this._determineNonGeneratedSourceRoots();
                if (StringHelper.isEmpty((String)this.grammarEncoding)) {
                    this.getLog().warn((CharSequence)"File encoding for grammars has not been configured, using platform default encoding, i.e. build is platform dependent!");
                }
                if (StringHelper.isEmpty((String)this.outputEncoding)) {
                    this.getLog().warn((CharSequence)"File encoding for output has not been configured, defaulting to UTF-8!");
                }
                grammarInfoArray2 = grammarInfoArray;
                int n = grammarInfoArray2.length;
                boolean bl = false;
                while (file < n) {
                    GrammarInfo grammarInfo = grammarInfoArray2[file];
                    this.processGrammar(grammarInfo);
                    ++file;
                }
                this.getLog().info((CharSequence)("Processed " + grammarInfoArray.length + " grammar" + (grammarInfoArray.length != 1 ? "s" : "")));
            }
            grammarInfoArray2 = new CommonsLinkedHashSet((Object[])this.getCompileSourceRoots());
            for (File file : grammarInfoArray2) {
                this._addSourceRoot(file);
            }
        }
    }

    protected abstract void processGrammar(GrammarInfo var1) throws MojoExecutionException, MojoFailureException;

    private GrammarInfo[] _scanForGrammars() throws MojoExecutionException {
        GrammarInfo[] grammarInfoArray;
        if (!this.getSourceDirectory().isDirectory()) {
            return null;
        }
        this.getLog().debug((CharSequence)("Scanning for grammars: " + String.valueOf(this.getSourceDirectory())));
        try {
            GrammarDirectoryScanner grammarDirectoryScanner = new GrammarDirectoryScanner();
            grammarDirectoryScanner.setSourceDirectory(this.getSourceDirectory());
            grammarDirectoryScanner.setIncludes(this.getIncludes());
            grammarDirectoryScanner.setExcludes(this.getExcludes());
            grammarDirectoryScanner.setOutputDirectory(this.getOutputDirectory());
            grammarDirectoryScanner.setStaleMillis(this.getStaleMillis());
            grammarDirectoryScanner.scan();
            grammarInfoArray = grammarDirectoryScanner.getIncludedGrammars();
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Failed to scan for grammars: " + String.valueOf(this.getSourceDirectory()), exception);
        }
        this.getLog().debug((CharSequence)("Found grammars: " + String.valueOf(Arrays.asList(grammarInfoArray))));
        return grammarInfoArray;
    }

    protected File getTempDirectory() {
        return new File(this.project.getBuild().getDirectory(), "javacc-" + System.currentTimeMillis());
    }

    protected void deleteTempDirectory(File file) {
        try {
            FileUtils.deleteDirectory((File)file);
        }
        catch (IOException iOException) {
            this.getLog().warn((CharSequence)("Failed to delete temporary directory: " + String.valueOf(file)), (Throwable)iOException);
        }
    }

    protected void copyGrammarOutput(File file, String string, File file2, String string2) throws MojoExecutionException {
        try {
            List list = FileUtils.getFiles((File)file2, (String)"*.java", null);
            for (File file3 : list) {
                Object object = "";
                if (string.length() > 0) {
                    object = string.replace('.', '/') + "/";
                }
                object = (String)object + file3.getName();
                File file4 = new File(file, (String)object);
                File file5 = this._findSourceFile((String)object);
                boolean bl = false;
                if (string2 != null && file5 != null) {
                    bl = string2.startsWith("!") ? !SelectorUtils.match((String)string2.substring(1), (String)file3.getName()) : SelectorUtils.match((String)string2, (String)file3.getName());
                }
                if (file5 == null || bl && file5.equals(file4)) {
                    this.getLog().debug((CharSequence)("Copying generated file: " + (String)object));
                    try {
                        FileUtils.copyFile((File)file3, (File)file4);
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new MojoExecutionException("Failed to copy generated source file to output directory:" + String.valueOf(file3) + " -> " + String.valueOf(file4), (Exception)iOException);
                    }
                }
                this.getLog().debug((CharSequence)("Skipping customized file: " + (String)object));
            }
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("Failed to copy generated source files", (Exception)iOException);
        }
    }

    private void _determineNonGeneratedSourceRoots() throws MojoExecutionException {
        this.nonGeneratedSourceRoots = new LinkedHashSet<File>();
        try {
            String string = new File(this.project.getBuild().getDirectory()).getCanonicalPath() + File.separator;
            List list = this.project.getCompileSourceRoots();
            for (String string2 : list) {
                String string3;
                File file = new File(string2);
                if (!file.isAbsolute()) {
                    file = new File(this.project.getBasedir(), file.getPath());
                }
                if (!(string3 = file.getCanonicalPath()).startsWith(string)) {
                    this.nonGeneratedSourceRoots.add(file);
                    this.getLog().debug((CharSequence)("Non-generated compile source root: " + String.valueOf(file)));
                    continue;
                }
                this.getLog().debug((CharSequence)("Generated compile source root: " + String.valueOf(file)));
            }
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("Failed to determine non-generated source roots", (Exception)iOException);
        }
    }

    private File _findSourceFile(String string) {
        Collection<File> collection = this.nonGeneratedSourceRoots;
        for (File file : collection) {
            File file2 = new File(file, string);
            if (!file2.exists()) continue;
            return file2;
        }
        return null;
    }

    protected boolean isSourceRoot(File file) {
        return this.nonGeneratedSourceRoots.contains(file);
    }

    private void _addSourceRoot(File file) {
        if (this.project != null) {
            this.getLog().debug((CharSequence)("Adding compile source root: " + String.valueOf(file)));
            this.project.addCompileSourceRoot(file.getAbsolutePath());
        }
    }

    @Nonnull
    protected JavaCC newJavaCC() {
        JavaCC javaCC = new JavaCC();
        javaCC.setLog(this.getLog());
        javaCC.setGrammarEncoding(this.grammarEncoding);
        javaCC.setOutputEncoding(this.outputEncoding);
        javaCC.setJdkVersion(this.jdkVersion);
        javaCC.setBuildParser(this.buildParser);
        javaCC.setBuildTokenManager(this.buildTokenManager);
        javaCC.setCacheTokens(this.cacheTokens);
        javaCC.setChoiceAmbiguityCheck(this.choiceAmbiguityCheck);
        javaCC.setCommonTokenAction(this.commonTokenAction);
        javaCC.setDebugLookAhead(this.debugLookAhead);
        javaCC.setDebugParser(this.debugParser);
        javaCC.setDebugTokenManager(this.debugTokenManager);
        javaCC.setErrorReporting(this.errorReporting);
        javaCC.setForceLaCheck(this.forceLaCheck);
        javaCC.setIgnoreCase(this.ignoreCase);
        javaCC.setJavaUnicodeEscape(this.javaUnicodeEscape);
        javaCC.setKeepLineColumn(this.keepLineColumn);
        javaCC.setLookAhead(this.lookAhead);
        javaCC.setOtherAmbiguityCheck(this.otherAmbiguityCheck);
        javaCC.setSanityCheck(this.sanityCheck);
        javaCC.setTokenManagerUsesParser(this.tokenManagerUsesParser);
        javaCC.setTokenExtends(this.tokenExtends);
        javaCC.setTokenFactory(this.tokenFactory);
        javaCC.setUnicodeInput(this.unicodeInput);
        javaCC.setUserCharStream(this.userCharStream);
        javaCC.setUserTokenManager(this.userTokenManager);
        javaCC.setSupportClassVisibilityPublic(this.supportClassVisibilityPublic);
        javaCC.setJavaTemplateType(this.javaTemplateType);
        return javaCC;
    }
}

