/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import jakarta.annotation.Nullable;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.mojo.javacc.UrlUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

class ForkedJvm {
    private StreamConsumer systemOut;
    private StreamConsumer systemErr;
    private final String executable;
    private File workingDirectory;
    private final Set<String> m_aClassPathEntries = new LinkedHashSet<String>();
    private String mainClass;
    private final List<String> cmdLineArgs = new ArrayList<String>();

    public ForkedJvm() {
        this.executable = ForkedJvm._getDefaultExecutable();
    }

    private static String _getDefaultExecutable() {
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    }

    public void setWorkingDirectory(File file) {
        this.workingDirectory = file;
    }

    public void setSystemOut(StreamConsumer streamConsumer) {
        this.systemOut = streamConsumer;
    }

    public void setSystemErr(StreamConsumer streamConsumer) {
        this.systemErr = streamConsumer;
    }

    private String _getClassPath() {
        return StringUtils.join(this.m_aClassPathEntries.iterator(), (String)File.pathSeparator);
    }

    public void addClassPathEntry(String string) {
        if (string != null) {
            this.m_aClassPathEntries.add(string);
        }
    }

    public final void addClassPathEntry(@Nullable File file) {
        if (file != null) {
            this.m_aClassPathEntries.add(file.getAbsolutePath());
        }
    }

    public final void addClassPathEntry(Class<?> clazz) {
        this.addClassPathEntry(ForkedJvm._getClassSource(clazz));
    }

    private static File _getClassSource(Class<?> clazz) {
        if (clazz != null) {
            String string = clazz.getName().replace('.', '/') + ".class";
            return ForkedJvm._getResourceSource(string, clazz.getClassLoader());
        }
        return null;
    }

    private static File _getClassSource(String string) {
        if (string != null) {
            String string2 = string.replace('.', '/') + ".class";
            return ForkedJvm._getResourceSource(string2, Thread.currentThread().getContextClassLoader());
        }
        return null;
    }

    @Nullable
    private static File _getResourceSource(String string, ClassLoader classLoader) {
        if (string != null) {
            URL uRL = classLoader != null ? classLoader.getResource(string) : ClassLoader.getSystemResource(string);
            return UrlUtils.getResourceRoot(uRL, string);
        }
        return null;
    }

    public void setMainClass(String string) {
        this.mainClass = string;
        this.addClassPathEntry(ForkedJvm._getClassSource(string));
    }

    public void setMainClass(Class<?> clazz) {
        this.mainClass = clazz != null ? clazz.getName() : null;
        this.addClassPathEntry(clazz);
    }

    private String[] _getArguments() {
        return this.cmdLineArgs.toArray(new String[this.cmdLineArgs.size()]);
    }

    public void addArgument(String string) {
        if (string != null) {
            this.cmdLineArgs.add(string);
        }
    }

    public void addArgument(File file) {
        if (file != null) {
            this.cmdLineArgs.add(file.getAbsolutePath());
        }
    }

    public void addArguments(String[] stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                this.addArgument(string);
            }
        }
    }

    private Commandline _createCommandLine() {
        String string;
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.executable);
        if (this.workingDirectory != null) {
            commandline.setWorkingDirectory(this.workingDirectory.getAbsolutePath());
        }
        if ((string = this._getClassPath()) != null && string.length() > 0) {
            commandline.addArguments(new String[]{"-cp", string});
        }
        if (this.mainClass != null && this.mainClass.length() > 0) {
            commandline.addArguments(new String[]{this.mainClass});
        }
        commandline.addArguments(this._getArguments());
        return commandline;
    }

    public int run() throws Exception {
        return CommandLineUtils.executeCommandLine((Commandline)this._createCommandLine(), (StreamConsumer)this.systemOut, (StreamConsumer)this.systemErr);
    }

    public String toString() {
        return String.valueOf(this._createCommandLine());
    }
}

