/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.FileUtils;

class GrammarInfo {
    private final File sourceDirectory;
    private final String grammarFile;
    private final String parserPackage;
    private final String parserDirectory;
    private final String parserName;
    private final String parserFile;

    public GrammarInfo(File file, String string) throws IOException {
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("source directory is not absolute: " + String.valueOf(file));
        }
        this.sourceDirectory = file;
        File file2 = new File(string);
        if (!file2.isAbsolute()) {
            this.grammarFile = file2.getPath();
        } else if (file2.getPath().startsWith(file.getPath())) {
            this.grammarFile = file2.getPath().substring(file.getPath().length() + 1);
        } else {
            throw new IllegalArgumentException("input file is not relative to source directory:" + string);
        }
        String string2 = FileUtils.fileRead((File)this.getGrammarFile());
        this.parserPackage = this.findPackageName(string2);
        this.parserDirectory = this.parserPackage.replace('.', File.separatorChar);
        String string3 = this.findParserName(string2);
        this.parserName = string3.length() <= 0 ? FileUtils.removeExtension((String)file2.getName()) : string3;
        this.parserFile = this.parserDirectory.length() > 0 ? new File(this.parserDirectory, this.parserName + ".java").getPath() : this.parserName + ".java";
    }

    private String findPackageName(String string) {
        Matcher matcher = Pattern.compile("package\\s+([^\\s.;]+(\\.[^\\s.;]+)*)\\s*;").matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private String findParserName(String string) {
        Matcher matcher = Pattern.compile("PARSER_BEGIN\\s*\\(\\s*([^\\s\\)]+)\\s*\\)").matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public File getGrammarFile() {
        return new File(this.sourceDirectory, this.grammarFile);
    }

    public String getRelativeGrammarFile() {
        return this.grammarFile;
    }

    public String resolvePackageName(String string) {
        Object object = string;
        if (object != null && ((String)object).startsWith("*") && ((String)(object = this.getParserPackage() + ((String)object).substring(1))).startsWith(".")) {
            object = ((String)object).substring(1);
        }
        return object;
    }

    public String getParserPackage() {
        return this.parserPackage;
    }

    public String getParserDirectory() {
        return this.parserDirectory;
    }

    public String getParserName() {
        return this.parserName;
    }

    public String getParserFile() {
        return this.parserFile;
    }

    public String toString() {
        return String.valueOf(this.getGrammarFile()) + " -> " + this.getParserFile();
    }
}

