/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.javacc.AbstractJavaCCMojo;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JJTree;
import org.codehaus.mojo.javacc.JavaCC;

@Mojo(name="jjtree-javacc", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class JJTreeJavaCCMojo
extends AbstractJavaCCMojo {
    @Parameter(property="buildNodeFiles")
    private Boolean buildNodeFiles;
    @Parameter(property="multi")
    private Boolean multi;
    @Parameter(property="nodeDefaultVoid")
    private Boolean nodeDefaultVoid;
    @Parameter(property="nodeClass")
    private String nodeClass;
    @Parameter(property="nodeFactory")
    private String nodeFactory;
    @Parameter(property="nodePackage")
    private String nodePackage;
    @Parameter(property="nodePrefix")
    private String nodePrefix;
    @Parameter(property="nodeScopeHook")
    private Boolean nodeScopeHook;
    @Parameter(property="nodeUsesParser")
    private Boolean nodeUsesParser;
    @Parameter(property="trackTokens")
    private Boolean trackTokens;
    @Parameter(property="visitor")
    private Boolean visitor;
    @Parameter(property="visitorDataType")
    private String visitorDataType;
    @Parameter(property="visitorReturnType")
    private String visitorReturnType;
    @Parameter(property="visitorException")
    private String visitorException;
    @Parameter(property="sourceDirectory", defaultValue="${basedir}/src/main/jjtree")
    private File sourceDirectory;
    @Parameter(property="interimDirectory", defaultValue="${project.build.directory}/generated-sources/jjtree")
    private File interimDirectory;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/javacc")
    private File outputDirectory;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(property="lastModGranularityMs", defaultValue="0")
    private int staleMillis;

    @Override
    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    @Override
    protected String[] getIncludes() {
        if (this.includes != null) {
            return this.includes;
        }
        return new String[]{"**/*.jj", "**/*.JJ", "**/*.jjt", "**/*.JJT"};
    }

    @Override
    protected String[] getExcludes() {
        return this.excludes;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected int getStaleMillis() {
        return this.staleMillis;
    }

    private File getInterimDirectory() {
        return this.interimDirectory;
    }

    @Override
    protected File[] getCompileSourceRoots() {
        return new File[]{this.getOutputDirectory(), this.getInterimDirectory()};
    }

    @Override
    protected void processGrammar(GrammarInfo grammarInfo) throws MojoExecutionException, MojoFailureException {
        File file = grammarInfo.getGrammarFile();
        File file2 = file.getParentFile();
        File file3 = this.getTempDirectory();
        File file4 = new File(file3, "node");
        File file5 = new File(file3, "parser");
        String string = grammarInfo.resolvePackageName(this.nodePackage);
        JJTree jJTree = this.newJJTree();
        jJTree.setInputFile(file);
        jJTree.setOutputDirectory(file4);
        jJTree.setNodePackage(string);
        jJTree.run();
        JavaCC javaCC = this.newJavaCC();
        javaCC.setInputFile(jJTree.getOutputFile());
        javaCC.setOutputDirectory(file5);
        javaCC.run();
        this.copyGrammarOutput(this.getInterimDirectory(), string != null ? string : grammarInfo.getParserPackage(), file4, grammarInfo.getParserName() + "TreeConstants*");
        this.copyGrammarOutput(this.getOutputDirectory(), grammarInfo.getParserPackage(), file5, grammarInfo.getParserName() + "*");
        if (!this.isSourceRoot(grammarInfo.getSourceDirectory())) {
            this.copyGrammarOutput(this.getOutputDirectory(), grammarInfo.getParserPackage(), file2, "*");
        }
        this.deleteTempDirectory(file3);
    }

    protected JJTree newJJTree() {
        JJTree jJTree = new JJTree();
        jJTree.setLog(this.getLog());
        jJTree.setGrammarEncoding(this.getGrammarEncoding());
        jJTree.setOutputEncoding(this.getOutputEncoding());
        jJTree.setJdkVersion(this.getJdkVersion());
        jJTree.setBuildNodeFiles(this.buildNodeFiles);
        jJTree.setMulti(this.multi);
        jJTree.setNodeDefaultVoid(this.nodeDefaultVoid);
        jJTree.setNodeClass(this.nodeClass);
        jJTree.setNodeFactory(this.nodeFactory);
        jJTree.setNodePrefix(this.nodePrefix);
        jJTree.setNodeScopeHook(this.nodeScopeHook);
        jJTree.setNodeUsesParser(this.nodeUsesParser);
        jJTree.setTrackTokens(this.trackTokens);
        jJTree.setVisitor(this.visitor);
        jJTree.setVisitorDataType(this.visitorDataType);
        jJTree.setVisitorReturnType(this.visitorReturnType);
        jJTree.setVisitorException(this.visitorException);
        jJTree.setJavaTemplateType(this.getJavaTemplateType());
        return jJTree;
    }
}

