/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.javacc.AbstractJavaCCMojo;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JTB;
import org.codehaus.mojo.javacc.JavaCC;

@Mojo(name="jtb-javacc", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class JTBJavaCCMojo
extends AbstractJavaCCMojo {
    @Parameter(property="package")
    private String packageName;
    @Parameter(property="nodePackageName")
    private String nodePackageName;
    @Parameter(property="visitorPackageName")
    private String visitorPackageName;
    @Parameter(property="supressErrorChecking")
    private Boolean supressErrorChecking;
    @Parameter(property="javadocFriendlyComments")
    private Boolean javadocFriendlyComments;
    @Parameter(property="descriptiveFieldNames")
    private Boolean descriptiveFieldNames;
    @Parameter(property="nodeParentClass")
    private String nodeParentClass;
    @Parameter(property="parentPointers")
    private Boolean parentPointers;
    @Parameter(property="specialTokens")
    private Boolean specialTokens;
    @Parameter(property="scheme")
    private Boolean scheme;
    @Parameter(property="printer")
    private Boolean printer;
    @Parameter(property="sourceDirectory", defaultValue="${basedir}/src/main/jtb")
    private File sourceDirectory;
    @Parameter(property="interimDirectory", defaultValue="${project.build.directory}/generated-sources/jtb")
    private File interimDirectory;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/javacc")
    private File outputDirectory;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(property="lastModGranularityMs", defaultValue="0")
    private int staleMillis;

    @Override
    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    @Override
    protected String[] getIncludes() {
        if (this.includes != null) {
            return this.includes;
        }
        return new String[]{"**/*.jj", "**/*.JJ", "**/*.jtb", "**/*.JTB"};
    }

    @Override
    protected String[] getExcludes() {
        return this.excludes;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected int getStaleMillis() {
        return this.staleMillis;
    }

    private File getInterimDirectory() {
        return this.interimDirectory;
    }

    @Override
    protected File[] getCompileSourceRoots() {
        return new File[]{this.getOutputDirectory(), this.getInterimDirectory()};
    }

    @Override
    protected void processGrammar(GrammarInfo grammarInfo) throws MojoExecutionException, MojoFailureException {
        File file;
        File file2 = grammarInfo.getGrammarFile();
        File file3 = file2.getParentFile();
        File file4 = file = this.getTempDirectory();
        String string = grammarInfo.resolvePackageName(this.getNodePackageName());
        File file5 = new File(file, "node");
        String string2 = grammarInfo.resolvePackageName(this.getVisitorPackageName());
        File file6 = new File(file, "visitor");
        File file7 = new File(file, "parser");
        JTB jTB = this.newJTB();
        jTB.setInputFile(file2);
        jTB.setOutputDirectory(file4);
        jTB.setNodeDirectory(file5);
        jTB.setVisitorDirectory(file6);
        jTB.setNodePackageName(string);
        jTB.setVisitorPackageName(string2);
        jTB.run();
        JavaCC javaCC = this.newJavaCC();
        javaCC.setInputFile(jTB.getOutputFile());
        javaCC.setOutputDirectory(file7);
        javaCC.run();
        this.copyGrammarOutput(this.getInterimDirectory(), string, file5, "!Node*");
        this.copyGrammarOutput(this.getInterimDirectory(), string2, file6, "");
        this.copyGrammarOutput(this.getOutputDirectory(), grammarInfo.getParserPackage(), file7, grammarInfo.getParserName() + "*");
        if (!this.isSourceRoot(grammarInfo.getSourceDirectory())) {
            this.copyGrammarOutput(this.getOutputDirectory(), grammarInfo.getParserPackage(), file3, "*");
        }
        this.deleteTempDirectory(file);
    }

    private String getNodePackageName() {
        if (this.packageName != null) {
            return this.packageName + ".syntaxtree";
        }
        if (this.nodePackageName != null) {
            return this.nodePackageName;
        }
        return "*.syntaxtree";
    }

    private String getVisitorPackageName() {
        if (this.packageName != null) {
            return this.packageName + ".visitor";
        }
        if (this.visitorPackageName != null) {
            return this.visitorPackageName;
        }
        return "*.visitor";
    }

    private JTB newJTB() {
        JTB jTB = new JTB();
        jTB.setLog(this.getLog());
        jTB.setDescriptiveFieldNames(this.descriptiveFieldNames);
        jTB.setJavadocFriendlyComments(this.javadocFriendlyComments);
        jTB.setNodeParentClass(this.nodeParentClass);
        jTB.setParentPointers(this.parentPointers);
        jTB.setPrinter(this.printer);
        jTB.setScheme(this.scheme);
        jTB.setSpecialTokens(this.specialTokens);
        jTB.setSupressErrorChecking(this.supressErrorChecking);
        return jTB;
    }
}

