/*
 * Decompiled with CFR 0.152.
 */
package com.helger.maven.schematron;

import com.helger.commons.error.IError;
import com.helger.commons.string.StringHelper;
import com.helger.xml.transform.AbstractTransformErrorListener;
import java.io.File;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.sonatype.plexus.build.incremental.BuildContext;

public class PluginErrorListener
extends AbstractTransformErrorListener {
    private final BuildContext m_aBuildContext;
    private final File m_aSourceFile;

    public PluginErrorListener(@Nonnull BuildContext buildContext, @Nonnull File file) {
        this.m_aBuildContext = buildContext;
        this.m_aSourceFile = file;
    }

    public static void logIError(@Nonnull BuildContext buildContext, @Nonnull File file, @Nonnull IError iError) {
        int n = iError.getErrorLocation().getLineNumber();
        int n2 = iError.getErrorLocation().getColumnNumber();
        String string = StringHelper.getImplodedNonEmpty((String)" - ", (String[])new String[]{iError.getErrorText(Locale.US), iError.getLinkedExceptionMessage()});
        buildContext.addMessage(file, n <= 0 ? 0 : n, n2 <= 0 ? 0 : n2, string, iError.isError() ? 2 : 1, iError.getLinkedExceptionCause());
    }

    protected void internalLog(@Nonnull IError iError) {
        PluginErrorListener.logIError(this.m_aBuildContext, this.m_aSourceFile, iError);
    }
}

