/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.pgcc.parser.ICCCharacter;
import com.helger.pgcc.parser.JavaCCErrors;

public class CharacterRange
implements ICCCharacter {
    private int m_nColumn;
    private int m_nLine;
    private char m_nRight;
    private char m_nLeft;

    CharacterRange(char c, char c2) {
        if (c > c2) {
            JavaCCErrors.semantic_error(this, "Invalid range : \"" + c + "\" - \"" + c2 + "\". First character shoud be less than or equal to the second one in a range.");
        }
        this.setLeft(c);
        this.setRight(c2);
    }

    void setLine(int n) {
        this.m_nLine = n;
    }

    int getLine() {
        return this.m_nLine;
    }

    void setColumn(int n) {
        this.m_nColumn = n;
    }

    int getColumn() {
        return this.m_nColumn;
    }

    public void setLeft(char c) {
        this.m_nLeft = c;
    }

    public char getLeft() {
        return this.m_nLeft;
    }

    public void setRight(char c) {
        this.m_nRight = c;
    }

    public char getRight() {
        return this.m_nRight;
    }

    public boolean isInRange(char c) {
        return c >= this.m_nLeft && c <= this.m_nRight;
    }

    public boolean isSubRangeOf(CharacterRange characterRange) {
        return this.m_nLeft >= characterRange.getLeft() && this.m_nRight <= characterRange.getRight();
    }
}

