/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.commons.string.StringHelper;
import com.helger.pgcc.output.EOutputLanguage;
import com.helger.pgcc.output.OutputHelper;
import com.helger.pgcc.parser.AbstractExpRegularExpression;
import com.helger.pgcc.parser.ETokenKind;
import com.helger.pgcc.parser.ExpAction;
import com.helger.pgcc.parser.ExpRChoice;
import com.helger.pgcc.parser.ExpRStringLiteral;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.LexGenJava;
import com.helger.pgcc.parser.NfaState;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.RegExprSpec;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.parser.TokenProduction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LexGenCpp
extends LexGenJava {
    private void _printClassHead() {
        ArrayList<String> arrayList = new ArrayList<String>(JavaCCGlobals.s_toolNames);
        arrayList.add("ParserGeneratorCC");
        this.switchToStaticsFile();
        this.switchToIncludeFile();
        this.genCodeLine("#include \"stdio.h\"");
        this.genCodeLine("#include \"JavaCC.h\"");
        this.genCodeLine("#include \"CharStream.h\"");
        this.genCodeLine("#include \"Token.h\"");
        this.genCodeLine("#include \"ErrorHandler.h\"");
        this.genCodeLine("#include \"TokenManager.h\"");
        this.genCodeLine("#include \"" + JavaCCGlobals.s_cu_name + "Constants.h\"");
        if (Options.stringValue("TOKEN_MANAGER_INCLUDES").length() > 0) {
            this.genCodeLine("#include \"" + Options.stringValue("TOKEN_MANAGER_INCLUDES") + "\"\n");
        }
        this.genCodeLine();
        if (Options.stringValue("NAMESPACE").length() > 0) {
            this.genCodeLine("namespace " + Options.stringValue("NAMESPACE_OPEN"));
        }
        this.genCodeLine("class " + JavaCCGlobals.s_cu_name + ";");
        this.genCodeLine();
        this.genCodeLine("/** Token Manager. */");
        String string = Options.stringValue("TOKEN_MANAGER_SUPER_CLASS");
        this.genClassStart(null, s_tokMgrClassName, new String[]{}, new String[]{"public TokenManager" + (string == null ? "" : ", public " + string)});
        if (JavaCCGlobals.s_token_mgr_decls != null && JavaCCGlobals.s_token_mgr_decls.size() > 0) {
            Token token = JavaCCGlobals.s_token_mgr_decls.get(0);
            boolean bl = false;
            boolean bl2 = Options.isCommonTokenAction();
            this.printTokenSetup(JavaCCGlobals.s_token_mgr_decls.get(0));
            this.m_ccol = 1;
            this.switchToMainFile();
            for (int i = 0; i < JavaCCGlobals.s_token_mgr_decls.size(); ++i) {
                token = JavaCCGlobals.s_token_mgr_decls.get(i);
                if (token.kind == 150 && bl2 && !bl && (bl = token.image.equals("CommonTokenAction"))) {
                    token.image = JavaCCGlobals.s_cu_name + "TokenManager::" + token.image;
                }
                this.printToken(token);
            }
            this.switchToIncludeFile();
            this.genCodeLine("  void CommonTokenAction(Token* token);");
            if (Options.isTokenManagerUsesParser()) {
                this.genCodeLine("  void setParser(void* parser) {");
                this.genCodeLine("      this->parser = (" + JavaCCGlobals.s_cu_name + "*) parser;");
                this.genCodeLine("  }");
            }
            this.genCodeLine();
            if (bl2 && !bl) {
                JavaCCErrors.warning("You have the COMMON_TOKEN_ACTION option set. But it appears you have not defined the method :\n      void CommonTokenAction(Token *t)\nin your TOKEN_MGR_DECLS. The generated token manager will not compile.");
            }
        } else if (Options.isCommonTokenAction()) {
            JavaCCErrors.warning("You have the COMMON_TOKEN_ACTION option set. But you have not defined the method :\n      void CommonTokenAction(Token *t)\nin your TOKEN_MGR_DECLS. The generated token manager will not compile.");
        }
        this.genCodeLine();
        this.genCodeLine("  FILE *debugStream;");
        this.generateMethodDefHeader("  void ", s_tokMgrClassName, "setDebugStream(FILE *ds)");
        this.genCodeLine("{ debugStream = ds; }");
        this.switchToIncludeFile();
        if (Options.isTokenManagerUsesParser()) {
            this.genCodeLine();
            this.genCodeLine("private:");
            this.genCodeLine("  " + JavaCCGlobals.s_cu_name + "* parser = nullptr;");
        }
        this.switchToMainFile();
    }

    private void _dumpDebugMethods() throws IOException {
        this.writeTemplate("/templates/cpp/DumpDebugMethods.template", "maxOrdinal", Integer.toString(s_maxOrdinal), "stateSetSize", Integer.toString(s_stateSetSize));
    }

    private static void _buildLexStatesTable() {
        int n;
        Iterator<TokenProduction> iterator = JavaCCGlobals.s_rexprlist.iterator();
        String[] stringArray = new String[JavaCCGlobals.s_lexstate_I2S.size()];
        while (iterator.hasNext()) {
            TokenProduction tokenProduction = iterator.next();
            List<RegExprSpec> list = tokenProduction.m_respecs;
            for (n = 0; n < tokenProduction.m_lexStates.length; ++n) {
                ArrayList<TokenProduction> arrayList = (ArrayList<TokenProduction>)s_allTpsForState.get(tokenProduction.m_lexStates[n]);
                if (arrayList == null) {
                    stringArray[LexGenCpp.s_maxLexStates++] = tokenProduction.m_lexStates[n];
                    arrayList = new ArrayList<TokenProduction>();
                    s_allTpsForState.put(tokenProduction.m_lexStates[n], arrayList);
                }
                arrayList.add(tokenProduction);
            }
            if (list == null || list.size() == 0) continue;
            for (n = 0; n < list.size(); ++n) {
                AbstractExpRegularExpression abstractExpRegularExpression = list.get((int)n).rexp;
                if (s_maxOrdinal > abstractExpRegularExpression.m_ordinal) continue;
                s_maxOrdinal = abstractExpRegularExpression.m_ordinal + 1;
            }
        }
        s_kinds = new ETokenKind[s_maxOrdinal];
        s_toSkip = new long[s_maxOrdinal / 64 + 1];
        s_toSpecial = new long[s_maxOrdinal / 64 + 1];
        s_toMore = new long[s_maxOrdinal / 64 + 1];
        s_toToken = new long[s_maxOrdinal / 64 + 1];
        LexGenCpp.s_toToken[0] = 1L;
        s_actions = new ExpAction[s_maxOrdinal];
        LexGenCpp.s_actions[0] = JavaCCGlobals.s_actForEof;
        s_hasTokenActions = JavaCCGlobals.s_actForEof != null;
        s_initStates.clear();
        s_canMatchAnyChar = new int[s_maxLexStates];
        s_canLoop = new boolean[s_maxLexStates];
        s_stateHasActions = new boolean[s_maxLexStates];
        s_lexStateName = new String[s_maxLexStates];
        s_singlesToSkip = new NfaState[s_maxLexStates];
        System.arraycopy(stringArray, 0, s_lexStateName, 0, s_maxLexStates);
        for (n = 0; n < s_maxLexStates; ++n) {
            LexGenCpp.s_canMatchAnyChar[n] = -1;
        }
        s_hasNfa = new boolean[s_maxLexStates];
        s_mixed = new boolean[s_maxLexStates];
        s_maxLongsReqd = new int[s_maxLexStates];
        s_initMatch = new int[s_maxLexStates];
        s_newLexState = new String[s_maxOrdinal];
        LexGenCpp.s_newLexState[0] = JavaCCGlobals.s_nextStateForEof;
        s_hasEmptyMatch = false;
        s_lexStates = new int[s_maxOrdinal];
        s_ignoreCase = new boolean[s_maxOrdinal];
        s_rexprs = new AbstractExpRegularExpression[s_maxOrdinal];
        ExpRStringLiteral.s_allImages = new String[s_maxOrdinal];
        s_canReachOnMore = new boolean[s_maxLexStates];
    }

    private static int _getIndex(String string) {
        for (int i = 0; i < s_lexStateName.length; ++i) {
            if (s_lexStateName[i] == null || !s_lexStateName[i].equals(string)) continue;
            return i;
        }
        throw new IllegalStateException("Should never come here");
    }

    @Override
    public void start() throws IOException {
        if (!Options.isBuildTokenManager() || Options.isUserTokenManager() || JavaCCErrors.getErrorCount() > 0) {
            return;
        }
        s_keepLineCol = Options.isKeepLineColumn();
        ArrayList<ExpRChoice> arrayList = new ArrayList<ExpRChoice>();
        s_tokMgrClassName = JavaCCGlobals.s_cu_name + "TokenManager";
        this._printClassHead();
        LexGenCpp._buildLexStatesTable();
        boolean bl = false;
        for (Map.Entry object : s_allTpsForState.entrySet()) {
            NfaState.reInitStatic();
            ExpRStringLiteral.reInitStatic();
            String string = (String)object.getKey();
            s_lexStateIndex = LexGenCpp._getIndex(string);
            s_lexStateSuffix = "_" + s_lexStateIndex;
            List list = (List)object.getValue();
            s_initialState = new NfaState();
            s_initStates.put(string, s_initialState);
            bl = false;
            LexGenCpp.s_singlesToSkip[LexGenCpp.s_lexStateIndex] = new NfaState();
            LexGenCpp.s_singlesToSkip[LexGenCpp.s_lexStateIndex].m_dummy = true;
            if (string.equals("DEFAULT")) {
                s_defaultLexState = s_lexStateIndex;
            }
            for (int i = 0; i < list.size(); ++i) {
                TokenProduction tokenProduction = (TokenProduction)list.get(i);
                ETokenKind eTokenKind = tokenProduction.m_kind;
                boolean bl2 = tokenProduction.m_ignoreCase;
                List<RegExprSpec> list2 = tokenProduction.m_respecs;
                if (i == 0) {
                    bl = bl2;
                }
                block8: for (int j = 0; j < list2.size(); ++j) {
                    ETokenKind[] eTokenKindArray;
                    RegExprSpec regExprSpec = list2.get(j);
                    s_curRE = regExprSpec.rexp;
                    s_curKind = LexGenCpp.s_curRE.m_ordinal;
                    LexGenCpp.s_rexprs[LexGenCpp.s_curKind] = s_curRE;
                    LexGenCpp.s_lexStates[LexGenCpp.s_curRE.m_ordinal] = s_lexStateIndex;
                    LexGenCpp.s_ignoreCase[LexGenCpp.s_curRE.m_ordinal] = bl2;
                    if (LexGenCpp.s_curRE.m_private_rexp) {
                        LexGenCpp.s_kinds[LexGenCpp.s_curRE.m_ordinal] = null;
                        continue;
                    }
                    if (s_curRE instanceof ExpRStringLiteral && StringHelper.hasText((String)((ExpRStringLiteral)LexGenCpp.s_curRE).m_image)) {
                        ((ExpRStringLiteral)s_curRE).generateDfa();
                        if (i != 0 && !s_mixed[s_lexStateIndex] && bl != bl2) {
                            LexGenCpp.s_mixed[LexGenCpp.s_lexStateIndex] = true;
                        }
                    } else if (s_curRE.canMatchAnyChar()) {
                        if (s_canMatchAnyChar[s_lexStateIndex] == -1 || s_canMatchAnyChar[s_lexStateIndex] > LexGenCpp.s_curRE.m_ordinal) {
                            LexGenCpp.s_canMatchAnyChar[LexGenCpp.s_lexStateIndex] = LexGenCpp.s_curRE.m_ordinal;
                        }
                    } else {
                        if (s_curRE instanceof ExpRChoice) {
                            arrayList.add((ExpRChoice)s_curRE);
                        }
                        eTokenKindArray = s_curRE.generateNfa(bl2);
                        eTokenKindArray.end.m_isFinal = true;
                        eTokenKindArray.end.m_kind = LexGenCpp.s_curRE.m_ordinal;
                        s_initialState.addMove(eTokenKindArray.start);
                    }
                    if (s_kinds.length < LexGenCpp.s_curRE.m_ordinal) {
                        eTokenKindArray = new ETokenKind[LexGenCpp.s_curRE.m_ordinal + 1];
                        System.arraycopy(s_kinds, 0, eTokenKindArray, 0, s_kinds.length);
                        s_kinds = eTokenKindArray;
                    }
                    LexGenCpp.s_kinds[LexGenCpp.s_curRE.m_ordinal] = eTokenKind;
                    if (regExprSpec.nextState != null && !regExprSpec.nextState.equals(s_lexStateName[s_lexStateIndex])) {
                        LexGenCpp.s_newLexState[LexGenCpp.s_curRE.m_ordinal] = regExprSpec.nextState;
                    }
                    if (regExprSpec.act != null && regExprSpec.act.getActionTokens() != null && regExprSpec.act.getActionTokens().size() > 0) {
                        LexGenCpp.s_actions[LexGenCpp.s_curRE.m_ordinal] = regExprSpec.act;
                    }
                    switch (eTokenKind) {
                        case SPECIAL: {
                            s_hasSkipActions |= s_actions[LexGenCpp.s_curRE.m_ordinal] != null || s_newLexState[LexGenCpp.s_curRE.m_ordinal] != null;
                            s_hasSpecial = true;
                            int n = LexGenCpp.s_curRE.m_ordinal / 64;
                            s_toSpecial[n] = s_toSpecial[n] | 1L << LexGenCpp.s_curRE.m_ordinal % 64;
                            int n2 = LexGenCpp.s_curRE.m_ordinal / 64;
                            s_toSkip[n2] = s_toSkip[n2] | 1L << LexGenCpp.s_curRE.m_ordinal % 64;
                            continue block8;
                        }
                        case SKIP: {
                            s_hasSkipActions |= s_actions[LexGenCpp.s_curRE.m_ordinal] != null;
                            s_hasSkip = true;
                            int n = LexGenCpp.s_curRE.m_ordinal / 64;
                            s_toSkip[n] = s_toSkip[n] | 1L << LexGenCpp.s_curRE.m_ordinal % 64;
                            continue block8;
                        }
                        case MORE: {
                            s_hasMoreActions |= s_actions[LexGenCpp.s_curRE.m_ordinal] != null;
                            s_hasMore = true;
                            int n = LexGenCpp.s_curRE.m_ordinal / 64;
                            s_toMore[n] = s_toMore[n] | 1L << LexGenCpp.s_curRE.m_ordinal % 64;
                            if (s_newLexState[LexGenCpp.s_curRE.m_ordinal] != null) {
                                LexGenCpp.s_canReachOnMore[LexGenCpp._getIndex((String)LexGenCpp.s_newLexState[LexGenCpp.s_curRE.m_ordinal])] = true;
                                continue block8;
                            }
                            LexGenCpp.s_canReachOnMore[LexGenCpp.s_lexStateIndex] = true;
                            continue block8;
                        }
                        case TOKEN: {
                            s_hasTokenActions |= s_actions[LexGenCpp.s_curRE.m_ordinal] != null;
                            int n = LexGenCpp.s_curRE.m_ordinal / 64;
                            s_toToken[n] = s_toToken[n] | 1L << LexGenCpp.s_curRE.m_ordinal % 64;
                            continue block8;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
            }
            NfaState.computeClosures();
            for (NfaState nfaState : LexGenCpp.s_initialState.m_epsilonMoves) {
                nfaState.generateCode();
            }
            boolean bl3 = LexGenCpp.s_hasNfa[LexGenCpp.s_lexStateIndex] = NfaState.s_generatedStates != 0;
            if (s_hasNfa[s_lexStateIndex]) {
                s_initialState.generateCode();
                s_initialState.generateInitMoves();
            }
            if (LexGenCpp.s_initialState.m_kind != Integer.MAX_VALUE && LexGenCpp.s_initialState.m_kind != 0) {
                if ((s_toSkip[LexGenCpp.s_initialState.m_kind / 64] & 1L << LexGenCpp.s_initialState.m_kind) != 0L || (s_toSpecial[LexGenCpp.s_initialState.m_kind / 64] & 1L << LexGenCpp.s_initialState.m_kind) != 0L) {
                    s_hasSkipActions = true;
                } else if ((s_toMore[LexGenCpp.s_initialState.m_kind / 64] & 1L << LexGenCpp.s_initialState.m_kind) != 0L) {
                    s_hasMoreActions = true;
                } else {
                    s_hasTokenActions = true;
                }
                if (s_initMatch[s_lexStateIndex] == 0 || s_initMatch[s_lexStateIndex] > LexGenCpp.s_initialState.m_kind) {
                    LexGenCpp.s_initMatch[LexGenCpp.s_lexStateIndex] = LexGenCpp.s_initialState.m_kind;
                    s_hasEmptyMatch = true;
                }
            } else if (s_initMatch[s_lexStateIndex] == 0) {
                LexGenCpp.s_initMatch[LexGenCpp.s_lexStateIndex] = Integer.MAX_VALUE;
            }
            ExpRStringLiteral.fillSubString();
            if (s_hasNfa[s_lexStateIndex] && !s_mixed[s_lexStateIndex]) {
                ExpRStringLiteral.generateNfaStartStates(this, s_initialState);
            }
            ExpRStringLiteral.dumpDfaCode(this);
            if (s_hasNfa[s_lexStateIndex]) {
                NfaState.dumpMoveNfa(this);
            }
            if (s_stateSetSize >= NfaState.s_generatedStates) continue;
            s_stateSetSize = NfaState.s_generatedStates;
        }
        for (ExpRChoice expRChoice : arrayList) {
            expRChoice.checkUnmatchability();
        }
        NfaState.dumpStateSets(this);
        LexGenCpp.checkEmptyStringMatch();
        NfaState.dumpNonAsciiMoveMethods(this);
        ExpRStringLiteral.dumpStrLiteralImages(this);
        this._dumpFillToken();
        this._dumpGetNextToken();
        if (Options.isDebugTokenManager()) {
            NfaState.dumpStatesForKind(this);
            this._dumpDebugMethods();
        }
        if (s_hasLoop) {
            this.switchToStaticsFile();
            this.genCodeLine("static int  jjemptyLineNo[" + s_maxLexStates + "];");
            this.genCodeLine("static int  jjemptyColNo[" + s_maxLexStates + "];");
            this.genCodeLine("static bool jjbeenHere[" + s_maxLexStates + "];");
            this.switchToMainFile();
        }
        if (s_hasSkipActions) {
            this._dumpSkipActions();
        }
        if (s_hasMoreActions) {
            this._dumpMoreActions();
        }
        if (s_hasTokenActions) {
            this._dumpTokenActions();
        }
        NfaState.printBoilerPlateCPP(this);
        this.writeTemplate("/templates/cpp/TokenManagerBoilerPlateMethods.template", "charStreamName", "CharStream", "parserClassName", JavaCCGlobals.s_cu_name, "defaultLexState", "defaultLexState", "lexStateNameLength", Integer.toString(s_lexStateName.length));
        this._dumpBoilerPlateInHeader();
        this._dumpStaticVarDeclarations();
        this.switchToIncludeFile();
        this.writeTemplate("/templates/cpp/DumpVarDeclarations.template", "charStreamName", "CharStream", "lexStateNameLength", Integer.toString(s_lexStateName.length));
        this.genCodeLine("};");
        this.switchToStaticsFile();
        String string = Options.getOutputDirectory() + File.separator + s_tokMgrClassName + JavaCCGlobals.getFileExtension();
        this.saveOutput(string);
    }

    private void _dumpBoilerPlateInHeader() {
        EOutputLanguage eOutputLanguage = this.getOutputLanguage();
        this.switchToIncludeFile();
        this.genCodeLine("#ifndef JAVACC_CHARSTREAM");
        this.genCodeLine("#define JAVACC_CHARSTREAM CharStream");
        this.genCodeLine("#endif");
        this.genCodeLine();
        this.genCodeLine("private:");
        this.genCodeLine("  void ReInitRounds();");
        this.genCodeLine();
        this.genCodeLine("public:");
        this.genCodeLine("  " + s_tokMgrClassName + "(JAVACC_CHARSTREAM *stream, int lexState = " + s_defaultLexState + ");");
        this.genCodeLine("  virtual ~" + s_tokMgrClassName + "();");
        this.genCodeLine("  void ReInit(JAVACC_CHARSTREAM *stream, int lexState = " + s_defaultLexState + ");");
        this.genCodeLine("  void SwitchTo(int lexState);");
        this.genCodeLine("  void clear();");
        this.genCodeLine("  const JJSimpleString jjKindsForBitVector(int i, " + eOutputLanguage.getTypeLong() + " vec);");
        this.genCodeLine("  const JJSimpleString jjKindsForStateVector(int lexState, int vec[], int start, int end);");
        this.genCodeLine();
    }

    private void _dumpStaticVarDeclarations() {
        int n;
        EOutputLanguage eOutputLanguage = this.getOutputLanguage();
        this.switchToStaticsFile();
        this.genCodeLine();
        this.genCodeLine("/** Lexer state names. */");
        this.genStringLiteralArrayCPP("lexStateNames", s_lexStateName);
        if (s_maxLexStates > 1) {
            this.genCodeLine();
            this.genCodeLine("/** Lex State array. */");
            this.genCode("static const int jjnewLexState[] = {");
            for (n = 0; n < s_maxOrdinal; ++n) {
                if (n % 25 == 0) {
                    this.genCode("\n   ");
                }
                if (s_newLexState[n] == null) {
                    this.genCode("-1, ");
                    continue;
                }
                this.genCode(LexGenCpp._getIndex(s_newLexState[n]) + ", ");
            }
            this.genCodeLine("\n};");
        }
        if (s_hasSkip || s_hasMore || s_hasSpecial) {
            this.genCode("static const " + eOutputLanguage.getTypeLong() + " jjtoToken[] = {");
            for (n = 0; n < s_maxOrdinal / 64 + 1; ++n) {
                if (n % 4 == 0) {
                    this.genCode("\n   ");
                }
                this.genCode(eOutputLanguage.getLongHex(s_toToken[n]) + ", ");
            }
            this.genCodeLine("\n};");
        }
        if (s_hasSkip || s_hasSpecial) {
            this.genCode("static const " + eOutputLanguage.getTypeLong() + " jjtoSkip[] = {");
            for (n = 0; n < s_maxOrdinal / 64 + 1; ++n) {
                if (n % 4 == 0) {
                    this.genCode("\n   ");
                }
                this.genCode(eOutputLanguage.getLongHex(s_toSkip[n]) + ", ");
            }
            this.genCodeLine("\n};");
        }
        if (s_hasSpecial) {
            this.genCode("static const " + eOutputLanguage.getTypeLong() + " jjtoSpecial[] = {");
            for (n = 0; n < s_maxOrdinal / 64 + 1; ++n) {
                if (n % 4 == 0) {
                    this.genCode("\n   ");
                }
                this.genCode(eOutputLanguage.getLongHex(s_toSpecial[n]) + ", ");
            }
            this.genCodeLine("\n};");
        }
    }

    private void _dumpFillToken() {
        double d = OutputHelper.getVersionDashStar("Token.java");
        boolean bl = d > 4.09;
        this.generateMethodDefHeader("Token *", s_tokMgrClassName, "jjFillToken()");
        this.genCodeLine("{");
        this.genCodeLine("   Token *t;");
        this.genCodeLine("   JJString curTokenImage;");
        if (s_keepLineCol) {
            this.genCodeLine("   int beginLine   = -1;");
            this.genCodeLine("   int endLine     = -1;");
            this.genCodeLine("   int beginColumn = -1;");
            this.genCodeLine("   int endColumn   = -1;");
        }
        if (s_hasEmptyMatch) {
            this.genCodeLine("   if (jjmatchedPos < 0)");
            this.genCodeLine("   {");
            this.genCodeLine("       curTokenImage = image.c_str();");
            if (s_keepLineCol) {
                this.genCodeLine("   if (input_stream->getTrackLineColumn()) {");
                this.genCodeLine("      beginLine = endLine = input_stream->getEndLine();");
                this.genCodeLine("      beginColumn = endColumn = input_stream->getEndColumn();");
                this.genCodeLine("   }");
            }
            this.genCodeLine("   }");
            this.genCodeLine("   else");
            this.genCodeLine("   {");
            this.genCodeLine("      JJString im = jjstrLiteralImages[jjmatchedKind];");
            this.genCodeLine("      curTokenImage = (im.length() == 0) ? input_stream->GetImage() : im;");
            if (s_keepLineCol) {
                this.genCodeLine("   if (input_stream->getTrackLineColumn()) {");
                this.genCodeLine("      beginLine = input_stream->getBeginLine();");
                this.genCodeLine("      beginColumn = input_stream->getBeginColumn();");
                this.genCodeLine("      endLine = input_stream->getEndLine();");
                this.genCodeLine("      endColumn = input_stream->getEndColumn();");
                this.genCodeLine("   }");
            }
            this.genCodeLine("   }");
        } else {
            this.genCodeLine("   JJString im = jjstrLiteralImages[jjmatchedKind];");
            this.genCodeLine("   curTokenImage = (im.length() == 0) ? input_stream->GetImage() : im;");
            if (s_keepLineCol) {
                this.genCodeLine("   if (input_stream->getTrackLineColumn()) {");
                this.genCodeLine("     beginLine = input_stream->getBeginLine();");
                this.genCodeLine("     beginColumn = input_stream->getBeginColumn();");
                this.genCodeLine("     endLine = input_stream->getEndLine();");
                this.genCodeLine("     endColumn = input_stream->getEndColumn();");
                this.genCodeLine("   }");
            }
        }
        if (Options.getTokenFactory().length() > 0) {
            this.genCodeLine("   t = " + this.getClassQualifier(Options.getTokenFactory()) + "newToken(jjmatchedKind, curTokenImage);");
        } else if (bl) {
            this.genCodeLine("   t = " + this.getClassQualifier("Token") + "newToken(jjmatchedKind, curTokenImage);");
        } else {
            this.genCodeLine("   t = " + this.getClassQualifier("Token") + "newToken(jjmatchedKind);");
            this.genCodeLine("   t->kind = jjmatchedKind;");
            this.genCodeLine("   t->image = curTokenImage;");
        }
        this.genCodeLine("   t->specialToken = nullptr;");
        this.genCodeLine("   t->next = nullptr;");
        if (s_keepLineCol) {
            this.genCodeLine();
            this.genCodeLine("   if (input_stream->getTrackLineColumn()) {");
            this.genCodeLine("   t->beginLine = beginLine;");
            this.genCodeLine("   t->endLine = endLine;");
            this.genCodeLine("   t->beginColumn = beginColumn;");
            this.genCodeLine("   t->endColumn = endColumn;");
            this.genCodeLine("   }");
        }
        this.genCodeLine();
        this.genCodeLine("   return t;");
        this.genCodeLine("}");
    }

    private void _dumpGetNextToken() {
        EOutputLanguage eOutputLanguage = this.getOutputLanguage();
        this.switchToIncludeFile();
        this.genCodeLine();
        this.genCodeLine("public:");
        this.genCodeLine("    int curLexState;");
        this.genCodeLine("    int jjnewStateCnt;");
        this.genCodeLine("    int jjround;");
        this.genCodeLine("    int jjmatchedPos;");
        this.genCodeLine("    int jjmatchedKind;");
        this.genCodeLine();
        this.switchToMainFile();
        this.genCodeLine("const int defaultLexState = " + s_defaultLexState + ";");
        this.genCodeLine("/** Get the next Token. */");
        this.generateMethodDefHeader("Token *", s_tokMgrClassName, "getNextToken()");
        this.genCodeLine("{");
        if (s_hasSpecial) {
            this.genCodeLine("  Token *specialToken = nullptr;");
        }
        this.genCodeLine("  Token *matchedToken = nullptr;");
        this.genCodeLine("  int curPos = 0;");
        this.genCodeLine();
        this.genCodeLine("  for (;;)");
        this.genCodeLine("  {");
        this.genCodeLine("   EOFLoop: ");
        this.genCodeLine("   if (input_stream->endOfInput())");
        this.genCodeLine("   {");
        if (Options.isDebugTokenManager()) {
            this.genCodeLine("      fprintf(debugStream, \"Returning the <EOF> token.\\n\");");
        }
        this.genCodeLine("      jjmatchedKind = 0;");
        this.genCodeLine("      jjmatchedPos = -1;");
        this.genCodeLine("      matchedToken = jjFillToken();");
        if (s_hasSpecial) {
            this.genCodeLine("      matchedToken->specialToken = specialToken;");
        }
        if (JavaCCGlobals.s_nextStateForEof != null || JavaCCGlobals.s_actForEof != null) {
            this.genCodeLine("      TokenLexicalActions(matchedToken);");
        }
        if (Options.isCommonTokenAction()) {
            this.genCodeLine("      CommonTokenAction(matchedToken);");
        }
        this.genCodeLine("      return matchedToken;");
        this.genCodeLine("   }");
        this.genCodeLine("   curChar = input_stream->BeginToken();");
        if (s_hasMoreActions || s_hasSkipActions || s_hasTokenActions) {
            this.genCodeLine("   image = jjimage;");
            this.genCodeLine("   image.clear();");
            this.genCodeLine("   jjimageLen = 0;");
        }
        this.genCodeLine();
        String string = "";
        if (s_hasMore) {
            this.genCodeLine("   for (;;)");
            this.genCodeLine("   {");
            string = "  ";
        }
        String string2 = "";
        String string3 = "";
        if (s_maxLexStates > 1) {
            this.genCodeLine(string + "   switch(curLexState)");
            this.genCodeLine(string + "   {");
            string2 = string + "   }";
            string3 = string + "     case ";
            string = string + "    ";
        }
        string = string + "   ";
        for (int i = 0; i < s_maxLexStates; ++i) {
            if (s_maxLexStates > 1) {
                this.genCodeLine(string3 + i + ":");
            }
            if (s_singlesToSkip[i].hasTransitions()) {
                this.genCodeLine(string + "{ input_stream->backup(0);");
                if (LexGenCpp.s_singlesToSkip[i].m_asciiMoves[0] != 0L && LexGenCpp.s_singlesToSkip[i].m_asciiMoves[1] != 0L) {
                    this.genCodeLine(string + "   while ((curChar < 64 && (" + eOutputLanguage.getLongHex(LexGenCpp.s_singlesToSkip[i].m_asciiMoves[0]) + " & (1L << curChar)) != 0L) || \n" + string + "          (curChar >> 6) == 1 && (" + eOutputLanguage.getLongHex(LexGenCpp.s_singlesToSkip[i].m_asciiMoves[1]) + " & (1L << (curChar & 077))) != " + eOutputLanguage.getLongPlain(0L) + ")");
                } else if (LexGenCpp.s_singlesToSkip[i].m_asciiMoves[1] == 0L) {
                    this.genCodeLine(string + "   while (curChar <= " + LexGenCpp.maxChar(LexGenCpp.s_singlesToSkip[i].m_asciiMoves[0]) + " && (" + eOutputLanguage.getLongHex(LexGenCpp.s_singlesToSkip[i].m_asciiMoves[0]) + " & (1L << curChar)) != " + eOutputLanguage.getLongPlain(0L) + ")");
                } else if (LexGenCpp.s_singlesToSkip[i].m_asciiMoves[0] == 0L) {
                    this.genCodeLine(string + "   while (curChar > 63 && curChar <= " + (LexGenCpp.maxChar(LexGenCpp.s_singlesToSkip[i].m_asciiMoves[1]) + 64) + " && (" + eOutputLanguage.getLongHex(LexGenCpp.s_singlesToSkip[i].m_asciiMoves[1]) + " & (1L << (curChar & 077))) != " + eOutputLanguage.getLongPlain(0L) + ")");
                }
                this.genCodeLine(string + "{");
                if (Options.isDebugTokenManager()) {
                    if (s_maxLexStates > 1) {
                        this.genCodeLine("      fprintf(debugStream, \"<%s>\" , addUnicodeEscapes(lexStateNames[curLexState]).c_str());");
                    }
                    this.genCodeLine("      fprintf(debugStream, \"Skipping character : %c(%d)\\n\", curChar, (int)curChar);");
                }
                this.genCodeLine(string + "if (input_stream->endOfInput()) { goto EOFLoop; }");
                this.genCodeLine(string + "curChar = input_stream->BeginToken();");
                this.genCodeLine(string + "}");
                this.genCodeLine(string + "}");
            }
            if (s_initMatch[i] != Integer.MAX_VALUE && s_initMatch[i] != 0) {
                if (Options.isDebugTokenManager()) {
                    this.genCodeLine("      fprintf(debugStream, \"   Matched the empty string as %s token.\\n\", addUnicodeEscapes(tokenImage[" + s_initMatch[i] + "]).c_str());");
                }
                this.genCodeLine(string + "jjmatchedKind = " + s_initMatch[i] + ";");
                this.genCodeLine(string + "jjmatchedPos = -1;");
                this.genCodeLine(string + "curPos = 0;");
            } else {
                this.genCodeLine(string + "jjmatchedKind = 0x" + Integer.toHexString(Integer.MAX_VALUE) + ";");
                this.genCodeLine(string + "jjmatchedPos = 0;");
            }
            if (Options.isDebugTokenManager()) {
                this.genCodeLine("   fprintf(debugStream, \"<%s>Current character : %c(%d) at line %d column %d\\n\",addUnicodeEscapes(lexStateNames[curLexState]).c_str(), curChar, (int)curChar, input_stream->getEndLine(), input_stream->getEndColumn());");
            }
            this.genCodeLine(string + "curPos = jjMoveStringLiteralDfa0_" + i + "();");
            if (s_canMatchAnyChar[i] != -1) {
                if (s_initMatch[i] != Integer.MAX_VALUE && s_initMatch[i] != 0) {
                    this.genCodeLine(string + "if (jjmatchedPos < 0 || (jjmatchedPos == 0 && jjmatchedKind > " + s_canMatchAnyChar[i] + "))");
                } else {
                    this.genCodeLine(string + "if (jjmatchedPos == 0 && jjmatchedKind > " + s_canMatchAnyChar[i] + ")");
                }
                this.genCodeLine(string + "{");
                if (Options.isDebugTokenManager()) {
                    this.genCodeLine("           fprintf(debugStream, \"   Current character matched as a %s token.\\n\", addUnicodeEscapes(tokenImage[" + s_canMatchAnyChar[i] + "]).c_str());");
                }
                this.genCodeLine(string + "   jjmatchedKind = " + s_canMatchAnyChar[i] + ";");
                if (s_initMatch[i] != Integer.MAX_VALUE && s_initMatch[i] != 0) {
                    this.genCodeLine(string + "   jjmatchedPos = 0;");
                }
                this.genCodeLine(string + "}");
            }
            if (s_maxLexStates <= 1) continue;
            this.genCodeLine(string + "break;");
        }
        if (s_maxLexStates > 1) {
            this.genCodeLine(string2);
        } else if (s_maxLexStates == 0) {
            this.genCodeLine("       jjmatchedKind = 0x" + Integer.toHexString(Integer.MAX_VALUE) + ";");
        }
        string = s_maxLexStates > 1 ? "  " : "";
        if (s_maxLexStates > 0) {
            this.genCodeLine(string + "   if (jjmatchedKind != 0x" + Integer.toHexString(Integer.MAX_VALUE) + ")");
            this.genCodeLine(string + "   {");
            this.genCodeLine(string + "      if (jjmatchedPos + 1 < curPos)");
            if (Options.isDebugTokenManager()) {
                this.genCodeLine(string + "      {");
                this.genCodeLine(string + "         fprintf(debugStream, \"   Putting back %d characters into the input stream.\\n\", (curPos - jjmatchedPos - 1));");
            }
            this.genCodeLine(string + "         input_stream->backup(curPos - jjmatchedPos - 1);");
            if (Options.isDebugTokenManager()) {
                this.genCodeLine(string + "      }");
            }
            if (Options.isDebugTokenManager()) {
                this.genCodeLine("    fprintf(debugStream, \"****** FOUND A %d(%s) MATCH (%s) ******\\n\", jjmatchedKind, addUnicodeEscapes(tokenImage[jjmatchedKind]).c_str(), addUnicodeEscapes(input_stream->GetSuffix(jjmatchedPos + 1)).c_str());");
            }
            if (s_hasSkip || s_hasMore || s_hasSpecial) {
                this.genCodeLine(string + "      if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)");
                this.genCodeLine(string + "      {");
            }
            this.genCodeLine(string + "         matchedToken = jjFillToken();");
            if (s_hasSpecial) {
                this.genCodeLine(string + "         matchedToken->specialToken = specialToken;");
            }
            if (s_hasTokenActions) {
                this.genCodeLine(string + "         TokenLexicalActions(matchedToken);");
            }
            if (s_maxLexStates > 1) {
                this.genCodeLine("       if (jjnewLexState[jjmatchedKind] != -1)");
                this.genCodeLine(string + "       curLexState = jjnewLexState[jjmatchedKind];");
            }
            if (Options.isCommonTokenAction()) {
                this.genCodeLine(string + "         CommonTokenAction(matchedToken);");
            }
            this.genCodeLine(string + "         return matchedToken;");
            if (s_hasSkip || s_hasMore || s_hasSpecial) {
                this.genCodeLine(string + "      }");
                if (s_hasSkip || s_hasSpecial) {
                    if (s_hasMore) {
                        this.genCodeLine(string + "      else if ((jjtoSkip[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)");
                    } else {
                        this.genCodeLine(string + "      else");
                    }
                    this.genCodeLine(string + "      {");
                    if (s_hasSpecial) {
                        this.genCodeLine(string + "         if ((jjtoSpecial[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)");
                        this.genCodeLine(string + "         {");
                        this.genCodeLine(string + "            matchedToken = jjFillToken();");
                        this.genCodeLine(string + "            if (specialToken == nullptr)");
                        this.genCodeLine(string + "               specialToken = matchedToken;");
                        this.genCodeLine(string + "            else");
                        this.genCodeLine(string + "            {");
                        this.genCodeLine(string + "               matchedToken->specialToken = specialToken;");
                        this.genCodeLine(string + "               specialToken = (specialToken->next = matchedToken);");
                        this.genCodeLine(string + "            }");
                        if (s_hasSkipActions) {
                            this.genCodeLine(string + "            SkipLexicalActions(matchedToken);");
                        }
                        this.genCodeLine(string + "         }");
                        if (s_hasSkipActions) {
                            this.genCodeLine(string + "         else");
                            this.genCodeLine(string + "            SkipLexicalActions(nullptr);");
                        }
                    } else if (s_hasSkipActions) {
                        this.genCodeLine(string + "         SkipLexicalActions(nullptr);");
                    }
                    if (s_maxLexStates > 1) {
                        this.genCodeLine("         if (jjnewLexState[jjmatchedKind] != -1)");
                        this.genCodeLine(string + "         curLexState = jjnewLexState[jjmatchedKind];");
                    }
                    this.genCodeLine(string + "         goto EOFLoop;");
                    this.genCodeLine(string + "      }");
                }
                if (s_hasMore) {
                    if (s_hasMoreActions) {
                        this.genCodeLine(string + "      MoreLexicalActions();");
                    } else if (s_hasSkipActions || s_hasTokenActions) {
                        this.genCodeLine(string + "      jjimageLen += jjmatchedPos + 1;");
                    }
                    if (s_maxLexStates > 1) {
                        this.genCodeLine("      if (jjnewLexState[jjmatchedKind] != -1)");
                        this.genCodeLine(string + "      curLexState = jjnewLexState[jjmatchedKind];");
                    }
                    this.genCodeLine(string + "      curPos = 0;");
                    this.genCodeLine(string + "      jjmatchedKind = 0x" + Integer.toHexString(Integer.MAX_VALUE) + ";");
                    this.genCodeLine(string + "   if (!input_stream->endOfInput()) {");
                    this.genCodeLine(string + "         curChar = input_stream->readChar();");
                    if (Options.isDebugTokenManager()) {
                        this.genCodeLine("   fprintf(debugStream, \"<%s>Current character : %c(%d) at line %d column %d\\n\",addUnicodeEscapes(lexStateNames[curLexState]).c_str(), curChar, (int)curChar, input_stream->getEndLine(), input_stream->getEndColumn());");
                    }
                    this.genCodeLine(string + "   continue;");
                    this.genCodeLine(string + " }");
                }
            }
            this.genCodeLine(string + "   }");
            this.genCodeLine(string + "   int error_line = input_stream->getEndLine();");
            this.genCodeLine(string + "   int error_column = input_stream->getEndColumn();");
            this.genCodeLine(string + "   JJString error_after;");
            this.genCodeLine(string + "   bool EOFSeen = false;");
            this.genCodeLine(string + "   if (input_stream->endOfInput()) {");
            this.genCodeLine(string + "      EOFSeen = true;");
            this.genCodeLine(string + "      error_after = curPos <= 1 ? EMPTY : input_stream->GetImage();");
            this.genCodeLine(string + "      if (curChar == '\\n' || curChar == '\\r') {");
            this.genCodeLine(string + "         error_line++;");
            this.genCodeLine(string + "         error_column = 0;");
            this.genCodeLine(string + "      }");
            this.genCodeLine(string + "      else");
            this.genCodeLine(string + "         error_column++;");
            this.genCodeLine(string + "   }");
            this.genCodeLine(string + "   if (!EOFSeen) {");
            this.genCodeLine(string + "      error_after = curPos <= 1 ? EMPTY : input_stream->GetImage();");
            this.genCodeLine(string + "   }");
            this.genCodeLine(string + "   errorHandler->lexicalError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, this);");
        }
        if (s_hasMore) {
            this.genCodeLine(string + " }");
        }
        this.genCodeLine("  }");
        this.genCodeLine("}");
        this.genCodeLine();
    }

    private void _dumpSkipActions() {
        this.generateMethodDefHeader("void ", s_tokMgrClassName, "SkipLexicalActions(Token *matchedToken)");
        this.genCodeLine("{");
        this.genCodeLine("   switch(jjmatchedKind)");
        this.genCodeLine("   {");
        for (int i = 0; i < s_maxOrdinal; ++i) {
            ExpAction expAction;
            if ((s_toSkip[i / 64] & 1L << i % 64) == 0L || ((expAction = s_actions[i]) == null || expAction.getActionTokens() == null || expAction.getActionTokens().size() == 0) && !s_canLoop[s_lexStates[i]]) continue;
            this.genCodeLine("      case " + i + " : {");
            if (s_initMatch[s_lexStates[i]] == i && s_canLoop[s_lexStates[i]]) {
                this.genCodeLine("         if (jjmatchedPos == -1)");
                this.genCodeLine("         {");
                this.genCodeLine("            if (jjbeenHere[" + s_lexStates[i] + "] &&");
                this.genCodeLine("                jjemptyLineNo[" + s_lexStates[i] + "] == input_stream->getBeginLine() &&");
                this.genCodeLine("                jjemptyColNo[" + s_lexStates[i] + "] == input_stream->getBeginColumn())");
                this.genCodeLine("               errorHandler->lexicalError(JJString(\"(\"Error: Bailing out of infinite loop caused by repeated empty string matches \" + \"at line \" + input_stream->getBeginLine() + \", \" + \"column \" + input_stream->getBeginColumn() + \".\")), this);");
                this.genCodeLine("            jjemptyLineNo[" + s_lexStates[i] + "] = input_stream->getBeginLine();");
                this.genCodeLine("            jjemptyColNo[" + s_lexStates[i] + "] = input_stream->getBeginColumn();");
                this.genCodeLine("            jjbeenHere[" + s_lexStates[i] + "] = true;");
                this.genCodeLine("         }");
            }
            if ((expAction = s_actions[i]) != null && expAction.getActionTokens().size() != 0) {
                this.genCode("         image.append");
                if (ExpRStringLiteral.s_allImages[i] != null) {
                    this.genCodeLine("(jjstrLiteralImages[" + i + "]);");
                    this.genCodeLine("        lengthOfMatch = jjstrLiteralImages[" + i + "].length();");
                } else {
                    this.genCodeLine("(input_stream->GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));");
                }
                this.printTokenSetup(expAction.getActionTokens().get(0));
                this.m_ccol = 1;
                for (int j = 0; j < expAction.getActionTokens().size(); ++j) {
                    this.printToken(expAction.getActionTokens().get(j));
                }
                this.genCodeLine();
            }
            this.genCodeLine("         break;");
            this.genCodeLine("       }");
        }
        this.genCodeLine("      default :");
        this.genCodeLine("         break;");
        this.genCodeLine("   }");
        this.genCodeLine("}");
    }

    private void _dumpMoreActions() {
        this.generateMethodDefHeader("void ", s_tokMgrClassName, "MoreLexicalActions()");
        this.genCodeLine("{");
        this.genCodeLine("   jjimageLen += (lengthOfMatch = jjmatchedPos + 1);");
        this.genCodeLine("   switch(jjmatchedKind)");
        this.genCodeLine("   {");
        for (int i = 0; i < s_maxOrdinal; ++i) {
            ExpAction expAction;
            if ((s_toMore[i / 64] & 1L << i % 64) == 0L || ((expAction = s_actions[i]) == null || expAction.getActionTokens() == null || expAction.getActionTokens().size() == 0) && !s_canLoop[s_lexStates[i]]) continue;
            this.genCodeLine("      case " + i + " : {");
            if (s_initMatch[s_lexStates[i]] == i && s_canLoop[s_lexStates[i]]) {
                this.genCodeLine("         if (jjmatchedPos == -1)");
                this.genCodeLine("         {");
                this.genCodeLine("            if (jjbeenHere[" + s_lexStates[i] + "] &&");
                this.genCodeLine("                jjemptyLineNo[" + s_lexStates[i] + "] == input_stream->getBeginLine() &&");
                this.genCodeLine("                jjemptyColNo[" + s_lexStates[i] + "] == input_stream->getBeginColumn())");
                this.genCodeLine("               errorHandler->lexicalError(JJString(\"(\"Error: Bailing out of infinite loop caused by repeated empty string matches \" + \"at line \" + input_stream->getBeginLine() + \", \" + \"column \" + input_stream->getBeginColumn() + \".\")), this);");
                this.genCodeLine("            jjemptyLineNo[" + s_lexStates[i] + "] = input_stream->getBeginLine();");
                this.genCodeLine("            jjemptyColNo[" + s_lexStates[i] + "] = input_stream->getBeginColumn();");
                this.genCodeLine("            jjbeenHere[" + s_lexStates[i] + "] = true;");
                this.genCodeLine("         }");
            }
            if ((expAction = s_actions[i]) != null && expAction.getActionTokens().size() != 0) {
                this.genCode("         image.append");
                if (ExpRStringLiteral.s_allImages[i] != null) {
                    this.genCodeLine("(jjstrLiteralImages[" + i + "]);");
                } else {
                    this.genCodeLine("(input_stream->GetSuffix(jjimageLen));");
                }
                this.genCodeLine("         jjimageLen = 0;");
                this.printTokenSetup(expAction.getActionTokens().get(0));
                this.m_ccol = 1;
                for (int j = 0; j < expAction.getActionTokens().size(); ++j) {
                    this.printToken(expAction.getActionTokens().get(j));
                }
                this.genCodeLine();
            }
            this.genCodeLine("         break;");
            this.genCodeLine("       }");
        }
        this.genCodeLine("      default :");
        this.genCodeLine("         break;");
        this.genCodeLine("   }");
        this.genCodeLine("}");
    }

    private void _dumpTokenActions() {
        this.generateMethodDefHeader("void ", s_tokMgrClassName, "TokenLexicalActions(Token *matchedToken)");
        this.genCodeLine("{");
        this.genCodeLine("   switch(jjmatchedKind)");
        this.genCodeLine("   {");
        for (int i = 0; i < s_maxOrdinal; ++i) {
            ExpAction expAction;
            if ((s_toToken[i / 64] & 1L << i % 64) == 0L || ((expAction = s_actions[i]) == null || expAction.getActionTokens() == null || expAction.getActionTokens().size() == 0) && !s_canLoop[s_lexStates[i]]) continue;
            this.genCodeLine("      case " + i + " : {");
            if (s_initMatch[s_lexStates[i]] == i && s_canLoop[s_lexStates[i]]) {
                this.genCodeLine("         if (jjmatchedPos == -1)");
                this.genCodeLine("         {");
                this.genCodeLine("            if (jjbeenHere[" + s_lexStates[i] + "] &&");
                this.genCodeLine("                jjemptyLineNo[" + s_lexStates[i] + "] == input_stream->getBeginLine() &&");
                this.genCodeLine("                jjemptyColNo[" + s_lexStates[i] + "] == input_stream->getBeginColumn())");
                this.genCodeLine("               errorHandler->lexicalError(JJString(\"Error: Bailing out of infinite loop caused by repeated empty string matches at line \" + input_stream->getBeginLine() + \", column \" + input_stream->getBeginColumn() + \".\"), this);");
                this.genCodeLine("            jjemptyLineNo[" + s_lexStates[i] + "] = input_stream->getBeginLine();");
                this.genCodeLine("            jjemptyColNo[" + s_lexStates[i] + "] = input_stream->getBeginColumn();");
                this.genCodeLine("            jjbeenHere[" + s_lexStates[i] + "] = true;");
                this.genCodeLine("         }");
            }
            if ((expAction = s_actions[i]) != null && expAction.getActionTokens().size() != 0) {
                if (i == 0) {
                    this.genCodeLine("      image.setLength(0);");
                } else {
                    this.genCode("        image.append");
                    if (ExpRStringLiteral.s_allImages[i] != null) {
                        this.genCodeLine("(jjstrLiteralImages[" + i + "]);");
                        this.genCodeLine("        lengthOfMatch = jjstrLiteralImages[" + i + "].length();");
                    } else {
                        this.genCodeLine("(input_stream->GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));");
                    }
                }
                this.printTokenSetup(expAction.getActionTokens().get(0));
                this.m_ccol = 1;
                for (int j = 0; j < expAction.getActionTokens().size(); ++j) {
                    this.printToken(expAction.getActionTokens().get(j));
                }
                this.genCodeLine();
            }
            this.genCodeLine("         break;");
            this.genCodeLine("       }");
        }
        this.genCodeLine("      default :");
        this.genCodeLine("         break;");
        this.genCodeLine("   }");
        this.genCodeLine("}");
    }
}

