/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.string.StringHelper;
import com.helger.pgcc.PGPrinter;
import com.helger.pgcc.output.EOutputLanguage;
import com.helger.pgcc.output.UnsupportedOutputLanguageException;
import com.helger.pgcc.parser.AbstractCodeProduction;
import com.helger.pgcc.parser.AbstractExpRegularExpression;
import com.helger.pgcc.parser.BNFProduction;
import com.helger.pgcc.parser.CodeGenerator;
import com.helger.pgcc.parser.CodeProductionCpp;
import com.helger.pgcc.parser.CodeProductionJava;
import com.helger.pgcc.parser.ExpAction;
import com.helger.pgcc.parser.ExpChoice;
import com.helger.pgcc.parser.ExpLookahead;
import com.helger.pgcc.parser.ExpNonTerminal;
import com.helger.pgcc.parser.ExpOneOrMore;
import com.helger.pgcc.parser.ExpSequence;
import com.helger.pgcc.parser.ExpTryBlock;
import com.helger.pgcc.parser.ExpZeroOrMore;
import com.helger.pgcc.parser.ExpZeroOrOne;
import com.helger.pgcc.parser.Expansion;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.NormalProduction;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.Phase3Data;
import com.helger.pgcc.parser.Semanticize;
import com.helger.pgcc.parser.Token;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class ParseEngine {
    private int m_nGenSymbolIndex = 0;
    private int m_indentamt;
    private boolean m_bJJ2LA;
    private CodeGenerator m_codeGenerator;
    private final ICommonsList<ExpLookahead> m_phase2list = new CommonsArrayList();
    private final ICommonsList<Phase3Data> m_phase3list = new CommonsArrayList();
    private final ICommonsMap<Expansion, Phase3Data> m_phase3table = new CommonsHashMap();
    private static final char INDENT_INC = '\u0001';
    private static final char INDENT_DEC = '\u0002';
    private static final char INDENT_OFF = '\u0003';
    private static final char INDENT_ON = '\u0004';
    private boolean[] m_firstSet;
    private boolean m_xsp_declared;
    private Expansion m_jj3_expansion;

    private boolean _javaCodeCheck(Expansion expansion) {
        if (expansion instanceof AbstractExpRegularExpression) {
            return false;
        }
        if (expansion instanceof ExpNonTerminal) {
            NormalProduction normalProduction = ((ExpNonTerminal)expansion).getProd();
            if (normalProduction instanceof AbstractCodeProduction) {
                return true;
            }
            return this._javaCodeCheck(normalProduction.getExpansion());
        }
        if (expansion instanceof ExpChoice) {
            ExpChoice expChoice = (ExpChoice)expansion;
            List<Expansion> list = expChoice.getChoices();
            for (int i = 0; i < list.size(); ++i) {
                if (!this._javaCodeCheck(list.get(i))) continue;
                return true;
            }
            return false;
        }
        if (expansion instanceof ExpSequence) {
            ExpSequence expSequence = (ExpSequence)expansion;
            for (int i = 0; i < expSequence.m_units.size(); ++i) {
                Expansion[] expansionArray = expSequence.m_units.toArray(new Expansion[expSequence.m_units.size()]);
                if (expansionArray[i] instanceof ExpLookahead && ((ExpLookahead)expansionArray[i]).isExplicit()) {
                    return false;
                }
                if (this._javaCodeCheck(expansionArray[i])) {
                    return true;
                }
                if (Semanticize.emptyExpansionExists(expansionArray[i])) continue;
                return false;
            }
            return false;
        }
        if (expansion instanceof ExpOneOrMore) {
            ExpOneOrMore expOneOrMore = (ExpOneOrMore)expansion;
            return this._javaCodeCheck(expOneOrMore.m_expansion);
        }
        if (expansion instanceof ExpZeroOrMore) {
            ExpZeroOrMore expZeroOrMore = (ExpZeroOrMore)expansion;
            return this._javaCodeCheck(expZeroOrMore.m_expansion);
        }
        if (expansion instanceof ExpZeroOrOne) {
            ExpZeroOrOne expZeroOrOne = (ExpZeroOrOne)expansion;
            return this._javaCodeCheck(expZeroOrOne.m_expansion);
        }
        if (expansion instanceof ExpTryBlock) {
            ExpTryBlock expTryBlock = (ExpTryBlock)expansion;
            return this._javaCodeCheck(expTryBlock.m_exp);
        }
        return false;
    }

    private void _genFirstSet(Expansion expansion) {
        if (expansion instanceof AbstractExpRegularExpression) {
            this.m_firstSet[((AbstractExpRegularExpression)expansion).m_ordinal] = true;
        } else if (expansion instanceof ExpNonTerminal) {
            if (!(((ExpNonTerminal)expansion).getProd() instanceof AbstractCodeProduction)) {
                this._genFirstSet(((BNFProduction)((ExpNonTerminal)expansion).getProd()).getExpansion());
            }
        } else if (expansion instanceof ExpChoice) {
            ExpChoice expChoice = (ExpChoice)expansion;
            for (int i = 0; i < expChoice.getChoices().size(); ++i) {
                this._genFirstSet(expChoice.getChoices().get(i));
            }
        } else if (expansion instanceof ExpSequence) {
            ExpSequence expSequence = (ExpSequence)expansion;
            Expansion expansion2 = expSequence.m_units.get(0);
            if (expansion2 instanceof ExpLookahead && ((ExpLookahead)expansion2).getActionTokens().size() != 0) {
                this.m_bJJ2LA = true;
            }
            for (int i = 0; i < expSequence.m_units.size(); ++i) {
                Expansion expansion3 = expSequence.m_units.get(i);
                if (expansion3 instanceof ExpNonTerminal && ((ExpNonTerminal)expansion3).getProd() instanceof AbstractCodeProduction) {
                    if (i > 0 && expSequence.m_units.get(i - 1) instanceof ExpLookahead) {
                        ExpLookahead expLookahead = (ExpLookahead)expSequence.m_units.get(i - 1);
                        this._genFirstSet(expLookahead.getLaExpansion());
                    }
                } else {
                    this._genFirstSet(expSequence.m_units.get(i));
                }
                if (Semanticize.emptyExpansionExists(expSequence.m_units.get(i))) {
                    continue;
                }
                break;
            }
        } else if (expansion instanceof ExpOneOrMore) {
            ExpOneOrMore expOneOrMore = (ExpOneOrMore)expansion;
            this._genFirstSet(expOneOrMore.m_expansion);
        } else if (expansion instanceof ExpZeroOrMore) {
            ExpZeroOrMore expZeroOrMore = (ExpZeroOrMore)expansion;
            this._genFirstSet(expZeroOrMore.m_expansion);
        } else if (expansion instanceof ExpZeroOrOne) {
            ExpZeroOrOne expZeroOrOne = (ExpZeroOrOne)expansion;
            this._genFirstSet(expZeroOrOne.m_expansion);
        } else if (expansion instanceof ExpTryBlock) {
            ExpTryBlock expTryBlock = (ExpTryBlock)expansion;
            this._genFirstSet(expTryBlock.m_exp);
        }
    }

    private void _dumpLookaheads(ExpLookahead[] expLookaheadArray, String[] stringArray) {
        for (int i = 0; i < expLookaheadArray.length; ++i) {
            PGPrinter.error("Lookahead: " + i);
            PGPrinter.error(expLookaheadArray[i].dump(0, new HashSet()).toString());
            PGPrinter.error("");
        }
    }

    String buildLookaheadChecker(ExpLookahead[] expLookaheadArray, String[] stringArray) {
        int n;
        EState eState = EState.NOOPENSTM;
        int n2 = 0;
        boolean[] blArray = new boolean[JavaCCGlobals.s_tokenCount];
        String string = "";
        Token token = null;
        int n3 = (JavaCCGlobals.s_tokenCount - 1) / 32 + 1;
        int[] nArray = null;
        for (n = 0; n < expLookaheadArray.length; ++n) {
            Token token2;
            Iterator<Token> iterator;
            ExpLookahead expLookahead = expLookaheadArray[n];
            this.m_bJJ2LA = false;
            if (expLookahead.getAmount() == 0 || Semanticize.emptyExpansionExists(expLookahead.getLaExpansion()) || this._javaCodeCheck(expLookahead.getLaExpansion())) {
                if (expLookahead.getActionTokens().size() == 0) break;
                switch (eState) {
                    case NOOPENSTM: {
                        string = string + "\nif (";
                        ++n2;
                        break;
                    }
                    case OPENIF: {
                        string = string + "\u0002\n} else if (";
                        break;
                    }
                    case OPENSWITCH: {
                        string = string + "\u0002\ndefault:\u0001";
                        if (Options.isErrorReporting()) {
                            string = string + "\njj_la1[" + JavaCCGlobals.s_maskindex + "] = jj_gen;";
                            ++JavaCCGlobals.s_maskindex;
                        }
                        JavaCCGlobals.s_maskVals.add(nArray);
                        string = string + "\nif (";
                        ++n2;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                this.m_codeGenerator.printTokenSetup(expLookahead.getActionTokens().get(0));
                iterator = expLookahead.getActionTokens().iterator();
                while (iterator.hasNext()) {
                    token = token2 = iterator.next();
                    string = string + this.m_codeGenerator.getStringToPrint(token);
                }
                string = string + this.m_codeGenerator.getTrailingComments(token);
                string = string + ") {\u0001" + stringArray[n];
                eState = EState.OPENIF;
            } else if (expLookahead.getAmount() == 1 && expLookahead.getActionTokens().size() == 0) {
                int n4;
                if (this.m_firstSet == null) {
                    this.m_firstSet = new boolean[JavaCCGlobals.s_tokenCount];
                }
                for (n4 = 0; n4 < JavaCCGlobals.s_tokenCount; ++n4) {
                    this.m_firstSet[n4] = false;
                }
                this._genFirstSet(expLookahead.getLaExpansion());
                if (!this.m_bJJ2LA) {
                    switch (eState) {
                        case OPENIF: {
                            string = string + "\u0002\n} else {\u0001";
                        }
                        case NOOPENSTM: {
                            string = string + "\nswitch (";
                            string = Options.isCacheTokens() ? string + "jj_nt.kind" : string + "jj_ntk == -1 ? jj_ntk_f() : jj_ntk";
                            string = string + ") {\u0001";
                            for (n4 = 0; n4 < JavaCCGlobals.s_tokenCount; ++n4) {
                                blArray[n4] = false;
                            }
                            ++n2;
                            nArray = new int[n3];
                            for (n4 = 0; n4 < n3; ++n4) {
                                nArray[n4] = 0;
                            }
                            break;
                        }
                        case OPENSWITCH: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    for (n4 = 0; n4 < JavaCCGlobals.s_tokenCount; ++n4) {
                        if (!this.m_firstSet[n4] || blArray[n4]) continue;
                        blArray[n4] = true;
                        string = string + "\u0002\ncase ";
                        int n5 = n4 / 32;
                        int n6 = n4 % 32;
                        int n7 = n5;
                        nArray[n7] = nArray[n7] | 1 << n6;
                        String string2 = JavaCCGlobals.s_names_of_tokens.get(n4);
                        string = string2 == null ? string + n4 : string + string2;
                        string = string + ":\u0001";
                    }
                    string = string + "{";
                    string = string + stringArray[n];
                    string = string + "\nbreak;\n}";
                    eState = EState.OPENSWITCH;
                }
            } else {
                this.m_bJJ2LA = true;
            }
            if (!this.m_bJJ2LA) continue;
            switch (eState) {
                case NOOPENSTM: {
                    string = string + "\nif (";
                    ++n2;
                    break;
                }
                case OPENIF: {
                    string = string + "\u0002\n} else if (";
                    break;
                }
                case OPENSWITCH: {
                    string = string + "\u0002\ndefault:\u0001";
                    if (Options.isErrorReporting()) {
                        string = string + "\njj_la1[" + JavaCCGlobals.s_maskindex + "] = jj_gen;";
                        ++JavaCCGlobals.s_maskindex;
                    }
                    JavaCCGlobals.s_maskVals.add(nArray);
                    string = string + "\nif (";
                    ++n2;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++JavaCCGlobals.s_jj2index;
            assert (expLookahead.getLaExpansion().getInternalName().equals(""));
            expLookahead.getLaExpansion().setInternalName("_", JavaCCGlobals.s_jj2index);
            this.m_phase2list.add((Object)expLookahead);
            string = string + "jj_2" + expLookahead.getLaExpansion().getInternalName() + "(" + expLookahead.getAmount() + ")";
            if (expLookahead.getActionTokens().size() != 0) {
                string = string + " && (";
                this.m_codeGenerator.printTokenSetup(expLookahead.getActionTokens().get(0));
                iterator = expLookahead.getActionTokens().iterator();
                while (iterator.hasNext()) {
                    token = token2 = iterator.next();
                    string = string + this.m_codeGenerator.getStringToPrint(token);
                }
                string = string + this.m_codeGenerator.getTrailingComments(token);
                string = string + ")";
            }
            string = string + ") {\u0001" + stringArray[n];
            eState = EState.OPENIF;
        }
        switch (eState) {
            case NOOPENSTM: {
                string = string + stringArray[n];
                break;
            }
            case OPENIF: {
                string = string + "\u0002\n} else {\u0001" + stringArray[n];
                break;
            }
            case OPENSWITCH: {
                string = string + "\u0002\ndefault:\u0001";
                if (Options.isErrorReporting()) {
                    string = string + "\njj_la1[" + JavaCCGlobals.s_maskindex + "] = jj_gen;";
                    JavaCCGlobals.s_maskVals.add(nArray);
                    ++JavaCCGlobals.s_maskindex;
                }
                string = string + stringArray[n];
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        for (int i = 0; i < n2; ++i) {
            string = string + "\u0002\n}";
        }
        return string;
    }

    void dumpFormattedString(String string) {
        char c = ' ';
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = c;
            c = string.charAt(i);
            if (c == '\n' && c2 == '\r') continue;
            if (c == '\n' || c == '\r') {
                if (bl) {
                    this.phase1NewLine();
                    continue;
                }
                this.m_codeGenerator.genCodeLine();
                continue;
            }
            if (c == '\u0001') {
                this.m_indentamt += 2;
                continue;
            }
            if (c == '\u0002') {
                this.m_indentamt -= 2;
                continue;
            }
            if (c == '\u0003') {
                bl = false;
                continue;
            }
            if (c == '\u0004') {
                bl = true;
                continue;
            }
            this.m_codeGenerator.genCode(c);
        }
    }

    private String _generateCPPMethodheader(CodeProductionCpp codeProductionCpp) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        Token token = null;
        for (int i = 0; i < codeProductionCpp.getReturnTypeTokens().size(); ++i) {
            token = codeProductionCpp.getReturnTypeTokens().get(i);
            object = this.m_codeGenerator.getStringToPrint(token);
            stringBuilder.append(token.toString());
            stringBuilder.append(" ");
        }
        String string = "";
        if (token != null) {
            string = this.m_codeGenerator.getTrailingComments(token);
        }
        String string2 = stringBuilder.toString();
        stringBuilder.setLength(0);
        stringBuilder.append("(");
        if (codeProductionCpp.getParameterListTokens().size() != 0) {
            this.m_codeGenerator.printTokenSetup(codeProductionCpp.getParameterListTokens().get(0));
            object = codeProductionCpp.getParameterListTokens().iterator();
            while (object.hasNext()) {
                Token token2;
                token = token2 = (Token)object.next();
                stringBuilder.append(this.m_codeGenerator.getStringToPrint(token));
            }
            stringBuilder.append(this.m_codeGenerator.getTrailingComments(token));
        }
        stringBuilder.append(")");
        String string3 = stringBuilder.toString();
        this.m_codeGenerator.generateMethodDefHeader(string2, JavaCCGlobals.s_cu_name, codeProductionCpp.getLhs() + string3, stringBuilder.toString());
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private String _generateCPPMethodheader(BNFProduction bNFProduction, Token token) {
        void var12_17;
        Object string5;
        StringBuilder stringBuilder = new StringBuilder();
        Token token2 = token;
        String string = bNFProduction.getLhs();
        boolean bl = false;
        boolean bl2 = false;
        this.m_codeGenerator.printTokenSetup(token2);
        JavaCCGlobals.s_ccol = 1;
        String string2 = this.m_codeGenerator.getLeadingComments(token2);
        JavaCCGlobals.s_cline = token2.beginLine;
        JavaCCGlobals.s_ccol = token2.beginColumn;
        stringBuilder.append(token2.image);
        if (token2.kind == 84) {
            bl = true;
        }
        if (token2.kind == 126) {
            bl2 = true;
        }
        for (int i = 1; i < bNFProduction.getReturnTypeTokens().size(); ++i) {
            token2 = bNFProduction.getReturnTypeTokens().get(i);
            stringBuilder.append(this.m_codeGenerator.getStringToPrint(token2));
            if (token2.kind == 84) {
                bl = true;
            }
            if (token2.kind != 126) continue;
            bl2 = true;
        }
        String string3 = this.m_codeGenerator.getTrailingComments(token2);
        String string4 = stringBuilder.toString();
        stringBuilder.setLength(0);
        stringBuilder.append("(");
        if (bNFProduction.getParameterListTokens().size() != 0) {
            this.m_codeGenerator.printTokenSetup(bNFProduction.getParameterListTokens().get(0));
            string5 = bNFProduction.getParameterListTokens().iterator();
            while (string5.hasNext()) {
                Token object2;
                token2 = object2 = (Token)string5.next();
                stringBuilder.append(this.m_codeGenerator.getStringToPrint(token2));
            }
            stringBuilder.append(this.m_codeGenerator.getTrailingComments(token2));
        }
        stringBuilder.append(")");
        string5 = stringBuilder.toString();
        this.m_codeGenerator.generateMethodDefHeader(string4, JavaCCGlobals.s_cu_name, bNFProduction.getLhs() + (String)string5, stringBuilder.toString());
        if (bl2) {
            String string6 = "NULL";
        } else if (bl) {
            String string7 = "";
        } else {
            String string8 = "0";
        }
        StringBuilder stringBuilder2 = new StringBuilder("\n#if !defined ERROR_RET_" + string + "\n");
        stringBuilder2.append("#define ERROR_RET_" + string + " " + (String)var12_17 + "\n");
        stringBuilder2.append("#endif\n");
        stringBuilder2.append("#define __ERROR_RET__ ERROR_RET_" + string + "\n");
        return stringBuilder2.toString();
    }

    private void _genStackCheck(boolean bl) {
        EOutputLanguage eOutputLanguage = this.m_codeGenerator.getOutputLanguage();
        if (Options.hasDepthLimit()) {
            switch (eOutputLanguage) {
                case JAVA: {
                    this.m_codeGenerator.genCodeLine("if(++jj_depth > " + Options.getDepthLimit() + ") {");
                    this.m_codeGenerator.genCodeLine("  jj_consume_token(-1);");
                    this.m_codeGenerator.genCodeLine("  throw new ParseException();");
                    this.m_codeGenerator.genCodeLine("}");
                    this.m_codeGenerator.genCodeLine("try {");
                    break;
                }
                case CPP: {
                    if (!bl) {
                        this.m_codeGenerator.genCodeLine("if(jj_depth_error){ return __ERROR_RET__; }");
                    } else {
                        this.m_codeGenerator.genCodeLine("if(jj_depth_error){ return; }");
                    }
                    this.m_codeGenerator.genCodeLine("__jj_depth_inc __jj_depth_counter(this);");
                    this.m_codeGenerator.genCodeLine("if(jj_depth > " + Options.getDepthLimit() + ") {");
                    this.m_codeGenerator.genCodeLine("  jj_depth_error = true;");
                    this.m_codeGenerator.genCodeLine("  jj_consume_token(-1);");
                    this.m_codeGenerator.genCodeLine("  errorHandler->handleParseError(token, getToken(1), __FUNCTION__, this), hasError = true;");
                    if (!bl) {
                        this.m_codeGenerator.genCodeLine("  return __ERROR_RET__;");
                    } else {
                        this.m_codeGenerator.genCodeLine("  return;");
                    }
                    this.m_codeGenerator.genCodeLine("}");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
    }

    void genStackCheckEnd() {
        if (Options.hasDepthLimit()) {
            EOutputLanguage eOutputLanguage = this.m_codeGenerator.getOutputLanguage();
            switch (eOutputLanguage) {
                case JAVA: {
                    this.m_codeGenerator.genCodeLine(" } finally {");
                    this.m_codeGenerator.genCodeLine("   --jj_depth;");
                    this.m_codeGenerator.genCodeLine(" }");
                    break;
                }
                case CPP: {
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
    }

    void buildPhase1Routine(BNFProduction bNFProduction) {
        Iterator<List<Token>> iterator;
        EOutputLanguage eOutputLanguage = this.m_codeGenerator.getOutputLanguage();
        Token object2 = bNFProduction.getReturnTypeTokens().get(0);
        boolean bl = false;
        if (object2.kind == 84) {
            bl = true;
        }
        String string = null;
        switch (eOutputLanguage) {
            case JAVA: {
                this.m_codeGenerator.printTokenSetup(object2);
                JavaCCGlobals.s_ccol = 1;
                this.m_codeGenerator.printLeadingComments(object2);
                this.m_codeGenerator.genCode("  final " + (bNFProduction.getAccessMod() != null ? bNFProduction.getAccessMod() : "public") + " ");
                JavaCCGlobals.s_cline = object2.beginLine;
                JavaCCGlobals.s_ccol = object2.beginColumn;
                this.m_codeGenerator.printTokenOnly(object2);
                for (int i = 1; i < bNFProduction.getReturnTypeTokens().size(); ++i) {
                    object2 = bNFProduction.getReturnTypeTokens().get(i);
                    this.m_codeGenerator.printToken(object2);
                }
                this.m_codeGenerator.printTrailingComments(object2);
                this.m_codeGenerator.genCode(" " + bNFProduction.getLhs() + "(");
                if (bNFProduction.getParameterListTokens().size() != 0) {
                    this.m_codeGenerator.printTokenSetup(bNFProduction.getParameterListTokens().get(0));
                    Iterator<Token> iterator2 = bNFProduction.getParameterListTokens().iterator();
                    while (iterator2.hasNext()) {
                        Token object3;
                        object2 = object3 = iterator2.next();
                        this.m_codeGenerator.printToken(object2);
                    }
                    this.m_codeGenerator.printTrailingComments(object2);
                }
                this.m_codeGenerator.genCode(")");
                this.m_codeGenerator.genCode(" throws ParseException");
                for (List<Token> list : bNFProduction.getThrowsList()) {
                    this.m_codeGenerator.genCode(", ");
                    for (Token token : list) {
                        this.m_codeGenerator.genCode(token.image);
                    }
                }
                break;
            }
            case CPP: {
                string = this._generateCPPMethodheader(bNFProduction, object2);
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        this.m_codeGenerator.genCode(" {");
        switch (eOutputLanguage) {
            case JAVA: {
                break;
            }
            case CPP: {
                if (Options.booleanValue("STOP_ON_FIRST_ERROR") && string != null || Options.hasDepthLimit() && !bl) {
                    this.m_codeGenerator.genCode(string);
                    break;
                }
                string = null;
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        this._genStackCheck(bl);
        this.m_indentamt = 4;
        if (Options.isDebugParser()) {
            this.m_codeGenerator.genCodeLine();
            switch (eOutputLanguage) {
                case JAVA: {
                    this.m_codeGenerator.genCodeLine("    trace_call(\"" + JavaCCGlobals.addUnicodeEscapes(bNFProduction.getLhs()) + "\");");
                    break;
                }
                case CPP: {
                    this.m_codeGenerator.genCodeLine("    JJEnter<std::function<void()>> jjenter([this]() {trace_call  (\"" + JavaCCGlobals.addUnicodeEscapes(bNFProduction.getLhs()) + "\"); });");
                    this.m_codeGenerator.genCodeLine("    JJExit <std::function<void()>> jjexit ([this]() {trace_return(\"" + JavaCCGlobals.addUnicodeEscapes(bNFProduction.getLhs()) + "\"); });");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
            this.m_codeGenerator.genCodeLine("    try {");
            this.m_indentamt = 6;
        }
        if (!Options.booleanValue("IGNORE_ACTIONS") && bNFProduction.getDeclarationTokens().size() != 0) {
            this.m_codeGenerator.printTokenSetup(bNFProduction.getDeclarationTokens().get(0));
            --JavaCCGlobals.s_cline;
            iterator = bNFProduction.getDeclarationTokens().iterator();
            while (iterator.hasNext()) {
                Token token;
                object2 = token = (Token)iterator.next();
                this.m_codeGenerator.printToken(object2);
            }
            this.m_codeGenerator.printTrailingComments(object2);
        }
        iterator = this._phase1ExpansionGen(bNFProduction.getExpansion());
        this.dumpFormattedString((String)((Object)iterator));
        this.m_codeGenerator.genCodeLine();
        if (bNFProduction.isJumpPatched() && !bl) {
            switch (eOutputLanguage) {
                case JAVA: {
                    this.m_codeGenerator.genCodeLine("    throw new IllegalStateException (\"Missing return statement in function\");");
                    break;
                }
                case CPP: {
                    this.m_codeGenerator.genCodeLine("    throw \"Missing return statement in function\";");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        if (Options.isDebugParser()) {
            switch (eOutputLanguage) {
                case JAVA: {
                    this.m_codeGenerator.genCodeLine("    } finally {");
                    this.m_codeGenerator.genCodeLine("      trace_return(\"" + JavaCCGlobals.addUnicodeEscapes(bNFProduction.getLhs()) + "\");");
                    this.m_codeGenerator.genCodeLine("    }");
                    break;
                }
                case CPP: {
                    this.m_codeGenerator.genCodeLine("    } catch(...) { }");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        if (!bl) {
            switch (eOutputLanguage) {
                case JAVA: {
                    break;
                }
                case CPP: {
                    this.m_codeGenerator.genCodeLine("assert(false);");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        if (string != null) {
            this.m_codeGenerator.genCodeLine("\n#undef __ERROR_RET__\n");
        }
        this.genStackCheckEnd();
        this.m_codeGenerator.genCodeLine("}");
        this.m_codeGenerator.genCodeLine();
    }

    void phase1NewLine() {
        this.m_codeGenerator.genCodeLine();
        this.m_codeGenerator.genCode(StringHelper.getRepeated((char)' ', (int)this.m_indentamt));
    }

    private String _phase1ExpansionGen(Expansion expansion) {
        String string;
        block91: {
            EOutputLanguage eOutputLanguage;
            Object object;
            block92: {
                block90: {
                    Object object2;
                    Object object3;
                    string = "";
                    object = null;
                    eOutputLanguage = this.m_codeGenerator.getOutputLanguage();
                    if (!(expansion instanceof AbstractExpRegularExpression)) break block90;
                    AbstractExpRegularExpression abstractExpRegularExpression = (AbstractExpRegularExpression)expansion;
                    string = string + "\n";
                    if (abstractExpRegularExpression.m_lhsTokens.size() != 0) {
                        this.m_codeGenerator.printTokenSetup(abstractExpRegularExpression.m_lhsTokens.get(0));
                        object3 = abstractExpRegularExpression.m_lhsTokens.iterator();
                        while (object3.hasNext()) {
                            object = object2 = (Token)object3.next();
                            string = string + this.m_codeGenerator.getStringToPrint((Token)object);
                        }
                        string = string + this.m_codeGenerator.getTrailingComments((Token)object);
                        string = string + " = ";
                    }
                    if (abstractExpRegularExpression.m_rhsToken == null) {
                        object3 = ");";
                    } else {
                        switch (eOutputLanguage) {
                            case JAVA: {
                                object3 = ")." + abstractExpRegularExpression.m_rhsToken.image + ";";
                                break;
                            }
                            case CPP: {
                                object3 = ")->" + abstractExpRegularExpression.m_rhsToken.image + ";";
                                break;
                            }
                            default: {
                                throw new UnsupportedOutputLanguageException(eOutputLanguage);
                            }
                        }
                    }
                    string = abstractExpRegularExpression.m_label.length() == 0 ? ((object2 = JavaCCGlobals.s_names_of_tokens.get(abstractExpRegularExpression.m_ordinal)) != null ? string + "jj_consume_token(" + (String)object2 + (String)object3 : string + "jj_consume_token(" + abstractExpRegularExpression.m_ordinal + (String)object3) : string + "jj_consume_token(" + abstractExpRegularExpression.m_label + (String)object3;
                    switch (eOutputLanguage) {
                        case JAVA: {
                            break;
                        }
                        case CPP: {
                            if (Options.booleanValue("STOP_ON_FIRST_ERROR")) {
                                string = string + "\n    { if (hasError) { return __ERROR_RET__; } }\n";
                                break;
                            }
                            break block91;
                        }
                        default: {
                            throw new UnsupportedOutputLanguageException(eOutputLanguage);
                        }
                    }
                    break block91;
                }
                if (!(expansion instanceof ExpNonTerminal)) break block92;
                ExpNonTerminal expNonTerminal = (ExpNonTerminal)expansion;
                string = string + "\n";
                if (expNonTerminal.getLhsTokens().size() != 0) {
                    this.m_codeGenerator.printTokenSetup(expNonTerminal.getLhsTokens().get(0));
                    for (Token token : expNonTerminal.getLhsTokens()) {
                        object = token;
                        string = string + this.m_codeGenerator.getStringToPrint((Token)object);
                    }
                    string = string + this.m_codeGenerator.getTrailingComments((Token)object);
                    string = string + " = ";
                }
                string = string + expNonTerminal.getName() + "(";
                if (expNonTerminal.getArgumentTokens().size() != 0) {
                    this.m_codeGenerator.printTokenSetup(expNonTerminal.getArgumentTokens().get(0));
                    for (Token token : expNonTerminal.getArgumentTokens()) {
                        object = token;
                        string = string + this.m_codeGenerator.getStringToPrint((Token)object);
                    }
                    string = string + this.m_codeGenerator.getTrailingComments((Token)object);
                }
                string = string + ");";
                switch (eOutputLanguage) {
                    case JAVA: {
                        break;
                    }
                    case CPP: {
                        if (Options.booleanValue("STOP_ON_FIRST_ERROR")) {
                            string = string + "\n    { if (hasError) { return __ERROR_RET__; } }\n";
                            break;
                        }
                        break block91;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
                break block91;
            }
            if (expansion instanceof ExpAction) {
                ExpAction expAction = (ExpAction)expansion;
                string = string + "\u0003\n";
                if (!Options.booleanValue("IGNORE_ACTIONS") && expAction.getActionTokens().size() != 0) {
                    this.m_codeGenerator.printTokenSetup(expAction.getActionTokens().get(0));
                    JavaCCGlobals.s_ccol = 1;
                    for (Token token : expAction.getActionTokens()) {
                        object = token;
                        string = string + this.m_codeGenerator.getStringToPrint((Token)object);
                    }
                    string = string + this.m_codeGenerator.getTrailingComments((Token)object);
                }
                string = string + '\u0004';
            } else if (expansion instanceof ExpChoice) {
                String string2;
                ExpChoice expChoice = (ExpChoice)expansion;
                ExpLookahead[] expLookaheadArray = new ExpLookahead[expChoice.getChoices().size()];
                String[] stringArray = new String[expChoice.getChoices().size() + 1];
                switch (eOutputLanguage) {
                    case JAVA: {
                        string2 = "\njj_consume_token(-1);\nthrow new ParseException();";
                        break;
                    }
                    case CPP: {
                        string2 = "\njj_consume_token(-1);\nerrorHandler->handleParseError(token, getToken(1), __FUNCTION__, this), hasError = true;" + (Options.booleanValue("STOP_ON_FIRST_ERROR") ? "return __ERROR_RET__;\n" : "");
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
                stringArray[expChoice.getChoices().size()] = string2;
                for (int i = 0; i < expChoice.getChoices().size(); ++i) {
                    ExpSequence expSequence = (ExpSequence)expChoice.getChoices().get(i);
                    stringArray[i] = this._phase1ExpansionGen(expSequence);
                    expLookaheadArray[i] = (ExpLookahead)expSequence.m_units.get(0);
                }
                string = this.buildLookaheadChecker(expLookaheadArray, stringArray);
            } else if (expansion instanceof ExpSequence) {
                ExpSequence expSequence = (ExpSequence)expansion;
                for (int i = 1; i < expSequence.m_units.size(); ++i) {
                    boolean bl = false;
                    if (!JavaCCGlobals.s_jjtreeGenerated) {
                        switch (eOutputLanguage) {
                            case JAVA: {
                                break;
                            }
                            case CPP: {
                                Expansion expansion2 = expSequence.m_units.get(i);
                                if (expansion2 instanceof ExpAction && expansion.m_parent instanceof BNFProduction && i == expSequence.m_units.size() - 1) break;
                                bl = true;
                                string = string + "\nif (!hasError) {";
                                break;
                            }
                            default: {
                                throw new UnsupportedOutputLanguageException(eOutputLanguage);
                            }
                        }
                    }
                    string = string + this._phase1ExpansionGen(expSequence.m_units.get(i));
                    if (!bl) continue;
                    string = string + "\n}";
                }
            } else if (expansion instanceof ExpOneOrMore) {
                ExpLookahead expLookahead;
                ExpOneOrMore expOneOrMore = (ExpOneOrMore)expansion;
                Expansion expansion3 = expOneOrMore.m_expansion;
                if (expansion3 instanceof ExpSequence) {
                    expLookahead = (ExpLookahead)((ExpSequence)expansion3).m_units.get(0);
                } else {
                    expLookahead = new ExpLookahead();
                    expLookahead.setAmount(Options.getLookahead());
                    expLookahead.setLaExpansion(expansion3);
                }
                string = string + "\n";
                int n = ++this.m_nGenSymbolIndex;
                switch (eOutputLanguage) {
                    case JAVA: {
                        string = string + "label_" + n + ":\n";
                        string = string + "while (true) {\u0001";
                        break;
                    }
                    case CPP: {
                        string = string + "while (!hasError) {\u0001";
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
                string = string + this._phase1ExpansionGen(expansion3);
                ExpLookahead[] expLookaheadArray = new ExpLookahead[]{expLookahead};
                String[] stringArray = new String[2];
                stringArray[0] = "";
                switch (eOutputLanguage) {
                    case JAVA: {
                        stringArray[1] = "\nbreak label_" + n + ";";
                        break;
                    }
                    case CPP: {
                        stringArray[1] = "\ngoto end_label_" + n + ";";
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
                string = string + this.buildLookaheadChecker(expLookaheadArray, stringArray);
                string = string + "\u0002\n}";
                switch (eOutputLanguage) {
                    case JAVA: {
                        break;
                    }
                    case CPP: {
                        string = string + "\nend_label_" + n + ": ;";
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
            } else if (expansion instanceof ExpZeroOrMore) {
                ExpLookahead expLookahead;
                ExpZeroOrMore expZeroOrMore = (ExpZeroOrMore)expansion;
                Expansion expansion4 = expZeroOrMore.m_expansion;
                if (expansion4 instanceof ExpSequence) {
                    expLookahead = (ExpLookahead)((ExpSequence)expansion4).m_units.get(0);
                } else {
                    expLookahead = new ExpLookahead();
                    expLookahead.setAmount(Options.getLookahead());
                    expLookahead.setLaExpansion(expansion4);
                }
                string = string + "\n";
                int n = ++this.m_nGenSymbolIndex;
                switch (eOutputLanguage) {
                    case JAVA: {
                        string = string + "label_" + n + ":\n";
                        string = string + "while (true) {\u0001";
                        break;
                    }
                    case CPP: {
                        string = string + "while (!hasError) {\u0001";
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
                ExpLookahead[] expLookaheadArray = new ExpLookahead[]{expLookahead};
                String[] stringArray = new String[2];
                stringArray[0] = "";
                switch (eOutputLanguage) {
                    case JAVA: {
                        stringArray[1] = "\nbreak label_" + n + ";";
                        break;
                    }
                    case CPP: {
                        stringArray[1] = "\ngoto end_label_" + n + ";";
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
                string = string + this.buildLookaheadChecker(expLookaheadArray, stringArray);
                string = string + this._phase1ExpansionGen(expansion4);
                string = string + "\u0002\n}";
                switch (eOutputLanguage) {
                    case JAVA: {
                        break;
                    }
                    case CPP: {
                        string = string + "\nend_label_" + n + ": ;";
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
            } else if (expansion instanceof ExpZeroOrOne) {
                ExpLookahead expLookahead;
                ExpZeroOrOne expZeroOrOne = (ExpZeroOrOne)expansion;
                Expansion expansion5 = expZeroOrOne.m_expansion;
                if (expansion5 instanceof ExpSequence) {
                    expLookahead = (ExpLookahead)((ExpSequence)expansion5).m_units.get(0);
                } else {
                    expLookahead = new ExpLookahead();
                    expLookahead.setAmount(Options.getLookahead());
                    expLookahead.setLaExpansion(expansion5);
                }
                ExpLookahead[] expLookaheadArray = new ExpLookahead[]{expLookahead};
                String[] stringArray = new String[]{this._phase1ExpansionGen(expansion5), "\n;"};
                string = string + this.buildLookaheadChecker(expLookaheadArray, stringArray);
            } else if (expansion instanceof ExpTryBlock) {
                ExpTryBlock expTryBlock = (ExpTryBlock)expansion;
                Expansion expansion6 = expTryBlock.m_exp;
                string = string + "\n";
                string = string + "try {\u0001";
                string = string + this._phase1ExpansionGen(expansion6);
                string = string + "\u0002\n}";
                for (int i = 0; i < expTryBlock.m_catchblks.size(); ++i) {
                    string = string + " catch (";
                    List<Token> list = expTryBlock.m_types.get(i);
                    if (list.size() != 0) {
                        this.m_codeGenerator.printTokenSetup(list.get(0));
                        for (Token token : list) {
                            object = token;
                            string = string + this.m_codeGenerator.getStringToPrint((Token)object);
                        }
                        string = string + this.m_codeGenerator.getTrailingComments((Token)object);
                    }
                    string = string + " ";
                    object = expTryBlock.m_ids.get(i);
                    this.m_codeGenerator.printTokenSetup((Token)object);
                    string = string + this.m_codeGenerator.getStringToPrint((Token)object);
                    string = string + this.m_codeGenerator.getTrailingComments((Token)object);
                    string = string + ") {\u0003\n";
                    list = expTryBlock.m_catchblks.get(i);
                    if (list.size() != 0) {
                        this.m_codeGenerator.printTokenSetup(list.get(0));
                        JavaCCGlobals.s_ccol = 1;
                        for (Token token : list) {
                            object = token;
                            string = string + this.m_codeGenerator.getStringToPrint((Token)object);
                        }
                        string = string + this.m_codeGenerator.getTrailingComments((Token)object);
                    }
                    string = string + "\u0004\n}";
                }
                if (expTryBlock.m_finallyblk != null) {
                    switch (eOutputLanguage) {
                        case JAVA: {
                            string = string + " finally {\u0003\n";
                            break;
                        }
                        case CPP: {
                            string = string + " finally {\u0003\n";
                            break;
                        }
                        default: {
                            throw new UnsupportedOutputLanguageException(eOutputLanguage);
                        }
                    }
                    if (expTryBlock.m_finallyblk.size() != 0) {
                        this.m_codeGenerator.printTokenSetup(expTryBlock.m_finallyblk.get(0));
                        JavaCCGlobals.s_ccol = 1;
                        for (Token token : expTryBlock.m_finallyblk) {
                            object = token;
                            string = string + this.m_codeGenerator.getStringToPrint((Token)object);
                        }
                        string = string + this.m_codeGenerator.getTrailingComments((Token)object);
                    }
                    string = string + "\u0004\n}";
                }
            }
        }
        return string;
    }

    private void _buildPhase2Routine(ExpLookahead expLookahead) {
        EOutputLanguage eOutputLanguage = this.m_codeGenerator.getOutputLanguage();
        Expansion expansion = expLookahead.getLaExpansion();
        switch (eOutputLanguage) {
            case JAVA: {
                this.m_codeGenerator.genCodeLine("  private boolean jj_2" + expansion.getInternalName() + "(int xla)");
                break;
            }
            case CPP: {
                this.m_codeGenerator.genCodeLine(" inline bool jj_2" + expansion.getInternalName() + "(int xla)");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        this.m_codeGenerator.genCodeLine(" {");
        this.m_codeGenerator.genCodeLine("    jj_la = xla;");
        this.m_codeGenerator.genCodeLine("    jj_scanpos = token;");
        this.m_codeGenerator.genCodeLine("    jj_lastpos = token;");
        String string = "";
        if (Options.hasDepthLimit()) {
            string = " && !jj_depth_error";
        }
        switch (eOutputLanguage) {
            case JAVA: {
                this.m_codeGenerator.genCodeLine("    try { return (!jj_3" + expansion.getInternalName() + "()" + string + "); }");
                this.m_codeGenerator.genCodeLine("    catch(LookaheadSuccess ls) { return true; }");
                break;
            }
            case CPP: {
                this.m_codeGenerator.genCodeLine("    jj_done = false;");
                this.m_codeGenerator.genCodeLine("    return (!jj_3" + expansion.getInternalName() + "() || jj_done)" + string + ";");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        if (Options.isErrorReporting()) {
            switch (eOutputLanguage) {
                case JAVA: {
                    this.m_codeGenerator.genCodeLine("    finally { jj_save(" + (expansion.getInternalIndex() - 1) + ", xla); }");
                    break;
                }
                case CPP: {
                    this.m_codeGenerator.genCodeLine(" { jj_save(" + (expansion.getInternalIndex() - 1) + ", xla); }");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        this.m_codeGenerator.genCodeLine("  }");
        this.m_codeGenerator.genCodeLine();
        Phase3Data phase3Data = new Phase3Data(expansion, expLookahead.getAmount());
        this.m_phase3list.add((Object)phase3Data);
        this.m_phase3table.put((Object)expansion, (Object)phase3Data);
    }

    private String _genReturn(boolean bl) {
        String string;
        String string2 = string = bl ? "true" : "false";
        if (Options.isDebugLookahead() && this.m_jj3_expansion != null) {
            String string3 = "trace_return(\"" + JavaCCGlobals.addUnicodeEscapes(((NormalProduction)this.m_jj3_expansion.m_parent).getLhs()) + "(LOOKAHEAD " + (bl ? "FAILED" : "SUCCEEDED") + ")\");";
            if (Options.isErrorReporting()) {
                string3 = "if (!jj_rescan) " + string3;
            }
            return "{ " + string3 + " return " + string + "; }";
        }
        return "return " + string + ";";
    }

    private void _generate3R(@Nonnull Expansion expansion, Phase3Data phase3Data) {
        Object object;
        Expansion expansion2 = expansion;
        if (expansion.hasNoInternalName()) {
            while (true) {
                NormalProduction normalProduction;
                if (expansion2 instanceof ExpSequence && ((ExpSequence)expansion2).m_units.size() == 2) {
                    expansion2 = ((ExpSequence)expansion2).m_units.get(1);
                    continue;
                }
                if (!(expansion2 instanceof ExpNonTerminal) || (normalProduction = JavaCCGlobals.s_production_table.get(((ExpNonTerminal)(object = (ExpNonTerminal)expansion2)).getName())) instanceof AbstractCodeProduction) break;
                expansion2 = normalProduction.getExpansion();
            }
            if (expansion2 instanceof AbstractExpRegularExpression) {
                expansion.setInternalNameOnly("jj_scan_token(" + ((AbstractExpRegularExpression)expansion2).m_ordinal + ")");
                return;
            }
            ++this.m_nGenSymbolIndex;
            expansion.setInternalName("R_", this.m_nGenSymbolIndex);
        }
        if ((object = (Phase3Data)this.m_phase3table.get((Object)expansion)) == null || ((Phase3Data)object).m_count < phase3Data.m_count) {
            object = new Phase3Data(expansion, phase3Data.m_count);
            this.m_phase3list.add(object);
            this.m_phase3table.put((Object)expansion, object);
        }
    }

    void setupPhase3Builds(Phase3Data phase3Data) {
        Expansion expansion = phase3Data.m_exp;
        if (!(expansion instanceof AbstractExpRegularExpression)) {
            if (expansion instanceof ExpNonTerminal) {
                ExpNonTerminal expNonTerminal = (ExpNonTerminal)expansion;
                NormalProduction normalProduction = JavaCCGlobals.s_production_table.get(expNonTerminal.getName());
                if (!(normalProduction instanceof AbstractCodeProduction)) {
                    this._generate3R(normalProduction.getExpansion(), phase3Data);
                }
            } else if (expansion instanceof ExpChoice) {
                ExpChoice expChoice = (ExpChoice)expansion;
                for (int i = 0; i < expChoice.getChoices().size(); ++i) {
                    this._generate3R(expChoice.getChoices().get(i), phase3Data);
                }
            } else if (expansion instanceof ExpSequence) {
                ExpSequence expSequence = (ExpSequence)expansion;
                int n = phase3Data.m_count;
                for (int i = 1; i < expSequence.m_units.size(); ++i) {
                    Expansion expansion2 = expSequence.m_units.get(i);
                    this.setupPhase3Builds(new Phase3Data(expansion2, n));
                    if ((n -= this.minimumSize(expansion2)) > 0) {
                        continue;
                    }
                    break;
                }
            } else if (expansion instanceof ExpTryBlock) {
                ExpTryBlock expTryBlock = (ExpTryBlock)expansion;
                this.setupPhase3Builds(new Phase3Data(expTryBlock.m_exp, phase3Data.m_count));
            } else if (expansion instanceof ExpOneOrMore) {
                ExpOneOrMore expOneOrMore = (ExpOneOrMore)expansion;
                this._generate3R(expOneOrMore.m_expansion, phase3Data);
            } else if (expansion instanceof ExpZeroOrMore) {
                ExpZeroOrMore expZeroOrMore = (ExpZeroOrMore)expansion;
                this._generate3R(expZeroOrMore.m_expansion, phase3Data);
            } else if (expansion instanceof ExpZeroOrOne) {
                ExpZeroOrOne expZeroOrOne = (ExpZeroOrOne)expansion;
                this._generate3R(expZeroOrOne.m_expansion, phase3Data);
            }
        }
    }

    private String _getTypeForToken() {
        EOutputLanguage eOutputLanguage = this.m_codeGenerator.getOutputLanguage();
        switch (eOutputLanguage) {
            case JAVA: {
                return "Token";
            }
            case CPP: {
                return "Token *";
            }
        }
        throw new UnsupportedOutputLanguageException(eOutputLanguage);
    }

    private String _genjj_3Call(Expansion expansion) {
        String string = expansion.getInternalName();
        if (string.startsWith("jj_scan_token")) {
            return string;
        }
        return "jj_3" + string + "()";
    }

    void buildPhase3Routine(Phase3Data phase3Data, boolean bl) {
        Expansion expansion = phase3Data.m_exp;
        Token token = null;
        if (expansion.getInternalName().startsWith("jj_scan_token")) {
            return;
        }
        EOutputLanguage eOutputLanguage = this.m_codeGenerator.getOutputLanguage();
        if (!bl) {
            switch (eOutputLanguage) {
                case JAVA: {
                    this.m_codeGenerator.genCodeLine("  private " + eOutputLanguage.getTypeBoolean() + " jj_3" + expansion.getInternalName() + "()");
                    break;
                }
                case CPP: {
                    this.m_codeGenerator.genCodeLine(" inline bool jj_3" + expansion.getInternalName() + "()");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
            this.m_codeGenerator.genCodeLine(" {");
            switch (eOutputLanguage) {
                case JAVA: {
                    break;
                }
                case CPP: {
                    this.m_codeGenerator.genCodeLine("    if (jj_done) return true;");
                    if (!Options.hasDepthLimit()) break;
                    this.m_codeGenerator.genCodeLine("#define __ERROR_RET__ true");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
            this._genStackCheck(false);
            this.m_xsp_declared = false;
            if (Options.isDebugLookahead() && expansion.m_parent instanceof NormalProduction) {
                this.m_codeGenerator.genCode("    ");
                if (Options.isErrorReporting()) {
                    this.m_codeGenerator.genCode("if (!jj_rescan) ");
                }
                this.m_codeGenerator.genCodeLine("trace_call(\"" + JavaCCGlobals.addUnicodeEscapes(((NormalProduction)expansion.m_parent).getLhs()) + "(LOOKING AHEAD...)\");");
                this.m_jj3_expansion = expansion;
            } else {
                this.m_jj3_expansion = null;
            }
        }
        if (expansion instanceof AbstractExpRegularExpression) {
            AbstractExpRegularExpression abstractExpRegularExpression = (AbstractExpRegularExpression)expansion;
            if (abstractExpRegularExpression.m_label.length() == 0) {
                String string = JavaCCGlobals.s_names_of_tokens.get(abstractExpRegularExpression.m_ordinal);
                if (string != null) {
                    this.m_codeGenerator.genCodeLine("    if (jj_scan_token(" + string + ")) " + this._genReturn(true));
                } else {
                    this.m_codeGenerator.genCodeLine("    if (jj_scan_token(" + abstractExpRegularExpression.m_ordinal + ")) " + this._genReturn(true));
                }
            } else {
                this.m_codeGenerator.genCodeLine("    if (jj_scan_token(" + abstractExpRegularExpression.m_label + ")) " + this._genReturn(true));
            }
        } else if (expansion instanceof ExpNonTerminal) {
            ExpNonTerminal expNonTerminal = (ExpNonTerminal)expansion;
            NormalProduction normalProduction = JavaCCGlobals.s_production_table.get(expNonTerminal.getName());
            if (normalProduction instanceof AbstractCodeProduction) {
                this.m_codeGenerator.genCodeLine("    if (true) { jj_la = 0; jj_scanpos = jj_lastpos; " + this._genReturn(false) + "}");
            } else {
                Expansion expansion2 = normalProduction.getExpansion();
                this.m_codeGenerator.genCodeLine("    if (" + this._genjj_3Call(expansion2) + ") " + this._genReturn(true));
            }
        } else if (expansion instanceof ExpChoice) {
            int n;
            ExpChoice expChoice = (ExpChoice)expansion;
            if (expChoice.getChoices().size() != 1) {
                if (!this.m_xsp_declared) {
                    this.m_xsp_declared = true;
                    this.m_codeGenerator.genCodeLine("    " + this._getTypeForToken() + " xsp;");
                }
                this.m_codeGenerator.genCodeLine("    xsp = jj_scanpos;");
            }
            for (n = 0; n < expChoice.getChoices().size(); ++n) {
                ExpSequence expSequence = (ExpSequence)expChoice.getChoices().get(n);
                ExpLookahead expLookahead = (ExpLookahead)expSequence.m_units.get(0);
                if (expLookahead.getActionTokens().size() != 0) {
                    JavaCCGlobals.s_lookaheadNeeded = true;
                    this.m_codeGenerator.genCodeLine("    jj_lookingAhead = true;");
                    this.m_codeGenerator.genCode("    jj_semLA = ");
                    this.m_codeGenerator.printTokenSetup(expLookahead.getActionTokens().get(0));
                    Iterator<Token> iterator = expLookahead.getActionTokens().iterator();
                    while (iterator.hasNext()) {
                        Token token2;
                        token = token2 = iterator.next();
                        this.m_codeGenerator.printToken(token);
                    }
                    this.m_codeGenerator.printTrailingComments(token);
                    this.m_codeGenerator.genCodeLine(";");
                    this.m_codeGenerator.genCodeLine("    jj_lookingAhead = false;");
                }
                this.m_codeGenerator.genCode("    if (");
                if (expLookahead.getActionTokens().size() != 0) {
                    this.m_codeGenerator.genCode("!jj_semLA || ");
                }
                if (n != expChoice.getChoices().size() - 1) {
                    this.m_codeGenerator.genCodeLine(this._genjj_3Call(expSequence) + ") {");
                    this.m_codeGenerator.genCodeLine("    jj_scanpos = xsp;");
                    continue;
                }
                this.m_codeGenerator.genCodeLine(this._genjj_3Call(expSequence) + ") " + this._genReturn(true));
            }
            for (n = 1; n < expChoice.getChoices().size(); ++n) {
                this.m_codeGenerator.genCodeLine("    }");
            }
        } else if (expansion instanceof ExpSequence) {
            ExpSequence expSequence = (ExpSequence)expansion;
            int n = phase3Data.m_count;
            for (int i = 1; i < expSequence.m_units.size(); ++i) {
                Expansion expansion3 = expSequence.m_units.get(i);
                this.buildPhase3Routine(new Phase3Data(expansion3, n), true);
                if ((n -= this.minimumSize(expansion3)) > 0) {
                    continue;
                }
                break;
            }
        } else if (expansion instanceof ExpTryBlock) {
            ExpTryBlock expTryBlock = (ExpTryBlock)expansion;
            this.buildPhase3Routine(new Phase3Data(expTryBlock.m_exp, phase3Data.m_count), true);
        } else if (expansion instanceof ExpOneOrMore) {
            if (!this.m_xsp_declared) {
                this.m_xsp_declared = true;
                this.m_codeGenerator.genCodeLine("    " + this._getTypeForToken() + " xsp;");
            }
            ExpOneOrMore expOneOrMore = (ExpOneOrMore)expansion;
            Expansion expansion4 = expOneOrMore.m_expansion;
            this.m_codeGenerator.genCodeLine("    if (" + this._genjj_3Call(expansion4) + ") " + this._genReturn(true));
            this.m_codeGenerator.genCodeLine("    while (true) {");
            this.m_codeGenerator.genCodeLine("      xsp = jj_scanpos;");
            this.m_codeGenerator.genCodeLine("      if (" + this._genjj_3Call(expansion4) + ") { jj_scanpos = xsp; break; }");
            this.m_codeGenerator.genCodeLine("    }");
        } else if (expansion instanceof ExpZeroOrMore) {
            if (!this.m_xsp_declared) {
                this.m_xsp_declared = true;
                this.m_codeGenerator.genCodeLine("    " + this._getTypeForToken() + " xsp;");
            }
            ExpZeroOrMore expZeroOrMore = (ExpZeroOrMore)expansion;
            Expansion expansion5 = expZeroOrMore.m_expansion;
            this.m_codeGenerator.genCodeLine("    while (true) {");
            this.m_codeGenerator.genCodeLine("      xsp = jj_scanpos;");
            this.m_codeGenerator.genCodeLine("      if (" + this._genjj_3Call(expansion5) + ") { jj_scanpos = xsp; break; }");
            this.m_codeGenerator.genCodeLine("    }");
        } else if (expansion instanceof ExpZeroOrOne) {
            if (!this.m_xsp_declared) {
                this.m_xsp_declared = true;
                this.m_codeGenerator.genCodeLine("    " + this._getTypeForToken() + " xsp;");
            }
            ExpZeroOrOne expZeroOrOne = (ExpZeroOrOne)expansion;
            Expansion expansion6 = expZeroOrOne.m_expansion;
            this.m_codeGenerator.genCodeLine("    xsp = jj_scanpos;");
            this.m_codeGenerator.genCodeLine("    if (" + this._genjj_3Call(expansion6) + ") jj_scanpos = xsp;");
        }
        if (!bl) {
            this.m_codeGenerator.genCodeLine("    " + this._genReturn(false));
            this.genStackCheckEnd();
            switch (eOutputLanguage) {
                case JAVA: {
                    break;
                }
                case CPP: {
                    if (!Options.hasDepthLimit()) break;
                    this.m_codeGenerator.genCodeLine("#undef __ERROR_RET__");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
            this.m_codeGenerator.genCodeLine("  }");
            this.m_codeGenerator.genCodeLine();
        }
    }

    int minimumSize(Expansion expansion) {
        return this.minimumSize(expansion, Integer.MAX_VALUE);
    }

    int minimumSize(Expansion expansion, int n) {
        int n2 = 0;
        if (expansion.m_inMinimumSize) {
            return Integer.MAX_VALUE;
        }
        expansion.m_inMinimumSize = true;
        if (expansion instanceof AbstractExpRegularExpression) {
            n2 = 1;
        } else if (expansion instanceof ExpNonTerminal) {
            ExpNonTerminal expNonTerminal = (ExpNonTerminal)expansion;
            NormalProduction normalProduction = JavaCCGlobals.s_production_table.get(expNonTerminal.getName());
            if (normalProduction instanceof AbstractCodeProduction) {
                n2 = Integer.MAX_VALUE;
            } else {
                Expansion expansion2 = normalProduction.getExpansion();
                n2 = this.minimumSize(expansion2);
            }
        } else if (expansion instanceof ExpChoice) {
            int n3 = n;
            ExpChoice expChoice = (ExpChoice)expansion;
            for (int i = 0; n3 > 1 && i < expChoice.getChoices().size(); ++i) {
                Expansion expansion3 = expChoice.getChoices().get(i);
                int n4 = this.minimumSize(expansion3, n3);
                if (n3 <= n4) continue;
                n3 = n4;
            }
            n2 = n3;
        } else if (expansion instanceof ExpSequence) {
            int n5 = 0;
            ExpSequence expSequence = (ExpSequence)expansion;
            for (int i = 1; i < expSequence.m_units.size(); ++i) {
                Expansion expansion4 = expSequence.m_units.get(i);
                int n6 = this.minimumSize(expansion4);
                if (n5 == Integer.MAX_VALUE || n6 == Integer.MAX_VALUE) {
                    n5 = Integer.MAX_VALUE;
                    continue;
                }
                if ((n5 += n6) > n) break;
            }
            n2 = n5;
        } else if (expansion instanceof ExpTryBlock) {
            ExpTryBlock expTryBlock = (ExpTryBlock)expansion;
            n2 = this.minimumSize(expTryBlock.m_exp);
        } else if (expansion instanceof ExpOneOrMore) {
            ExpOneOrMore expOneOrMore = (ExpOneOrMore)expansion;
            n2 = this.minimumSize(expOneOrMore.m_expansion);
        } else if (expansion instanceof ExpZeroOrMore) {
            n2 = 0;
        } else if (expansion instanceof ExpZeroOrOne) {
            n2 = 0;
        } else if (expansion instanceof ExpLookahead) {
            n2 = 0;
        } else if (expansion instanceof ExpAction) {
            n2 = 0;
        }
        expansion.m_inMinimumSize = false;
        return n2;
    }

    void build(CodeGenerator codeGenerator) {
        int n;
        this.m_codeGenerator = codeGenerator;
        EOutputLanguage eOutputLanguage = this.m_codeGenerator.getOutputLanguage();
        for (NormalProduction object : JavaCCGlobals.s_bnfproductions) {
            Object object2;
            if (object instanceof CodeProductionCpp) {
                if (!eOutputLanguage.isJava()) {
                    JavaCCErrors.semantic_error("Cannot use JAVACODE productions with non-Java output.");
                    continue;
                }
                object2 = (CodeProductionCpp)object;
                this._generateCPPMethodheader((CodeProductionCpp)object2);
                codeGenerator.genCodeLine(" {");
                if (Options.isDebugParser()) {
                    codeGenerator.genCodeLine();
                    switch (eOutputLanguage) {
                        case JAVA: {
                            codeGenerator.genCodeLine("    trace_call(\"" + JavaCCGlobals.addUnicodeEscapes(((NormalProduction)object2).getLhs()) + "\");");
                            codeGenerator.genCodeLine("    try {");
                            break;
                        }
                        case CPP: {
                            codeGenerator.genCodeLine("    JJEnter<std::function<void()>> jjenter([this]() {trace_call  (\"" + JavaCCGlobals.addUnicodeEscapes(((NormalProduction)object2).getLhs()) + "\"); });");
                            codeGenerator.genCodeLine("    JJExit <std::function<void()>> jjexit ([this]() {trace_return(\"" + JavaCCGlobals.addUnicodeEscapes(((NormalProduction)object2).getLhs()) + "\"); });");
                            codeGenerator.genCodeLine("    try {");
                            break;
                        }
                        default: {
                            throw new UnsupportedOutputLanguageException(eOutputLanguage);
                        }
                    }
                }
                if (((AbstractCodeProduction)object2).getCodeTokens().size() != 0) {
                    codeGenerator.printTokenSetup(((AbstractCodeProduction)object2).getCodeTokens().get(0));
                    --JavaCCGlobals.s_cline;
                    codeGenerator.printTokenList(((AbstractCodeProduction)object2).getCodeTokens());
                }
                codeGenerator.genCodeLine();
                if (Options.isDebugParser()) {
                    codeGenerator.genCodeLine("    } catch(...) { }");
                }
                codeGenerator.genCodeLine("  }");
                codeGenerator.genCodeLine();
                continue;
            }
            if (object instanceof CodeProductionJava) {
                if (!eOutputLanguage.isJava()) {
                    JavaCCErrors.semantic_error("Cannot use JAVACODE productions with non-Java output.");
                    continue;
                }
                object2 = (CodeProductionJava)object;
                Token token = ((NormalProduction)object2).getReturnTypeTokens().get(0);
                codeGenerator.printTokenSetup(token);
                JavaCCGlobals.s_ccol = 1;
                codeGenerator.printLeadingComments(token);
                codeGenerator.genCode("  " + (object.getAccessMod() != null ? object.getAccessMod() + " " : ""));
                JavaCCGlobals.s_cline = token.beginLine;
                JavaCCGlobals.s_ccol = token.beginColumn;
                codeGenerator.printTokenOnly(token);
                for (int i = 1; i < ((NormalProduction)object2).getReturnTypeTokens().size(); ++i) {
                    token = ((NormalProduction)object2).getReturnTypeTokens().get(i);
                    codeGenerator.printToken(token);
                }
                codeGenerator.printTrailingComments(token);
                codeGenerator.genCode(" " + ((NormalProduction)object2).getLhs() + "(");
                if (((NormalProduction)object2).getParameterListTokens().size() != 0) {
                    codeGenerator.printTokenSetup(((NormalProduction)object2).getParameterListTokens().get(0));
                    Iterator<Token> iterator = ((NormalProduction)object2).getParameterListTokens().iterator();
                    while (iterator.hasNext()) {
                        Token token2;
                        token = token2 = iterator.next();
                        codeGenerator.printToken(token);
                    }
                    codeGenerator.printTrailingComments(token);
                }
                codeGenerator.genCode(")");
                switch (eOutputLanguage) {
                    case JAVA: {
                        codeGenerator.genCode(" throws ParseException");
                        break;
                    }
                    case CPP: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
                for (List<Token> list : ((NormalProduction)object2).getThrowsList()) {
                    codeGenerator.genCode(", ");
                    Iterator<Token> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Token token3;
                        token = token3 = iterator.next();
                        codeGenerator.genCode(token.image);
                    }
                }
                codeGenerator.genCode(" {");
                if (Options.isDebugParser()) {
                    codeGenerator.genCodeLine();
                    codeGenerator.genCodeLine("    trace_call(\"" + JavaCCGlobals.addUnicodeEscapes(((NormalProduction)object2).getLhs()) + "\");");
                    codeGenerator.genCode("    try {");
                }
                if (((AbstractCodeProduction)object2).getCodeTokens().size() != 0) {
                    codeGenerator.printTokenSetup(((AbstractCodeProduction)object2).getCodeTokens().get(0));
                    --JavaCCGlobals.s_cline;
                    codeGenerator.printTokenList(((AbstractCodeProduction)object2).getCodeTokens());
                }
                codeGenerator.genCodeLine();
                if (Options.isDebugParser()) {
                    codeGenerator.genCodeLine("    } finally {");
                    codeGenerator.genCodeLine("      trace_return(\"" + JavaCCGlobals.addUnicodeEscapes(((NormalProduction)object2).getLhs()) + "\");");
                    codeGenerator.genCodeLine("    }");
                }
                codeGenerator.genCodeLine("  }");
                codeGenerator.genCodeLine();
                continue;
            }
            this.buildPhase1Routine((BNFProduction)object);
        }
        codeGenerator.switchToIncludeFile();
        for (n = 0; n < this.m_phase2list.size(); ++n) {
            this._buildPhase2Routine((ExpLookahead)this.m_phase2list.get(n));
        }
        n = 0;
        while (n < this.m_phase3list.size()) {
            while (n < this.m_phase3list.size()) {
                this.setupPhase3Builds((Phase3Data)this.m_phase3list.get(n));
                ++n;
            }
        }
        for (Object object2 : this.m_phase3table.values()) {
            this.buildPhase3Routine((Phase3Data)object2, false);
        }
        codeGenerator.switchToMainFile();
    }

    public void reInit() {
        this.m_nGenSymbolIndex = 0;
        this.m_indentamt = 0;
        this.m_bJJ2LA = false;
        this.m_phase2list.clear();
        this.m_phase3list.clear();
        this.m_phase3table.clear();
        this.m_firstSet = null;
        this.m_xsp_declared = false;
        this.m_jj3_expansion = null;
    }

    void buildPhase3TableRec(Phase3Data phase3Data) {
        Expansion expansion = phase3Data.m_exp;
        if (expansion instanceof AbstractExpRegularExpression) {
            AbstractExpRegularExpression abstractExpRegularExpression = (AbstractExpRegularExpression)expansion;
            PGPrinter.info("TOKEN, " + abstractExpRegularExpression.m_ordinal);
        } else if (expansion instanceof ExpNonTerminal) {
            ExpNonTerminal expNonTerminal = (ExpNonTerminal)expansion;
            NormalProduction normalProduction = JavaCCGlobals.s_production_table.get(expNonTerminal.getName());
            if (normalProduction instanceof AbstractCodeProduction) {
                PGPrinter.info("JAVACODE_PROD, true");
            } else {
                Expansion expansion2 = normalProduction.getExpansion();
                PGPrinter.info("PRODUCTION, " + expansion2.getInternalIndex());
            }
        } else if (expansion instanceof ExpChoice) {
            ExpChoice expChoice = (ExpChoice)expansion;
            PGPrinter.info("CHOICE, ");
            for (int i = 0; i < expChoice.getChoices().size(); ++i) {
                if (i > 0) {
                    PGPrinter.info("\n|");
                }
                ExpSequence expSequence = (ExpSequence)expChoice.getChoices().get(i);
                ExpLookahead expLookahead = (ExpLookahead)expSequence.m_units.get(0);
                if (expLookahead.getActionTokens().size() != 0) {
                    PGPrinter.info("SEMANTIC,");
                    continue;
                }
                PGPrinter.info("<start recurse>");
                this.buildPhase3TableRec(new Phase3Data(expSequence, phase3Data.m_count));
                PGPrinter.info("<end recurse>");
            }
            PGPrinter.info();
        } else if (expansion instanceof ExpSequence) {
            ExpSequence expSequence = (ExpSequence)expansion;
            int n = phase3Data.m_count;
            if (expSequence.m_units.size() > 2) {
                PGPrinter.info("SEQ, " + n);
                for (int i = 1; i < expSequence.m_units.size(); ++i) {
                    Expansion expansion3 = expSequence.m_units.get(i);
                    this.buildPhase3TableRec(new Phase3Data(expansion3, n));
                    if ((n -= this.minimumSize(expansion3)) > 0) {
                        continue;
                    }
                    break;
                }
            } else {
                NormalProduction normalProduction;
                Expansion expansion4 = expSequence.m_units.get(1);
                while (expansion4 instanceof ExpNonTerminal && !((normalProduction = JavaCCGlobals.s_production_table.get(((ExpNonTerminal)expansion4).getName())) instanceof AbstractCodeProduction)) {
                    expansion4 = normalProduction.getExpansion();
                }
                this.buildPhase3TableRec(new Phase3Data(expansion4, n));
            }
            PGPrinter.info();
        } else if (expansion instanceof ExpTryBlock) {
            ExpTryBlock expTryBlock = (ExpTryBlock)expansion;
            this.buildPhase3TableRec(new Phase3Data(expTryBlock.m_exp, phase3Data.m_count));
        } else if (expansion instanceof ExpOneOrMore) {
            ExpOneOrMore expOneOrMore = (ExpOneOrMore)expansion;
            PGPrinter.info("SEQ PROD " + expOneOrMore.m_expansion.getInternalIndex());
            PGPrinter.info("ZEROORMORE " + expOneOrMore.m_expansion.getInternalIndex());
        } else if (expansion instanceof ExpZeroOrMore) {
            ExpZeroOrMore expZeroOrMore = (ExpZeroOrMore)expansion;
            PGPrinter.info("ZEROORMORE, " + expZeroOrMore.m_expansion.getInternalIndex());
        } else if (expansion instanceof ExpZeroOrOne) {
            ExpZeroOrOne expZeroOrOne = (ExpZeroOrOne)expansion;
            PGPrinter.info("ZERORONE, " + expZeroOrOne.m_expansion.getInternalIndex());
        } else assert (false);
    }

    static enum EState {
        NOOPENSTM,
        OPENIF,
        OPENSWITCH;

    }
}

