/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.SimpleFileIO;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.io.stream.NonBlockingBufferedWriter;
import com.helger.commons.io.stream.NonBlockingStringWriter;
import com.helger.commons.system.ENewLineMode;
import com.helger.commons.system.SystemHelper;
import com.helger.pgcc.utils.ConditionParser;
import com.helger.pgcc.utils.ParseException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;

public class OutputFileGenerator {
    private final String m_templateName;
    private final Map<String, Object> m_options;
    private ENewLineMode m_eNewLineMode = ENewLineMode.DEFAULT;
    private String m_currentLine;

    public OutputFileGenerator(String string, Map<String, Object> map) {
        this.m_templateName = string;
        this.m_options = map;
    }

    @Nonnull
    public OutputFileGenerator setNewLineMode(@Nonnull ENewLineMode eNewLineMode) {
        ValueEnforcer.notNull((Object)eNewLineMode, (String)"NewLineMode");
        this.m_eNewLineMode = eNewLineMode;
        return this;
    }

    public void generate(@WillNotClose Writer writer) throws IOException {
        InputStream inputStream = ClassPathResource.getInputStream((String)this.m_templateName);
        if (inputStream == null) {
            throw new IOException("Invalid template name: " + this.m_templateName);
        }
        try (NonBlockingBufferedReader nonBlockingBufferedReader = new NonBlockingBufferedReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            this._process(nonBlockingBufferedReader, writer, false);
        }
    }

    private String _peekLine(NonBlockingBufferedReader nonBlockingBufferedReader) throws IOException {
        if (this.m_currentLine == null) {
            this.m_currentLine = nonBlockingBufferedReader.readLine();
        }
        return this.m_currentLine;
    }

    private String _getLine(NonBlockingBufferedReader nonBlockingBufferedReader) throws IOException {
        String string = this.m_currentLine;
        this.m_currentLine = null;
        if (string == null) {
            nonBlockingBufferedReader.readLine();
        }
        return string;
    }

    private boolean _evaluate(@Nonnull String string) {
        try {
            return new ConditionParser(string.trim()).CompilationUnit(this.m_options);
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    private String _substitute(String string) throws IOException {
        int n;
        int n2 = string.indexOf("${");
        if (n2 == -1) {
            return string;
        }
        int n3 = 1;
        for (n = n2 + 2; n < string.length() && n3 > 0; ++n) {
            if (string.charAt(n) == '{') {
                ++n3;
                continue;
            }
            if (string.charAt(n) != '}') continue;
            --n3;
        }
        if (n3 != 0) {
            throw new IOException("Mismatched \"{}\" in template string: " + string);
        }
        String string2 = string.substring(n2 + 2, n - 1);
        String string3 = null;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == ':' && i < string2.length() - 1 && string2.charAt(i + 1) == '-') {
                string3 = this._substituteWithDefault(string2.substring(0, i), string2.substring(i + 2));
                break;
            }
            if (c == '?') {
                string3 = this._substituteWithConditional(string2.substring(0, i), string2.substring(i + 1));
                break;
            }
            if (c == '_' || Character.isJavaIdentifierPart(c)) continue;
            throw new IOException("Invalid variable in " + string);
        }
        if (string3 == null) {
            string3 = this._substituteWithDefault(string2, "");
        }
        return string.substring(0, n2) + string3 + string.substring(n);
    }

    private String _substituteWithConditional(String string, String string2) throws IOException {
        int n = string2.indexOf(58);
        if (n == -1) {
            throw new IOException("No ':' separator in " + string2);
        }
        if (this._evaluate(string)) {
            return this._substitute(string2.substring(0, n));
        }
        return this._substitute(string2.substring(n + 1));
    }

    private String _substituteWithDefault(String string, String string2) throws IOException {
        Object object = this.m_options.get(string.trim());
        if (object == null || object.toString().length() == 0) {
            return this._substitute(string2);
        }
        return object.toString();
    }

    private void _write(Writer writer, String string) throws IOException {
        String string2 = string;
        while (string2.indexOf("${") != -1) {
            string2 = this._substitute(string2);
        }
        if (string2.startsWith("\\#")) {
            string2 = string2.substring(1);
        }
        writer.write(string2);
        writer.write(this.m_eNewLineMode.getText());
    }

    private void _process(NonBlockingBufferedReader nonBlockingBufferedReader, Writer writer, boolean bl) throws IOException {
        while (this._peekLine(nonBlockingBufferedReader) != null) {
            if (this._peekLine(nonBlockingBufferedReader).trim().startsWith("#if")) {
                this._processIf(nonBlockingBufferedReader, writer, bl);
                continue;
            }
            if (this._peekLine(nonBlockingBufferedReader).trim().startsWith("#")) break;
            String string = this._getLine(nonBlockingBufferedReader);
            if (bl) continue;
            this._write(writer, string);
        }
        writer.flush();
    }

    private void _processIf(NonBlockingBufferedReader nonBlockingBufferedReader, Writer writer, boolean bl) throws IOException {
        String string = this._getLine(nonBlockingBufferedReader).trim();
        assert (string.trim().startsWith("#if"));
        boolean bl2 = false;
        boolean bl3 = this._evaluate(string.substring(3).trim());
        while (true) {
            this._process(nonBlockingBufferedReader, writer, bl || bl2 || !bl3);
            bl2 |= bl3;
            if (this._peekLine(nonBlockingBufferedReader) == null || !this._peekLine(nonBlockingBufferedReader).trim().startsWith("#elif")) break;
            bl3 = this._evaluate(this._getLine(nonBlockingBufferedReader).trim().substring(5).trim());
        }
        if (this._peekLine(nonBlockingBufferedReader) != null && this._peekLine(nonBlockingBufferedReader).trim().startsWith("#else")) {
            this._getLine(nonBlockingBufferedReader);
            this._process(nonBlockingBufferedReader, writer, bl || bl2);
        }
        if ((string = this._getLine(nonBlockingBufferedReader)) == null) {
            throw new IOException("Missing \"#fi\"");
        }
        if (!string.trim().startsWith("#fi")) {
            throw new IOException("Expected \"#fi\", got: " + string);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("falseArg", Boolean.FALSE);
        hashMap.put("trueArg", Boolean.TRUE);
        hashMap.put("stringValue", "someString");
        try (NonBlockingBufferedWriter nonBlockingBufferedWriter = FileHelper.getBufferedWriter((File)new File(stringArray[1]), (Charset)SystemHelper.getSystemCharset());){
            new OutputFileGenerator(stringArray[0], hashMap).generate((Writer)nonBlockingBufferedWriter);
        }
    }

    public static void generateFromTemplate(String string, Map<String, Object> map, String string2, @Nonnull Charset charset) throws IOException {
        OutputFileGenerator outputFileGenerator = new OutputFileGenerator(string, map);
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();){
            outputFileGenerator.generate((Writer)nonBlockingStringWriter);
            SimpleFileIO.writeFile((File)new File(string2), (String)nonBlockingStringWriter.getAsString(), (Charset)charset);
        }
    }
}

