/* Generated by: ParserGeneratorCC: Do not edit this line. JavaCharStream.java Version 1.1 */
/* ParserGeneratorCCOptions:SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package com.helger.pgcc.utils;

/**
 * An implementation of interface CharStream, where the stream is assumed to
 * contain only ASCII characters (with java-like unicode escape processing).
 */
public
class JavaCharStream extends AbstractCharStream
{
  protected Provider inputStream;

  @Override
  protected int streamRead(final char[] buffer, final int offset, final int len) throws java.io.IOException {
    return inputStream.read (buffer, offset, len); 
  }
  
  @Override
  protected void streamClose() throws java.io.IOException {
    inputStream.close (); 
  }

  protected void fillBuff() throws java.io.IOException
  {
    if (maxNextCharInd == 4096)
      maxNextCharInd = nextCharInd = 0;

    try {
      int i = inputStream.read(nextCharBuf, maxNextCharInd, 4096 - maxNextCharInd);
      if (i == -1)
      {
        inputStream.close();
        throw new java.io.IOException();
      }
      maxNextCharInd += i;
      return;
    }
    catch(final java.io.IOException e) {
      if (bufpos != 0)
      {
        --bufpos;
        backup(0);
      }
      else
      {
        bufline[bufpos] = line;
        bufcolumn[bufpos] = column;
      }
      throw e;
    }
  }

  protected char readByte() throws java.io.IOException
  {
    if (++nextCharInd >= maxNextCharInd)
      fillBuff();

    return nextCharBuf[nextCharInd];
  }

/** @return starting character for token. */
  public char beginToken() throws java.io.IOException
  {
    if (inBuf > 0)
    {
      --inBuf;

      if (++bufpos == bufsize)
        bufpos = 0;

      tokenBegin = bufpos;
      return buffer[bufpos];
    }

    tokenBegin = 0;
    bufpos = -1;

    return readChar();
  }

  protected void adjustBuffSize()
  {
    if (available == bufsize)
    {
      if (tokenBegin > 2048)
      {
        bufpos = 0;
        available = tokenBegin;
      }
      else
        expandBuff(false);
    }
    else
    if (available > tokenBegin)
      available = bufsize;
    else
    if ((tokenBegin - available) < 2048)
      expandBuff(true);
    else
      available = tokenBegin;
  }

/** Read a character. */
  public char readChar() throws java.io.IOException
  {
    if (inBuf > 0)
    {
      --inBuf;

      if (++bufpos == bufsize)
        bufpos = 0;

      return buffer[bufpos];
    }

    ++bufpos;
    if (bufpos == available)
      adjustBuffSize();

    char c = readByte();
    buffer[bufpos] = c;
    if (c == '\\')
    {
      if (isTrackLineColumn()) 
        updateLineColumn(c);

      int backSlashCnt = 1;

      for (;;) // Read all the backslashes
      {
        ++bufpos;
        if (bufpos == available)
          adjustBuffSize();

        try
        {
          c = readByte();
          buffer[bufpos] = c;
          if (c != '\\')
          {
            if (isTrackLineColumn()) 
               updateLineColumn(c);
               
            // found a non-backslash char.
            if ((c == 'u') && ((backSlashCnt & 1) == 1))
            {
              if (--bufpos < 0)
                bufpos = bufsize - 1;

              break;
            }

            backup(backSlashCnt);
            return '\\';
          }
        }
        catch(final java.io.IOException e)
        {
	        // We are returning one backslash so we should only backup (count-1)
          if (backSlashCnt > 1)
            backup(backSlashCnt-1);

          return '\\';
        }

        if (isTrackLineColumn()) 
          updateLineColumn(c);
        backSlashCnt++;
      }

      // Here, we have seen an odd number of backslash's followed by a 'u'
      try
      {
        while ((c = readByte()) == 'u')
          ++column;

        buffer[bufpos] = c = (char)(hexval(c) << 12 |
                                    hexval(readByte()) << 8 |
                                    hexval(readByte()) << 4 |
                                    hexval(readByte()));

        column += 4;
      }
      catch(final java.io.IOException e)
      {
        throw new IllegalStateException("Invalid escape character at line " + line + " column " + column + ".");
      }

      if (backSlashCnt == 1)
        return c;

      backup(backSlashCnt - 1);
      return '\\';
    }

    // Not a backslash
    if (isTrackLineColumn()) 
      updateLineColumn(c);
    return c;
  }

  /** Constructor. */
  public JavaCharStream(final Provider dstream,
                        final int startline,
                        final int startcolumn,
                        final int buffersize)
  {
    super (startline, startcolumn, buffersize);
    inputStream = dstream;
  }

  /** Constructor. */
  public JavaCharStream(final Provider dstream,
                        final int startline,
                        final int startcolumn)
  {
    this(dstream, startline, startcolumn, 4096);
  }

  /** Constructor. */
  public JavaCharStream(final Provider dstream)
  {
    this(dstream, 1, 1, 4096);
  }
  
  /** Reinitialise. */
  public void reInit(final Provider dstream)
  {
    reInit(dstream, 1, 1, 4096);
  }

  /** Reinitialise. */
  public void reInit(final Provider dstream,
                     final int startline,
                     final int startcolumn)
  {
    reInit(dstream, startline, startcolumn, 4096);
  }
  
  /** Reinitialise. */
  public void reInit(final Provider dstream,
                     final int startline,
                     final int startcolumn,
                     final int buffersize)
  {
    inputStream = dstream;
    super.reInit (startline, startcolumn, buffersize);
  }
}
/* ParserGeneratorCC - OriginalChecksum=90f979d74f5596090819672061319af6 (do not edit this line) */
