/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjdoc;

import com.helger.commons.string.StringHelper;
import com.helger.pgcc.PGPrinter;
import com.helger.pgcc.jjdoc.IDocGenerator;
import com.helger.pgcc.jjdoc.JJDocGlobals;
import com.helger.pgcc.parser.AbstractExpRegularExpression;
import com.helger.pgcc.parser.BNFProduction;
import com.helger.pgcc.parser.CharacterRange;
import com.helger.pgcc.parser.CodeProductionCpp;
import com.helger.pgcc.parser.CodeProductionJava;
import com.helger.pgcc.parser.ExpAction;
import com.helger.pgcc.parser.ExpChoice;
import com.helger.pgcc.parser.ExpLookahead;
import com.helger.pgcc.parser.ExpNonTerminal;
import com.helger.pgcc.parser.ExpOneOrMore;
import com.helger.pgcc.parser.ExpRCharacterList;
import com.helger.pgcc.parser.ExpRChoice;
import com.helger.pgcc.parser.ExpREndOfFile;
import com.helger.pgcc.parser.ExpRJustName;
import com.helger.pgcc.parser.ExpROneOrMore;
import com.helger.pgcc.parser.ExpRRepetitionRange;
import com.helger.pgcc.parser.ExpRSequence;
import com.helger.pgcc.parser.ExpRStringLiteral;
import com.helger.pgcc.parser.ExpRZeroOrMore;
import com.helger.pgcc.parser.ExpRZeroOrOne;
import com.helger.pgcc.parser.ExpSequence;
import com.helger.pgcc.parser.ExpTryBlock;
import com.helger.pgcc.parser.ExpZeroOrMore;
import com.helger.pgcc.parser.ExpZeroOrOne;
import com.helger.pgcc.parser.Expansion;
import com.helger.pgcc.parser.ICCCharacter;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.NormalProduction;
import com.helger.pgcc.parser.RegExprSpec;
import com.helger.pgcc.parser.SingleCharacter;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.parser.TokenProduction;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public final class JJDoc {
    static void start() throws IOException {
        JJDocGlobals.s_generator = JJDocGlobals.getGenerator();
        JJDocGlobals.s_generator.documentStart();
        JJDoc._emitTokenProductions(JJDocGlobals.s_generator, JavaCCGlobals.s_rexprlist);
        JJDoc._emitNormalProductions(JJDocGlobals.s_generator, JavaCCGlobals.s_bnfproductions);
        JJDocGlobals.s_generator.documentEnd();
    }

    private static Token _getPrecedingSpecialToken(Token token) {
        Token token2 = token;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        return token2 != token ? token2 : null;
    }

    private static void _emitTopLevelSpecialTokens(Token token, IDocGenerator iDocGenerator) throws IOException {
        if (token == null) {
            return;
        }
        Token token2 = JJDoc._getPrecedingSpecialToken(token);
        String string = "";
        if (token2 != null) {
            JavaCCGlobals.s_cline = token2.beginLine;
            JavaCCGlobals.s_ccol = token2.beginColumn;
            while (token2 != null) {
                string = string + JavaCCGlobals.printTokenOnly(token2);
                token2 = token2.next;
            }
        }
        if (string.length() > 0) {
            iDocGenerator.specialTokens(string);
        }
    }

    private static void _emitTokenProductions(IDocGenerator iDocGenerator, List<TokenProduction> list) throws IOException {
        iDocGenerator.tokensStart();
        Iterator<TokenProduction> iterator = list.iterator();
        while (iterator.hasNext()) {
            TokenProduction tokenProduction;
            TokenProduction tokenProduction2 = tokenProduction = iterator.next();
            JJDoc._emitTopLevelSpecialTokens(tokenProduction2.m_firstToken, iDocGenerator);
            iDocGenerator.handleTokenProduction(tokenProduction2);
        }
        iDocGenerator.tokensEnd();
    }

    public static String getStandardTokenProductionText(TokenProduction tokenProduction) {
        String string = "";
        if (tokenProduction.m_isExplicit) {
            if (tokenProduction.m_lexStates == null) {
                string = string + "<*> ";
            } else {
                string = string + "<";
                for (int i = 0; i < tokenProduction.m_lexStates.length; ++i) {
                    string = string + tokenProduction.m_lexStates[i];
                    if (i >= tokenProduction.m_lexStates.length - 1) continue;
                    string = string + ",";
                }
                string = string + "> ";
            }
            string = string + tokenProduction.m_kind.getImage();
            if (tokenProduction.m_ignoreCase) {
                string = string + " [IGNORE_CASE]";
            }
            string = string + " : {\n";
            Iterator<RegExprSpec> iterator = tokenProduction.m_respecs.iterator();
            while (iterator.hasNext()) {
                RegExprSpec regExprSpec = iterator.next();
                string = string + JJDoc.emitRE(regExprSpec.rexp);
                if (regExprSpec.nsTok != null) {
                    string = string + " : " + regExprSpec.nsTok.image;
                }
                string = string + "\n";
                if (!iterator.hasNext()) continue;
                string = string + "| ";
            }
            string = string + "}\n\n";
        }
        return string;
    }

    private static void _emitNormalProductions(IDocGenerator iDocGenerator, List<NormalProduction> list) throws IOException {
        iDocGenerator.nonterminalsStart();
        for (NormalProduction normalProduction : list) {
            JJDoc._emitTopLevelSpecialTokens(normalProduction.getFirstToken(), iDocGenerator);
            if (normalProduction instanceof BNFProduction) {
                iDocGenerator.productionStart(normalProduction);
                if (normalProduction.getExpansion() instanceof ExpChoice) {
                    boolean bl = true;
                    ExpChoice expChoice = (ExpChoice)normalProduction.getExpansion();
                    for (Expansion expansion : expChoice.getChoices()) {
                        iDocGenerator.expansionStart(expansion, bl);
                        JJDoc._emitExpansionTree(expansion, iDocGenerator);
                        iDocGenerator.expansionEnd(expansion, bl);
                        bl = false;
                    }
                } else {
                    iDocGenerator.expansionStart(normalProduction.getExpansion(), true);
                    JJDoc._emitExpansionTree(normalProduction.getExpansion(), iDocGenerator);
                    iDocGenerator.expansionEnd(normalProduction.getExpansion(), true);
                }
                iDocGenerator.productionEnd(normalProduction);
                continue;
            }
            if (normalProduction instanceof CodeProductionCpp) {
                iDocGenerator.cppcode((CodeProductionCpp)normalProduction);
                continue;
            }
            if (!(normalProduction instanceof CodeProductionJava)) continue;
            iDocGenerator.javacode((CodeProductionJava)normalProduction);
        }
        iDocGenerator.nonterminalsEnd();
    }

    private static void _emitExpansionTree(Expansion expansion, IDocGenerator iDocGenerator) throws IOException {
        if (expansion instanceof ExpAction) {
            JJDoc._emitExpansionAction((ExpAction)expansion, iDocGenerator);
        } else if (expansion instanceof ExpChoice) {
            JJDoc._emitExpansionChoice((ExpChoice)expansion, iDocGenerator);
        } else if (expansion instanceof ExpLookahead) {
            JJDoc._emitExpansionLookahead((ExpLookahead)expansion, iDocGenerator);
        } else if (expansion instanceof ExpNonTerminal) {
            JJDoc._emitExpansionNonTerminal((ExpNonTerminal)expansion, iDocGenerator);
        } else if (expansion instanceof ExpOneOrMore) {
            JJDoc._emitExpansionOneOrMore((ExpOneOrMore)expansion, iDocGenerator);
        } else if (expansion instanceof AbstractExpRegularExpression) {
            JJDoc._emitExpansionRegularExpression((AbstractExpRegularExpression)expansion, iDocGenerator);
        } else if (expansion instanceof ExpSequence) {
            JJDoc._emitExpansionSequence((ExpSequence)expansion, iDocGenerator);
        } else if (expansion instanceof ExpTryBlock) {
            JJDoc._emitExpansionTryBlock((ExpTryBlock)expansion, iDocGenerator);
        } else if (expansion instanceof ExpZeroOrMore) {
            JJDoc._emitExpansionZeroOrMore((ExpZeroOrMore)expansion, iDocGenerator);
        } else if (expansion instanceof ExpZeroOrOne) {
            JJDoc._emitExpansionZeroOrOne((ExpZeroOrOne)expansion, iDocGenerator);
        } else {
            PGPrinter.error("Oops: Unknown expansion type.");
        }
    }

    private static void _emitExpansionAction(ExpAction expAction, IDocGenerator iDocGenerator) {
        iDocGenerator.doNothing(expAction);
    }

    private static void _emitExpansionChoice(ExpChoice expChoice, IDocGenerator iDocGenerator) throws IOException {
        Iterator<Expansion> iterator = expChoice.getChoices().iterator();
        while (iterator.hasNext()) {
            Expansion expansion = iterator.next();
            JJDoc._emitExpansionTree(expansion, iDocGenerator);
            if (!iterator.hasNext()) continue;
            iDocGenerator.text(" | ");
        }
    }

    private static void _emitExpansionLookahead(ExpLookahead expLookahead, IDocGenerator iDocGenerator) {
        iDocGenerator.doNothing(expLookahead);
    }

    private static void _emitExpansionNonTerminal(ExpNonTerminal expNonTerminal, IDocGenerator iDocGenerator) throws IOException {
        iDocGenerator.nonTerminalStart(expNonTerminal);
        iDocGenerator.text(expNonTerminal.getName());
        iDocGenerator.nonTerminalEnd(expNonTerminal);
    }

    private static void _emitExpansionOneOrMore(ExpOneOrMore expOneOrMore, IDocGenerator iDocGenerator) throws IOException {
        iDocGenerator.text("( ");
        JJDoc._emitExpansionTree(expOneOrMore.m_expansion, iDocGenerator);
        iDocGenerator.text(" )+");
    }

    private static void _emitExpansionRegularExpression(AbstractExpRegularExpression abstractExpRegularExpression, IDocGenerator iDocGenerator) throws IOException {
        String string = JJDoc.emitRE(abstractExpRegularExpression);
        if (StringHelper.hasText((String)string)) {
            iDocGenerator.reStart(abstractExpRegularExpression);
            iDocGenerator.text(string);
            iDocGenerator.reEnd(abstractExpRegularExpression);
        }
    }

    private static void _emitExpansionSequence(ExpSequence expSequence, IDocGenerator iDocGenerator) throws IOException {
        boolean bl = true;
        for (Expansion expansion : expSequence.units()) {
            boolean bl2;
            if (expansion instanceof ExpLookahead || expansion instanceof ExpAction) continue;
            if (!bl) {
                iDocGenerator.text(" ");
            }
            boolean bl3 = bl2 = expansion instanceof ExpChoice || expansion instanceof ExpSequence;
            if (bl2) {
                iDocGenerator.text("( ");
            }
            JJDoc._emitExpansionTree(expansion, iDocGenerator);
            if (bl2) {
                iDocGenerator.text(" )");
            }
            bl = false;
        }
    }

    private static void _emitExpansionTryBlock(ExpTryBlock expTryBlock, IDocGenerator iDocGenerator) throws IOException {
        boolean bl = expTryBlock.m_exp instanceof ExpChoice;
        if (bl) {
            iDocGenerator.text("( ");
        }
        JJDoc._emitExpansionTree(expTryBlock.m_exp, iDocGenerator);
        if (bl) {
            iDocGenerator.text(" )");
        }
    }

    private static void _emitExpansionZeroOrMore(ExpZeroOrMore expZeroOrMore, IDocGenerator iDocGenerator) throws IOException {
        iDocGenerator.text("( ");
        JJDoc._emitExpansionTree(expZeroOrMore.m_expansion, iDocGenerator);
        iDocGenerator.text(" )*");
    }

    private static void _emitExpansionZeroOrOne(ExpZeroOrOne expZeroOrOne, IDocGenerator iDocGenerator) throws IOException {
        iDocGenerator.text("( ");
        JJDoc._emitExpansionTree(expZeroOrOne.m_expansion, iDocGenerator);
        iDocGenerator.text(" )?");
    }

    public static String emitRE(AbstractExpRegularExpression abstractExpRegularExpression) {
        boolean bl;
        String string = "";
        boolean bl2 = StringHelper.hasText((String)abstractExpRegularExpression.m_label);
        boolean bl3 = abstractExpRegularExpression instanceof ExpRJustName;
        boolean bl4 = abstractExpRegularExpression instanceof ExpREndOfFile;
        boolean bl5 = abstractExpRegularExpression instanceof ExpRStringLiteral;
        boolean bl6 = abstractExpRegularExpression.m_tpContext != null;
        boolean bl7 = bl = bl3 || bl4 || bl2 || !bl5 && bl6;
        if (bl) {
            string = string + "<";
            if (!bl3) {
                if (abstractExpRegularExpression.m_private_rexp) {
                    string = string + "#";
                }
                if (bl2) {
                    string = string + abstractExpRegularExpression.m_label;
                    string = string + ": ";
                }
            }
        }
        if (abstractExpRegularExpression instanceof ExpRCharacterList) {
            ExpRCharacterList expRCharacterList = (ExpRCharacterList)abstractExpRegularExpression;
            if (expRCharacterList.m_negated_list) {
                string = string + "~";
            }
            string = string + "[";
            Iterator<ICCCharacter> iterator = expRCharacterList.m_descriptors.iterator();
            while (iterator.hasNext()) {
                char[] cArray;
                ICCCharacter iCCCharacter = iterator.next();
                if (iCCCharacter instanceof SingleCharacter) {
                    string = string + "\"";
                    cArray = new char[]{((SingleCharacter)iCCCharacter).getChar()};
                    string = string + JavaCCGlobals.addEscapes(new String(cArray));
                    string = string + "\"";
                } else if (iCCCharacter instanceof CharacterRange) {
                    string = string + "\"";
                    cArray = new char[]{((CharacterRange)iCCCharacter).getLeft()};
                    string = string + JavaCCGlobals.addEscapes(new String(cArray));
                    string = string + "\"-\"";
                    cArray[0] = ((CharacterRange)iCCCharacter).getRight();
                    string = string + JavaCCGlobals.addEscapes(new String(cArray));
                    string = string + "\"";
                } else {
                    PGPrinter.error("Oops: unknown character list element type.");
                }
                if (!iterator.hasNext()) continue;
                string = string + ",";
            }
            string = string + "]";
        } else if (abstractExpRegularExpression instanceof ExpRChoice) {
            ExpRChoice expRChoice = (ExpRChoice)abstractExpRegularExpression;
            Iterator<AbstractExpRegularExpression> iterator = expRChoice.getChoices().iterator();
            while (iterator.hasNext()) {
                AbstractExpRegularExpression abstractExpRegularExpression2 = iterator.next();
                string = string + JJDoc.emitRE(abstractExpRegularExpression2);
                if (!iterator.hasNext()) continue;
                string = string + " | ";
            }
        } else if (abstractExpRegularExpression instanceof ExpREndOfFile) {
            string = string + "EOF";
        } else if (abstractExpRegularExpression instanceof ExpRJustName) {
            ExpRJustName expRJustName = (ExpRJustName)abstractExpRegularExpression;
            string = string + expRJustName.m_label;
        } else if (abstractExpRegularExpression instanceof ExpROneOrMore) {
            ExpROneOrMore expROneOrMore = (ExpROneOrMore)abstractExpRegularExpression;
            string = string + "(";
            string = string + JJDoc.emitRE(expROneOrMore.m_regexpr);
            string = string + ")+";
        } else if (abstractExpRegularExpression instanceof ExpRSequence) {
            ExpRSequence expRSequence = (ExpRSequence)abstractExpRegularExpression;
            Iterator<AbstractExpRegularExpression> iterator = expRSequence.iterator();
            while (iterator.hasNext()) {
                AbstractExpRegularExpression abstractExpRegularExpression3 = iterator.next();
                boolean bl8 = false;
                if (abstractExpRegularExpression3 instanceof ExpRChoice) {
                    bl8 = true;
                }
                if (bl8) {
                    string = string + "(";
                }
                string = string + JJDoc.emitRE(abstractExpRegularExpression3);
                if (bl8) {
                    string = string + ")";
                }
                if (!iterator.hasNext()) continue;
                string = string + " ";
            }
        } else if (abstractExpRegularExpression instanceof ExpRStringLiteral) {
            ExpRStringLiteral expRStringLiteral = (ExpRStringLiteral)abstractExpRegularExpression;
            string = string + "\"" + JavaCCGlobals.addEscapes(expRStringLiteral.m_image) + "\"";
        } else if (abstractExpRegularExpression instanceof ExpRZeroOrMore) {
            ExpRZeroOrMore expRZeroOrMore = (ExpRZeroOrMore)abstractExpRegularExpression;
            string = string + "(";
            string = string + JJDoc.emitRE(expRZeroOrMore.m_regexpr);
            string = string + ")*";
        } else if (abstractExpRegularExpression instanceof ExpRZeroOrOne) {
            ExpRZeroOrOne expRZeroOrOne = (ExpRZeroOrOne)abstractExpRegularExpression;
            string = string + "(";
            string = string + JJDoc.emitRE(expRZeroOrOne.m_regexpr);
            string = string + ")?";
        } else if (abstractExpRegularExpression instanceof ExpRRepetitionRange) {
            ExpRRepetitionRange expRRepetitionRange = (ExpRRepetitionRange)abstractExpRegularExpression;
            string = string + "(";
            string = string + JJDoc.emitRE(expRRepetitionRange.m_regexpr);
            string = string + ")";
            string = string + "{";
            if (expRRepetitionRange.m_hasMax) {
                string = string + expRRepetitionRange.m_min;
                string = string + ",";
                string = string + expRRepetitionRange.m_max;
            } else {
                string = string + expRRepetitionRange.m_min;
            }
            string = string + "}";
        } else {
            PGPrinter.error("Oops: Unknown regular expression type.");
        }
        if (bl) {
            string = string + ">";
        }
        return string;
    }
}

