/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjtree;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.pgcc.jjtree.JJTreeIO;
import com.helger.pgcc.jjtree.JJTreeParser;
import com.helger.pgcc.jjtree.Node;
import com.helger.pgcc.jjtree.NodeScope;
import com.helger.pgcc.jjtree.SimpleNode;
import com.helger.pgcc.jjtree.Token;
import com.helger.pgcc.jjtree.TokenUtils;

public class JJTreeNode
extends SimpleNode {
    private int m_nMyOrdinal;
    private Token m_first;
    private Token m_last;
    private boolean m_whitingOut = false;

    public JJTreeNode(int n) {
        super(n);
    }

    public JJTreeNode(JJTreeParser jJTreeParser, int n) {
        this(n);
    }

    public static Node jjtCreate(int n) {
        return new JJTreeNode(n);
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        super.jjtAddChild(node, n);
        ((JJTreeNode)node).setOrdinal(n);
    }

    public int getOrdinal() {
        return this.m_nMyOrdinal;
    }

    public void setOrdinal(int n) {
        this.m_nMyOrdinal = n;
    }

    public Token getFirstToken() {
        return this.m_first;
    }

    public void setFirstToken(Token token) {
        this.m_first = token;
    }

    public Token getLastToken() {
        return this.m_last;
    }

    public void setLastToken(Token token) {
        this.m_last = token;
    }

    @OverrideOnDemand
    String translateImage(Token token) {
        return token.image;
    }

    static final String whiteOut(Token token) {
        StringBuilder stringBuilder = new StringBuilder(token.image.length());
        for (char c : token.image.toCharArray()) {
            if (c != '\t' && c != '\n' && c != '\r' && c != '\f') {
                stringBuilder.append(' ');
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    protected void print(Token token, JJTreeIO jJTreeIO) {
        NodeScope nodeScope;
        Token token2 = token.specialToken;
        if (token2 != null) {
            while (token2.specialToken != null) {
                token2 = token2.specialToken;
            }
            while (token2 != null) {
                jJTreeIO.print(TokenUtils.addUnicodeEscapes(this.translateImage(token2)));
                token2 = token2.next;
            }
        }
        if ((nodeScope = NodeScope.getEnclosingNodeScope(this)) == null) {
            jJTreeIO.print(TokenUtils.addUnicodeEscapes(this.translateImage(token)));
            return;
        }
        if (token.image.equals("jjtThis")) {
            jJTreeIO.print(nodeScope.getNodeVariable());
            return;
        }
        if (token.image.equals("jjtree") && token.next.image.equals(".") && token.next.next.image.equals("currentNode") && token.next.next.next.image.equals("(") && token.next.next.next.next.image.equals(")")) {
            this.m_whitingOut = true;
        }
        if (this.m_whitingOut) {
            if (token.image.equals("jjtree")) {
                jJTreeIO.print(nodeScope.getNodeVariable());
                jJTreeIO.print(" ");
            } else if (token.image.equals(")")) {
                jJTreeIO.print(" ");
                this.m_whitingOut = false;
            } else {
                for (int i = 0; i < token.image.length(); ++i) {
                    jJTreeIO.print(" ");
                }
            }
            return;
        }
        jJTreeIO.print(TokenUtils.addUnicodeEscapes(this.translateImage(token)));
    }
}

