/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.output.java;

import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.NonBlockingBufferedWriter;
import com.helger.commons.string.StringHelper;
import com.helger.pgcc.output.java.FilesJava;
import com.helger.pgcc.output.java.IJavaResourceTemplateLocations;
import com.helger.pgcc.output.java.JavaModernResourceTemplateLocationImpl;
import com.helger.pgcc.output.java.JavaResourceTemplateLocationImpl;
import com.helger.pgcc.parser.AbstractExpRegularExpression;
import com.helger.pgcc.parser.ETokenKind;
import com.helger.pgcc.parser.ExpRStringLiteral;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.LexGenJava;
import com.helger.pgcc.parser.MetaParseException;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.RegExprSpec;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.parser.TokenProduction;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OtherFilesGenJava {
    private static final String CONSTANTS_FILENAME_SUFFIX = "Constants.java";
    private static final IJavaResourceTemplateLocations RESOURCES_JAVA_CLASSIC = new JavaResourceTemplateLocationImpl();
    private static final IJavaResourceTemplateLocations RESOURCES_JAVA_MODERN = new JavaModernResourceTemplateLocationImpl();

    public static void start(boolean bl) throws MetaParseException {
        if (JavaCCErrors.getErrorCount() != 0) {
            throw new MetaParseException("Error count is already present!");
        }
        IJavaResourceTemplateLocations iJavaResourceTemplateLocations = bl ? RESOURCES_JAVA_MODERN : RESOURCES_JAVA_CLASSIC;
        Token token = null;
        if (Options.isGenerateJavaBoilerplateCode()) {
            if (bl) {
                FilesJava.gen_JavaModernFiles();
            }
            FilesJava.gen_TokenMgrError(iJavaResourceTemplateLocations);
            FilesJava.gen_ParseException(iJavaResourceTemplateLocations);
            FilesJava.gen_Token(iJavaResourceTemplateLocations);
        }
        if (Options.isUserTokenManager()) {
            FilesJava.gen_TokenManager(iJavaResourceTemplateLocations);
        } else if (Options.isGenerateJavaBoilerplateCode()) {
            FilesJava.gen_CharStream(iJavaResourceTemplateLocations);
            if (!Options.isJavaUserCharStream()) {
                FilesJava.gen_AbstractCharStream(iJavaResourceTemplateLocations);
                if (Options.isJavaUnicodeEscape()) {
                    FilesJava.gen_JavaCharStream(iJavaResourceTemplateLocations);
                } else {
                    FilesJava.gen_SimpleCharStream(iJavaResourceTemplateLocations);
                }
            }
        }
        NonBlockingBufferedWriter nonBlockingBufferedWriter = FileHelper.getBufferedWriter((File)new File(Options.getOutputDirectory(), JavaCCGlobals.s_cu_name + CONSTANTS_FILENAME_SUFFIX), (Charset)Options.getOutputEncoding());
        if (nonBlockingBufferedWriter == null) {
            JavaCCErrors.semantic_error("Could not open file " + JavaCCGlobals.s_cu_name + CONSTANTS_FILENAME_SUFFIX + " for writing.");
            return;
        }
        try (PrintWriter printWriter = new PrintWriter((Writer)nonBlockingBufferedWriter);){
            ArrayList<String> arrayList = new ArrayList<String>(JavaCCGlobals.s_toolNames);
            arrayList.add("ParserGeneratorCC");
            printWriter.println("/* " + JavaCCGlobals.getIdString(arrayList, JavaCCGlobals.s_cu_name + CONSTANTS_FILENAME_SUFFIX) + " */");
            if (JavaCCGlobals.s_cu_to_insertion_point_1.size() != 0 && JavaCCGlobals.s_cu_to_insertion_point_1.get((int)0).kind == 67) {
                for (int i = 1; i < JavaCCGlobals.s_cu_to_insertion_point_1.size(); ++i) {
                    if (JavaCCGlobals.s_cu_to_insertion_point_1.get((int)i).kind != 106) continue;
                    token = JavaCCGlobals.s_cu_to_insertion_point_1.get(0);
                    JavaCCGlobals.printTokenSetup(token);
                    for (int j = 0; j <= i; ++j) {
                        token = JavaCCGlobals.s_cu_to_insertion_point_1.get(j);
                        JavaCCGlobals.printToken(token, printWriter);
                    }
                    JavaCCGlobals.printTrailingComments(token);
                    printWriter.println();
                    printWriter.println();
                    break;
                }
            }
            printWriter.println();
            printWriter.println("/**");
            printWriter.println(" * Token literal values and constants.");
            printWriter.println(" * Generated by " + OtherFilesGenJava.class.getName() + "#start()");
            printWriter.println(" */");
            if (Options.isJavaSupportClassVisibilityPublic()) {
                printWriter.print("public ");
            }
            printWriter.println("interface " + JavaCCGlobals.s_cu_name + "Constants {");
            printWriter.println();
            printWriter.println("  /** End of File. */");
            printWriter.println("  int EOF = 0;");
            for (AbstractExpRegularExpression abstractExpRegularExpression : JavaCCGlobals.s_ordered_named_tokens) {
                printWriter.println("  /** RegularExpression Id. */");
                printWriter.println("  int " + abstractExpRegularExpression.m_label + " = " + abstractExpRegularExpression.m_ordinal + ";");
            }
            printWriter.println();
            if (!Options.isUserTokenManager() && Options.isBuildTokenManager()) {
                for (int i = 0; i < LexGenJava.s_lexStateName.length; ++i) {
                    printWriter.println("  /** Lexical state. */");
                    printWriter.println("  int " + LexGenJava.s_lexStateName[i] + " = " + i + ";");
                }
                printWriter.println();
            }
            printWriter.println("  /** Literal token values. */");
            printWriter.println("  String[] tokenImage = {");
            printWriter.println("    \"<EOF>\",");
            Iterator<TokenProduction> iterator = JavaCCGlobals.s_rexprlist.iterator();
            while (iterator.hasNext()) {
                TokenProduction tokenProduction;
                TokenProduction tokenProduction2 = tokenProduction = iterator.next();
                List<RegExprSpec> list = tokenProduction2.m_respecs;
                Iterator<RegExprSpec> iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    RegExprSpec regExprSpec;
                    RegExprSpec regExprSpec2 = regExprSpec = iterator2.next();
                    AbstractExpRegularExpression abstractExpRegularExpression = regExprSpec2.rexp;
                    printWriter.print("    ");
                    if (abstractExpRegularExpression instanceof ExpRStringLiteral) {
                        printWriter.println("\"\\\"" + JavaCCGlobals.addEscapes(JavaCCGlobals.addEscapes(((ExpRStringLiteral)abstractExpRegularExpression).m_image)) + "\\\"\",");
                        continue;
                    }
                    if (StringHelper.hasText((String)abstractExpRegularExpression.m_label)) {
                        printWriter.println("\"<" + abstractExpRegularExpression.m_label + ">\",");
                        continue;
                    }
                    if (abstractExpRegularExpression.m_tpContext.m_kind == ETokenKind.TOKEN) {
                        JavaCCErrors.warning(abstractExpRegularExpression, "Consider giving this non-string token a label for better error reporting.");
                    }
                    printWriter.println("\"<token of kind " + abstractExpRegularExpression.m_ordinal + ">\",");
                }
            }
            printWriter.println("  };");
            printWriter.println();
            printWriter.println("}");
        }
    }

    public static void reInit() {
    }
}

