/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.NonBlockingBufferedWriter;
import com.helger.commons.io.stream.NonBlockingStringWriter;
import com.helger.pgcc.output.EOutputLanguage;
import com.helger.pgcc.output.UnsupportedOutputLanguageException;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.utils.OutputFileGenerator;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

public class CodeGenerator {
    protected StringBuilder m_mainBuffer = new StringBuilder();
    protected StringBuilder m_includeBuffer = new StringBuilder();
    protected StringBuilder m_staticsBuffer = new StringBuilder();
    protected StringBuilder m_outputBuffer = this.m_mainBuffer;
    protected int m_cline;
    protected int m_ccol;

    @Nonnull
    protected final EOutputLanguage getOutputLanguage() {
        return Options.getOutputLanguage();
    }

    public void switchToMainFile() {
        this.m_outputBuffer = this.m_mainBuffer;
    }

    public void switchToStaticsFile() {
        if (this.getOutputLanguage().hasStaticsFile()) {
            this.m_outputBuffer = this.m_staticsBuffer;
        }
    }

    public void switchToIncludeFile() {
        if (this.getOutputLanguage().hasIncludeFile()) {
            this.m_outputBuffer = this.m_includeBuffer;
        }
    }

    public void genStringLiteralArrayCPP(String string, String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            this.genCodeLine("static const JJChar " + string + "_arr_" + n + "[] = ");
            this.genStringLiteralInCPP(stringArray[n]);
            this.genCodeLine(";");
        }
        this.genCodeLine("static const JJString " + string + "[] = {");
        for (n = 0; n < stringArray.length; ++n) {
            this.genCodeLine(string + "_arr_" + n + ", ");
        }
        this.genCodeLine("};");
    }

    public void genStringLiteralInCPP(String string) {
        this.m_outputBuffer.append("{");
        for (char c : string.toCharArray()) {
            this.m_outputBuffer.append("0x").append(Integer.toHexString(c)).append(", ");
        }
        this.m_outputBuffer.append("0}");
    }

    public void genCode(char c) {
        this.m_outputBuffer.append(c);
    }

    public final void genCode(String string) {
        this.m_outputBuffer.append(string);
    }

    public final void genCodeNewLine() {
        this.genCode("\n");
    }

    public final void genCodeLine(String string) {
        this.genCode(string);
        this.genCodeNewLine();
    }

    public void saveOutput(String string) {
        if (this.getOutputLanguage().hasIncludeFile()) {
            String string2 = string.replace(".cc", ".h");
            String string3 = new File(string2).getName();
            String string4 = string3.replace('.', '_').toUpperCase(Locale.US);
            this.m_includeBuffer.insert(0, "#define " + string4 + "\n");
            this.m_includeBuffer.insert(0, "#ifndef " + string4 + "\n");
            this.m_mainBuffer.insert(0, this.m_staticsBuffer);
            if (Options.stringValue("NAMESPACE").length() > 0) {
                this.m_mainBuffer.insert(0, "namespace " + Options.stringValue("NAMESPACE_OPEN") + "\n");
                this.m_mainBuffer.append(Options.stringValue("NAMESPACE_CLOSE") + "\n");
                this.m_includeBuffer.append(Options.stringValue("NAMESPACE_CLOSE") + "\n");
            }
            if (JavaCCGlobals.s_jjtreeGenerated) {
                this.m_mainBuffer.insert(0, "#include \"SimpleNode.h\"\n");
            }
            if (Options.isTokenManagerUsesParser()) {
                this.m_mainBuffer.insert(0, "#include \"" + JavaCCGlobals.s_cu_name + ".h\"\n");
            }
            this.m_mainBuffer.insert(0, "#include \"TokenMgrError.h\"\n");
            this.m_mainBuffer.insert(0, "#include \"" + string3 + "\"\n");
            this.m_includeBuffer.append("#endif\n");
            this.saveOutput(string2, this.m_includeBuffer);
        }
        this.m_mainBuffer.insert(0, "/* " + new File(string).getName() + " */\n");
        this.saveOutput(string, this.m_mainBuffer);
    }

    public void saveOutput(String string, StringBuilder stringBuilder) {
        try (NonBlockingBufferedWriter nonBlockingBufferedWriter = FileHelper.getBufferedWriter((File)new File(string), (Charset)Options.getOutputEncoding());){
            nonBlockingBufferedWriter.write(stringBuilder.toString());
        }
        catch (IOException iOException) {
            JavaCCErrors.fatal("Could not create output file: " + string);
        }
    }

    protected void printTokenSetup(Token token) {
        Token token2 = token;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        this.m_cline = token2.beginLine;
        this.m_ccol = token2.beginColumn;
    }

    protected void printTokenList(List<Token> list) {
        Token token = null;
        Iterator<Token> iterator = list.iterator();
        while (iterator.hasNext()) {
            Token token2;
            token = token2 = iterator.next();
            this.printToken(token);
        }
        if (token != null) {
            this.printTrailingComments(token);
        }
    }

    protected void printTokenOnly(Token token) {
        this.genCode(this.getStringForTokenOnly(token));
    }

    protected String getStringForTokenOnly(Token token) {
        char c;
        String string = "";
        while (this.m_cline < token.beginLine) {
            string = string + "\n";
            this.m_ccol = 1;
            ++this.m_cline;
        }
        while (this.m_ccol < token.beginColumn) {
            string = string + " ";
            ++this.m_ccol;
        }
        string = token.kind == 99 || token.kind == 98 ? string + JavaCCGlobals.addUnicodeEscapes(token.image) : string + token.image;
        this.m_cline = token.endLine;
        this.m_ccol = token.endColumn + 1;
        if (token.image.length() > 0 && ((c = token.image.charAt(token.image.length() - 1)) == '\n' || c == '\r')) {
            ++this.m_cline;
            this.m_ccol = 1;
        }
        return string;
    }

    protected void printToken(@Nonnull Token token) {
        this.genCode(this.getStringToPrint(token));
    }

    protected String getStringToPrint(@Nonnull Token token) {
        String string = "";
        Token token2 = token.specialToken;
        if (token2 != null) {
            while (token2.specialToken != null) {
                token2 = token2.specialToken;
            }
            while (token2 != null) {
                string = string + this.getStringForTokenOnly(token2);
                token2 = token2.next;
            }
        }
        return string + this.getStringForTokenOnly(token);
    }

    protected final void printLeadingComments(Token token) {
        this.genCode(this.getLeadingComments(token));
    }

    protected String getLeadingComments(Token token) {
        String string = "";
        if (token.specialToken == null) {
            return string;
        }
        Token token2 = token.specialToken;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        while (token2 != null) {
            string = string + this.getStringForTokenOnly(token2);
            token2 = token2.next;
        }
        if (this.m_ccol != 1 && this.m_cline != token.beginLine) {
            string = string + "\n";
            ++this.m_cline;
            this.m_ccol = 1;
        }
        return string;
    }

    protected void printTrailingComments(Token token) {
        this.m_outputBuffer.append(this.getTrailingComments(token));
    }

    protected String getTrailingComments(Token token) {
        if (token.next == null) {
            return "";
        }
        return this.getLeadingComments(token.next);
    }

    public String getGeneratedCode() {
        return this.m_outputBuffer.toString() + "\n";
    }

    public void genAnnotation(String string) {
        EOutputLanguage eOutputLanguage = this.getOutputLanguage();
        switch (eOutputLanguage) {
            case JAVA: {
                this.genCode("@" + string);
                break;
            }
            case CPP: {
                this.genCode("/*" + string + "*/");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
    }

    public void genModifier(String string) {
        EOutputLanguage eOutputLanguage = this.getOutputLanguage();
        switch (eOutputLanguage) {
            case JAVA: {
                this.genCode(string);
                break;
            }
            case CPP: {
                String string2 = string.trim().toLowerCase(Locale.US);
                if (!string2.equals("public") && !string2.equals("protected") && !string2.equals("private")) break;
                this.genCode(string2 + ": ");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
    }

    public void genClassStart(String string, String string2, String[] stringArray, String[] stringArray2) {
        EOutputLanguage eOutputLanguage = this.getOutputLanguage();
        switch (eOutputLanguage) {
            case JAVA: {
                if (string != null) {
                    this.genModifier(string);
                }
                this.genCode("class " + string2);
                if (stringArray.length == 1 && stringArray[0] != null) {
                    this.genCode(" extends " + stringArray[0]);
                }
                if (stringArray2.length != 0) {
                    this.genCode(" implements ");
                }
                this._genCommaSeperatedString(stringArray2);
                this.genCodeLine(" {");
                break;
            }
            case CPP: {
                this.genCode("class " + string2);
                if (stringArray.length > 0 || stringArray2.length > 0) {
                    this.genCode(" : ");
                }
                this._genCommaSeperatedString(stringArray);
                this._genCommaSeperatedString(stringArray2);
                this.genCodeLine(" {");
                this.genCodeLine("public:");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
    }

    private void _genCommaSeperatedString(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                this.genCode(", ");
            }
            this.genCode(stringArray[i]);
        }
    }

    public void generateMethodDefHeader(String string, String string2, String string3) {
        this.generateMethodDefHeader(string, string2, string3, null);
    }

    public void generateMethodDefHeader(String string, String string2, String string3, String string4) {
        EOutputLanguage eOutputLanguage = this.getOutputLanguage();
        switch (eOutputLanguage) {
            case JAVA: {
                this.genCode(string + " " + string3);
                if (string4 != null) {
                    this.genCode(" throws " + string4);
                }
                this.genCodeNewLine();
                break;
            }
            case CPP: {
                String string5;
                this.m_includeBuffer.append(string + " " + string3);
                this.m_includeBuffer.append(";\n");
                String string6 = null;
                int n = string.lastIndexOf(58);
                if (n >= 0) {
                    string6 = string.substring(n + 1);
                }
                if (string6 != null && (n = string6.lastIndexOf("virtual")) >= 0) {
                    string6 = string6.substring(n + "virtual".length());
                }
                if ((n = (string5 = string).lastIndexOf("virtual")) >= 0) {
                    string5 = string5.substring(n + "virtual".length());
                }
                this.m_mainBuffer.append("\n" + string5 + " " + this.getClassQualifier(string2) + string3);
                this.switchToMainFile();
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
    }

    protected String getClassQualifier(String string) {
        return string == null ? "" : string + "::";
    }

    public static String getCharStreamName() {
        if (Options.isJavaUserCharStream()) {
            return "CharStream";
        }
        return Options.isJavaUnicodeEscape() ? "JavaCharStream" : "SimpleCharStream";
    }

    protected void writeTemplate(String string, Map<String, Object> map) throws IOException {
        OutputFileGenerator outputFileGenerator = new OutputFileGenerator(string, map);
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();){
            outputFileGenerator.generate((Writer)nonBlockingStringWriter);
            this.genCode(nonBlockingStringWriter.getAsString());
        }
    }
}

