/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.commons.string.StringHelper;
import com.helger.pgcc.output.EOutputLanguage;
import com.helger.pgcc.output.UnsupportedOutputLanguageException;
import com.helger.pgcc.parser.AbstractExpRegularExpression;
import com.helger.pgcc.parser.CodeGenerator;
import com.helger.pgcc.parser.ExpRCharacterList;
import com.helger.pgcc.parser.Expansion;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.LexGenJava;
import com.helger.pgcc.parser.Nfa;
import com.helger.pgcc.parser.NfaState;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.parser.TokenizerData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ExpRStringLiteral
extends AbstractExpRegularExpression {
    public String m_image;
    private static int s_maxStrKind = 0;
    private static int s_maxLen = 0;
    private static int s_charCnt = 0;
    private static List<Map<String, KindInfo>> s_charPosKind = new ArrayList<Map<String, KindInfo>>();
    private static int[] s_maxLenForActive = new int[100];
    public static String[] s_allImages;
    private static int[][] s_intermediateKinds;
    private static int[][] s_intermediateMatchedPos;
    private static boolean[] s_subString;
    private static boolean[] s_subStringAtPos;
    private static Map<String, long[]>[] s_statesForPos;
    private static boolean boilerPlateDumped;
    static final Map<Integer, List<String>> literalsByLength;
    static final Map<Integer, List<Integer>> literalKinds;
    static final Map<Integer, Integer> kindToLexicalState;
    static final Map<Integer, NfaState> nfaStateMap;

    public ExpRStringLiteral(Token token, String string) {
        this.setLine(token.beginLine);
        this.setColumn(token.beginColumn);
        this.m_image = string;
    }

    public static void reInitStatic() {
        s_maxStrKind = 0;
        s_maxLen = 0;
        s_charPosKind = new ArrayList<Map<String, KindInfo>>();
        s_maxLenForActive = new int[100];
        s_intermediateKinds = null;
        s_intermediateMatchedPos = null;
        s_subString = null;
        s_subStringAtPos = null;
        s_statesForPos = null;
    }

    public static void dumpStrLiteralImages(CodeGenerator codeGenerator) {
        EOutputLanguage eOutputLanguage = codeGenerator.getOutputLanguage();
        switch (eOutputLanguage) {
            case JAVA: {
                ExpRStringLiteral.dumpStrLiteralImagesForJava(codeGenerator);
                return;
            }
            case CPP: {
                int n;
                s_charCnt = 0;
                codeGenerator.genCodeNewLine();
                codeGenerator.genCodeLine("/** Token literal values. */");
                int n2 = 0;
                codeGenerator.switchToStaticsFile();
                if (s_allImages == null || s_allImages.length == 0) {
                    codeGenerator.genCodeLine("static const JJString jjstrLiteralImages[] = {};");
                    return;
                }
                ExpRStringLiteral.s_allImages[0] = "";
                for (n = 0; n < s_allImages.length; ++n) {
                    String string = s_allImages[n];
                    if (string == null || (LexGenJava.s_toSkip[n / 64] & 1L << n % 64) == 0L && (LexGenJava.s_toMore[n / 64] & 1L << n % 64) == 0L && (LexGenJava.s_toToken[n / 64] & 1L << n % 64) == 0L || (LexGenJava.s_toSkip[n / 64] & 1L << n % 64) != 0L || (LexGenJava.s_toMore[n / 64] & 1L << n % 64) != 0L || LexGenJava.s_canReachOnMore[LexGenJava.s_lexStates[n]] || (Options.isIgnoreCase() || LexGenJava.s_ignoreCase[n]) && (!string.equals(string.toLowerCase(Locale.US)) || !string.equals(string.toUpperCase(Locale.US)))) {
                        ExpRStringLiteral.s_allImages[n] = null;
                        if ((s_charCnt += 6) > 80) {
                            codeGenerator.genCodeNewLine();
                            s_charCnt = 0;
                        }
                        codeGenerator.genCodeLine("static JJChar jjstrLiteralChars_" + n2++ + "[] = {0};");
                        continue;
                    }
                    String string2 = "static JJChar jjstrLiteralChars_" + n2++ + "[] = {";
                    for (int i = 0; i < string.length(); ++i) {
                        string2 = string2 + "0x" + Integer.toHexString(string.charAt(i)) + ", ";
                    }
                    if ((s_charCnt += (string2 = string2 + "0 };").length()) >= 80) {
                        codeGenerator.genCodeNewLine();
                        s_charCnt = 0;
                    }
                    codeGenerator.genCodeLine(string2);
                }
                while (++n < LexGenJava.s_maxOrdinal) {
                    if ((s_charCnt += 6) > 80) {
                        codeGenerator.genCodeNewLine();
                        s_charCnt = 0;
                    }
                    codeGenerator.genCodeLine("static JJChar jjstrLiteralChars_" + n2++ + "[] = {0};");
                }
                codeGenerator.genCodeLine("static const JJString jjstrLiteralImages[] = {");
                for (int i = 0; i < n2; ++i) {
                    codeGenerator.genCodeLine("jjstrLiteralChars_" + i + ", ");
                }
                codeGenerator.genCodeLine("};");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
    }

    public static void dumpStrLiteralImagesForJava(CodeGenerator codeGenerator) {
        int n;
        EOutputLanguage eOutputLanguage = codeGenerator.getOutputLanguage();
        s_charCnt = 0;
        codeGenerator.genCodeNewLine();
        codeGenerator.genCodeLine("/** Token literal values. */");
        codeGenerator.genCodeLine("public static final String[] jjstrLiteralImages = {");
        if (s_allImages == null || s_allImages.length == 0) {
            codeGenerator.genCodeLine("};");
            return;
        }
        ExpRStringLiteral.s_allImages[0] = "";
        for (n = 0; n < s_allImages.length; ++n) {
            String string = s_allImages[n];
            if (string == null || (LexGenJava.s_toSkip[n / 64] & 1L << n % 64) == 0L && (LexGenJava.s_toMore[n / 64] & 1L << n % 64) == 0L && (LexGenJava.s_toToken[n / 64] & 1L << n % 64) == 0L || (LexGenJava.s_toSkip[n / 64] & 1L << n % 64) != 0L || (LexGenJava.s_toMore[n / 64] & 1L << n % 64) != 0L || LexGenJava.s_canReachOnMore[LexGenJava.s_lexStates[n]] || (Options.isIgnoreCase() || LexGenJava.s_ignoreCase[n]) && (!string.equals(string.toLowerCase(Locale.US)) || !string.equals(string.toUpperCase(Locale.US)))) {
                ExpRStringLiteral.s_allImages[n] = null;
                if ((s_charCnt += 6) > 80) {
                    codeGenerator.genCodeNewLine();
                    s_charCnt = 0;
                }
                codeGenerator.genCode("null, ");
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder("\"");
            block5: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (eOutputLanguage) {
                    case JAVA: {
                        if (c <= '\u00ff') {
                            stringBuilder.append('\\').append(Integer.toOctalString(c));
                            continue block5;
                        }
                        String string2 = Integer.toHexString(c);
                        if (string2.length() == 3) {
                            string2 = "0" + string2;
                        }
                        stringBuilder.append("\\u").append(string2);
                        continue block5;
                    }
                    case CPP: {
                        String string2 = Integer.toHexString(c);
                        if (string2.length() == 3) {
                            string2 = "0" + string2;
                        }
                        stringBuilder.append("\\u").append(string2);
                        continue block5;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
            }
            stringBuilder.append("\", ");
            if ((s_charCnt += stringBuilder.length()) > 80) {
                codeGenerator.genCodeNewLine();
                s_charCnt = 0;
            }
            codeGenerator.genCode(stringBuilder.toString());
        }
        while (++n < LexGenJava.s_maxOrdinal) {
            if ((s_charCnt += 6) > 80) {
                codeGenerator.genCodeNewLine();
                s_charCnt = 0;
            }
            codeGenerator.genCode("null, ");
        }
        codeGenerator.genCodeLine("};");
    }

    public void generateDfa() {
        int n;
        if (s_maxStrKind <= this.m_ordinal) {
            s_maxStrKind = this.m_ordinal + 1;
        }
        if ((n = this.m_image.length()) > s_maxLen) {
            s_maxLen = n;
        }
        for (int i = 0; i < n; ++i) {
            Map<Object, Object> map;
            char c = this.m_image.charAt(i);
            String string2 = Options.isIgnoreCase() ? Character.toString(Character.toLowerCase(c)) : Character.toString(c);
            if (!(NfaState.s_unicodeWarningGiven || c <= '\u00ff' || Options.isJavaUnicodeEscape() || Options.isJavaUserCharStream())) {
                NfaState.s_unicodeWarningGiven = true;
                JavaCCErrors.warning(LexGenJava.s_curRE, "Non-ASCII characters used in regular expression.Please make sure you use the correct Reader when you create the parser, one that can handle your character set.");
            }
            if (i >= s_charPosKind.size()) {
                map = new HashMap();
                s_charPosKind.add(map);
            } else {
                map = s_charPosKind.get(i);
            }
            KindInfo kindInfo = map.computeIfAbsent(string2, string -> new KindInfo(LexGenJava.s_maxOrdinal));
            if (i + 1 == n) {
                kindInfo.insertFinalKind(this.m_ordinal);
            } else {
                kindInfo.insertValidKind(this.m_ordinal);
            }
            if (!Options.isIgnoreCase() && LexGenJava.s_ignoreCase[this.m_ordinal] && c != Character.toLowerCase(c)) {
                string2 = Character.toString(Character.toLowerCase(c));
                if (i >= s_charPosKind.size()) {
                    map = new HashMap();
                    s_charPosKind.add(map);
                } else {
                    map = s_charPosKind.get(i);
                }
                kindInfo = map.computeIfAbsent(string2, string -> new KindInfo(LexGenJava.s_maxOrdinal));
                if (i + 1 == n) {
                    kindInfo.insertFinalKind(this.m_ordinal);
                } else {
                    kindInfo.insertValidKind(this.m_ordinal);
                }
            }
            if (Options.isIgnoreCase() || !LexGenJava.s_ignoreCase[this.m_ordinal] || c == Character.toUpperCase(c)) continue;
            string2 = Character.toString(Character.toUpperCase(c));
            if (i >= s_charPosKind.size()) {
                map = new HashMap();
                s_charPosKind.add(map);
            } else {
                map = s_charPosKind.get(i);
            }
            kindInfo = map.computeIfAbsent(string2, string -> new KindInfo(LexGenJava.s_maxOrdinal));
            if (i + 1 == n) {
                kindInfo.insertFinalKind(this.m_ordinal);
                continue;
            }
            kindInfo.insertValidKind(this.m_ordinal);
        }
        ExpRStringLiteral.s_maxLenForActive[this.m_ordinal / 64] = Math.max(s_maxLenForActive[this.m_ordinal / 64], n - 1);
        ExpRStringLiteral.s_allImages[this.m_ordinal] = this.m_image;
    }

    @Override
    public Nfa generateNfa(boolean bl) {
        NfaState nfaState;
        if (this.m_image.length() == 1) {
            ExpRCharacterList expRCharacterList = new ExpRCharacterList(this.m_image.charAt(0));
            return expRCharacterList.generateNfa(bl);
        }
        NfaState nfaState2 = nfaState = new NfaState();
        NfaState nfaState3 = null;
        if (this.m_image.length() == 0) {
            return new Nfa(nfaState2, nfaState2);
        }
        for (int i = 0; i < this.m_image.length(); ++i) {
            nfaState3 = new NfaState();
            nfaState.m_charMoves = new char[1];
            nfaState.addChar(this.m_image.charAt(i));
            if (Options.isIgnoreCase() || bl) {
                nfaState.addChar(Character.toLowerCase(this.m_image.charAt(i)));
                nfaState.addChar(Character.toUpperCase(this.m_image.charAt(i)));
            }
            nfaState.m_next = nfaState3;
            nfaState = nfaState3;
        }
        return new Nfa(nfaState2, nfaState3);
    }

    static void dumpNullStrLiterals(CodeGenerator codeGenerator) {
        codeGenerator.genCodeLine("{");
        if (NfaState.s_generatedStates != 0) {
            codeGenerator.genCodeLine("   return jjMoveNfa" + LexGenJava.s_lexStateSuffix + "(" + NfaState.initStateName() + ", 0);");
        } else {
            codeGenerator.genCodeLine("   return 1;");
        }
        codeGenerator.genCodeLine("}");
    }

    private static int _getStateSetForKind(int n, int n2) {
        if (LexGenJava.s_mixed[LexGenJava.s_lexStateIndex] || NfaState.s_generatedStates == 0) {
            return -1;
        }
        Map<String, long[]> map = s_statesForPos[n];
        if (map == null) {
            return -1;
        }
        for (Map.Entry<String, long[]> entry : map.entrySet()) {
            String string = entry.getKey();
            long[] lArray = entry.getValue();
            string = string.substring(string.indexOf(", ") + 2);
            if ((string = string.substring(string.indexOf(", ") + 2)).equals("null;") || lArray == null || (lArray[n2 / 64] & 1L << n2 % 64) == 0L) continue;
            return NfaState.addStartStateSet(string);
        }
        return -1;
    }

    static String getLabel(int n) {
        AbstractExpRegularExpression abstractExpRegularExpression = LexGenJava.s_rexprs[n];
        if (abstractExpRegularExpression instanceof ExpRStringLiteral) {
            return " \"" + JavaCCGlobals.addEscapes(((ExpRStringLiteral)abstractExpRegularExpression).m_image) + "\"";
        }
        if (abstractExpRegularExpression.m_label.length() > 0) {
            return " <" + abstractExpRegularExpression.m_label + ">";
        }
        return " <token of kind " + n + ">";
    }

    static int getLine(int n) {
        return LexGenJava.s_rexprs[n].getLine();
    }

    static int getColumn(int n) {
        return LexGenJava.s_rexprs[n].getColumn();
    }

    private static boolean _startsWithIgnoreCase(String string, String string2) {
        if (string.length() < string2.length()) {
            return false;
        }
        for (int i = 0; i < string2.length(); ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = string2.charAt(i)) || Character.toLowerCase(c) == c2 || Character.toUpperCase(c) == c2) continue;
            return false;
        }
        return true;
    }

    static void fillSubString() {
        s_subString = new boolean[s_maxStrKind + 1];
        s_subStringAtPos = new boolean[s_maxLen];
        block0: for (int i = 0; i < s_maxStrKind; ++i) {
            ExpRStringLiteral.s_subString[i] = false;
            String string = s_allImages[i];
            if (string == null || LexGenJava.s_lexStates[i] != LexGenJava.s_lexStateIndex) continue;
            if (LexGenJava.s_mixed[LexGenJava.s_lexStateIndex]) {
                ExpRStringLiteral.s_subString[i] = true;
                ExpRStringLiteral.s_subStringAtPos[string.length() - 1] = true;
                continue;
            }
            for (int j = 0; j < s_maxStrKind; ++j) {
                if (j == i || LexGenJava.s_lexStates[j] != LexGenJava.s_lexStateIndex || s_allImages[j] == null) continue;
                if (s_allImages[j].indexOf(string) == 0) {
                    ExpRStringLiteral.s_subString[i] = true;
                    ExpRStringLiteral.s_subStringAtPos[string.length() - 1] = true;
                    continue block0;
                }
                if (!Options.isIgnoreCase() || !ExpRStringLiteral._startsWithIgnoreCase(s_allImages[j], string)) continue;
                ExpRStringLiteral.s_subString[i] = true;
                ExpRStringLiteral.s_subStringAtPos[string.length() - 1] = true;
                continue block0;
            }
        }
    }

    static void dumpStartWithStates(CodeGenerator codeGenerator) {
        EOutputLanguage eOutputLanguage = codeGenerator.getOutputLanguage();
        switch (eOutputLanguage) {
            case JAVA: {
                codeGenerator.genCodeLine("private int jjStartNfaWithStates" + LexGenJava.s_lexStateSuffix + "(int pos, int kind, int state)");
                break;
            }
            case CPP: {
                codeGenerator.generateMethodDefHeader("int", LexGenJava.s_tokMgrClassName, "jjStartNfaWithStates" + LexGenJava.s_lexStateSuffix + "(int pos, int kind, int state)");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        codeGenerator.genCodeLine("{");
        codeGenerator.genCodeLine("   jjmatchedKind = kind;");
        codeGenerator.genCodeLine("   jjmatchedPos = pos;");
        if (Options.isDebugTokenManager()) {
            switch (eOutputLanguage) {
                case JAVA: {
                    codeGenerator.genCodeLine("   debugStream.println(\"   No more string literal token matches are possible.\");");
                    codeGenerator.genCodeLine("   debugStream.println(\"   Currently matched the first \" + (jjmatchedPos + 1) + \" characters as a \" + tokenImage[jjmatchedKind] + \" token.\");");
                    break;
                }
                case CPP: {
                    codeGenerator.genCodeLine("   fprintf(debugStream, \"   No more string literal token matches are possible.\");");
                    codeGenerator.genCodeLine("   fprintf(debugStream, \"   Currently matched the first %d characters as a \\\"%s\\\" token.\\n\",  (jjmatchedPos + 1),  addUnicodeEscapes(tokenImage[jjmatchedKind]).c_str());");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        switch (eOutputLanguage) {
            case JAVA: {
                codeGenerator.genCodeLine("   try { curChar = input_stream.readChar(); }");
                codeGenerator.genCodeLine("   catch(java.io.IOException e) { return pos + 1; }");
                break;
            }
            case CPP: {
                codeGenerator.genCodeLine("   if (input_stream->endOfInput()) { return pos + 1; }");
                codeGenerator.genCodeLine("   curChar = input_stream->readChar();");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        if (Options.isDebugTokenManager()) {
            switch (eOutputLanguage) {
                case JAVA: {
                    codeGenerator.genCodeLine("   debugStream.println(" + (LexGenJava.s_maxLexStates > 1 ? "\"<\" + lexStateNames[curLexState] + \">\" + " : "") + "\"Current character : \" + " + Options.getTokenMgrErrorClass() + ".addEscapes(String.valueOf(curChar)) + \" (\" + (int)curChar + \") at line \" + input_stream.getEndLine() + \" column \" + input_stream.getEndColumn());");
                    break;
                }
                case CPP: {
                    codeGenerator.genCodeLine("   fprintf(debugStream, \"<%s>Current character : %c(%d) at line %d column %d\\n\",addUnicodeEscapes(lexStateNames[curLexState]).c_str(), curChar, (int)curChar, input_stream->getEndLine(), input_stream->getEndColumn());");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        codeGenerator.genCodeLine("   return jjMoveNfa" + LexGenJava.s_lexStateSuffix + "(state, pos + 1);");
        codeGenerator.genCodeLine("}");
    }

    static void dumpBoilerPlate(CodeGenerator codeGenerator) {
        EOutputLanguage eOutputLanguage = codeGenerator.getOutputLanguage();
        switch (eOutputLanguage) {
            case JAVA: {
                codeGenerator.genCodeLine("private int jjStopAtPos(int pos, int kind)");
                break;
            }
            case CPP: {
                codeGenerator.generateMethodDefHeader(" int ", LexGenJava.s_tokMgrClassName, "jjStopAtPos(int pos, int kind)");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        codeGenerator.genCodeLine("{");
        codeGenerator.genCodeLine("   jjmatchedKind = kind;");
        codeGenerator.genCodeLine("   jjmatchedPos = pos;");
        if (Options.isDebugTokenManager()) {
            switch (eOutputLanguage) {
                case JAVA: {
                    codeGenerator.genCodeLine("   debugStream.println(\"   No more string literal token matches are possible.\");");
                    codeGenerator.genCodeLine("   debugStream.println(\"   Currently matched the first \" + (jjmatchedPos + 1) + \" characters as a \" + tokenImage[jjmatchedKind] + \" token.\");");
                    break;
                }
                case CPP: {
                    codeGenerator.genCodeLine("   fprintf(debugStream, \"   No more string literal token matches are possible.\");");
                    codeGenerator.genCodeLine("   fprintf(debugStream, \"   Currently matched the first %d characters as a \\\"%s\\\" token.\\n\",  (jjmatchedPos + 1),  addUnicodeEscapes(tokenImage[jjmatchedKind]).c_str());");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        codeGenerator.genCodeLine("   return pos + 1;");
        codeGenerator.genCodeLine("}");
    }

    private static String[] _reArrange(Map<String, KindInfo> map) {
        String[] stringArray = new String[map.size()];
        int n = 0;
        for (String string : map.keySet()) {
            int n2;
            char c = string.charAt(0);
            for (n2 = 0; n2 < n && stringArray[n2].charAt(0) < c; ++n2) {
            }
            if (n2 < n) {
                for (int i = n - 1; i >= n2; --i) {
                    stringArray[i + 1] = stringArray[i];
                }
            }
            stringArray[n2] = string;
            ++n;
        }
        return stringArray;
    }

    @Nonnull
    private static String _getCaseChar(char c, EOutputLanguage eOutputLanguage) {
        if (c < ' ' || c >= '\u007f') {
            return Integer.toString(c);
        }
        if (eOutputLanguage.isJava() && (c == '\'' || c == '\\')) {
            return "'\\" + c + "'";
        }
        return "'" + c + "'";
    }

    static void dumpDfaCode(CodeGenerator codeGenerator) {
        int n;
        LexGenJava.s_maxLongsReqd[LexGenJava.s_lexStateIndex] = n = s_maxStrKind / 64 + 1;
        EOutputLanguage eOutputLanguage = codeGenerator.getOutputLanguage();
        if (s_maxLen == 0) {
            switch (eOutputLanguage) {
                case JAVA: {
                    codeGenerator.genCodeLine("private int jjMoveStringLiteralDfa0" + LexGenJava.s_lexStateSuffix + "()");
                    break;
                }
                case CPP: {
                    codeGenerator.generateMethodDefHeader(" int ", LexGenJava.s_tokMgrClassName, "jjMoveStringLiteralDfa0" + LexGenJava.s_lexStateSuffix + "()");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
            ExpRStringLiteral.dumpNullStrLiterals(codeGenerator);
            return;
        }
        if (!boilerPlateDumped) {
            ExpRStringLiteral.dumpBoilerPlate(codeGenerator);
            boilerPlateDumped = true;
        }
        boolean bl = false;
        for (int i = 0; i < s_maxLen; ++i) {
            int n2;
            int n3;
            boolean bl2 = false;
            boolean bl3 = false;
            Map<String, KindInfo> map = s_charPosKind.get(i);
            String[] stringArray = ExpRStringLiteral._reArrange(map);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            if (i != 0) {
                if (i == 1) {
                    for (n3 = 0; n3 < n - 1; ++n3) {
                        if (i > s_maxLenForActive[n3]) continue;
                        if (bl2) {
                            stringBuilder.append(", ");
                        } else {
                            bl2 = true;
                        }
                        stringBuilder.append(eOutputLanguage.getTypeLong() + " active" + n3);
                    }
                    if (i <= s_maxLenForActive[n3]) {
                        if (bl2) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(eOutputLanguage.getTypeLong() + " active" + n3);
                    }
                } else {
                    for (n3 = 0; n3 < n - 1; ++n3) {
                        if (i > s_maxLenForActive[n3] + 1) continue;
                        if (bl2) {
                            stringBuilder.append(", ");
                        } else {
                            bl2 = true;
                        }
                        stringBuilder.append(eOutputLanguage.getTypeLong() + " old" + n3 + ", " + eOutputLanguage.getTypeLong() + " active" + n3);
                    }
                    if (i <= s_maxLenForActive[n3] + 1) {
                        if (bl2) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(eOutputLanguage.getTypeLong() + " old" + n3 + ", " + eOutputLanguage.getTypeLong() + " active" + n3);
                    }
                }
            }
            stringBuilder.append(")");
            switch (eOutputLanguage) {
                case JAVA: {
                    codeGenerator.genCode("private int jjMoveStringLiteralDfa" + i + LexGenJava.s_lexStateSuffix + stringBuilder);
                    break;
                }
                case CPP: {
                    codeGenerator.generateMethodDefHeader(" int ", LexGenJava.s_tokMgrClassName, "jjMoveStringLiteralDfa" + i + LexGenJava.s_lexStateSuffix + stringBuilder);
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
            codeGenerator.genCodeLine("{");
            if (i != 0) {
                if (i > 1) {
                    bl2 = false;
                    codeGenerator.genCode("   if ((");
                    for (n3 = 0; n3 < n - 1; ++n3) {
                        if (i > s_maxLenForActive[n3] + 1) continue;
                        if (bl2) {
                            codeGenerator.genCode(" | ");
                        } else {
                            bl2 = true;
                        }
                        codeGenerator.genCode("(active" + n3 + " &= old" + n3 + ")");
                    }
                    if (i <= s_maxLenForActive[n3] + 1) {
                        if (bl2) {
                            codeGenerator.genCode(" | ");
                        }
                        codeGenerator.genCode("(active" + n3 + " &= old" + n3 + ")");
                    }
                    codeGenerator.genCodeLine(") == 0L)");
                    if (!LexGenJava.s_mixed[LexGenJava.s_lexStateIndex] && NfaState.s_generatedStates != 0) {
                        codeGenerator.genCode("      return jjStartNfa" + LexGenJava.s_lexStateSuffix + "(" + (i - 2) + ", ");
                        for (n3 = 0; n3 < n - 1; ++n3) {
                            if (i <= s_maxLenForActive[n3] + 1) {
                                codeGenerator.genCode("old" + n3 + ", ");
                                continue;
                            }
                            codeGenerator.genCode("0L, ");
                        }
                        if (i <= s_maxLenForActive[n3] + 1) {
                            codeGenerator.genCodeLine("old" + n3 + ");");
                        } else {
                            codeGenerator.genCodeLine("0L);");
                        }
                    } else if (NfaState.s_generatedStates != 0) {
                        codeGenerator.genCodeLine("      return jjMoveNfa" + LexGenJava.s_lexStateSuffix + "(" + NfaState.initStateName() + ", " + (i - 1) + ");");
                    } else {
                        codeGenerator.genCodeLine("      return " + i + ";");
                    }
                }
                if (i != 0 && Options.isDebugTokenManager()) {
                    switch (eOutputLanguage) {
                        case JAVA: {
                            codeGenerator.genCodeLine("   if (jjmatchedKind != 0 && jjmatchedKind != 0x" + Integer.toHexString(Integer.MAX_VALUE) + ")");
                            codeGenerator.genCodeLine("      debugStream.println(\"   Currently matched the first \" + (jjmatchedPos + 1) + \" characters as a \" + tokenImage[jjmatchedKind] + \" token.\");");
                            codeGenerator.genCodeLine("   debugStream.println(\"   Possible string literal matches : { \"");
                            break;
                        }
                        case CPP: {
                            codeGenerator.genCodeLine("   if (jjmatchedKind != 0 && jjmatchedKind != 0x" + Integer.toHexString(Integer.MAX_VALUE) + ")");
                            codeGenerator.genCodeLine("      fprintf(debugStream, \"   Currently matched the first %d characters as a \\\"%s\\\" token.\\n\", (jjmatchedPos + 1), addUnicodeEscapes(tokenImage[jjmatchedKind]).c_str());");
                            codeGenerator.genCodeLine("   fprintf(debugStream, \"   Possible string literal matches : { \");");
                            break;
                        }
                        default: {
                            throw new UnsupportedOutputLanguageException(eOutputLanguage);
                        }
                    }
                    StringBuilder stringBuilder2 = new StringBuilder();
                    StringBuilder stringBuilder3 = new StringBuilder();
                    block45: for (n2 = 0; n2 < s_maxStrKind / 64 + 1; ++n2) {
                        if (i > s_maxLenForActive[n2]) continue;
                        switch (eOutputLanguage) {
                            case JAVA: {
                                codeGenerator.genCodeLine(" +");
                                codeGenerator.genCode("         jjKindsForBitVector(" + n2 + ", ");
                                codeGenerator.genCode("active" + n2 + ") ");
                                continue block45;
                            }
                            case CPP: {
                                if (stringBuilder2.length() > 0) {
                                    stringBuilder2.append(", ");
                                    stringBuilder3.append(", ");
                                }
                                stringBuilder2.append("%s");
                                stringBuilder3.append("         jjKindsForBitVector(" + n2 + ", ");
                                stringBuilder3.append("active" + n2 + ").c_str() ");
                                continue block45;
                            }
                            default: {
                                throw new UnsupportedOutputLanguageException(eOutputLanguage);
                            }
                        }
                    }
                    switch (eOutputLanguage) {
                        case JAVA: {
                            codeGenerator.genCodeLine(" + \" } \");");
                            break;
                        }
                        case CPP: {
                            stringBuilder2.append("}\\n");
                            codeGenerator.genCodeLine("    fprintf(debugStream, \"" + stringBuilder2 + "\"," + stringBuilder3 + ");");
                            break;
                        }
                        default: {
                            throw new UnsupportedOutputLanguageException(eOutputLanguage);
                        }
                    }
                }
                switch (eOutputLanguage) {
                    case JAVA: {
                        codeGenerator.genCodeLine("   try { curChar = input_stream.readChar(); }");
                        codeGenerator.genCodeLine("   catch(java.io.IOException e) {");
                        break;
                    }
                    case CPP: {
                        codeGenerator.genCodeLine("   if (input_stream->endOfInput()) {");
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
                if (!LexGenJava.s_mixed[LexGenJava.s_lexStateIndex] && NfaState.s_generatedStates != 0) {
                    int n4;
                    codeGenerator.genCode("      jjStopStringLiteralDfa" + LexGenJava.s_lexStateSuffix + "(" + (i - 1) + ", ");
                    for (n4 = 0; n4 < n - 1; ++n4) {
                        if (i <= s_maxLenForActive[n4]) {
                            codeGenerator.genCode("active" + n4 + ", ");
                            continue;
                        }
                        codeGenerator.genCode("0L, ");
                    }
                    if (i <= s_maxLenForActive[n4]) {
                        codeGenerator.genCodeLine("active" + n4 + ");");
                    } else {
                        codeGenerator.genCodeLine("0L);");
                    }
                    if (i != 0 && Options.isDebugTokenManager()) {
                        switch (eOutputLanguage) {
                            case JAVA: {
                                codeGenerator.genCodeLine("      if (jjmatchedKind != 0 && jjmatchedKind != 0x" + Integer.toHexString(Integer.MAX_VALUE) + ")");
                                codeGenerator.genCodeLine("         debugStream.println(\"   Currently matched the first \" + (jjmatchedPos + 1) + \" characters as a \" + tokenImage[jjmatchedKind] + \" token.\");");
                                break;
                            }
                            case CPP: {
                                codeGenerator.genCodeLine("      if (jjmatchedKind != 0 && jjmatchedKind != 0x" + Integer.toHexString(Integer.MAX_VALUE) + ")");
                                codeGenerator.genCodeLine("      fprintf(debugStream, \"   Currently matched the first %d characters as a \\\"%s\\\" token.\\n\", (jjmatchedPos + 1),  addUnicodeEscapes(tokenImage[jjmatchedKind]).c_str());");
                                break;
                            }
                            default: {
                                throw new UnsupportedOutputLanguageException(eOutputLanguage);
                            }
                        }
                    }
                    codeGenerator.genCodeLine("      return " + i + ";");
                } else if (NfaState.s_generatedStates != 0) {
                    codeGenerator.genCodeLine("   return jjMoveNfa" + LexGenJava.s_lexStateSuffix + "(" + NfaState.initStateName() + ", " + (i - 1) + ");");
                } else {
                    codeGenerator.genCodeLine("      return " + i + ";");
                }
                codeGenerator.genCodeLine("   }");
            }
            if (i != 0) {
                switch (eOutputLanguage) {
                    case JAVA: {
                        break;
                    }
                    case CPP: {
                        codeGenerator.genCodeLine("   curChar = input_stream->readChar();");
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
                if (Options.isDebugTokenManager()) {
                    switch (eOutputLanguage) {
                        case JAVA: {
                            codeGenerator.genCodeLine("   debugStream.println(" + (LexGenJava.s_maxLexStates > 1 ? "\"<\" + lexStateNames[curLexState] + \">\" + " : "") + "\"Current character : \" + " + Options.getTokenMgrErrorClass() + ".addEscapes(String.valueOf(curChar)) + \" (\" + (int)curChar + \") at line \" + input_stream.getEndLine() + \" column \" + input_stream.getEndColumn());");
                            break;
                        }
                        case CPP: {
                            codeGenerator.genCodeLine("   fprintf(debugStream, \"<%s>Current character : %c(%d) at line %d column %d\\n\",addUnicodeEscapes(lexStateNames[curLexState]).c_str(), curChar, (int)curChar, input_stream->getEndLine(), input_stream->getEndColumn());");
                            break;
                        }
                        default: {
                            throw new UnsupportedOutputLanguageException(eOutputLanguage);
                        }
                    }
                }
            }
            codeGenerator.genCodeLine("   switch(curChar)");
            codeGenerator.genCodeLine("   {");
            block47: for (n3 = 0; n3 < stringArray.length; ++n3) {
                int n5;
                String string;
                String string2 = stringArray[n3];
                KindInfo kindInfo = map.get(string2);
                boolean bl4 = false;
                char c = string2.charAt(0);
                if (!(i != 0 || c >= '\u0080' || kindInfo.m_finalKindCnt == 0 || NfaState.s_generatedStates != 0 && NfaState.canStartNfaUsingAscii(c))) {
                    int n6;
                    for (n6 = 0; n6 < n && kindInfo.m_finalKinds[n6] == 0L; ++n6) {
                    }
                    for (int j = 0; j < 64; ++j) {
                        if ((kindInfo.m_finalKinds[n6] & 1L << j) == 0L || s_subString[n2 = n6 * 64 + j]) continue;
                        if (s_intermediateKinds != null && s_intermediateKinds[n6 * 64 + j] != null && s_intermediateKinds[n6 * 64 + j][i] < n6 * 64 + j && s_intermediateMatchedPos != null && s_intermediateMatchedPos[n6 * 64 + j][i] == i || LexGenJava.s_canMatchAnyChar[LexGenJava.s_lexStateIndex] >= 0 && LexGenJava.s_canMatchAnyChar[LexGenJava.s_lexStateIndex] < n6 * 64 + j) break;
                        if ((LexGenJava.s_toSkip[n2 / 64] & 1L << n2 % 64) == 0L || (LexGenJava.s_toSpecial[n2 / 64] & 1L << n2 % 64) != 0L || LexGenJava.s_actions[n2] != null || LexGenJava.s_newLexState[n2] != null) continue;
                        LexGenJava.addCharToSkip(c, n2);
                        if (!Options.isIgnoreCase()) continue block47;
                        if (c != Character.toUpperCase(c)) {
                            LexGenJava.addCharToSkip(Character.toUpperCase(c), n2);
                        }
                        if (c == Character.toLowerCase(c)) continue block47;
                        LexGenJava.addCharToSkip(Character.toLowerCase(c), n2);
                        continue block47;
                    }
                }
                if (Options.isIgnoreCase()) {
                    if (c != Character.toUpperCase(c)) {
                        codeGenerator.genCodeLine("      case " + ExpRStringLiteral._getCaseChar(Character.toUpperCase(c), eOutputLanguage) + ":");
                    }
                    if (c != Character.toLowerCase(c)) {
                        codeGenerator.genCodeLine("      case " + ExpRStringLiteral._getCaseChar(Character.toLowerCase(c), eOutputLanguage) + ":");
                    }
                }
                codeGenerator.genCodeLine("      case " + ExpRStringLiteral._getCaseChar(c, eOutputLanguage) + ":");
                String string3 = string = i == 0 ? "         " : "            ";
                if (kindInfo.m_finalKindCnt != 0) {
                    for (n5 = 0; n5 < n; ++n5) {
                        long l = kindInfo.m_finalKinds[n5];
                        if (l == 0L) continue;
                        for (int j = 0; j < 64; ++j) {
                            int n7;
                            if ((l & 1L << j) == 0L) continue;
                            if (bl4) {
                                codeGenerator.genCode("         else if ");
                            } else if (i != 0) {
                                codeGenerator.genCode("         if ");
                            }
                            bl4 = true;
                            if (i != 0) {
                                codeGenerator.genCodeLine("((active" + n5 + " & " + eOutputLanguage.getLongHex(1L << j) + ") != " + eOutputLanguage.getLongPlain(0L) + ")");
                            }
                            if (s_intermediateKinds != null && s_intermediateKinds[n5 * 64 + j] != null && s_intermediateKinds[n5 * 64 + j][i] < n5 * 64 + j && s_intermediateMatchedPos != null && s_intermediateMatchedPos[n5 * 64 + j][i] == i) {
                                JavaCCErrors.warning(" \"" + JavaCCGlobals.addEscapes(s_allImages[n5 * 64 + j]) + "\" cannot be matched as a string literal token at line " + ExpRStringLiteral.getLine(n5 * 64 + j) + ", column " + ExpRStringLiteral.getColumn(n5 * 64 + j) + ". It will be matched as " + ExpRStringLiteral.getLabel(s_intermediateKinds[n5 * 64 + j][i]) + ".");
                                n7 = s_intermediateKinds[n5 * 64 + j][i];
                            } else if (i == 0 && LexGenJava.s_canMatchAnyChar[LexGenJava.s_lexStateIndex] >= 0 && LexGenJava.s_canMatchAnyChar[LexGenJava.s_lexStateIndex] < n5 * 64 + j) {
                                JavaCCErrors.warning(" \"" + JavaCCGlobals.addEscapes(s_allImages[n5 * 64 + j]) + "\" cannot be matched as a string literal token at line " + ExpRStringLiteral.getLine(n5 * 64 + j) + ", column " + ExpRStringLiteral.getColumn(n5 * 64 + j) + ". It will be matched as " + ExpRStringLiteral.getLabel(LexGenJava.s_canMatchAnyChar[LexGenJava.s_lexStateIndex]) + ".");
                                n7 = LexGenJava.s_canMatchAnyChar[LexGenJava.s_lexStateIndex];
                            } else {
                                n7 = n5 * 64 + j;
                            }
                            if (!s_subString[n5 * 64 + j]) {
                                int n8 = ExpRStringLiteral._getStateSetForKind(i, n5 * 64 + j);
                                if (n8 != -1) {
                                    bl = true;
                                    codeGenerator.genCodeLine(string + "return jjStartNfaWithStates" + LexGenJava.s_lexStateSuffix + "(" + i + ", " + n7 + ", " + n8 + ");");
                                    continue;
                                }
                                codeGenerator.genCodeLine(string + "return jjStopAtPos(" + i + ", " + n7 + ");");
                                continue;
                            }
                            if (LexGenJava.s_initMatch[LexGenJava.s_lexStateIndex] != 0 && LexGenJava.s_initMatch[LexGenJava.s_lexStateIndex] != Integer.MAX_VALUE || i != 0) {
                                codeGenerator.genCodeLine("         {");
                                codeGenerator.genCodeLine(string + "jjmatchedKind = " + n7 + ";");
                                codeGenerator.genCodeLine(string + "jjmatchedPos = " + i + ";");
                                codeGenerator.genCodeLine("         }");
                                continue;
                            }
                            codeGenerator.genCodeLine(string + "jjmatchedKind = " + n7 + ";");
                        }
                    }
                }
                if (kindInfo.m_validKindCnt != 0) {
                    bl2 = false;
                    if (i == 0) {
                        codeGenerator.genCode("         return ");
                        codeGenerator.genCode("jjMoveStringLiteralDfa" + (i + 1) + LexGenJava.s_lexStateSuffix + "(");
                        for (n5 = 0; n5 < n - 1; ++n5) {
                            if (i + 1 > s_maxLenForActive[n5]) continue;
                            if (bl2) {
                                codeGenerator.genCode(", ");
                            } else {
                                bl2 = true;
                            }
                            codeGenerator.genCode(eOutputLanguage.getLongHex(kindInfo.m_validKinds[n5]));
                        }
                        if (i + 1 <= s_maxLenForActive[n5]) {
                            if (bl2) {
                                codeGenerator.genCode(", ");
                            }
                            codeGenerator.genCode(eOutputLanguage.getLongHex(kindInfo.m_validKinds[n5]));
                        }
                        codeGenerator.genCodeLine(");");
                        continue;
                    }
                    codeGenerator.genCode("         return ");
                    codeGenerator.genCode("jjMoveStringLiteralDfa" + (i + 1) + LexGenJava.s_lexStateSuffix + "(");
                    for (n5 = 0; n5 < n - 1; ++n5) {
                        if (i + 1 > s_maxLenForActive[n5] + 1) continue;
                        if (bl2) {
                            codeGenerator.genCode(", ");
                        } else {
                            bl2 = true;
                        }
                        if (kindInfo.m_validKinds[n5] != 0L) {
                            codeGenerator.genCode("active" + n5 + ", " + eOutputLanguage.getLongHex(kindInfo.m_validKinds[n5]));
                            continue;
                        }
                        codeGenerator.genCode("active" + n5 + ", " + eOutputLanguage.getLongPlain(0L));
                    }
                    if (i + 1 <= s_maxLenForActive[n5] + 1) {
                        if (bl2) {
                            codeGenerator.genCode(", ");
                        }
                        if (kindInfo.m_validKinds[n5] != 0L) {
                            codeGenerator.genCode("active" + n5 + ", " + eOutputLanguage.getLongHex(kindInfo.m_validKinds[n5]));
                        } else {
                            codeGenerator.genCode("active" + n5 + ", " + eOutputLanguage.getLongPlain(0L));
                        }
                    }
                    codeGenerator.genCodeLine(");");
                    continue;
                }
                if (i == 0 && LexGenJava.s_mixed[LexGenJava.s_lexStateIndex]) {
                    if (NfaState.s_generatedStates != 0) {
                        codeGenerator.genCodeLine("         return jjMoveNfa" + LexGenJava.s_lexStateSuffix + "(" + NfaState.initStateName() + ", 0);");
                        continue;
                    }
                    codeGenerator.genCodeLine("         return 1;");
                    continue;
                }
                if (i == 0) continue;
                codeGenerator.genCodeLine("         break;");
                bl3 = true;
            }
            codeGenerator.genCodeLine("      default :");
            if (Options.isDebugTokenManager()) {
                switch (eOutputLanguage) {
                    case JAVA: {
                        codeGenerator.genCodeLine("      debugStream.println(\"   No string literal matches possible.\");");
                        break;
                    }
                    case CPP: {
                        codeGenerator.genCodeLine("      fprintf(debugStream, \"   No string literal matches possible.\\n\");");
                        break;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
            }
            if (NfaState.s_generatedStates != 0) {
                if (i == 0) {
                    codeGenerator.genCodeLine("         return jjMoveNfa" + LexGenJava.s_lexStateSuffix + "(" + NfaState.initStateName() + ", 0);");
                } else {
                    codeGenerator.genCodeLine("         break;");
                    bl3 = true;
                }
            } else {
                codeGenerator.genCodeLine("         return " + (i + 1) + ";");
            }
            codeGenerator.genCodeLine("   }");
            if (i != 0 && bl3) {
                if (!LexGenJava.s_mixed[LexGenJava.s_lexStateIndex] && NfaState.s_generatedStates != 0) {
                    codeGenerator.genCode("   return jjStartNfa" + LexGenJava.s_lexStateSuffix + "(" + (i - 1) + ", ");
                    for (n3 = 0; n3 < n - 1; ++n3) {
                        if (i <= s_maxLenForActive[n3]) {
                            codeGenerator.genCode("active" + n3 + ", ");
                            continue;
                        }
                        codeGenerator.genCode("0L, ");
                    }
                    if (i <= s_maxLenForActive[n3]) {
                        codeGenerator.genCodeLine("active" + n3 + ");");
                    } else {
                        codeGenerator.genCodeLine("0L);");
                    }
                } else if (NfaState.s_generatedStates != 0) {
                    codeGenerator.genCodeLine("   return jjMoveNfa" + LexGenJava.s_lexStateSuffix + "(" + NfaState.initStateName() + ", " + i + ");");
                } else {
                    codeGenerator.genCodeLine("   return " + (i + 1) + ";");
                }
            }
            codeGenerator.genCodeLine("}");
        }
        if (!LexGenJava.s_mixed[LexGenJava.s_lexStateIndex] && NfaState.s_generatedStates != 0 && bl) {
            ExpRStringLiteral.dumpStartWithStates(codeGenerator);
        }
    }

    static final int getStrKind(String string) {
        for (int i = 0; i < s_maxStrKind; ++i) {
            String string2;
            if (LexGenJava.s_lexStates[i] != LexGenJava.s_lexStateIndex || (string2 = s_allImages[i]) == null || !string2.equals(string)) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    static void generateNfaStartStates(CodeGenerator codeGenerator, NfaState nfaState) {
        boolean[] blArray = new boolean[NfaState.s_generatedStates];
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = "";
        int n = 0;
        int n2 = s_maxStrKind / 64 + 1;
        ArrayList<NfaState> arrayList = new ArrayList<NfaState>();
        ArrayList<NfaState> arrayList2 = null;
        s_statesForPos = new Map[s_maxLen];
        s_intermediateKinds = new int[s_maxStrKind + 1][];
        s_intermediateMatchedPos = new int[s_maxStrKind + 1][];
        for (int i = 0; i < s_maxStrKind; ++i) {
            String string3;
            if (LexGenJava.s_lexStates[i] != LexGenJava.s_lexStateIndex || (string3 = s_allImages[i]) == null || string3.length() < 1) continue;
            try {
                arrayList2 = new ArrayList<NfaState>(nfaState.m_epsilonMoves);
                if (arrayList2.size() == 0) {
                    ExpRStringLiteral.dumpNfaStartStatesCode(s_statesForPos, codeGenerator);
                    return;
                }
            }
            catch (Exception exception) {
                JavaCCErrors.semantic_error("Error cloning state vector");
            }
            ExpRStringLiteral.s_intermediateKinds[i] = new int[string3.length()];
            ExpRStringLiteral.s_intermediateMatchedPos[i] = new int[string3.length()];
            n = 0;
            int n3 = Integer.MAX_VALUE;
            for (int j = 0; j < string3.length(); ++j) {
                int n4;
                if (arrayList2 == null || arrayList2.size() <= 0) {
                    int n5 = s_intermediateKinds[i][j - 1];
                    ExpRStringLiteral.s_intermediateKinds[i][j] = n5;
                    n3 = n5;
                    int n6 = s_intermediateMatchedPos[i][j - 1];
                    ExpRStringLiteral.s_intermediateMatchedPos[i][j] = n6;
                    n = n6;
                } else {
                    n3 = NfaState.moveFromSet(string3.charAt(j), arrayList2, arrayList);
                    arrayList2.clear();
                    if (j == 0 && n3 != Integer.MAX_VALUE && LexGenJava.s_canMatchAnyChar[LexGenJava.s_lexStateIndex] != -1 && n3 > LexGenJava.s_canMatchAnyChar[LexGenJava.s_lexStateIndex]) {
                        n3 = LexGenJava.s_canMatchAnyChar[LexGenJava.s_lexStateIndex];
                    }
                    if (ExpRStringLiteral.getStrKind(string3.substring(0, j + 1)) < n3) {
                        n3 = Integer.MAX_VALUE;
                        ExpRStringLiteral.s_intermediateKinds[i][j] = Integer.MAX_VALUE;
                        n = 0;
                    } else if (n3 != Integer.MAX_VALUE) {
                        ExpRStringLiteral.s_intermediateKinds[i][j] = n3;
                        int n7 = j;
                        ExpRStringLiteral.s_intermediateMatchedPos[i][j] = n7;
                        n = n7;
                    } else if (j == 0) {
                        ExpRStringLiteral.s_intermediateKinds[i][j] = Integer.MAX_VALUE;
                        n3 = Integer.MAX_VALUE;
                    } else {
                        int n8 = s_intermediateKinds[i][j - 1];
                        ExpRStringLiteral.s_intermediateKinds[i][j] = n8;
                        n3 = n8;
                        int n9 = s_intermediateMatchedPos[i][j - 1];
                        ExpRStringLiteral.s_intermediateMatchedPos[i][j] = n9;
                        n = n9;
                    }
                    string2 = NfaState.getStateSetString(arrayList);
                }
                if (n3 == Integer.MAX_VALUE && (arrayList == null || arrayList.size() == 0)) continue;
                if (hashMap.get(string2) == null) {
                    hashMap.put(string2, string2);
                    for (n4 = 0; n4 < arrayList.size(); ++n4) {
                        if (blArray[((NfaState)arrayList.get((int)n4)).m_stateName]) {
                            ++((NfaState)arrayList.get((int)n4)).m_inNextOf;
                            continue;
                        }
                        blArray[((NfaState)arrayList.get((int)n4)).m_stateName] = true;
                    }
                } else {
                    for (n4 = 0; n4 < arrayList.size(); ++n4) {
                        blArray[((NfaState)arrayList.get((int)n4)).m_stateName] = true;
                    }
                }
                ArrayList<NfaState> arrayList3 = arrayList2;
                arrayList2 = arrayList;
                arrayList = arrayList3;
                arrayList.clear();
                if (s_statesForPos[j] == null) {
                    ExpRStringLiteral.s_statesForPos[j] = new HashMap<String, long[]>();
                }
                long[] lArray = s_statesForPos[j].computeIfAbsent(n3 + ", " + n + ", " + string2, string -> new long[n2]);
                int n10 = i / 64;
                lArray[n10] = lArray[n10] | 1L << i % 64;
            }
        }
        if (Options.getTokenManagerCodeGenerator() == null) {
            ExpRStringLiteral.dumpNfaStartStatesCode(s_statesForPos, codeGenerator);
        }
    }

    static void dumpNfaStartStatesCode(Map<String, long[]>[] mapArray, CodeGenerator codeGenerator) {
        int n;
        if (s_maxStrKind == 0) {
            return;
        }
        EOutputLanguage eOutputLanguage = codeGenerator.getOutputLanguage();
        int n2 = s_maxStrKind / 64 + 1;
        boolean bl = false;
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < n2 - 1; ++n) {
            stringBuilder.append(eOutputLanguage.getTypeLong() + " active" + n + ", ");
        }
        stringBuilder.append(eOutputLanguage.getTypeLong() + " active" + n + ")");
        switch (eOutputLanguage) {
            case JAVA: {
                codeGenerator.genCode("private final int jjStopStringLiteralDfa" + LexGenJava.s_lexStateSuffix + "(int pos, " + stringBuilder);
                break;
            }
            case CPP: {
                codeGenerator.generateMethodDefHeader(" int", LexGenJava.s_tokMgrClassName, "jjStopStringLiteralDfa" + LexGenJava.s_lexStateSuffix + "(int pos, " + stringBuilder);
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        codeGenerator.genCodeLine("{");
        if (Options.isDebugTokenManager()) {
            switch (eOutputLanguage) {
                case JAVA: {
                    codeGenerator.genCodeLine("      debugStream.println(\"   No more string literal token matches are possible.\");");
                    break;
                }
                case CPP: {
                    codeGenerator.genCodeLine("      fprintf(debugStream, \"   No more string literal token matches are possible.\");");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        codeGenerator.genCodeLine("   switch (pos)");
        codeGenerator.genCodeLine("   {");
        for (n = 0; n < s_maxLen - 1; ++n) {
            if (mapArray[n] == null) continue;
            codeGenerator.genCodeLine("      case " + n + ":");
            for (Map.Entry<String, long[]> entry : mapArray[n].entrySet()) {
                String string = entry.getKey();
                long[] lArray = entry.getValue();
                for (int i = 0; i < n2; ++i) {
                    if (lArray[i] == 0L) continue;
                    if (bl) {
                        codeGenerator.genCode(" || ");
                    } else {
                        codeGenerator.genCode("         if (");
                    }
                    bl = true;
                    codeGenerator.genCode("(active" + i + " & " + eOutputLanguage.getLongHex(lArray[i]) + ") != " + eOutputLanguage.getLongPlain(0L));
                }
                if (!bl) continue;
                codeGenerator.genCodeLine(")");
                n3 = string.indexOf(", ");
                String string2 = string.substring(0, n3);
                String string3 = string.substring(n3 + 2);
                int n4 = Integer.parseInt(string3.substring(0, string3.indexOf(", ")));
                if (!string2.equals(String.valueOf(Integer.MAX_VALUE))) {
                    codeGenerator.genCodeLine("         {");
                }
                if (!string2.equals(String.valueOf(Integer.MAX_VALUE))) {
                    if (n == 0) {
                        codeGenerator.genCodeLine("            jjmatchedKind = " + string2 + ";");
                        if (LexGenJava.s_initMatch[LexGenJava.s_lexStateIndex] != 0 && LexGenJava.s_initMatch[LexGenJava.s_lexStateIndex] != Integer.MAX_VALUE) {
                            codeGenerator.genCodeLine("            jjmatchedPos = 0;");
                        }
                    } else if (n == n4) {
                        if (s_subStringAtPos[n]) {
                            codeGenerator.genCodeLine("            if (jjmatchedPos != " + n + ")");
                            codeGenerator.genCodeLine("            {");
                            codeGenerator.genCodeLine("               jjmatchedKind = " + string2 + ";");
                            codeGenerator.genCodeLine("               jjmatchedPos = " + n + ";");
                            codeGenerator.genCodeLine("            }");
                        } else {
                            codeGenerator.genCodeLine("            jjmatchedKind = " + string2 + ";");
                            codeGenerator.genCodeLine("            jjmatchedPos = " + n + ";");
                        }
                    } else {
                        if (n4 > 0) {
                            codeGenerator.genCodeLine("            if (jjmatchedPos < " + n4 + ")");
                        } else {
                            codeGenerator.genCodeLine("            if (jjmatchedPos == 0)");
                        }
                        codeGenerator.genCodeLine("            {");
                        codeGenerator.genCodeLine("               jjmatchedKind = " + string2 + ";");
                        codeGenerator.genCodeLine("               jjmatchedPos = " + n4 + ";");
                        codeGenerator.genCodeLine("            }");
                    }
                }
                n3 = string.indexOf(", ");
                string2 = string.substring(0, n3);
                string3 = string.substring(n3 + 2);
                if ((string = string3.substring(string3.indexOf(", ") + 2)).equals("null;")) {
                    codeGenerator.genCodeLine("            return -1;");
                } else {
                    codeGenerator.genCodeLine("            return " + NfaState.addStartStateSet(string) + ";");
                }
                if (!string2.equals(String.valueOf(Integer.MAX_VALUE))) {
                    codeGenerator.genCodeLine("         }");
                }
                bl = false;
            }
            codeGenerator.genCodeLine("         return -1;");
        }
        codeGenerator.genCodeLine("      default :");
        codeGenerator.genCodeLine("         return -1;");
        codeGenerator.genCodeLine("   }");
        codeGenerator.genCodeLine("}");
        stringBuilder.setLength(0);
        stringBuilder.append("(int pos, ");
        for (n = 0; n < n2 - 1; ++n) {
            stringBuilder.append(eOutputLanguage.getTypeLong() + " active" + n + ", ");
        }
        stringBuilder.append(eOutputLanguage.getTypeLong() + " active" + n + ")");
        switch (eOutputLanguage) {
            case JAVA: {
                codeGenerator.genCode("private final int jjStartNfa" + LexGenJava.s_lexStateSuffix + stringBuilder);
                break;
            }
            case CPP: {
                codeGenerator.generateMethodDefHeader("int ", LexGenJava.s_tokMgrClassName, "jjStartNfa" + LexGenJava.s_lexStateSuffix + stringBuilder);
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        codeGenerator.genCodeLine("{");
        if (LexGenJava.s_mixed[LexGenJava.s_lexStateIndex]) {
            if (NfaState.s_generatedStates != 0) {
                codeGenerator.genCodeLine("   return jjMoveNfa" + LexGenJava.s_lexStateSuffix + "(" + NfaState.initStateName() + ", pos + 1);");
            } else {
                codeGenerator.genCodeLine("   return pos + 1;");
            }
            codeGenerator.genCodeLine("}");
            return;
        }
        codeGenerator.genCode("   return jjMoveNfa" + LexGenJava.s_lexStateSuffix + "(jjStopStringLiteralDfa" + LexGenJava.s_lexStateSuffix + "(pos, ");
        for (n = 0; n < n2 - 1; ++n) {
            codeGenerator.genCode("active" + n + ", ");
        }
        codeGenerator.genCode("active" + n + ")");
        codeGenerator.genCodeLine(", pos + 1);");
        codeGenerator.genCodeLine("}");
    }

    public static void reInit() {
        ExpRStringLiteral.reInitStatic();
        s_charCnt = 0;
        s_allImages = null;
        boilerPlateDumped = false;
    }

    @Override
    public StringBuilder dump(int n, Set<? super Expansion> set) {
        StringBuilder stringBuilder = super.dump(n, set).append(' ').append(this.m_image);
        return stringBuilder;
    }

    @Override
    public String toString() {
        return super.toString() + " - " + this.m_image;
    }

    public static void updateStringLiteralData(int n) {
        for (int i = 0; i < s_allImages.length; ++i) {
            int n2;
            if (StringHelper.hasNoText((String)s_allImages[i]) || LexGenJava.s_lexStates[i] != n) continue;
            String string = s_allImages[i];
            if (s_intermediateKinds != null && s_intermediateKinds[i][string.length() - 1] != Integer.MAX_VALUE && s_intermediateKinds[i][string.length() - 1] < i) {
                JavaCCErrors.warning("Token: " + string + " will not be matched as specified. It will be matched as token of kind: " + s_intermediateKinds[i][string.length() - 1] + " instead.");
                n2 = s_intermediateKinds[i][string.length() - 1];
            } else {
                n2 = i;
            }
            kindToLexicalState.put(n2, n);
            if (Options.isIgnoreCase()) {
                string = string.toLowerCase(Locale.US);
            }
            char c = string.charAt(0);
            int n3 = LexGenJava.s_lexStateIndex << 16 | c;
            List<String> list = literalsByLength.get(n3);
            List<Integer> list2 = literalKinds.get(n3);
            int n4 = 0;
            if (list == null) {
                list = new ArrayList<String>();
                literalsByLength.put(n3, list);
                assert (list2 == null);
                list2 = new ArrayList<Integer>();
                list2 = new ArrayList<Integer>();
                literalKinds.put(n3, list2);
            }
            while (n4 < list.size() && list.get(n4).length() > string.length()) {
                ++n4;
            }
            list.add(n4, string);
            list2.add(n4, n2);
            int n5 = ExpRStringLiteral._getStateSetForKind(string.length() - 1, i);
            if (n5 != -1) {
                nfaStateMap.put(n2, NfaState.getNfaState(n5));
                continue;
            }
            nfaStateMap.put(n2, null);
        }
    }

    public static void BuildTokenizerData(TokenizerData tokenizerData) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int n : nfaStateMap.keySet()) {
            if (nfaStateMap.get(n) != null) {
                hashMap.put(n, ExpRStringLiteral.nfaStateMap.get((Object)Integer.valueOf((int)n)).m_stateName);
                continue;
            }
            hashMap.put(n, -1);
        }
        tokenizerData.setLiteralSequence(literalsByLength);
        tokenizerData.setLiteralKinds(literalKinds);
        tokenizerData.setKindToNfaStartState(hashMap);
    }

    static {
        boilerPlateDumped = false;
        literalsByLength = new HashMap<Integer, List<String>>();
        literalKinds = new HashMap<Integer, List<Integer>>();
        kindToLexicalState = new HashMap<Integer, Integer>();
        nfaStateMap = new HashMap<Integer, NfaState>();
    }

    private static final class KindInfo {
        final long[] m_validKinds;
        final long[] m_finalKinds;
        int m_validKindCnt = 0;
        int m_finalKindCnt = 0;
        final Set<Integer> m_finalKindSet = new HashSet<Integer>();
        final Set<Integer> m_validKindSet = new HashSet<Integer>();

        KindInfo(int n) {
            this.m_validKinds = new long[n / 64 + 1];
            this.m_finalKinds = new long[n / 64 + 1];
        }

        public void insertValidKind(int n) {
            int n2 = n / 64;
            this.m_validKinds[n2] = this.m_validKinds[n2] | 1L << n % 64;
            ++this.m_validKindCnt;
            this.m_validKindSet.add(n);
        }

        public void insertFinalKind(int n) {
            int n2 = n / 64;
            this.m_finalKinds[n2] = this.m_finalKinds[n2] | 1L << n % 64;
            ++this.m_finalKindCnt;
            this.m_finalKindSet.add(n);
        }
    }
}

