/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjdoc;

import com.helger.pgcc.jjdoc.IDocGenerator;
import com.helger.pgcc.jjdoc.JJDoc;
import com.helger.pgcc.jjdoc.JJDocGlobals;
import com.helger.pgcc.jjdoc.TextGenerator;
import com.helger.pgcc.parser.AbstractExpRegularExpression;
import com.helger.pgcc.parser.CodeProductionCpp;
import com.helger.pgcc.parser.CodeProductionJava;
import com.helger.pgcc.parser.ExpNonTerminal;
import com.helger.pgcc.parser.Expansion;
import com.helger.pgcc.parser.NormalProduction;
import com.helger.pgcc.parser.RegExprSpec;
import com.helger.pgcc.parser.TokenProduction;
import java.io.IOException;
import java.io.Writer;

public class XTextGenerator
implements IDocGenerator {
    private Writer m_aPW;

    @Override
    public void handleTokenProduction(TokenProduction tokenProduction) {
        StringBuilder stringBuilder = new StringBuilder();
        for (RegExprSpec regExprSpec : tokenProduction.m_respecs) {
            String string = JJDoc.emitRE(regExprSpec.rexp);
            stringBuilder.append(string);
            if (regExprSpec.nsTok != null) {
                stringBuilder.append(" : " + regExprSpec.nsTok.image);
            }
            stringBuilder.append("\n");
        }
    }

    private void println(String string) throws IOException {
        this.print(string + "\n");
    }

    @Override
    public void text(String string) throws IOException {
        this.print(string);
    }

    @Override
    public void print(String string) throws IOException {
        this.m_aPW.write(string);
    }

    @Override
    public void documentStart() throws IOException {
        this.m_aPW = TextGenerator.createPrintWriter();
        this.println("grammar " + JJDocGlobals.s_input_file + " with org.eclipse.xtext.common.Terminals");
        this.println("import \"http://www.eclipse.org/emf/2002/Ecore\" as ecore");
        this.println("");
    }

    @Override
    public void documentEnd() throws IOException {
        this.m_aPW.close();
    }

    @Override
    public void specialTokens(String string) throws IOException {
        this.print(string);
    }

    @Override
    public void nonterminalsStart() {
    }

    @Override
    public void nonterminalsEnd() {
    }

    @Override
    public void tokensStart() {
    }

    @Override
    public void tokensEnd() {
    }

    @Override
    public void javacode(CodeProductionJava codeProductionJava) {
    }

    @Override
    public void cppcode(CodeProductionCpp codeProductionCpp) {
    }

    @Override
    public void productionStart(NormalProduction normalProduction) {
    }

    @Override
    public void productionEnd(NormalProduction normalProduction) {
    }

    @Override
    public void expansionStart(Expansion expansion, boolean bl) {
    }

    @Override
    public void expansionEnd(Expansion expansion, boolean bl) throws IOException {
        this.println(";");
    }

    @Override
    public void nonTerminalStart(ExpNonTerminal expNonTerminal) throws IOException {
        this.print("terminal ");
    }

    @Override
    public void nonTerminalEnd(ExpNonTerminal expNonTerminal) throws IOException {
        this.print(";");
    }

    @Override
    public void reStart(AbstractExpRegularExpression abstractExpRegularExpression) {
    }

    @Override
    public void reEnd(AbstractExpRegularExpression abstractExpRegularExpression) {
    }
}

