/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.pgcc.PGPrinter;
import com.helger.pgcc.parser.CharacterRange;
import com.helger.pgcc.parser.Expansion;
import com.helger.pgcc.parser.NormalProduction;
import com.helger.pgcc.parser.SingleCharacter;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.parser.TokenProduction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JavaCCErrors {
    private static int s_parse_error_count = 0;
    private static int s_semantic_error_count = 0;
    private static int s_warning_count = 0;

    private JavaCCErrors() {
    }

    @Nonnull
    private static String _getLocationInfo(@Nullable Object object) {
        if (object instanceof NormalProduction) {
            NormalProduction normalProduction = (NormalProduction)object;
            return "Line " + normalProduction.getLine() + ", Column " + normalProduction.getColumn() + ": ";
        }
        if (object instanceof TokenProduction) {
            TokenProduction tokenProduction = (TokenProduction)object;
            return "Line " + tokenProduction.getLine() + ", Column " + tokenProduction.getColumn() + ": ";
        }
        if (object instanceof Expansion) {
            Expansion expansion = (Expansion)object;
            return "Line " + expansion.getLine() + ", Column " + expansion.getColumn() + ": ";
        }
        if (object instanceof CharacterRange) {
            CharacterRange characterRange = (CharacterRange)object;
            return "Line " + characterRange.getLine() + ", Column " + characterRange.getColumn() + ": ";
        }
        if (object instanceof SingleCharacter) {
            SingleCharacter singleCharacter = (SingleCharacter)object;
            return "Line " + singleCharacter.getLine() + ", Column " + singleCharacter.getColumn() + ": ";
        }
        if (object instanceof Token) {
            Token token = (Token)object;
            return "Line " + token.beginLine + ", Column " + token.beginColumn + ": ";
        }
        return "";
    }

    public static void parse_error(Object object, String string) {
        PGPrinter.error("Error: " + JavaCCErrors._getLocationInfo(object) + string);
        ++s_parse_error_count;
    }

    public static void parse_error(String string) {
        PGPrinter.error("Error: " + string);
        ++s_parse_error_count;
    }

    public static int getParseErrorCount() {
        return s_parse_error_count;
    }

    public static void semantic_error(Object object, String string) {
        PGPrinter.error("Error: " + JavaCCErrors._getLocationInfo(object) + string);
        ++s_semantic_error_count;
    }

    public static void semantic_error(String string) {
        PGPrinter.error("Error: " + string);
        ++s_semantic_error_count;
    }

    public static void semantic_error(String string, Throwable throwable) {
        PGPrinter.error("Error: " + string, throwable);
        ++s_semantic_error_count;
    }

    public static int getSemanticErrorCount() {
        return s_semantic_error_count;
    }

    public static void warning(Object object, String string) {
        PGPrinter.warn("Warning: " + JavaCCErrors._getLocationInfo(object) + string);
        ++s_warning_count;
    }

    public static void warning(String string) {
        PGPrinter.warn("Warning: " + string);
        ++s_warning_count;
    }

    public static int getWarningCount() {
        return s_warning_count;
    }

    public static int getErrorCount() {
        return s_parse_error_count + s_semantic_error_count;
    }

    public static void fatal(String string) throws IllegalStateException {
        PGPrinter.error("Fatal Error: " + string);
        throw new IllegalStateException("Fatal Error: " + string);
    }

    public static void internalError() throws IllegalStateException {
        JavaCCErrors.fatal("Internal error in JavaCC: Please file an issue at https://github.com/phax/ParserGeneratorCC/issues . Thank you.");
    }

    public static void note(String string) {
        PGPrinter.info("Note: " + string);
    }

    public static void reInit() {
        s_parse_error_count = 0;
        s_semantic_error_count = 0;
        s_warning_count = 0;
    }
}

