/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.string.StringHelper;
import com.helger.pgcc.PGPrinter;
import com.helger.pgcc.PGVersion;
import com.helger.pgcc.output.UnsupportedOutputLanguageException;
import com.helger.pgcc.parser.AbstractExpRegularExpression;
import com.helger.pgcc.parser.ExpAction;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.NormalProduction;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.parser.TokenProduction;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public final class JavaCCGlobals {
    public static String s_fileName;
    public static String s_origFileName;
    public static boolean s_jjtreeGenerated;
    public static List<String> s_toolNames;
    public static String s_cu_name;
    public static final ICommonsList<Token> s_cu_to_insertion_point_1;
    public static final ICommonsList<Token> s_cu_to_insertion_point_2;
    public static final ICommonsList<Token> s_cu_from_insertion_point_2;
    public static final List<NormalProduction> s_bnfproductions;
    public static final Map<String, NormalProduction> s_production_table;
    public static final Map<String, Integer> s_lexstate_S2I;
    public static final Map<Integer, String> s_lexstate_I2S;
    public static ICommonsList<Token> s_token_mgr_decls;
    public static final List<TokenProduction> s_rexprlist;
    public static int s_tokenCount;
    public static final Map<String, AbstractExpRegularExpression> s_named_tokens_table;
    public static final List<AbstractExpRegularExpression> s_ordered_named_tokens;
    public static final Map<Integer, String> s_names_of_tokens;
    public static final Map<Integer, AbstractExpRegularExpression> s_rexps_of_tokens;
    public static final Map<String, Map<String, Map<String, AbstractExpRegularExpression>>> s_simple_tokens_table;
    protected static int s_maskindex;
    protected static int s_jj2index;
    private static boolean s_bLookAheadNeeded;
    protected static final List<int[]> s_maskVals;
    static ExpAction s_actForEof;
    static String s_nextStateForEof;
    static Token s_otherLanguageDeclTokenBeg;
    static Token s_otherLanguageDeclTokenEnd;
    public static int s_cline;
    public static int s_ccol;

    public static void bannerLine(String string, String string2) {
        PGPrinter.info("ParserGeneratorCC Version " + PGVersion.VERSION_NUMBER + " (" + string + (StringHelper.hasText((String)string2) ? " Version " + string2 : "") + ")");
    }

    public static boolean isLookAheadNeeded() {
        return s_bLookAheadNeeded;
    }

    public static void setLookAheadNeeded(boolean bl) {
        s_bLookAheadNeeded = bl;
    }

    public static String getIdString(String string, String string2) {
        return JavaCCGlobals.getIdString((List<String>)new CommonsArrayList((Object)string), string2);
    }

    public static String getIdString(List<String> list, String string) {
        String string2 = "Generated by: " + StringHelper.getImploded((char)'&', list) + ":";
        if (string2.length() > 200) {
            PGPrinter.error("Tool names too long.");
            throw new IllegalStateException("Tool names too long: " + string2);
        }
        return string2 + " Do not edit this line. " + JavaCCGlobals.addUnicodeEscapes(string);
    }

    public static boolean isGeneratedBy(String string, String string2) {
        List<String> list = JavaCCGlobals.getToolNames(string2);
        for (String string3 : list) {
            if (!string.equals(string3)) continue;
            return true;
        }
        return false;
    }

    private static List<String> _makeToolNameList(String string) {
        int n;
        String string2;
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = string.indexOf(10);
        if (n3 == -1) {
            n3 = 1000;
        }
        if ((n2 = string.indexOf(13)) == -1) {
            n2 = 1000;
        }
        if ((string2 = (n = n3 < n2 ? n3 : n2) == 1000 ? string : string.substring(0, n)).indexOf(58) == -1) {
            return arrayList;
        }
        if ((string2 = string2.substring(string2.indexOf(58) + 1)).indexOf(58) == -1) {
            return arrayList;
        }
        string2 = string2.substring(0, string2.indexOf(58));
        int n4 = 0;
        int n5 = 0;
        while (n5 < string2.length() && (n4 = string2.indexOf(38, n5)) != -1) {
            arrayList.add(string2.substring(n5, n4));
            n5 = n4 + 1;
        }
        if (n5 < string2.length()) {
            arrayList.add(string2.substring(n5));
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static List<String> getToolNames(String string) {
        Charset charset = Options.getOutputEncoding();
        char[] cArray = new char[256];
        int n = 0;
        try (NonBlockingBufferedReader nonBlockingBufferedReader = FileHelper.getBufferedReader((File)new File(string), (Charset)charset);){
            int n2;
            while ((n2 = nonBlockingBufferedReader.read(cArray, n, cArray.length - n)) != -1 && (n += n2) != cArray.length) {
            }
            List<String> list = JavaCCGlobals._makeToolNameList(new String(cArray, 0, n));
            return list;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new ArrayList<String>();
        }
        catch (IOException iOException) {
            if (n <= 0) return new ArrayList<String>();
            return JavaCCGlobals._makeToolNameList(new String(cArray, 0, n));
        }
    }

    public static void createOutputDir(File file) {
        if (!file.exists()) {
            JavaCCErrors.warning("Output directory \"" + file + "\" does not exist. Creating the directory.");
            if (!file.mkdirs()) {
                JavaCCErrors.semantic_error("Cannot create the output directory : " + file);
                return;
            }
        }
        if (!file.isDirectory()) {
            JavaCCErrors.semantic_error("\"" + file + " is not a valid output directory.");
            return;
        }
        if (!file.canWrite()) {
            JavaCCErrors.semantic_error("Cannot write to the output output directory : \"" + file + "\"");
            return;
        }
    }

    @Nonnull
    public static String addEscapes(@Nonnull String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (char c : string.toCharArray()) {
            if (c == '\b') {
                stringBuilder.append("\\b");
                continue;
            }
            if (c == '\t') {
                stringBuilder.append("\\t");
                continue;
            }
            if (c == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (c == '\f') {
                stringBuilder.append("\\f");
                continue;
            }
            if (c == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            if (c == '\'') {
                stringBuilder.append("\\'");
                continue;
            }
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c < ' ' || c > '~') {
                String string2 = "0000" + Integer.toString(c, 16);
                stringBuilder.append("\\u").append(string2.substring(string2.length() - 4, string2.length()));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String addUnicodeEscapes(String string) {
        switch (Options.getOutputLanguage()) {
            case JAVA: {
                StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
                for (char c : string.toCharArray()) {
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuilder.append("\\u").append(string2.substring(string2.length() - 4, string2.length()));
                        continue;
                    }
                    stringBuilder.append(c);
                }
                return stringBuilder.toString();
            }
            case CPP: {
                return string;
            }
        }
        throw new UnsupportedOutputLanguageException(Options.getOutputLanguage());
    }

    public static void printTokenSetup(Token token) {
        Token token2 = token;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        s_cline = token2.beginLine;
        s_ccol = token2.beginColumn;
    }

    protected static void printTokenOnly(Token token, PrintWriter printWriter) {
        while (s_cline < token.beginLine) {
            printWriter.println();
            s_ccol = 1;
            ++s_cline;
        }
        while (s_ccol < token.beginColumn) {
            printWriter.print(" ");
            ++s_ccol;
        }
        if (token.kind == 101 || token.kind == 100) {
            printWriter.print(JavaCCGlobals.addUnicodeEscapes(token.image));
        } else {
            printWriter.print(token.image);
        }
        s_cline = token.endLine;
        s_ccol = token.endColumn + 1;
        char c = token.image.charAt(token.image.length() - 1);
        if (c == '\n' || c == '\r') {
            ++s_cline;
            s_ccol = 1;
        }
    }

    public static void printToken(Token token, PrintWriter printWriter) {
        Token token2 = token.specialToken;
        if (token2 != null) {
            while (token2.specialToken != null) {
                token2 = token2.specialToken;
            }
            while (token2 != null) {
                JavaCCGlobals.printTokenOnly(token2, printWriter);
                token2 = token2.next;
            }
        }
        JavaCCGlobals.printTokenOnly(token, printWriter);
    }

    protected static void printTokenList(List<Token> list, PrintWriter printWriter) {
        Token token2 = null;
        for (Token token2 : list) {
            JavaCCGlobals.printToken(token2, printWriter);
        }
        if (token2 != null) {
            JavaCCGlobals.printTrailingComments(token2);
        }
    }

    protected static void printLeadingComments(Token token, PrintWriter printWriter) {
        if (token.specialToken == null) {
            return;
        }
        Token token2 = token.specialToken;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        while (token2 != null) {
            JavaCCGlobals.printTokenOnly(token2, printWriter);
            token2 = token2.next;
        }
        if (s_ccol != 1 && s_cline != token.beginLine) {
            printWriter.println();
            ++s_cline;
            s_ccol = 1;
        }
    }

    @Nonnull
    public static String printTokenOnly(@Nonnull Token token) {
        StringBuilder stringBuilder = new StringBuilder(token.image.length() * 2);
        while (s_cline < token.beginLine) {
            stringBuilder.append('\n');
            s_ccol = 1;
            ++s_cline;
        }
        while (s_ccol < token.beginColumn) {
            stringBuilder.append(' ');
            ++s_ccol;
        }
        if (token.kind == 101 || token.kind == 100) {
            stringBuilder.append(JavaCCGlobals.addUnicodeEscapes(token.image));
        } else {
            stringBuilder.append(token.image);
        }
        s_cline = token.endLine;
        s_ccol = token.endColumn + 1;
        char c = token.image.charAt(token.image.length() - 1);
        if (c == '\n' || c == '\r') {
            ++s_cline;
            s_ccol = 1;
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String printToken(@Nonnull Token token) {
        StringBuilder stringBuilder = new StringBuilder();
        Token token2 = token.specialToken;
        if (token2 != null) {
            while (token2.specialToken != null) {
                token2 = token2.specialToken;
            }
            while (token2 != null) {
                stringBuilder.append(JavaCCGlobals.printTokenOnly(token2));
                token2 = token2.next;
            }
        }
        stringBuilder.append(JavaCCGlobals.printTokenOnly(token));
        return stringBuilder.toString();
    }

    @Nonnull
    protected static String printLeadingComments(@Nonnull Token token) {
        if (token.specialToken == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Token token2 = token.specialToken;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        while (token2 != null) {
            stringBuilder.append(JavaCCGlobals.printTokenOnly(token2));
            token2 = token2.next;
        }
        if (s_ccol != 1 && s_cline != token.beginLine) {
            stringBuilder.append('\n');
            ++s_cline;
            s_ccol = 1;
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String printTrailingComments(@Nonnull Token token) {
        if (token.next == null) {
            return "";
        }
        return JavaCCGlobals.printLeadingComments(token.next);
    }

    public static void reInitStatic() {
        s_fileName = null;
        s_origFileName = null;
        s_jjtreeGenerated = false;
        s_toolNames = null;
        s_cu_name = null;
        s_cu_to_insertion_point_1.clear();
        s_cu_to_insertion_point_2.clear();
        s_cu_from_insertion_point_2.clear();
        s_bnfproductions.clear();
        s_production_table.clear();
        s_lexstate_S2I.clear();
        s_lexstate_I2S.clear();
        s_token_mgr_decls = null;
        s_rexprlist.clear();
        s_tokenCount = 0;
        s_named_tokens_table.clear();
        s_ordered_named_tokens.clear();
        s_names_of_tokens.clear();
        s_rexps_of_tokens.clear();
        s_simple_tokens_table.clear();
        s_maskindex = 0;
        s_jj2index = 0;
        s_bLookAheadNeeded = false;
        s_maskVals.clear();
        s_cline = 0;
        s_ccol = 0;
        s_actForEof = null;
        s_nextStateForEof = null;
    }

    static String getFileExtension() {
        switch (Options.getOutputLanguage()) {
            case JAVA: {
                return ".java";
            }
            case CPP: {
                return ".cc";
            }
        }
        throw new UnsupportedOutputLanguageException(Options.getOutputLanguage());
    }

    public static String replaceBackslash(String string) {
        if (string.indexOf(92) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (char c : string.toCharArray()) {
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static {
        s_cu_to_insertion_point_1 = new CommonsArrayList();
        s_cu_to_insertion_point_2 = new CommonsArrayList();
        s_cu_from_insertion_point_2 = new CommonsArrayList();
        s_bnfproductions = new ArrayList<NormalProduction>();
        s_production_table = new HashMap<String, NormalProduction>();
        s_lexstate_S2I = new HashMap<String, Integer>();
        s_lexstate_I2S = new HashMap<Integer, String>();
        s_rexprlist = new ArrayList<TokenProduction>();
        s_named_tokens_table = new HashMap<String, AbstractExpRegularExpression>();
        s_ordered_named_tokens = new ArrayList<AbstractExpRegularExpression>();
        s_names_of_tokens = new HashMap<Integer, String>();
        s_rexps_of_tokens = new HashMap<Integer, AbstractExpRegularExpression>();
        s_simple_tokens_table = new HashMap<String, Map<String, Map<String, AbstractExpRegularExpression>>>();
        s_maskindex = 0;
        s_jj2index = 0;
        s_bLookAheadNeeded = false;
        s_maskVals = new ArrayList<int[]>();
    }
}

