/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.pgcc.parser.AbstractCharStream;
import com.helger.pgcc.parser.Provider;
import java.io.IOException;

public class JavaCharStream
extends AbstractCharStream {
    protected static final int NEXTCHAR_BUF_SIZE = 4096;
    protected char[] nextCharBuf = new char[4096];
    protected int nextCharInd = -1;
    protected Provider inputStream;

    @Override
    protected int streamRead(char[] cArray, int n, int n2) throws IOException {
        return this.inputStream.read(cArray, n, n2);
    }

    @Override
    protected void streamClose() throws IOException {
        this.inputStream.close();
    }

    @Override
    protected void fillBuff() throws IOException {
        if (this.maxNextCharInd == 4096) {
            this.nextCharInd = 0;
            this.maxNextCharInd = 0;
        }
        try {
            int n = this.inputStream.read(this.nextCharBuf, this.maxNextCharInd, 4096 - this.maxNextCharInd);
            if (n == -1) {
                this.inputStream.close();
                throw new IOException();
            }
            this.maxNextCharInd += n;
        }
        catch (IOException iOException) {
            if (this.bufpos != 0) {
                --this.bufpos;
                this.backup(0);
            } else {
                this.bufline[this.bufpos] = this.line;
                this.bufcolumn[this.bufpos] = this.column;
            }
            throw iOException;
        }
    }

    protected char readByte() throws IOException {
        ++this.nextCharInd;
        if (this.nextCharInd >= this.maxNextCharInd) {
            this.fillBuff();
        }
        return this.nextCharBuf[this.nextCharInd];
    }

    @Override
    public char beginToken() throws IOException {
        if (this.inBuf > 0) {
            --this.inBuf;
            if (++this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            this.tokenBegin = this.bufpos;
            return this.buffer[this.bufpos];
        }
        this.tokenBegin = 0;
        this.bufpos = -1;
        return this.readChar();
    }

    protected void adjustBuffSize() {
        if (this.available == this.bufsize) {
            if (this.tokenBegin > 2048) {
                this.bufpos = 0;
                this.available = this.tokenBegin;
            } else {
                this.expandBuff(false);
            }
        } else if (this.available > this.tokenBegin) {
            this.available = this.bufsize;
        } else if (this.tokenBegin - this.available < 2048) {
            this.expandBuff(true);
        } else {
            this.available = this.tokenBegin;
        }
    }

    @Override
    public char readChar() throws IOException {
        char c;
        if (this.inBuf > 0) {
            --this.inBuf;
            if (++this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            return this.buffer[this.bufpos];
        }
        ++this.bufpos;
        if (this.bufpos == this.available) {
            this.adjustBuffSize();
        }
        this.buffer[this.bufpos] = c = this.readByte();
        if (c == '\\') {
            if (this.isTrackLineColumn()) {
                this.updateLineColumn(c);
            }
            int n = 1;
            while (true) {
                ++this.bufpos;
                if (this.bufpos == this.available) {
                    this.adjustBuffSize();
                }
                try {
                    this.buffer[this.bufpos] = c = this.readByte();
                    if (c != '\\') {
                        if (this.isTrackLineColumn()) {
                            this.updateLineColumn(c);
                        }
                        if (c == 'u' && (n & 1) == 1) {
                            if (--this.bufpos >= 0) break;
                            this.bufpos = this.bufsize - 1;
                            break;
                        }
                        this.backup(n);
                        return '\\';
                    }
                }
                catch (IOException iOException) {
                    if (n > 1) {
                        this.backup(n - 1);
                    }
                    return '\\';
                }
                if (this.isTrackLineColumn()) {
                    this.updateLineColumn(c);
                }
                ++n;
            }
            try {
                while ((c = this.readByte()) == 'u') {
                    ++this.column;
                }
                this.buffer[this.bufpos] = c = (char)(JavaCharStream.hexval(c) << 12 | JavaCharStream.hexval(this.readByte()) << 8 | JavaCharStream.hexval(this.readByte()) << 4 | JavaCharStream.hexval(this.readByte()));
                this.column += 4;
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Invalid escape character at line " + this.line + " column " + this.column + ".");
            }
            if (n == 1) {
                return c;
            }
            this.backup(n - 1);
            return '\\';
        }
        if (this.isTrackLineColumn()) {
            this.updateLineColumn(c);
        }
        return c;
    }

    public JavaCharStream(Provider provider, int n, int n2, int n3) {
        super(n, n2, n3);
        this.inputStream = provider;
    }

    public JavaCharStream(Provider provider, int n, int n2) {
        this(provider, n, n2, 4096);
    }

    public JavaCharStream(Provider provider) {
        this(provider, 1, 1, 4096);
    }

    public void reInit(Provider provider) {
        this.reInit(provider, 1, 1, 4096);
    }

    public void reInit(Provider provider, int n, int n2) {
        this.reInit(provider, n, n2, 4096);
    }

    public void reInit(Provider provider, int n, int n2, int n3) {
        this.nextCharBuf = new char[4096];
        this.nextCharInd = -1;
        this.inputStream = provider;
        super.reInit(n, n2, n3);
    }

    @Override
    public void done() {
        this.nextCharBuf = null;
        super.done();
    }
}

