/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.pgcc.EJDKVersion;
import com.helger.pgcc.output.EOutputLanguage;
import com.helger.pgcc.parser.CodeGenerator;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.MetaParseException;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.ParseEngine;
import com.helger.pgcc.parser.Token;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class ParseGenJava
extends CodeGenerator {
    public void start(boolean bl) throws MetaParseException {
        Object object;
        Object object2;
        if (JavaCCErrors.getErrorCount() != 0) {
            throw new MetaParseException("Error count is already present!");
        }
        if (!Options.isBuildParser()) {
            return;
        }
        EOutputLanguage eOutputLanguage = this.getOutputLanguage();
        EJDKVersion eJDKVersion = Options.getJdkVersion();
        boolean bl2 = eJDKVersion.isNewerOrEqualsThan(EJDKVersion.JDK_1_6);
        boolean bl3 = eJDKVersion.isNewerOrEqualsThan(EJDKVersion.JDK_1_7);
        ArrayList<String> arrayList = new ArrayList<String>(JavaCCGlobals.s_toolNames);
        arrayList.add("ParserGeneratorCC");
        this.genCodeLine("/* " + JavaCCGlobals.getIdString(arrayList, JavaCCGlobals.s_cu_name + ".java") + " */");
        boolean bl4 = false;
        if (JavaCCGlobals.s_cu_to_insertion_point_1.size() != 0) {
            Token token = (Token)JavaCCGlobals.s_cu_to_insertion_point_1.get(0);
            this.printTokenSetup(token);
            this.setColToStart();
            object2 = JavaCCGlobals.s_cu_to_insertion_point_1.iterator();
            while (object2.hasNext()) {
                object = (Token)object2.next();
                Token token2 = object;
                if (token2.kind == 58) {
                    bl4 = true;
                } else if (token2.kind == 42) {
                    bl4 = false;
                }
                this.printToken(token2);
            }
        }
        if (bl4) {
            this.genCode(", ");
        } else {
            this.genCode(" implements ");
        }
        this.genCode(JavaCCGlobals.s_cu_name + "Constants ");
        if (JavaCCGlobals.s_cu_to_insertion_point_2.isNotEmpty()) {
            this.printTokenSetup((Token)JavaCCGlobals.s_cu_to_insertion_point_2.get(0));
            for (Token token2 : JavaCCGlobals.s_cu_to_insertion_point_2) {
                this.printToken(token2);
            }
        }
        this.genCodeNewLine();
        this.genCodeNewLine();
        new ParseEngine().build(this);
        if (Options.isUserTokenManager()) {
            this.genCodeLine("  /** User defined Token Manager. */");
            this.genCodeLine("  public TokenManager token_source;");
        } else {
            this.genCodeLine("  /** Generated Token Manager. */");
            this.genCodeLine("  public " + JavaCCGlobals.s_cu_name + "TokenManager token_source;");
            if (!Options.isJavaUserCharStream()) {
                if (Options.isJavaUnicodeEscape()) {
                    this.genCodeLine("  JavaCharStream jj_input_stream;");
                } else {
                    this.genCodeLine("  SimpleCharStream jj_input_stream;");
                }
            }
        }
        this.genCodeLine("  /** Current token. */");
        this.genCodeLine("  public Token token;");
        this.genCodeLine("  /** Next token. */");
        this.genCodeLine("  public Token jj_nt;");
        if (!Options.isCacheTokens()) {
            this.genCodeLine("  private int jj_ntk;");
        }
        if (Options.hasDepthLimit()) {
            this.genCodeLine("  /** current depth */");
            this.genCodeLine("  private int jj_depth;");
        }
        if (JavaCCGlobals.s_jj2index != 0) {
            this.genCodeLine("  private Token jj_scanpos, jj_lastpos;");
            this.genCodeLine("  private int jj_la;");
            if (JavaCCGlobals.isLookAheadNeeded()) {
                this.genCodeLine("  /** Whether we are looking ahead. */");
                this.genCodeLine("  private " + eOutputLanguage.getTypeBoolean() + " jj_lookingAhead = false;");
                this.genCodeLine("  private " + eOutputLanguage.getTypeBoolean() + " jj_semLA;");
            }
        }
        if (Options.isErrorReporting()) {
            int n;
            this.genCodeLine("  private int jj_gen;");
            this.genCodeLine("  final private int[] jj_la1 = new int[" + JavaCCGlobals.s_maskindex + "];");
            int n2 = (JavaCCGlobals.s_tokenCount - 1) / 32 + 1;
            for (n = 0; n < n2; ++n) {
                this.genCodeLine("  static private int[] jj_la1_" + n + ";");
            }
            this.genCodeLine("  static {");
            for (n = 0; n < n2; ++n) {
                this.genCodeLine("\t   jj_la1_init_" + n + "();");
            }
            this.genCodeLine("\t}");
            for (n = 0; n < n2; ++n) {
                this.genCodeLine("\tprivate static void jj_la1_init_" + n + "() {");
                this.genCode("\t   jj_la1_" + n + " = new int[] {");
                object2 = JavaCCGlobals.s_maskVals.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    this.genCode("0x" + Integer.toHexString((int)object[n]) + ",");
                }
                this.genCodeLine("};");
                this.genCodeLine("\t}");
            }
        }
        if (JavaCCGlobals.s_jj2index != 0 && Options.isErrorReporting()) {
            this.genCodeLine("  private final JJCalls[] jj_2_rtns = new JJCalls[" + JavaCCGlobals.s_jj2index + "];");
            this.genCodeLine("  private " + eOutputLanguage.getTypeBoolean() + " jj_rescan = false;");
            this.genCodeLine("  private int jj_gc = 0;");
        }
        this.genCodeNewLine();
        if (!Options.isUserTokenManager()) {
            if (Options.isJavaUserCharStream()) {
                this.genCodeLine("  /**");
                this.genCodeLine("   * Constructor with user supplied CharStream.");
                this.genCodeLine("   * @param stream stream to init with");
                this.genCodeLine("   */");
                this.genCodeLine("  public " + JavaCCGlobals.s_cu_name + "(final CharStream stream) {");
                if (Options.isTokenManagerUsesParser()) {
                    this.genCodeLine("\t token_source = new " + JavaCCGlobals.s_cu_name + "TokenManager(this, stream);");
                } else {
                    this.genCodeLine("\t token_source = new " + JavaCCGlobals.s_cu_name + "TokenManager(stream);");
                }
                this.genCodeLine("\t token = new Token();");
                if (Options.isCacheTokens()) {
                    this.genCodeLine("   jj_nt = token_source.getNextToken();");
                    this.genCodeLine("   token.next = jj_nt;");
                } else {
                    this.genCodeLine("\t jj_ntk = -1;");
                }
                if (Options.hasDepthLimit()) {
                    this.genCodeLine("    jj_depth = -1;");
                }
                if (Options.isErrorReporting()) {
                    this.genCodeLine("\t jj_gen = 0;");
                    if (JavaCCGlobals.s_maskindex > 0) {
                        this.genCodeLine("\t for (int i = 0; i < " + JavaCCGlobals.s_maskindex + "; i++) jj_la1[i] = -1;");
                    }
                    if (JavaCCGlobals.s_jj2index != 0) {
                        this.genCodeLine("\t for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();");
                    }
                }
                this.genCodeLine("  }");
                this.genCodeNewLine();
                this.genCodeLine("  /**");
                this.genCodeLine("   * Reinitialise.");
                this.genCodeLine("   * @param stream stream to init with");
                this.genCodeLine("   */");
                this.genCodeLine("  public void ReInit(final CharStream stream) {");
                if (Options.isTokenManagerRequiresParserAccess()) {
                    this.genCodeLine("\t token_source.ReInit(this,stream);");
                } else {
                    this.genCodeLine("\t token_source.ReInit(stream);");
                }
                this.genCodeLine("\t token = new Token();");
                if (Options.isCacheTokens()) {
                    this.genCodeLine("   jj_nt = token_source.getNextToken();");
                    this.genCodeLine("   token.next = jj_nt;");
                } else {
                    this.genCodeLine("\t jj_ntk = -1;");
                }
                if (Options.hasDepthLimit()) {
                    this.genCodeLine("    jj_depth = -1;");
                }
                if (JavaCCGlobals.isLookAheadNeeded()) {
                    this.genCodeLine("\t jj_lookingAhead = false;");
                }
                if (JavaCCGlobals.s_jjtreeGenerated) {
                    this.genCodeLine("\t jjtree.reset();");
                }
                if (Options.isErrorReporting()) {
                    this.genCodeLine("\t jj_gen = 0;");
                    if (JavaCCGlobals.s_maskindex > 0) {
                        this.genCodeLine("   for (int i = 0; i < " + JavaCCGlobals.s_maskindex + "; i++)");
                        this.genCodeLine("     jj_la1[i] = -1;");
                    }
                    if (JavaCCGlobals.s_jj2index != 0) {
                        this.genCodeLine("   for (int i = 0; i < jj_2_rtns.length; i++)");
                        this.genCodeLine("     jj_2_rtns[i] = new JJCalls();");
                    }
                }
                this.genCodeLine("  }");
            } else {
                if (!bl) {
                    this.genCodeLine("  /**");
                    this.genCodeLine("   * Constructor with InputStream.");
                    this.genCodeLine("   * @param stream input stream");
                    this.genCodeLine("   */");
                    this.genCodeLine("  public " + JavaCCGlobals.s_cu_name + "(final java.io.InputStream stream) {");
                    this.genCodeLine("\t  this(stream, null);");
                    this.genCodeLine("  }");
                    this.genCodeNewLine();
                    this.genCodeLine("  /**");
                    this.genCodeLine("   * Constructor with InputStream and supplied encoding");
                    this.genCodeLine("   * @param stream input stream");
                    this.genCodeLine("   * @param encoding charset to be used");
                    this.genCodeLine("   */");
                    if (bl2) {
                        this.genCodeLine("  public " + JavaCCGlobals.s_cu_name + "(final java.io.InputStream stream, final java.nio.charset.Charset encoding) {");
                        this.genCodeLine("   jj_input_stream = new " + (Options.isJavaUnicodeEscape() ? "JavaCharStream" : "SimpleCharStream") + "(stream, encoding, 1, 1);");
                    } else {
                        this.genCodeLine("  public " + JavaCCGlobals.s_cu_name + "(final java.io.InputStream stream, final String encoding) {");
                        this.genCodeLine("   try {");
                        this.genCodeLine("     jj_input_stream = new " + (Options.isJavaUnicodeEscape() ? "JavaCharStream" : "SimpleCharStream") + "(stream, encoding, 1, 1);");
                        this.genCodeLine("   } catch(final java.io.UnsupportedEncodingException e) {");
                        this.genCodeLine("     throw new IllegalStateException(e);");
                        this.genCodeLine("   }");
                    }
                    if (Options.isTokenManagerUsesParser()) {
                        this.genCodeLine("\t token_source = new " + JavaCCGlobals.s_cu_name + "TokenManager(this, jj_input_stream);");
                    } else {
                        this.genCodeLine("\t token_source = new " + JavaCCGlobals.s_cu_name + "TokenManager(jj_input_stream);");
                    }
                    this.genCodeLine("\t token = new Token();");
                    if (Options.isCacheTokens()) {
                        this.genCodeLine("   jj_nt = token_source.getNextToken();");
                        this.genCodeLine("   token.next = jj_nt;");
                    } else {
                        this.genCodeLine("\t jj_ntk = -1;");
                    }
                    if (Options.hasDepthLimit()) {
                        this.genCodeLine("    jj_depth = -1;");
                    }
                    if (Options.isErrorReporting()) {
                        this.genCodeLine("\t jj_gen = 0;");
                        if (JavaCCGlobals.s_maskindex > 0) {
                            this.genCodeLine("\t for (int i = 0; i < " + JavaCCGlobals.s_maskindex + "; i++) jj_la1[i] = -1;");
                        }
                        if (JavaCCGlobals.s_jj2index != 0) {
                            this.genCodeLine("\t for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();");
                        }
                    }
                    this.genCodeLine("  }");
                    this.genCodeNewLine();
                    this.genCodeLine("  /**");
                    this.genCodeLine("   * Reinitialise");
                    this.genCodeLine("   * @param stream input stream");
                    this.genCodeLine("   */");
                    this.genCodeLine("  public void ReInit(final java.io.InputStream stream) {");
                    this.genCodeLine("\t  ReInit(stream, null);");
                    this.genCodeLine("  }");
                    this.genCodeLine("  /**");
                    this.genCodeLine("   * Reinitialise");
                    this.genCodeLine("   * @param stream input stream");
                    this.genCodeLine("   * @param encoding charset to be used");
                    this.genCodeLine("   */");
                    if (bl2) {
                        this.genCodeLine("  public void ReInit(final java.io.InputStream stream, final java.nio.charset.Charset encoding) {");
                        this.genCodeLine("    jj_input_stream.reInit(stream, encoding, 1, 1);");
                    } else {
                        this.genCodeLine("  public void ReInit(final java.io.InputStream stream, final String encoding) {");
                        this.genCodeLine("\t  try {");
                        this.genCodeLine("      jj_input_stream.reInit(stream, encoding, 1, 1);");
                        this.genCodeLine("    } catch(final java.io.UnsupportedEncodingException e) { ");
                        this.genCodeLine("      throw new IllegalStateException(e);");
                        this.genCodeLine("    }");
                    }
                    if (Options.isTokenManagerRequiresParserAccess()) {
                        this.genCodeLine("\t token_source.ReInit(this,jj_input_stream);");
                    } else {
                        this.genCodeLine("\t token_source.ReInit(jj_input_stream);");
                    }
                    this.genCodeLine("\t token = new Token();");
                    if (Options.isCacheTokens()) {
                        this.genCodeLine("   jj_nt = token_source.getNextToken();");
                        this.genCodeLine("   token.next = jj_nt;");
                    } else {
                        this.genCodeLine("\t jj_ntk = -1;");
                    }
                    if (Options.hasDepthLimit()) {
                        this.genCodeLine("    jj_depth = -1;");
                    }
                    if (JavaCCGlobals.s_jjtreeGenerated) {
                        this.genCodeLine("\t jjtree.reset();");
                    }
                    if (Options.isErrorReporting()) {
                        this.genCodeLine("\t jj_gen = 0;");
                        this.genCodeLine("\t for (int i = 0; i < " + JavaCCGlobals.s_maskindex + "; i++) jj_la1[i] = -1;");
                        if (JavaCCGlobals.s_jj2index != 0) {
                            this.genCodeLine("\t for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();");
                        }
                    }
                    this.genCodeLine("  }");
                    this.genCodeNewLine();
                }
                String string = bl ? "Provider" : "java.io.Reader";
                String string2 = bl ? "StringProvider" : "java.io.StringReader";
                this.genCodeLine("  /**");
                this.genCodeLine("   * Constructor with InputStream.");
                this.genCodeLine("   * @param stream char stream");
                this.genCodeLine("   */");
                this.genCodeLine("  public " + JavaCCGlobals.s_cu_name + "(final " + string + " stream) {");
                if (Options.isJavaUnicodeEscape()) {
                    this.genCodeLine("\t jj_input_stream = new JavaCharStream(stream, 1, 1);");
                } else {
                    this.genCodeLine("\t jj_input_stream = new SimpleCharStream(stream, 1, 1);");
                }
                if (Options.isTokenManagerUsesParser()) {
                    this.genCodeLine("\t token_source = new " + JavaCCGlobals.s_cu_name + "TokenManager(this, jj_input_stream);");
                } else {
                    this.genCodeLine("\t token_source = new " + JavaCCGlobals.s_cu_name + "TokenManager(jj_input_stream);");
                }
                this.genCodeLine("\t token = new Token();");
                if (Options.isCacheTokens()) {
                    this.genCodeLine("\t token.next = jj_nt = token_source.getNextToken();");
                } else {
                    this.genCodeLine("\t jj_ntk = -1;");
                }
                if (Options.hasDepthLimit()) {
                    this.genCodeLine("    jj_depth = -1;");
                }
                if (Options.isErrorReporting()) {
                    this.genCodeLine("\t jj_gen = 0;");
                    if (JavaCCGlobals.s_maskindex > 0) {
                        this.genCodeLine("   for (int i = 0; i < " + JavaCCGlobals.s_maskindex + "; i++)");
                        this.genCodeLine("     jj_la1[i] = -1;");
                    }
                    if (JavaCCGlobals.s_jj2index != 0) {
                        this.genCodeLine("   for (int i = 0; i < jj_2_rtns.length; i++)");
                        this.genCodeLine("     jj_2_rtns[i] = new JJCalls();");
                    }
                }
                this.genCodeLine("  }");
                this.genCodeNewLine();
                if (bl) {
                    this.genCodeLine("  /**");
                    this.genCodeLine("   * Constructor with InputStream.");
                    this.genCodeLine("   * @param sDSL String representation to be parsed");
                    this.genCodeLine("   */");
                    this.genCodeLine("  public " + JavaCCGlobals.s_cu_name + "(final String sDSL) {");
                    this.genCodeLine("\t   this(new " + string2 + "(sDSL));");
                    this.genCodeLine("  }");
                    this.genCodeNewLine();
                    this.genCodeLine("  /**");
                    this.genCodeLine("   * Reinitialise.");
                    this.genCodeLine("   * @param sDSL String representation to be parsed");
                    this.genCodeLine("   */");
                    this.genCodeLine("  public void ReInit(final String sDSL) {");
                    this.genCodeLine("\t  ReInit(new " + string2 + "(sDSL));");
                    this.genCodeLine("  }");
                }
                this.genCodeLine("  /**");
                this.genCodeLine("   * Reinitialise");
                this.genCodeLine("   * @param stream char stream");
                this.genCodeLine("   */");
                this.genCodeLine("  public void ReInit(final " + string + " stream) {");
                if (Options.isJavaUnicodeEscape()) {
                    this.genCodeLine("\tif (jj_input_stream == null) {");
                    this.genCodeLine("\t  jj_input_stream = new JavaCharStream(stream, 1, 1);");
                    this.genCodeLine("\t} else {");
                    this.genCodeLine("\t  jj_input_stream.reInit(stream, 1, 1);");
                    this.genCodeLine("  }");
                } else {
                    this.genCodeLine("\tif (jj_input_stream == null) {");
                    this.genCodeLine("\t  jj_input_stream = new SimpleCharStream(stream, 1, 1);");
                    this.genCodeLine("\t} else {");
                    this.genCodeLine("\t  jj_input_stream.reInit(stream, 1, 1);");
                    this.genCodeLine("  }");
                }
                this.genCodeLine("\tif (token_source == null) {");
                if (Options.isTokenManagerUsesParser()) {
                    this.genCodeLine(" token_source = new " + JavaCCGlobals.s_cu_name + "TokenManager(this, jj_input_stream);");
                } else {
                    this.genCodeLine(" token_source = new " + JavaCCGlobals.s_cu_name + "TokenManager(jj_input_stream);");
                }
                this.genCodeLine("\t}");
                this.genCodeNewLine();
                if (Options.isTokenManagerRequiresParserAccess()) {
                    this.genCodeLine("\t token_source.ReInit(this,jj_input_stream);");
                } else {
                    this.genCodeLine("\t token_source.ReInit(jj_input_stream);");
                }
                this.genCodeLine("\t token = new Token();");
                if (Options.isCacheTokens()) {
                    this.genCodeLine("\t token.next = jj_nt = token_source.getNextToken();");
                } else {
                    this.genCodeLine("\t jj_ntk = -1;");
                }
                if (Options.hasDepthLimit()) {
                    this.genCodeLine("    jj_depth = -1;");
                }
                if (JavaCCGlobals.s_jjtreeGenerated) {
                    this.genCodeLine("\t jjtree.reset();");
                }
                if (Options.isErrorReporting()) {
                    this.genCodeLine("\t jj_gen = 0;");
                    if (JavaCCGlobals.s_maskindex > 0) {
                        this.genCodeLine("   for (int i = 0; i < " + JavaCCGlobals.s_maskindex + "; i++)");
                        this.genCodeLine("     jj_la1[i] = -1;");
                    }
                    if (JavaCCGlobals.s_jj2index != 0) {
                        this.genCodeLine("   for (int i = 0; i < jj_2_rtns.length; i++)");
                        this.genCodeLine("     jj_2_rtns[i] = new JJCalls();");
                    }
                }
                this.genCodeLine("  }");
            }
        }
        this.genCodeNewLine();
        if (Options.isUserTokenManager()) {
            this.genCodeLine("  /**");
            this.genCodeLine("   * Constructor with user supplied Token Manager.");
            this.genCodeLine("   * @param tm Token manager to use");
            this.genCodeLine("   */");
            this.genCodeLine("  public " + JavaCCGlobals.s_cu_name + "(final TokenManager tm) {");
        } else {
            this.genCodeLine("  /**");
            this.genCodeLine("   * Constructor with generated Token Manager.");
            this.genCodeLine("   * @param tm Token manager to use");
            this.genCodeLine("   */");
            this.genCodeLine("  public " + JavaCCGlobals.s_cu_name + "(final " + JavaCCGlobals.s_cu_name + "TokenManager tm) {");
        }
        this.genCodeLine("\t token_source = tm;");
        this.genCodeLine("\t token = new Token();");
        if (Options.isCacheTokens()) {
            this.genCodeLine("\t token.next = jj_nt = token_source.getNextToken();");
        } else {
            this.genCodeLine("\t jj_ntk = -1;");
        }
        if (Options.hasDepthLimit()) {
            this.genCodeLine("    jj_depth = -1;");
        }
        if (Options.isErrorReporting()) {
            this.genCodeLine("\t jj_gen = 0;");
            if (JavaCCGlobals.s_maskindex > 0) {
                this.genCodeLine("\t for (int i = 0; i < " + JavaCCGlobals.s_maskindex + "; i++) jj_la1[i] = -1;");
            }
            if (JavaCCGlobals.s_jj2index != 0) {
                this.genCodeLine("\t for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();");
            }
        }
        this.genCodeLine("  }");
        this.genCodeNewLine();
        if (Options.isUserTokenManager()) {
            this.genCodeLine("  /**");
            this.genCodeLine("   * Reinitialise");
            this.genCodeLine("   * @param tm Token manager to use");
            this.genCodeLine("   */");
            this.genCodeLine("  public void ReInit(final TokenManager tm) {");
        } else {
            this.genCodeLine("  /**");
            this.genCodeLine("   * Reinitialise");
            this.genCodeLine("   * @param tm Token manager to use");
            this.genCodeLine("   */");
            this.genCodeLine("  public void ReInit(final " + JavaCCGlobals.s_cu_name + "TokenManager tm) {");
        }
        this.genCodeLine("\t token_source = tm;");
        this.genCodeLine("\t token = new Token();");
        if (Options.isCacheTokens()) {
            this.genCodeLine("\t token.next = jj_nt = token_source.getNextToken();");
        } else {
            this.genCodeLine("\t jj_ntk = -1;");
        }
        if (Options.hasDepthLimit()) {
            this.genCodeLine("    jj_depth = -1;");
        }
        if (JavaCCGlobals.s_jjtreeGenerated) {
            this.genCodeLine("\t jjtree.reset();");
        }
        if (Options.isErrorReporting()) {
            this.genCodeLine("\t jj_gen = 0;");
            if (JavaCCGlobals.s_maskindex > 0) {
                this.genCodeLine("\t for (int i = 0; i < " + JavaCCGlobals.s_maskindex + "; i++) jj_la1[i] = -1;");
            }
            if (JavaCCGlobals.s_jj2index != 0) {
                this.genCodeLine("\t for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();");
            }
        }
        this.genCodeLine("  }");
        this.genCodeNewLine();
        this.genCodeLine("  private Token jj_consume_token(final int kind) throws ParseException {");
        this.genCodeLine("    final Token oldToken = token;");
        if (Options.isCacheTokens()) {
            this.genCodeLine("    token = jj_nt;");
            this.genCodeLine("    if (token.next != null)");
            this.genCodeLine("      jj_nt = jj_nt.next;");
            this.genCodeLine("    else {");
            this.genCodeLine("      jj_nt.next = token_source.getNextToken();");
            this.genCodeLine("      jj_nt = jj_nt.next;");
            this.genCodeLine("    }");
        } else {
            this.genCodeLine("    if (token.next != null)");
            this.genCodeLine("      token = token.next;");
            this.genCodeLine("    else {");
            this.genCodeLine("      token.next = token_source.getNextToken();");
            this.genCodeLine("      token = token.next;");
            this.genCodeLine("    }");
            this.genCodeLine("    jj_ntk = -1;");
        }
        this.genCodeLine("    if (token.kind == kind) {");
        if (Options.isErrorReporting()) {
            this.genCodeLine("      jj_gen++;");
            if (JavaCCGlobals.s_jj2index != 0) {
                this.genCodeLine("      if (++jj_gc > 100) {");
                this.genCodeLine("        jj_gc = 0;");
                this.genCodeLine("        for (int i = 0; i < jj_2_rtns.length; i++) {");
                this.genCodeLine("          JJCalls c = jj_2_rtns[i];");
                this.genCodeLine("          while (c != null) {");
                this.genCodeLine("            if (c.gen < jj_gen)");
                this.genCodeLine("              c.first = null;");
                this.genCodeLine("            c = c.next;");
                this.genCodeLine("          }");
                this.genCodeLine("        }");
                this.genCodeLine("      }");
            }
        }
        if (Options.isDebugParser()) {
            this.genCodeLine("      trace_token(token, \"\");");
        }
        this.genCodeLine("      return token;");
        this.genCodeLine("    }");
        if (Options.isCacheTokens()) {
            this.genCodeLine("    jj_nt = token;");
        }
        this.genCodeLine("    token = oldToken;");
        if (Options.isErrorReporting()) {
            this.genCodeLine("    jj_kind = kind;");
        }
        this.genCodeLine("    throw generateParseException();");
        this.genCodeLine("  }");
        this.genCodeNewLine();
        if (JavaCCGlobals.s_jj2index != 0) {
            this.genCodeLine("  private static final class LookaheadSuccess extends IllegalStateException {}");
            this.genCodeLine("  private final LookaheadSuccess jj_ls = new LookaheadSuccess();");
            this.genCodeLine("  private " + eOutputLanguage.getTypeBoolean() + " jj_scan_token(int kind) {");
            this.genCodeLine("\t if (jj_scanpos == jj_lastpos) {");
            this.genCodeLine("\t   jj_la--;");
            this.genCodeLine("\t   if (jj_scanpos.next == null) {");
            this.genCodeLine("\t\t   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();");
            this.genCodeLine("\t   } else {");
            this.genCodeLine("\t\t   jj_lastpos = jj_scanpos = jj_scanpos.next;");
            this.genCodeLine("\t   }");
            this.genCodeLine("\t } else {");
            this.genCodeLine("\t   jj_scanpos = jj_scanpos.next;");
            this.genCodeLine("\t }");
            if (Options.isErrorReporting()) {
                this.genCodeLine("\t if (jj_rescan) {");
                this.genCodeLine("\t   int i = 0; Token tok = token;");
                this.genCodeLine("\t   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }");
                this.genCodeLine("\t   if (tok != null) jj_add_error_token(kind, i);");
                if (Options.isDebugLookahead()) {
                    this.genCodeLine("\t } else {");
                    this.genCodeLine("\t   trace_scan(jj_scanpos, kind);");
                }
                this.genCodeLine("\t }");
            } else if (Options.isDebugLookahead()) {
                this.genCodeLine("\t trace_scan(jj_scanpos, kind);");
            }
            this.genCodeLine("\t if (jj_scanpos.kind != kind) return true;");
            this.genCodeLine("\t if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;");
            this.genCodeLine("\t return false;");
            this.genCodeLine("  }");
            this.genCodeNewLine();
        }
        this.genCodeNewLine();
        this.genCodeLine("  /**");
        this.genCodeLine("   * @return the next Token.");
        this.genCodeLine("   */");
        this.genCodeLine("  public final Token getNextToken() {");
        if (Options.isCacheTokens()) {
            this.genCodeLine("   token = jj_nt;");
            this.genCodeLine("   if (token.next != null)");
            this.genCodeLine("     jj_nt = jj_nt.next;");
            this.genCodeLine("   else");
            this.genCodeLine("     jj_nt = jj_nt.next = token_source.getNextToken();");
        } else {
            this.genCodeLine("   if (token.next != null)");
            this.genCodeLine("     token = token.next;");
            this.genCodeLine("   else");
            this.genCodeLine("     token = token.next = token_source.getNextToken();");
            this.genCodeLine("\t jj_ntk = -1;");
        }
        if (Options.isErrorReporting()) {
            this.genCodeLine("\t jj_gen++;");
        }
        if (Options.isDebugParser()) {
            this.genCodeLine("\t   trace_token(token, \" (in getNextToken)\");");
        }
        this.genCodeLine("\t return token;");
        this.genCodeLine("  }");
        this.genCodeNewLine();
        this.genCodeLine("  /**");
        this.genCodeLine("   * @param index index to be retrieved");
        this.genCodeLine("   * @return the specific Token.");
        this.genCodeLine("   */");
        this.genCodeLine("  public final Token getToken(final int index) {");
        if (JavaCCGlobals.isLookAheadNeeded()) {
            this.genCodeLine("    Token t = jj_lookingAhead ? jj_scanpos : token;");
        } else {
            this.genCodeLine("    Token t = token;");
        }
        this.genCodeLine("    for (int i = 0; i < index; i++) {");
        this.genCodeLine("      if (t.next == null)");
        this.genCodeLine("        t.next = token_source.getNextToken();");
        this.genCodeLine("      t = t.next;");
        this.genCodeLine("    }");
        this.genCodeLine("    return t;");
        this.genCodeLine("  }");
        this.genCodeNewLine();
        if (!Options.isCacheTokens()) {
            this.genCodeLine("  private int jj_ntk_f() {");
            this.genCodeLine("    jj_nt = token.next;");
            this.genCodeLine("    if (jj_nt == null) {");
            this.genCodeLine("      token.next = token_source.getNextToken();");
            this.genCodeLine("      jj_ntk = token.next.kind;");
            this.genCodeLine("      return jj_ntk;");
            this.genCodeLine("    }");
            this.genCodeLine("    jj_ntk = jj_nt.kind;");
            this.genCodeLine("    return jj_ntk;");
            this.genCodeLine("  }");
            this.genCodeNewLine();
        }
        if (Options.isErrorReporting()) {
            this.genCodeLine("  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<" + (bl3 ? "" : "int[]") + ">();");
            this.genCodeLine("  private int[] jj_expentry;");
            this.genCodeLine("  private int jj_kind = -1;");
            if (JavaCCGlobals.s_jj2index != 0) {
                this.genCodeLine("  private int[] jj_lasttokens = new int[100];");
                this.genCodeLine("  private int jj_endpos;");
                this.genCodeNewLine();
                this.genCodeLine("  private void jj_add_error_token(int kind, int pos) {");
                this.genCodeLine("  if (pos >= 100) {");
                this.genCodeLine("    return;");
                this.genCodeLine("  }");
                this.genCodeNewLine();
                this.genCodeLine("  if (pos == jj_endpos + 1) {");
                this.genCodeLine("    jj_lasttokens[jj_endpos++] = kind;");
                this.genCodeLine("  } else if (jj_endpos != 0) {");
                this.genCodeLine("    jj_expentry = new int[jj_endpos];");
                this.genCodeNewLine();
                this.genCodeLine("    for (int i = 0; i < jj_endpos; i++) {");
                this.genCodeLine("      jj_expentry[i] = jj_lasttokens[i];");
                this.genCodeLine("    }");
                this.genCodeNewLine();
                this.genCodeLine("    for (final int[] oldentry : jj_expentries) {");
                this.genCodeLine("      if (oldentry.length == jj_expentry.length) {");
                this.genCodeLine("        boolean isMatched = true;");
                this.genCodeLine("        for (int i = 0; i < jj_expentry.length; i++) {");
                this.genCodeLine("          if (oldentry[i] != jj_expentry[i]) {");
                this.genCodeLine("            isMatched = false;");
                this.genCodeLine("            break;");
                this.genCodeLine("          }");
                this.genCodeLine("        }");
                this.genCodeLine("        if (isMatched) {");
                this.genCodeLine("          jj_expentries.add(jj_expentry);");
                this.genCodeLine("          break;");
                this.genCodeLine("        }");
                this.genCodeLine("      }");
                this.genCodeLine("    }");
                this.genCodeNewLine();
                this.genCodeLine("    if (pos != 0) {");
                this.genCodeLine("      jj_endpos = pos;");
                this.genCodeLine("      jj_lasttokens[jj_endpos - 1] = kind;");
                this.genCodeLine("    }");
                this.genCodeLine("  }");
                this.genCodeLine("}");
            }
            this.genCodeNewLine();
            this.genCodeLine("  /**");
            this.genCodeLine("   * Generate ParseException.");
            this.genCodeLine("   * @return new Exception object. Never <code>null</code>");
            this.genCodeLine("   */");
            this.genCodeLine("  public ParseException generateParseException() {");
            this.genCodeLine("    jj_expentries.clear();");
            this.genCodeLine("    " + eOutputLanguage.getTypeBoolean() + "[] la1tokens = new " + eOutputLanguage.getTypeBoolean() + "[" + JavaCCGlobals.s_tokenCount + "];");
            this.genCodeLine("    if (jj_kind >= 0) {");
            this.genCodeLine("      la1tokens[jj_kind] = true;");
            this.genCodeLine("      jj_kind = -1;");
            this.genCodeLine("    }");
            this.genCodeLine("    for (int i = 0; i < " + JavaCCGlobals.s_maskindex + "; i++) {");
            this.genCodeLine("      if (jj_la1[i] == jj_gen) {");
            this.genCodeLine("        for (int j = 0; j < 32; j++) {");
            for (int i = 0; i < (JavaCCGlobals.s_tokenCount - 1) / 32 + 1; ++i) {
                this.genCodeLine("          if ((jj_la1_" + i + "[i] & (1<<j)) != 0) {");
                this.genCode("            la1tokens[");
                if (i != 0) {
                    this.genCode(32 * i + "+");
                }
                this.genCodeLine("j] = true;");
                this.genCodeLine("          }");
            }
            this.genCodeLine("        }");
            this.genCodeLine("      }");
            this.genCodeLine("    }");
            this.genCodeLine("    for (int i = 0; i < " + JavaCCGlobals.s_tokenCount + "; i++) {");
            this.genCodeLine("      if (la1tokens[i]) {");
            this.genCodeLine("        jj_expentry = new int[1];");
            this.genCodeLine("        jj_expentry[0] = i;");
            this.genCodeLine("        jj_expentries.add(jj_expentry);");
            this.genCodeLine("      }");
            this.genCodeLine("    }");
            if (JavaCCGlobals.s_jj2index != 0) {
                this.genCodeLine("    jj_endpos = 0;");
                this.genCodeLine("    jj_rescan_token();");
                this.genCodeLine("    jj_add_error_token(0, 0);");
            }
            this.genCodeLine("    int[][] exptokseq = new int[jj_expentries.size()][];");
            this.genCodeLine("    for (int i = 0; i < jj_expentries.size(); i++) {");
            this.genCodeLine("      exptokseq[i] = jj_expentries.get(i);");
            this.genCodeLine("    }");
            if (bl && !Options.isUserTokenManager()) {
                this.genCodeLine("    return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : " + JavaCCGlobals.s_cu_name + "TokenManager.lexStateNames[token_source.curLexState]);");
            } else {
                this.genCodeLine("    return new ParseException(token, exptokseq, tokenImage);");
            }
            this.genCodeLine("  }");
        } else {
            this.genCodeLine("  /** Generate ParseException. */");
            this.genCodeLine("  public ParseException generateParseException() {");
            this.genCodeLine("  final Token errortok = token.next;");
            if (Options.isKeepLineColumn()) {
                this.genCodeLine("  final int line = errortok.beginLine;");
                this.genCodeLine("  final int column = errortok.beginColumn;");
            }
            this.genCodeLine("  final String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;");
            if (Options.isKeepLineColumn()) {
                this.genCodeLine("  return new ParseException(\"Parse error at line \" + line + \", column \" + column + \".  Encountered: \" + mess);");
            } else {
                this.genCodeLine("  return new ParseException(\"Parse error at <unknown location>.  Encountered: \" + mess);");
            }
            this.genCodeLine("  }");
        }
        this.genCodeNewLine();
        if (Options.isDebugParser()) {
            this.genCodeLine("  private int trace_indent = 0;");
            this.genCodeLine("  private " + eOutputLanguage.getTypeBoolean() + " trace_enabled = " + (Options.isDebugParser() ? "true" : "false") + ";");
            this.genCodeNewLine();
            this.genCodeLine("  /**");
            this.genCodeLine("   * @return Trace enabled or not?");
            this.genCodeLine("   */");
            this.genCodeLine("  public final boolean trace_enabled() {");
            this.genCodeLine("    return trace_enabled;");
            this.genCodeLine("  }");
            this.genCodeNewLine();
            this.genCodeLine("  /** Enable tracing. */");
            this.genCodeLine("  public final void enable_tracing() {");
            this.genCodeLine("    trace_enabled = true;");
            this.genCodeLine("  }");
            this.genCodeNewLine();
            this.genCodeLine("  /** Disable tracing. */");
            this.genCodeLine("  public final void disable_tracing() {");
            this.genCodeLine("    trace_enabled = false;");
            this.genCodeLine("  }");
            this.genCodeNewLine();
            this.genCodeLine("  protected java.io.PrintStream tracePS = System.out;");
            this.genCodeNewLine();
            this.genCodeLine("  protected void trace_call(final String s) {");
            this.genCodeLine("    if (trace_enabled) {");
            this.genCodeLine("      for (int i = 0; i < trace_indent; i++) {");
            this.genCodeLine("        tracePS.print(\" \");");
            this.genCodeLine("      }");
            this.genCodeLine("      tracePS.println(\"Call:\t\" + s);");
            this.genCodeLine("    }");
            this.genCodeLine("    trace_indent += 2;");
            this.genCodeLine("  }");
            this.genCodeNewLine();
            this.genCodeLine("  protected void trace_return(String s) {");
            this.genCodeLine("    trace_indent -= 2;");
            this.genCodeLine("    if (trace_enabled) {");
            this.genCodeLine("      for (int i = 0; i < trace_indent; i++) { tracePS.print(\" \"); }");
            this.genCodeLine("      tracePS.println(\"Return: \" + s);");
            this.genCodeLine("    }");
            this.genCodeLine("  }");
            this.genCodeNewLine();
            this.genCodeLine("  protected void trace_token(Token t, String where) {");
            this.genCodeLine("    if (trace_enabled) {");
            this.genCodeLine("      for (int i = 0; i < trace_indent; i++) {");
            this.genCodeLine("        tracePS.print(\" \");");
            this.genCodeLine("      }");
            this.genCodeLine("      tracePS.print(\"Consumed token: <\" + tokenImage[t.kind]);");
            this.genCodeLine("      if (t.kind != 0 && !tokenImage[t.kind].equals(\"\\\"\" + t.image + \"\\\"\")) {");
            this.genCodeLine("        tracePS.print(\": \\\"\" + " + Options.getTokenMgrErrorClass() + ".addEscapes(t.image) + \"\\\"\");");
            this.genCodeLine("      }");
            this.genCodeLine("      tracePS.println(\" at line \" + t.beginLine + \" column \" + t.beginColumn + \">\" + where);");
            this.genCodeLine("    }");
            this.genCodeLine("  }");
            this.genCodeNewLine();
            this.genCodeLine("  protected void trace_scan(Token t1, int t2) {");
            this.genCodeLine("    if (trace_enabled) {");
            this.genCodeLine("      for (int i = 0; i < trace_indent; i++) { tracePS.print(\" \"); }");
            this.genCodeLine("      tracePS.print(\"Visited token: <\" + tokenImage[t1.kind]);");
            this.genCodeLine("      if (t1.kind != 0 && !tokenImage[t1.kind].equals(\"\\\"\" + t1.image + \"\\\"\")) {");
            this.genCodeLine("        tracePS.print(\": \\\"\" + " + Options.getTokenMgrErrorClass() + ".addEscapes(t1.image) + \"\\\"\");");
            this.genCodeLine("      }");
            this.genCodeLine("      tracePS.println(\" at line \" + t1.beginLine + \" column \" + t1.beginColumn + \">; Expected token: <\" + tokenImage[t2] + \">\");");
            this.genCodeLine("    }");
            this.genCodeLine("  }");
            this.genCodeNewLine();
        } else {
            this.genCodeLine("  /**");
            this.genCodeLine("   * @return Always <code>false</code>.");
            this.genCodeLine("   */");
            this.genCodeLine("  public final boolean trace_enabled() {");
            this.genCodeLine("    return false;");
            this.genCodeLine("  }");
            this.genCodeNewLine();
            this.genCodeLine("  /** Enable tracing. */");
            this.genCodeLine("  public final void enable_tracing() {}");
            this.genCodeNewLine();
            this.genCodeLine("  /** Disable tracing. */");
            this.genCodeLine("  public final void disable_tracing() {}");
            this.genCodeNewLine();
        }
        if (JavaCCGlobals.s_jj2index != 0 && Options.isErrorReporting()) {
            this.genCodeLine("  private void jj_rescan_token() {");
            this.genCodeLine("    jj_rescan = true;");
            this.genCodeLine("    for (int i = 0; i < " + JavaCCGlobals.s_jj2index + "; i++) {");
            this.genCodeLine("      try {");
            this.genCodeLine("        JJCalls p = jj_2_rtns[i];");
            this.genCodeLine("        do {");
            this.genCodeLine("          if (p.gen > jj_gen) {");
            this.genCodeLine("            jj_la = p.arg;");
            this.genCodeLine("            jj_scanpos = p.first;");
            this.genCodeLine("            jj_lastpos = p.first;");
            this.genCodeLine("            switch (i) {");
            for (int i = 0; i < JavaCCGlobals.s_jj2index; ++i) {
                this.genCodeLine("              case " + i + ": jj_3_" + (i + 1) + "(); break;");
            }
            this.genCodeLine("            }");
            this.genCodeLine("          }");
            this.genCodeLine("          p = p.next;");
            this.genCodeLine("        } while (p != null);");
            this.genCodeLine("      } catch(LookaheadSuccess ls) { /* ignore */ }");
            this.genCodeLine("    }");
            this.genCodeLine("    jj_rescan = false;");
            this.genCodeLine("  }");
            this.genCodeNewLine();
            this.genCodeLine("  private void jj_save(int index, int xla) {");
            this.genCodeLine("    JJCalls p = jj_2_rtns[index];");
            this.genCodeLine("    while (p.gen > jj_gen) {");
            this.genCodeLine("      if (p.next == null) {");
            this.genCodeLine("        p.next = new JJCalls();");
            this.genCodeLine("        p = p.next;");
            this.genCodeLine("        break;");
            this.genCodeLine("      }");
            this.genCodeLine("      p = p.next;");
            this.genCodeLine("    }");
            this.genCodeLine("    p.gen = jj_gen + xla - jj_la; ");
            this.genCodeLine("    p.first = token;");
            this.genCodeLine("    p.arg = xla;");
            this.genCodeLine("  }");
            this.genCodeNewLine();
        }
        if (JavaCCGlobals.s_jj2index != 0 && Options.isErrorReporting()) {
            this.genCodeLine("  static final class JJCalls {");
            this.genCodeLine("\t int gen;");
            this.genCodeLine("\t Token first;");
            this.genCodeLine("\t int arg;");
            this.genCodeLine("\t JJCalls next;");
            this.genCodeLine("  }");
            this.genCodeNewLine();
        }
        if (JavaCCGlobals.s_cu_from_insertion_point_2.isNotEmpty()) {
            this.printTokenSetup((Token)JavaCCGlobals.s_cu_from_insertion_point_2.getFirst());
            this.setColToStart();
            Object object3 = null;
            Iterator iterator = JavaCCGlobals.s_cu_from_insertion_point_2.iterator();
            while (iterator.hasNext()) {
                object3 = object2 = (Token)iterator.next();
                this.printToken((Token)object3);
            }
            this.printTrailingComments((Token)object3);
        }
        this.genCodeNewLine();
        this.saveOutput(Options.getOutputDirectory() + File.separator + JavaCCGlobals.s_cu_name + JavaCCGlobals.getFileExtension());
    }

    public static void reInit() {
        JavaCCGlobals.setLookAheadNeeded(false);
    }
}

