/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EJDKVersion {
    JDK_1_1(1),
    JDK_1_2(2),
    JDK_1_3(3),
    JDK_1_4(4),
    JDK_1_5(5),
    JDK_1_6(6),
    JDK_1_7(7),
    JDK_1_8(8),
    JDK_9(9),
    JDK_10(10),
    JDK_11(11),
    JDK_12(12),
    JDK_13(13),
    JDK_14(14);

    public static final EJDKVersion DEFAULT;
    private int m_nMajor;

    private EJDKVersion(int n2) {
        this.m_nMajor = n2;
    }

    public boolean isNewerOrEqualsThan(@Nonnull EJDKVersion eJDKVersion) {
        return this.m_nMajor >= eJDKVersion.m_nMajor;
    }

    public boolean isOlderThan(@Nonnull EJDKVersion eJDKVersion) {
        return this.m_nMajor < eJDKVersion.m_nMajor;
    }

    @Nullable
    public static EJDKVersion getFromStringOrNull(String string) {
        if ("1.1".equals(string)) {
            return JDK_1_1;
        }
        if ("1.2".equals(string)) {
            return JDK_1_2;
        }
        if ("1.3".equals(string)) {
            return JDK_1_3;
        }
        if ("1.4".equals(string)) {
            return JDK_1_4;
        }
        if ("1.5".equals(string)) {
            return JDK_1_5;
        }
        if ("1.6".equals(string)) {
            return JDK_1_6;
        }
        if ("1.7".equals(string)) {
            return JDK_1_7;
        }
        if ("1.8".equals(string)) {
            return JDK_1_8;
        }
        if ("1.9".equals(string) || "9".equals(string)) {
            return JDK_9;
        }
        if ("1.10".equals(string) || "10".equals(string)) {
            return JDK_10;
        }
        if ("1.11".equals(string) || "11".equals(string)) {
            return JDK_11;
        }
        if ("1.12".equals(string) || "12".equals(string)) {
            return JDK_12;
        }
        if ("1.13".equals(string) || "13".equals(string)) {
            return JDK_13;
        }
        if ("1.14".equals(string) || "14".equals(string)) {
            return JDK_14;
        }
        return null;
    }

    static {
        DEFAULT = JDK_1_5;
    }
}

