/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.output.java;

import com.helger.pgcc.EJDKVersion;
import com.helger.pgcc.PGVersion;
import com.helger.pgcc.output.OutputFile;
import com.helger.pgcc.output.java.IJavaResourceTemplateLocations;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.utils.OutputFileGenerator;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;

public class FilesJava {
    private static final String charStreamVersion = PGVersion.MAJOR_DOT_MINOR;
    private static final String tokenManagerVersion = PGVersion.MAJOR_DOT_MINOR;
    private static final String tokenVersion = PGVersion.MAJOR_DOT_MINOR;
    private static final String parseExceptionVersion = PGVersion.MAJOR_DOT_MINOR;
    private static final String tokenMgrErrorVersion = PGVersion.MAJOR_DOT_MINOR;
    private static boolean s_bReadFromClassPath = true;

    private FilesJava() {
    }

    public static void setReadFromClassPath(boolean bl) {
        s_bReadFromClassPath = bl;
    }

    private static Map<String, Object> _getDefaultOptions() {
        EJDKVersion eJDKVersion = Options.getJdkVersion();
        Map<String, Object> map = Options.getAllOptions();
        map.put("AT_LEAST_JDK6", eJDKVersion.isNewerOrEqualsThan(EJDKVersion.JDK_1_6));
        map.put("AT_LEAST_JDK7", eJDKVersion.isNewerOrEqualsThan(EJDKVersion.JDK_1_7));
        map.put("BEFORE_JDK7", eJDKVersion.isOlderThan(EJDKVersion.JDK_1_7));
        return map;
    }

    private static void _writePackageName(@Nonnull @WillNotClose PrintWriter printWriter) {
        if (JavaCCGlobals.CU_TO_INSERTION_POINT_1.isNotEmpty() && ((Token)JavaCCGlobals.CU_TO_INSERTION_POINT_1.get((int)0)).kind == 67) {
            for (int i = 1; i < JavaCCGlobals.CU_TO_INSERTION_POINT_1.size(); ++i) {
                if (((Token)JavaCCGlobals.CU_TO_INSERTION_POINT_1.get((int)i)).kind != 108) continue;
                JavaCCGlobals.s_cline = ((Token)JavaCCGlobals.CU_TO_INSERTION_POINT_1.get((int)0)).beginLine;
                JavaCCGlobals.s_ccol = ((Token)JavaCCGlobals.CU_TO_INSERTION_POINT_1.get((int)0)).beginColumn;
                for (int j = 0; j <= i; ++j) {
                    JavaCCGlobals.printToken((Token)JavaCCGlobals.CU_TO_INSERTION_POINT_1.get(j), printWriter);
                }
                printWriter.println();
                printWriter.println();
                break;
            }
        }
    }

    public static void gen_CharStream(IJavaResourceTemplateLocations iJavaResourceTemplateLocations) {
        File file = new File(Options.getOutputDirectory(), "CharStream.java");
        try (OutputFile outputFile = new OutputFile(file, charStreamVersion, new String[]{"SUPPORT_CLASS_VISIBILITY_PUBLIC"});){
            if (!outputFile.needToWrite()) {
                return;
            }
            try (PrintWriter printWriter = outputFile.getPrintWriter();){
                FilesJava._writePackageName(printWriter);
                Map<String, Object> map = FilesJava._getDefaultOptions();
                OutputFileGenerator outputFileGenerator = new OutputFileGenerator(iJavaResourceTemplateLocations.getCharStreamTemplateResourceUrl(), map);
                outputFileGenerator.setReadFromClasspath(s_bReadFromClassPath);
                outputFileGenerator.generate(printWriter);
            }
        }
        catch (IOException iOException) {
            JavaCCErrors.semantic_error("Could not open file CharStream.java for writing.", iOException);
            throw new UncheckedIOException(iOException);
        }
    }

    public static void gen_AbstractCharStream(IJavaResourceTemplateLocations iJavaResourceTemplateLocations) {
        File file = new File(Options.getOutputDirectory(), "AbstractCharStream.java");
        try (OutputFile outputFile = new OutputFile(file, charStreamVersion, new String[]{"SUPPORT_CLASS_VISIBILITY_PUBLIC"});){
            if (!outputFile.needToWrite()) {
                return;
            }
            try (PrintWriter printWriter = outputFile.getPrintWriter();){
                FilesJava._writePackageName(printWriter);
                Map<String, Object> map = FilesJava._getDefaultOptions();
                OutputFileGenerator outputFileGenerator = new OutputFileGenerator(iJavaResourceTemplateLocations.getAbstractCharStreamTemplateResourceUrl(), map);
                outputFileGenerator.setReadFromClasspath(s_bReadFromClassPath);
                outputFileGenerator.generate(printWriter);
            }
        }
        catch (IOException iOException) {
            JavaCCErrors.semantic_error("Could not open file AbstractCharStream.java for writing.", iOException);
            throw new UncheckedIOException(iOException);
        }
    }

    public static void gen_JavaCharStream(IJavaResourceTemplateLocations iJavaResourceTemplateLocations) {
        File file = new File(Options.getOutputDirectory(), "JavaCharStream.java");
        try (OutputFile outputFile = new OutputFile(file, charStreamVersion, new String[]{"SUPPORT_CLASS_VISIBILITY_PUBLIC"});){
            if (!outputFile.needToWrite()) {
                return;
            }
            try (PrintWriter printWriter = outputFile.getPrintWriter();){
                FilesJava._writePackageName(printWriter);
                Map<String, Object> map = FilesJava._getDefaultOptions();
                OutputFileGenerator outputFileGenerator = new OutputFileGenerator(iJavaResourceTemplateLocations.getJavaCharStreamTemplateResourceUrl(), map);
                outputFileGenerator.setReadFromClasspath(s_bReadFromClassPath);
                outputFileGenerator.generate(printWriter);
            }
        }
        catch (IOException iOException) {
            JavaCCErrors.semantic_error("Could not open file JavaCharStream.java for writing.", iOException);
            throw new UncheckedIOException(iOException);
        }
    }

    public static void gen_SimpleCharStream(IJavaResourceTemplateLocations iJavaResourceTemplateLocations) {
        File file = new File(Options.getOutputDirectory(), "SimpleCharStream.java");
        try (OutputFile outputFile = new OutputFile(file, charStreamVersion, new String[]{"SUPPORT_CLASS_VISIBILITY_PUBLIC"});){
            if (!outputFile.needToWrite()) {
                return;
            }
            try (PrintWriter printWriter = outputFile.getPrintWriter();){
                FilesJava._writePackageName(printWriter);
                Map<String, Object> map = FilesJava._getDefaultOptions();
                OutputFileGenerator outputFileGenerator = new OutputFileGenerator(iJavaResourceTemplateLocations.getSimpleCharStreamTemplateResourceUrl(), map);
                outputFileGenerator.setReadFromClasspath(s_bReadFromClassPath);
                outputFileGenerator.generate(printWriter);
            }
        }
        catch (IOException iOException) {
            JavaCCErrors.semantic_error("Could not open file SimpleCharStream.java for writing.", iOException);
            throw new UncheckedIOException(iOException);
        }
    }

    public static void gen_JavaModernFiles() {
        FilesJava._genMiscFile("Provider.java", "/templates/stream/java/modern/Provider.template");
        FilesJava._genMiscFile("StringProvider.java", "/templates/stream/java/modern/StringProvider.template");
        FilesJava._genMiscFile("StreamProvider.java", "/templates/stream/java/modern/StreamProvider.template");
    }

    private static void _genMiscFile(String string, String string2) throws Error {
        File file = new File(Options.getOutputDirectory(), string);
        try (OutputFile outputFile = new OutputFile(file, parseExceptionVersion, new String[]{"KEEP_LINE_COLUMN"});){
            if (!outputFile.needToWrite()) {
                return;
            }
            try (PrintWriter printWriter = outputFile.getPrintWriter();){
                FilesJava._writePackageName(printWriter);
                Map<String, Object> map = FilesJava._getDefaultOptions();
                OutputFileGenerator outputFileGenerator = new OutputFileGenerator(string2, map);
                outputFileGenerator.setReadFromClasspath(s_bReadFromClassPath);
                outputFileGenerator.generate(printWriter);
            }
        }
        catch (IOException iOException) {
            JavaCCErrors.semantic_error("Could not open file " + string + " for writing.", iOException);
            throw new UncheckedIOException(iOException);
        }
    }

    public static void gen_ParseException(IJavaResourceTemplateLocations iJavaResourceTemplateLocations) {
        File file = new File(Options.getOutputDirectory(), "ParseException.java");
        try (OutputFile outputFile = new OutputFile(file, parseExceptionVersion, new String[]{"KEEP_LINE_COLUMN"});){
            if (!outputFile.needToWrite()) {
                return;
            }
            try (PrintWriter printWriter = outputFile.getPrintWriter();){
                FilesJava._writePackageName(printWriter);
                Map<String, Object> map = FilesJava._getDefaultOptions();
                OutputFileGenerator outputFileGenerator = new OutputFileGenerator(iJavaResourceTemplateLocations.getParseExceptionTemplateResourceUrl(), map);
                outputFileGenerator.setReadFromClasspath(s_bReadFromClassPath);
                outputFileGenerator.generate(printWriter);
            }
        }
        catch (IOException iOException) {
            JavaCCErrors.semantic_error("Could not open file ParseException.java for writing.", iOException);
            throw new UncheckedIOException(iOException);
        }
    }

    public static void gen_TokenMgrError(IJavaResourceTemplateLocations iJavaResourceTemplateLocations) {
        String string = Options.getTokenMgrErrorClass() + ".java";
        File file = new File(Options.getOutputDirectory(), string);
        try (OutputFile outputFile = new OutputFile(file, tokenMgrErrorVersion, new String[0]);){
            if (!outputFile.needToWrite()) {
                return;
            }
            try (PrintWriter printWriter = outputFile.getPrintWriter();){
                FilesJava._writePackageName(printWriter);
                Map<String, Object> map = FilesJava._getDefaultOptions();
                OutputFileGenerator outputFileGenerator = new OutputFileGenerator(iJavaResourceTemplateLocations.getTokenMgrErrorTemplateResourceUrl(), map);
                outputFileGenerator.setReadFromClasspath(s_bReadFromClassPath);
                outputFileGenerator.generate(printWriter);
            }
        }
        catch (IOException iOException) {
            JavaCCErrors.semantic_error("Could not open file " + string + " for writing.", iOException);
            throw new UncheckedIOException(iOException);
        }
    }

    public static void gen_Token(IJavaResourceTemplateLocations iJavaResourceTemplateLocations) {
        File file = new File(Options.getOutputDirectory(), "Token.java");
        try (OutputFile outputFile = new OutputFile(file, tokenVersion, new String[]{"TOKEN_EXTENDS", "KEEP_LINE_COLUMN", "SUPPORT_CLASS_VISIBILITY_PUBLIC"});){
            if (!outputFile.needToWrite()) {
                return;
            }
            try (PrintWriter printWriter = outputFile.getPrintWriter();){
                FilesJava._writePackageName(printWriter);
                Map<String, Object> map = FilesJava._getDefaultOptions();
                OutputFileGenerator outputFileGenerator = new OutputFileGenerator(iJavaResourceTemplateLocations.getTokenTemplateResourceUrl(), map);
                outputFileGenerator.setReadFromClasspath(s_bReadFromClassPath);
                outputFileGenerator.generate(printWriter);
            }
        }
        catch (IOException iOException) {
            JavaCCErrors.semantic_error("Could not open file Token.java for writing.", iOException);
            throw new UncheckedIOException(iOException);
        }
    }

    public static void gen_TokenManager(IJavaResourceTemplateLocations iJavaResourceTemplateLocations) {
        File file = new File(Options.getOutputDirectory(), "TokenManager.java");
        try (OutputFile outputFile = new OutputFile(file, tokenManagerVersion, new String[]{"SUPPORT_CLASS_VISIBILITY_PUBLIC"});){
            if (!outputFile.needToWrite()) {
                return;
            }
            try (PrintWriter printWriter = outputFile.getPrintWriter();){
                FilesJava._writePackageName(printWriter);
                Map<String, Object> map = Options.getAllOptions();
                OutputFileGenerator outputFileGenerator = new OutputFileGenerator(iJavaResourceTemplateLocations.getTokenManagerTemplateResourceUrl(), map);
                outputFileGenerator.setReadFromClasspath(s_bReadFromClassPath);
                outputFileGenerator.generate(printWriter);
            }
        }
        catch (IOException iOException) {
            JavaCCErrors.semantic_error("Could not open file TokenManager.java for writing.", iOException);
            throw new UncheckedIOException(iOException);
        }
    }

    public static void reInit() {
    }
}

