/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjdoc;

import com.helger.base.string.StringHelper;
import com.helger.pgcc.jjdoc.JJDoc;
import com.helger.pgcc.jjdoc.JJDocGlobals;
import com.helger.pgcc.jjdoc.JJDocOptions;
import com.helger.pgcc.jjdoc.TextGenerator;
import com.helger.pgcc.parser.CodeProductionCpp;
import com.helger.pgcc.parser.CodeProductionJava;
import com.helger.pgcc.parser.NormalProduction;
import com.helger.pgcc.parser.TokenProduction;
import com.helger.pgcc.parser.exp.AbstractExpRegularExpression;
import com.helger.pgcc.parser.exp.ExpNonTerminal;
import com.helger.pgcc.parser.exp.Expansion;
import com.helger.xml.serialize.write.EXMLCharMode;
import com.helger.xml.serialize.write.EXMLIncorrectCharacterHandling;
import com.helger.xml.serialize.write.EXMLSerializeVersion;
import com.helger.xml.serialize.write.XMLMaskHelper;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class HTMLGenerator
extends TextGenerator {
    private final Map<String, String> m_aIDMap = new HashMap<String, String>();
    private int m_nID = 1;

    protected String getID(String string2) {
        return this.m_aIDMap.computeIfAbsent(string2, string -> "prod" + this.m_nID++);
    }

    private void _println(@Nonnull String string) throws IOException {
        this.print(string + "\n");
    }

    @Override
    public void text(String string) throws IOException {
        XMLMaskHelper.maskXMLTextTo((EXMLSerializeVersion)EXMLSerializeVersion.HTML, (EXMLCharMode)EXMLCharMode.TEXT, (EXMLIncorrectCharacterHandling)EXMLIncorrectCharacterHandling.DO_NOT_WRITE_LOG_WARNING, (String)string, (Writer)this.m_aPW);
    }

    @Override
    public void print(String string) throws IOException {
        this.m_aPW.write(string);
    }

    @Override
    public void documentStart() throws IOException {
        this.m_aPW = HTMLGenerator.createPrintWriter();
        this._println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">");
        this._println("<HTML>");
        this._println("<HEAD>");
        if (StringHelper.isNotEmpty((String)JJDocOptions.getCSS())) {
            this._println("<LINK REL=\"stylesheet\" type=\"text/css\" href=\"" + JJDocOptions.getCSS() + "\"/>");
        }
        if (StringHelper.isNotEmpty((String)JJDocGlobals.s_input_file)) {
            this._println("<TITLE>BNF for " + JJDocGlobals.s_input_file + "</TITLE>");
        } else {
            this._println("<TITLE>A BNF grammar by JJDoc</TITLE>");
        }
        this._println("</HEAD>");
        this._println("<BODY>");
        this._println("<H1 ALIGN=CENTER>BNF for " + JJDocGlobals.s_input_file + "</H1>");
    }

    @Override
    public void documentEnd() throws IOException {
        this._println("</BODY>");
        this._println("</HTML>");
        this.m_aPW.close();
    }

    @Override
    public void specialTokens(String string) throws IOException {
        this._println(" <!-- Special token -->");
        this._println(" <TR>");
        this._println("  <TD>");
        this._println("    <PRE>");
        this.print(string);
        this._println("    </PRE>");
        this._println("  </TD>");
        this._println(" </TR>");
    }

    @Override
    public void handleTokenProduction(TokenProduction tokenProduction) throws IOException {
        this._println(" <!-- Token -->");
        this._println(" <TR>");
        this._println("  <TD>");
        this._println("   <PRE>");
        this.text(JJDoc.getStandardTokenProductionText(tokenProduction));
        this._println("   </PRE>");
        this._println("  </TD>");
        this._println(" </TR>");
    }

    @Override
    public void nonterminalsStart() throws IOException {
        this._println("<H2 ALIGN='CENTER'>NON-TERMINALS</H2>");
        if (JJDocOptions.isOneTable()) {
            this._println("<TABLE>");
        }
    }

    @Override
    public void nonterminalsEnd() throws IOException {
        if (JJDocOptions.isOneTable()) {
            this._println("</TABLE>");
        }
    }

    @Override
    public void tokensStart() throws IOException {
        this._println("<H2 ALIGN=CENTER>TOKENS</H2>");
        this._println("<TABLE>");
    }

    @Override
    public void tokensEnd() throws IOException {
        this._println("</TABLE>");
    }

    @Override
    public void javacode(CodeProductionJava codeProductionJava) throws IOException {
        this.productionStart(codeProductionJava);
        this._println("<I>java code</I></TD></TR>");
        this.productionEnd(codeProductionJava);
    }

    @Override
    public void cppcode(CodeProductionCpp codeProductionCpp) throws IOException {
        this.productionStart(codeProductionCpp);
        this._println("<I>cpp code</I></TD></TR>");
        this.productionEnd(codeProductionCpp);
    }

    @Override
    public void productionStart(NormalProduction normalProduction) throws IOException {
        if (!JJDocOptions.isOneTable()) {
            this._println("");
            this._println("<TABLE ALIGN=CENTER>");
            this._println("<CAPTION><STRONG>" + normalProduction.getLhs() + "</STRONG></CAPTION>");
        }
        this._println("<TR>");
        this._println("<TD ALIGN=RIGHT VALIGN=BASELINE><A NAME=\"" + this.getID(normalProduction.getLhs()) + "\">" + normalProduction.getLhs() + "</A></TD>");
        this._println("<TD ALIGN=CENTER VALIGN=BASELINE>::=</TD>");
        this.print("<TD ALIGN=LEFT VALIGN=BASELINE>");
    }

    @Override
    public void productionEnd(NormalProduction normalProduction) throws IOException {
        if (!JJDocOptions.isOneTable()) {
            this._println("</TABLE>");
            this._println("<HR>");
        }
    }

    @Override
    public void expansionStart(Expansion expansion, boolean bl) throws IOException {
        if (!bl) {
            this._println("<TR>");
            this._println("<TD ALIGN=RIGHT VALIGN=BASELINE></TD>");
            this._println("<TD ALIGN=CENTER VALIGN=BASELINE>|</TD>");
            this.print("<TD ALIGN=LEFT VALIGN=BASELINE>");
        }
    }

    @Override
    public void expansionEnd(Expansion expansion, boolean bl) throws IOException {
        this._println("</TD>");
        this._println("</TR>");
    }

    @Override
    public void nonTerminalStart(ExpNonTerminal expNonTerminal) throws IOException {
        this.print("<A HREF=\"#" + this.getID(expNonTerminal.getName()) + "\">");
    }

    @Override
    public void nonTerminalEnd(ExpNonTerminal expNonTerminal) throws IOException {
        this.print("</A>");
    }

    @Override
    public void reStart(AbstractExpRegularExpression abstractExpRegularExpression) {
    }

    @Override
    public void reEnd(AbstractExpRegularExpression abstractExpRegularExpression) {
    }
}

