/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjdoc;

import com.helger.base.io.nonblocking.NonBlockingBufferedReader;
import com.helger.base.state.ESuccess;
import com.helger.io.file.FileHelper;
import com.helger.pgcc.PGPrinter;
import com.helger.pgcc.jjdoc.JJDoc;
import com.helger.pgcc.jjdoc.JJDocGlobals;
import com.helger.pgcc.jjdoc.JJDocOptions;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.JavaCCParser;
import com.helger.pgcc.parser.Main;
import com.helger.pgcc.parser.MetaParseException;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.ParseException;
import com.helger.pgcc.parser.StreamProvider;
import jakarta.annotation.Nonnull;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;

public final class JJDocMain {
    private JJDocMain() {
    }

    static void help_message() {
        PGPrinter.info();
        PGPrinter.info("    jjdoc option-settings - (to read from standard input)");
        PGPrinter.info("OR");
        PGPrinter.info("    jjdoc option-settings inputfile (to read from a file)");
        PGPrinter.info();
        PGPrinter.info("WHERE");
        PGPrinter.info("    \"option-settings\" is a sequence of settings separated by spaces.");
        PGPrinter.info();
        PGPrinter.info("Each option setting must be of one of the following forms:");
        PGPrinter.info();
        PGPrinter.info("    -optionname=value (e.g., -TEXT=false)");
        PGPrinter.info("    -optionname:value (e.g., -TEXT:false)");
        PGPrinter.info("    -optionname       (equivalent to -optionname=true.  e.g., -TEXT)");
        PGPrinter.info("    -NOoptionname     (equivalent to -optionname=false. e.g., -NOTEXT)");
        PGPrinter.info();
        PGPrinter.info("Option settings are not case-sensitive, so one can say \"-nOtExT\" instead");
        PGPrinter.info("of \"-NOTEXT\".  Option values must be appropriate for the corresponding");
        PGPrinter.info("option, and must be either an integer, boolean or string value.");
        PGPrinter.info();
        PGPrinter.info("The string valued options are:");
        PGPrinter.info();
        PGPrinter.info("    OUTPUT_FILE");
        PGPrinter.info("    CSS");
        PGPrinter.info();
        PGPrinter.info("The boolean valued options are:");
        PGPrinter.info();
        PGPrinter.info("    ONE_TABLE              (default true)");
        PGPrinter.info("    TEXT                   (default false)");
        PGPrinter.info("    BNF                    (default false)");
        PGPrinter.info();
        PGPrinter.info();
        PGPrinter.info("EXAMPLES:");
        PGPrinter.info("    jjdoc -ONE_TABLE=false mygrammar.jj");
        PGPrinter.info("    jjdoc - < mygrammar.jj");
        PGPrinter.info();
        PGPrinter.info("ABOUT JJDoc:");
        PGPrinter.info("    JJDoc generates JavaDoc documentation from JavaCC grammar files.");
        PGPrinter.info();
        PGPrinter.info("    For more information, see the online JJDoc documentation at");
        PGPrinter.info("    https://javacc.dev.java.net/doc/JJDoc.html");
    }

    public static void main(String[] stringArray) throws Exception {
        ESuccess eSuccess = JJDocMain.mainProgram(stringArray);
        System.exit(eSuccess.isFailure() ? 1 : 0);
    }

    @Nonnull
    public static ESuccess mainProgram(String[] stringArray) throws Exception {
        Main.reInitAll();
        JJDocOptions.init();
        JavaCCGlobals.bannerLine("Documentation Generator", "0.1.4");
        JavaCCParser javaCCParser = null;
        if (stringArray.length == 0) {
            JJDocMain.help_message();
            return ESuccess.FAILURE;
        }
        PGPrinter.info("(type \"jjdoc\" with no arguments for help)");
        if (Options.isOption(stringArray[stringArray.length - 1])) {
            PGPrinter.error("Last argument \"" + stringArray[stringArray.length - 1] + "\" is not a filename or \"-\".  ");
            return ESuccess.FAILURE;
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (!Options.isOption(stringArray[i])) {
                PGPrinter.error("Argument \"" + stringArray[i] + "\" must be an option setting.");
                return ESuccess.FAILURE;
            }
            Options.setCmdLineOption(stringArray[i]);
        }
        if (stringArray[stringArray.length - 1].equals("-")) {
            PGPrinter.info("Reading from standard input . . .");
            javaCCParser = new JavaCCParser(new StreamProvider((InputStream)new DataInputStream(System.in), Charset.defaultCharset()));
            JJDocGlobals.s_input_file = "standard input";
            JJDocGlobals.s_output_file = "standard output";
        } else {
            PGPrinter.info("Reading from file " + stringArray[stringArray.length - 1] + " . . .");
            try {
                File file = new File(stringArray[stringArray.length - 1]);
                if (!file.exists()) {
                    PGPrinter.error("File " + stringArray[stringArray.length - 1] + " not found.");
                    return ESuccess.FAILURE;
                }
                if (file.isDirectory()) {
                    PGPrinter.error(stringArray[stringArray.length - 1] + " is a directory. Please use a valid file name.");
                    return ESuccess.FAILURE;
                }
                JJDocGlobals.s_input_file = file.getName();
                NonBlockingBufferedReader nonBlockingBufferedReader = FileHelper.getBufferedReader((File)new File(stringArray[stringArray.length - 1]), (Charset)Options.getGrammarEncoding());
                if (nonBlockingBufferedReader == null) {
                    PGPrinter.error("File " + stringArray[stringArray.length - 1] + " not found.");
                    return ESuccess.FAILURE;
                }
                javaCCParser = new JavaCCParser(new StreamProvider((Reader)nonBlockingBufferedReader));
            }
            catch (SecurityException securityException) {
                PGPrinter.error("Security violation while trying to open " + stringArray[stringArray.length - 1]);
                return ESuccess.FAILURE;
            }
        }
        try {
            javaCCParser.javacc_input();
            JJDoc.start();
            if (JavaCCErrors.getErrorCount() == 0) {
                if (JavaCCErrors.getWarningCount() == 0) {
                    PGPrinter.info("Grammar documentation generated successfully in " + JJDocGlobals.s_output_file);
                } else {
                    PGPrinter.info("Grammar documentation generated with 0 errors and " + JavaCCErrors.getWarningCount() + " warnings.");
                }
                return ESuccess.SUCCESS;
            }
            PGPrinter.error("Detected " + JavaCCErrors.getErrorCount() + " errors and " + JavaCCErrors.getWarningCount() + " warnings.");
            return ESuccess.valueOf((JavaCCErrors.getErrorCount() == 0 ? 1 : 0) != 0);
        }
        catch (MetaParseException metaParseException) {
            PGPrinter.error("Detected " + JavaCCErrors.getErrorCount() + " errors and " + JavaCCErrors.getWarningCount() + " warnings.", metaParseException);
        }
        catch (ParseException parseException) {
            PGPrinter.error("Detected " + (JavaCCErrors.getErrorCount() + 1) + " errors and " + JavaCCErrors.getWarningCount() + " warnings.", parseException);
        }
        return ESuccess.FAILURE;
    }
}

