/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjtree;

import com.helger.base.string.StringHelper;
import com.helger.pgcc.jjtree.ASTBNFAction;
import com.helger.pgcc.jjtree.ASTBNFDeclaration;
import com.helger.pgcc.jjtree.ASTBNFNodeScope;
import com.helger.pgcc.jjtree.ASTBNFNonTerminal;
import com.helger.pgcc.jjtree.ASTBNFOneOrMore;
import com.helger.pgcc.jjtree.ASTBNFSequence;
import com.helger.pgcc.jjtree.ASTBNFTryBlock;
import com.helger.pgcc.jjtree.ASTBNFZeroOrMore;
import com.helger.pgcc.jjtree.ASTBNFZeroOrOne;
import com.helger.pgcc.jjtree.ASTCompilationUnit;
import com.helger.pgcc.jjtree.ASTExpansionNodeScope;
import com.helger.pgcc.jjtree.ASTGrammar;
import com.helger.pgcc.jjtree.ASTJavacodeBody;
import com.helger.pgcc.jjtree.ASTLHS;
import com.helger.pgcc.jjtree.ASTNodeDescriptor;
import com.helger.pgcc.jjtree.DefaultJJTreeVisitor;
import com.helger.pgcc.jjtree.JJTreeGlobals;
import com.helger.pgcc.jjtree.JJTreeIO;
import com.helger.pgcc.jjtree.JJTreeNode;
import com.helger.pgcc.jjtree.JJTreeOptions;
import com.helger.pgcc.jjtree.Node;
import com.helger.pgcc.jjtree.NodeScope;
import com.helger.pgcc.jjtree.SimpleNode;
import com.helger.pgcc.jjtree.Token;
import com.helger.pgcc.jjtree.TokenUtils;
import com.helger.pgcc.jjtree.output.JJTreeStateJava;
import com.helger.pgcc.jjtree.output.NodeFilesJava;
import com.helger.pgcc.parser.JavaCCGlobals;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class CodeGeneratorJava
extends DefaultJJTreeVisitor {
    @Override
    public Object defaultVisit(SimpleNode simpleNode, Object object) {
        this.visit((JJTreeNode)simpleNode, object);
        return null;
    }

    @Override
    public Object visit(ASTGrammar aSTGrammar, Object object) {
        JJTreeIO jJTreeIO = (JJTreeIO)object;
        jJTreeIO.println("/*@bgen(jjtree) " + JavaCCGlobals.getIdString(JJTreeGlobals.toolList, new File(jJTreeIO.getOutputFilename()).getName()) + " */");
        jJTreeIO.print("/*@egen*/");
        return aSTGrammar.childrenAccept(this, jJTreeIO);
    }

    @Override
    public Object visit(ASTBNFAction aSTBNFAction, Object object) {
        JJTreeIO jJTreeIO = (JJTreeIO)object;
        NodeScope nodeScope = NodeScope.getEnclosingNodeScope(aSTBNFAction);
        if (nodeScope != null && !nodeScope.isVoid()) {
            boolean bl = true;
            Node node = aSTBNFAction.getScopingParent(nodeScope);
            JJTreeNode jJTreeNode = aSTBNFAction;
            while (true) {
                Node node2;
                if ((node2 = jJTreeNode.jjtGetParent()) instanceof ASTBNFSequence || node2 instanceof ASTBNFTryBlock) {
                    if (jJTreeNode.getOrdinal() != node2.jjtGetNumChildren() - 1) {
                        bl = false;
                        break;
                    }
                } else if (node2 instanceof ASTBNFZeroOrOne || node2 instanceof ASTBNFZeroOrMore || node2 instanceof ASTBNFOneOrMore) {
                    bl = false;
                    break;
                }
                if (node2 == node) break;
                jJTreeNode = (JJTreeNode)node2;
            }
            if (bl) {
                CodeGeneratorJava.openJJTreeComment(jJTreeIO, null);
                jJTreeIO.println();
                this.insertCloseNodeAction(nodeScope, jJTreeIO, this.getIndentation(aSTBNFAction));
                CodeGeneratorJava.closeJJTreeComment(jJTreeIO);
            }
        }
        return this.visit((JJTreeNode)aSTBNFAction, (Object)jJTreeIO);
    }

    @Override
    public Object visit(ASTBNFDeclaration aSTBNFDeclaration, Object object) {
        JJTreeIO jJTreeIO = (JJTreeIO)object;
        if (!aSTBNFDeclaration.m_node_scope.isVoid()) {
            Object object2 = "";
            if (TokenUtils.hasTokens(aSTBNFDeclaration)) {
                for (int i = 1; i < aSTBNFDeclaration.getFirstToken().beginColumn; ++i) {
                    object2 = (String)object2 + " ";
                }
            } else {
                object2 = "  ";
            }
            CodeGeneratorJava.openJJTreeComment(jJTreeIO, aSTBNFDeclaration.m_node_scope.getNodeDescriptorText());
            jJTreeIO.println();
            this.insertOpenNodeCode(aSTBNFDeclaration.m_node_scope, jJTreeIO, (String)object2);
            CodeGeneratorJava.closeJJTreeComment(jJTreeIO);
        }
        return this.visit((JJTreeNode)aSTBNFDeclaration, (Object)jJTreeIO);
    }

    @Override
    public Object visit(ASTBNFNodeScope aSTBNFNodeScope, Object object) {
        JJTreeIO jJTreeIO = (JJTreeIO)object;
        if (aSTBNFNodeScope.m_node_scope.isVoid()) {
            return this.visit((JJTreeNode)aSTBNFNodeScope, (Object)jJTreeIO);
        }
        String string = this.getIndentation(aSTBNFNodeScope.m_expansion_unit);
        CodeGeneratorJava.openJJTreeComment(jJTreeIO, aSTBNFNodeScope.m_node_scope.getNodeDescriptor().getDescriptor());
        jJTreeIO.println();
        this.tryExpansionUnit(aSTBNFNodeScope.m_node_scope, jJTreeIO, string, aSTBNFNodeScope.m_expansion_unit);
        return null;
    }

    @Override
    public Object visit(ASTCompilationUnit aSTCompilationUnit, Object object) {
        JJTreeIO jJTreeIO = (JJTreeIO)object;
        Token token = aSTCompilationUnit.getFirstToken();
        while (true) {
            if (token == JJTreeGlobals.s_parserImports && StringHelper.isNotEmpty((String)JJTreeGlobals.s_nodePackageName) && !JJTreeGlobals.s_nodePackageName.equals(JJTreeGlobals.s_packageName)) {
                jJTreeIO.getOut().println();
                jJTreeIO.getOut().println("import " + JJTreeGlobals.s_nodePackageName + ".*;");
            }
            if (token == JJTreeGlobals.s_parserImplements) {
                if (token.image.equals("implements")) {
                    aSTCompilationUnit.print(token, jJTreeIO);
                    CodeGeneratorJava.openJJTreeComment(jJTreeIO, null);
                    jJTreeIO.getOut().print(" " + NodeFilesJava.nodeConstants() + ", ");
                    CodeGeneratorJava.closeJJTreeComment(jJTreeIO);
                } else {
                    CodeGeneratorJava.openJJTreeComment(jJTreeIO, null);
                    jJTreeIO.getOut().print("implements " + NodeFilesJava.nodeConstants());
                    CodeGeneratorJava.closeJJTreeComment(jJTreeIO);
                    aSTCompilationUnit.print(token, jJTreeIO);
                }
            } else {
                aSTCompilationUnit.print(token, jJTreeIO);
            }
            if (token == JJTreeGlobals.s_parserClassBodyStart) {
                CodeGeneratorJava.openJJTreeComment(jJTreeIO, null);
                JJTreeStateJava.insertParserMembers(jJTreeIO);
                CodeGeneratorJava.closeJJTreeComment(jJTreeIO);
            }
            if (token == aSTCompilationUnit.getLastToken()) {
                return null;
            }
            token = token.next;
        }
    }

    @Override
    public Object visit(ASTExpansionNodeScope aSTExpansionNodeScope, Object object) {
        JJTreeIO jJTreeIO = (JJTreeIO)object;
        String string = this.getIndentation(aSTExpansionNodeScope.m_expansion_unit);
        CodeGeneratorJava.openJJTreeComment(jJTreeIO, aSTExpansionNodeScope.m_node_scope.getNodeDescriptor().getDescriptor());
        jJTreeIO.println();
        this.insertOpenNodeAction(aSTExpansionNodeScope.m_node_scope, jJTreeIO, string);
        this.tryExpansionUnit(aSTExpansionNodeScope.m_node_scope, jJTreeIO, string, aSTExpansionNodeScope.m_expansion_unit);
        ((ASTNodeDescriptor)aSTExpansionNodeScope.jjtGetChild(1)).jjtAccept(this, jJTreeIO);
        return null;
    }

    @Override
    public Object visit(ASTJavacodeBody aSTJavacodeBody, Object object) {
        JJTreeIO jJTreeIO = (JJTreeIO)object;
        if (aSTJavacodeBody.m_node_scope.isVoid()) {
            return this.visit((JJTreeNode)aSTJavacodeBody, (Object)jJTreeIO);
        }
        Token token = aSTJavacodeBody.getFirstToken();
        Object object2 = "";
        for (int i = 4; i < token.beginColumn; ++i) {
            object2 = (String)object2 + " ";
        }
        CodeGeneratorJava.openJJTreeComment(jJTreeIO, aSTJavacodeBody.m_node_scope.getNodeDescriptorText());
        jJTreeIO.println();
        this.insertOpenNodeCode(aSTJavacodeBody.m_node_scope, jJTreeIO, (String)object2);
        this.tryTokenSequence(aSTJavacodeBody.m_node_scope, jJTreeIO, (String)object2, token, aSTJavacodeBody.getLastToken());
        return null;
    }

    public Object visit(ASTLHS aSTLHS, Object object) {
        JJTreeIO jJTreeIO = (JJTreeIO)object;
        NodeScope nodeScope = NodeScope.getEnclosingNodeScope(aSTLHS);
        Token token = aSTLHS.getFirstToken();
        Token token2 = aSTLHS.getLastToken();
        Token token3 = token;
        while (token3 != token2.next) {
            TokenUtils.print(token3, jJTreeIO, "jjtThis", nodeScope.getNodeVariable());
            token3 = token3.next;
        }
        return null;
    }

    public Object visit(JJTreeNode jJTreeNode, Object object) {
        JJTreeIO jJTreeIO = (JJTreeIO)object;
        if (jJTreeNode.getLastToken().next == jJTreeNode.getFirstToken()) {
            return null;
        }
        Token token = jJTreeNode.getFirstToken();
        Token token2 = new Token();
        token2.next = token;
        for (int i = 0; i < jJTreeNode.jjtGetNumChildren(); ++i) {
            JJTreeNode jJTreeNode2 = (JJTreeNode)jJTreeNode.jjtGetChild(i);
            while ((token2 = token2.next) != jJTreeNode2.getFirstToken()) {
                jJTreeNode.print(token2, jJTreeIO);
            }
            jJTreeNode2.jjtAccept(this, jJTreeIO);
            token2 = jJTreeNode2.getLastToken();
        }
        while (token2 != jJTreeNode.getLastToken()) {
            token2 = token2.next;
            jJTreeNode.print(token2, jJTreeIO);
        }
        return null;
    }

    static void openJJTreeComment(JJTreeIO jJTreeIO, String string) {
        if (string != null) {
            jJTreeIO.print("/*@bgen(jjtree) " + string + " */");
        } else {
            jJTreeIO.print("/*@bgen(jjtree)*/");
        }
    }

    static void closeJJTreeComment(JJTreeIO jJTreeIO) {
        jJTreeIO.print("/*@egen*/");
    }

    String getIndentation(JJTreeNode jJTreeNode) {
        return this.getIndentation(jJTreeNode, 0);
    }

    String getIndentation(JJTreeNode jJTreeNode, int n) {
        Object object = "";
        for (int i = n + 1; i < jJTreeNode.getFirstToken().beginColumn; ++i) {
            object = (String)object + " ";
        }
        return object;
    }

    void insertOpenNodeDeclaration(NodeScope nodeScope, JJTreeIO jJTreeIO, String string) {
        this.insertOpenNodeCode(nodeScope, jJTreeIO, string);
    }

    void insertOpenNodeCode(NodeScope nodeScope, JJTreeIO jJTreeIO, String string) {
        String string2;
        String string3 = nodeScope.m_node_descriptor.getNodeType();
        String string4 = JJTreeOptions.getNodeClass().length() > 0 && !JJTreeOptions.isMulti() ? JJTreeOptions.getNodeClass() : string3;
        NodeFilesJava.ensure(jJTreeIO, string3);
        jJTreeIO.print(string + string4 + " " + nodeScope.m_nodeVar + " = ");
        String string5 = string2 = JJTreeOptions.isNodeUsesParser() ? "this, " : "";
        if (JJTreeOptions.getNodeFactory().equals("*")) {
            jJTreeIO.println("(" + string4 + ")" + string4 + ".jjtCreate(" + string2 + nodeScope.m_node_descriptor.getNodeId() + ");");
        } else if (JJTreeOptions.getNodeFactory().length() > 0) {
            jJTreeIO.println("(" + string4 + ")" + JJTreeOptions.getNodeFactory() + ".jjtCreate(" + string2 + nodeScope.m_node_descriptor.getNodeId() + ");");
        } else {
            jJTreeIO.println("new " + string4 + "(" + string2 + nodeScope.m_node_descriptor.getNodeId() + ");");
        }
        if (nodeScope.usesCloseNodeVar()) {
            jJTreeIO.println(string + "boolean " + nodeScope.m_closedVar + " = true;");
        }
        jJTreeIO.println(string + nodeScope.m_node_descriptor.openNode(nodeScope.m_nodeVar));
        if (JJTreeOptions.isNodeScopeHook()) {
            jJTreeIO.println(string + "jjtreeOpenNodeScope(" + nodeScope.m_nodeVar + ");");
        }
        if (JJTreeOptions.isTrackTokens()) {
            jJTreeIO.println(string + nodeScope.m_nodeVar + ".jjtSetFirstToken(getToken(1));");
        }
    }

    void insertCloseNodeCode(NodeScope nodeScope, JJTreeIO jJTreeIO, String string, boolean bl) {
        String string2 = nodeScope.m_node_descriptor.closeNode(nodeScope.m_nodeVar);
        jJTreeIO.println(string + string2);
        if (nodeScope.usesCloseNodeVar() && !bl) {
            jJTreeIO.println(string + nodeScope.m_closedVar + " = false;");
        }
        if (JJTreeOptions.isNodeScopeHook()) {
            jJTreeIO.println(string + "if (jjtree.nodeCreated()) {");
            jJTreeIO.println(string + " jjtreeCloseNodeScope(" + nodeScope.m_nodeVar + ");");
            jJTreeIO.println(string + "}");
        }
        if (JJTreeOptions.isTrackTokens()) {
            jJTreeIO.println(string + nodeScope.m_nodeVar + ".jjtSetLastToken(getToken(0));");
        }
    }

    void insertOpenNodeAction(NodeScope nodeScope, JJTreeIO jJTreeIO, String string) {
        jJTreeIO.println(string + "{");
        this.insertOpenNodeCode(nodeScope, jJTreeIO, string + "  ");
        jJTreeIO.println(string + "}");
    }

    void insertCloseNodeAction(NodeScope nodeScope, JJTreeIO jJTreeIO, String string) {
        jJTreeIO.println(string + "{");
        this.insertCloseNodeCode(nodeScope, jJTreeIO, string + "  ", false);
        jJTreeIO.println(string + "}");
    }

    private void insertCatchBlocks(NodeScope nodeScope, JJTreeIO jJTreeIO, Collection<String> collection, String string) {
        if (!collection.isEmpty()) {
            jJTreeIO.println(string + "} catch (Throwable " + nodeScope.m_exceptionVar + ") {");
            if (nodeScope.usesCloseNodeVar()) {
                jJTreeIO.println(string + "  if (" + nodeScope.m_closedVar + ") {");
                jJTreeIO.println(string + "    jjtree.clearNodeScope(" + nodeScope.m_nodeVar + ");");
                jJTreeIO.println(string + "    " + nodeScope.m_closedVar + " = false;");
                jJTreeIO.println(string + "  } else {");
                jJTreeIO.println(string + "    jjtree.popNode();");
                jJTreeIO.println(string + "  }");
            }
            for (String string2 : collection) {
                jJTreeIO.println(string + "  if (" + nodeScope.m_exceptionVar + " instanceof " + string2 + ") {");
                jJTreeIO.println(string + "    throw (" + string2 + ")" + nodeScope.m_exceptionVar + ";");
                jJTreeIO.println(string + "  }");
            }
            jJTreeIO.println(string + "  throw (Error)" + nodeScope.m_exceptionVar + ";");
        }
    }

    void tryTokenSequence(NodeScope nodeScope, JJTreeIO jJTreeIO, String string, Token token, Token token2) {
        jJTreeIO.println(string + "try {");
        CodeGeneratorJava.closeJJTreeComment(jJTreeIO);
        Token token3 = token;
        while (token3 != token2.next) {
            TokenUtils.print(token3, jJTreeIO, "jjtThis", nodeScope.m_nodeVar);
            token3 = token3.next;
        }
        CodeGeneratorJava.openJJTreeComment(jJTreeIO, null);
        jJTreeIO.println();
        this.insertCatchBlocks(nodeScope, jJTreeIO, nodeScope.m_production.m_throws_list, string);
        jJTreeIO.println(string + "} finally {");
        if (nodeScope.usesCloseNodeVar()) {
            jJTreeIO.println(string + "  if (" + nodeScope.m_closedVar + ") {");
            this.insertCloseNodeCode(nodeScope, jJTreeIO, string + "    ", true);
            jJTreeIO.println(string + "  }");
        }
        jJTreeIO.println(string + "}");
        CodeGeneratorJava.closeJJTreeComment(jJTreeIO);
    }

    private static void findThrown(NodeScope nodeScope, Map<String, String> map, JJTreeNode jJTreeNode) {
        String string;
        JJTreeNode jJTreeNode2;
        if (jJTreeNode instanceof ASTBNFNonTerminal && (jJTreeNode2 = JJTreeGlobals.s_productions.get(string = jJTreeNode.getFirstToken().image)) != null) {
            for (String string2 : jJTreeNode2.m_throws_list) {
                map.put(string2, string2);
            }
        }
        for (int i = 0; i < jJTreeNode.jjtGetNumChildren(); ++i) {
            jJTreeNode2 = (JJTreeNode)jJTreeNode.jjtGetChild(i);
            CodeGeneratorJava.findThrown(nodeScope, map, jJTreeNode2);
        }
    }

    void tryExpansionUnit(NodeScope nodeScope, JJTreeIO jJTreeIO, String string, JJTreeNode jJTreeNode) {
        jJTreeIO.println(string + "try {");
        CodeGeneratorJava.closeJJTreeComment(jJTreeIO);
        jJTreeNode.jjtAccept(this, jJTreeIO);
        CodeGeneratorJava.openJJTreeComment(jJTreeIO, null);
        jJTreeIO.println();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        CodeGeneratorJava.findThrown(nodeScope, linkedHashMap, jJTreeNode);
        this.insertCatchBlocks(nodeScope, jJTreeIO, linkedHashMap.keySet(), string);
        jJTreeIO.println(string + "} finally {");
        if (nodeScope.usesCloseNodeVar()) {
            jJTreeIO.println(string + "  if (" + nodeScope.m_closedVar + ") {");
            this.insertCloseNodeCode(nodeScope, jJTreeIO, string + "    ", true);
            jJTreeIO.println(string + "  }");
        }
        jJTreeIO.println(string + "}");
        CodeGeneratorJava.closeJJTreeComment(jJTreeIO);
    }
}

