/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjtree;

import com.helger.base.string.StringHelper;
import com.helger.pgcc.EJDKVersion;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.Options;
import java.io.File;

public class JJTreeOptions
extends Options {
    protected JJTreeOptions() {
    }

    public static void init() {
        Options.init();
        Options.s_optionValues.put("MULTI", Boolean.FALSE);
        Options.s_optionValues.put("NODE_DEFAULT_VOID", Boolean.FALSE);
        Options.s_optionValues.put("NODE_SCOPE_HOOK", Boolean.FALSE);
        Options.s_optionValues.put("NODE_USES_PARSER", Boolean.FALSE);
        Options.s_optionValues.put("BUILD_NODE_FILES", Boolean.TRUE);
        Options.s_optionValues.put("VISITOR", Boolean.FALSE);
        Options.s_optionValues.put("VISITOR_METHOD_NAME_INCLUDES_TYPE_NAME", Boolean.FALSE);
        Options.s_optionValues.put("TRACK_TOKENS", Boolean.FALSE);
        Options.s_optionValues.put("NODE_PREFIX", "AST");
        Options.s_optionValues.put("NODE_PACKAGE", "");
        Options.s_optionValues.put("NODE_EXTENDS", "");
        Options.s_optionValues.put("NODE_CLASS", "");
        Options.s_optionValues.put("NODE_FACTORY", "");
        Options.s_optionValues.put("NODE_INCLUDES", "");
        Options.s_optionValues.put("OUTPUT_FILE", "");
        Options.s_optionValues.put("VISITOR_DATA_TYPE", "");
        Options.s_optionValues.put("VISITOR_RETURN_TYPE", "Object");
        Options.s_optionValues.put("VISITOR_EXCEPTION", "");
        Options.s_optionValues.put("JJTREE_OUTPUT_DIRECTORY", "");
        Options.s_optionValues.put("JDK_VERSION", (Object)EJDKVersion.DEFAULT);
        Options.s_optionValues.put("NAMESPACE", "");
        Options.s_optionValues.put("IGNORE_ACTIONS", Boolean.FALSE);
    }

    public static void validate() {
        if (!JJTreeOptions.isVisitor()) {
            if (JJTreeOptions.getVisitorDataType().length() > 0) {
                JavaCCErrors.warning("VISITOR_DATA_TYPE option will be ignored since VISITOR is false");
            }
            if (JJTreeOptions.getVisitorReturnType().length() > 0 && !JJTreeOptions.getVisitorReturnType().equals("Object")) {
                JavaCCErrors.warning("VISITOR_RETURN_TYPE option will be ignored since VISITOR is false");
            }
            if (JJTreeOptions.getVisitorException().length() > 0) {
                JavaCCErrors.warning("VISITOR_EXCEPTION option will be ignored since VISITOR is false");
            }
        }
    }

    public static boolean isMulti() {
        return JJTreeOptions.booleanValue("MULTI");
    }

    public static boolean isNodeDefaultVoid() {
        return JJTreeOptions.booleanValue("NODE_DEFAULT_VOID");
    }

    public static boolean isNodeScopeHook() {
        return JJTreeOptions.booleanValue("NODE_SCOPE_HOOK");
    }

    public static String getNodeFactory() {
        return JJTreeOptions.stringValue("NODE_FACTORY");
    }

    public static boolean isNodeUsesParser() {
        return JJTreeOptions.booleanValue("NODE_USES_PARSER");
    }

    public static boolean isBuildNodeFiles() {
        return JJTreeOptions.booleanValue("BUILD_NODE_FILES");
    }

    public static boolean isVisitor() {
        return JJTreeOptions.booleanValue("VISITOR");
    }

    public static boolean isTrackTokens() {
        return JJTreeOptions.booleanValue("TRACK_TOKENS");
    }

    public static String getNodePrefix() {
        return JJTreeOptions.stringValue("NODE_PREFIX");
    }

    public static String getNodeExtends() {
        return JJTreeOptions.stringValue("NODE_EXTENDS");
    }

    public static String getNodeClass() {
        return JJTreeOptions.stringValue("NODE_CLASS");
    }

    public static String getNodePackage() {
        return JJTreeOptions.stringValue("NODE_PACKAGE");
    }

    public static String getOutputFile() {
        return JJTreeOptions.stringValue("OUTPUT_FILE");
    }

    public static String getVisitorException() {
        return JJTreeOptions.stringValue("VISITOR_EXCEPTION");
    }

    public static String getVisitorDataType() {
        return JJTreeOptions.stringValue("VISITOR_DATA_TYPE");
    }

    public static String getVisitorReturnType() {
        return JJTreeOptions.stringValue("VISITOR_RETURN_TYPE");
    }

    public static File getJJTreeOutputDirectory() {
        String string = JJTreeOptions.stringValue("JJTREE_OUTPUT_DIRECTORY");
        if (StringHelper.isEmpty((String)string)) {
            return JJTreeOptions.getOutputDirectory();
        }
        return new File(string);
    }
}

