/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjtree;

import com.helger.pgcc.jjtree.ASTBNFDeclaration;
import com.helger.pgcc.jjtree.ASTBNFNodeScope;
import com.helger.pgcc.jjtree.ASTExpansionNodeScope;
import com.helger.pgcc.jjtree.ASTNodeDescriptor;
import com.helger.pgcc.jjtree.ASTProduction;
import com.helger.pgcc.jjtree.JJTreeOptions;
import com.helger.pgcc.jjtree.Node;
import jakarta.annotation.Nullable;

public class NodeScope {
    ASTProduction m_production;
    ASTNodeDescriptor m_node_descriptor;
    String m_closedVar;
    String m_exceptionVar;
    String m_nodeVar;
    int m_scopeNumber;

    NodeScope(ASTProduction aSTProduction, @Nullable ASTNodeDescriptor aSTNodeDescriptor) {
        this.m_production = aSTProduction;
        if (aSTNodeDescriptor == null) {
            String string = this.m_production.m_name;
            if (JJTreeOptions.isNodeDefaultVoid()) {
                string = "void";
            }
            this.m_node_descriptor = ASTNodeDescriptor.indefinite(string);
        } else {
            this.m_node_descriptor = aSTNodeDescriptor;
        }
        this.m_scopeNumber = this.m_production.getNodeScopeNumber(this);
        this.m_nodeVar = this.constructVariable("n");
        this.m_closedVar = this.constructVariable("c");
        this.m_exceptionVar = this.constructVariable("e");
    }

    boolean isVoid() {
        return this.m_node_descriptor.isVoid();
    }

    ASTNodeDescriptor getNodeDescriptor() {
        return this.m_node_descriptor;
    }

    String getNodeDescriptorText() {
        return this.m_node_descriptor.getDescriptor();
    }

    String getNodeVariable() {
        return this.m_nodeVar;
    }

    private String constructVariable(String string) {
        String string2 = "000" + this.m_scopeNumber;
        return "jjt" + string + string2.substring(string2.length() - 3, string2.length());
    }

    boolean usesCloseNodeVar() {
        return true;
    }

    @Nullable
    static NodeScope getEnclosingNodeScope(Node node) {
        if (node instanceof ASTBNFDeclaration) {
            return ((ASTBNFDeclaration)node).m_node_scope;
        }
        for (Node node2 = node.jjtGetParent(); node2 != null; node2 = node2.jjtGetParent()) {
            if (node2 instanceof ASTBNFDeclaration) {
                return ((ASTBNFDeclaration)node2).m_node_scope;
            }
            if (node2 instanceof ASTBNFNodeScope) {
                return ((ASTBNFNodeScope)node2).m_node_scope;
            }
            if (!(node2 instanceof ASTExpansionNodeScope)) continue;
            return ((ASTExpansionNodeScope)node2).m_node_scope;
        }
        return null;
    }
}

