/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjtree;

import com.helger.pgcc.jjtree.JJTreeIO;
import com.helger.pgcc.jjtree.JJTreeNode;
import com.helger.pgcc.jjtree.Token;
import com.helger.pgcc.parser.JavaCCErrors;
import jakarta.annotation.Nonnull;

public final class TokenUtils {
    private TokenUtils() {
    }

    static void print(Token token, JJTreeIO jJTreeIO, String string, String string2) {
        Token token2 = token.specialToken;
        if (token2 != null) {
            while (token2.specialToken != null) {
                token2 = token2.specialToken;
            }
            while (token2 != null) {
                jJTreeIO.print(TokenUtils.addUnicodeEscapes(token2.image));
                token2 = token2.next;
            }
        }
        String string3 = token.image;
        if (string != null && string3.equals(string)) {
            string3 = string2;
        }
        jJTreeIO.print(TokenUtils.addUnicodeEscapes(string3));
    }

    static void print(Token token, JJTreeIO jJTreeIO) {
        TokenUtils.print(token, jJTreeIO, null, null);
    }

    static String addUnicodeEscapes(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (char c : string.toCharArray()) {
            if ((c < ' ' || c > '~') && c != '\t' && c != '\n' && c != '\r' && c != '\f') {
                String string2 = "0000" + Integer.toString(c, 16);
                stringBuilder.append("\\u").append(string2.substring(string2.length() - 4, string2.length()));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static boolean hasTokens(@Nonnull JJTreeNode jJTreeNode) {
        return jJTreeNode.getLastToken().next != jJTreeNode.getFirstToken();
    }

    static String remove_escapes_and_quotes(Token token, String string) {
        Object object = "";
        int n = 1;
        while (n < string.length() - 1) {
            int n2;
            char c;
            if (string.charAt(n) != '\\') {
                object = (String)object + string.charAt(n);
                ++n;
                continue;
            }
            if ((c = string.charAt(++n)) == 'b') {
                object = (String)object + "\b";
                ++n;
                continue;
            }
            if (c == 't') {
                object = (String)object + "\t";
                ++n;
                continue;
            }
            if (c == 'n') {
                object = (String)object + "\n";
                ++n;
                continue;
            }
            if (c == 'f') {
                object = (String)object + "\f";
                ++n;
                continue;
            }
            if (c == 'r') {
                object = (String)object + "\r";
                ++n;
                continue;
            }
            if (c == '\"') {
                object = (String)object + "\"";
                ++n;
                continue;
            }
            if (c == '\'') {
                object = (String)object + "'";
                ++n;
                continue;
            }
            if (c == '\\') {
                object = (String)object + "\\";
                ++n;
                continue;
            }
            if (c >= '0' && c <= '7') {
                char c2;
                n2 = c - 48;
                if ((c2 = string.charAt(++n)) >= '0' && c2 <= '7') {
                    n2 = n2 * 8 + c2 - 48;
                    c2 = string.charAt(++n);
                    if (c <= '3' && c2 >= '0' && c2 <= '7') {
                        n2 = n2 * 8 + c2 - 48;
                        ++n;
                    }
                }
                object = (String)object + (char)n2;
                continue;
            }
            if (c == 'u') {
                if (TokenUtils._isHexchar(c = string.charAt(++n))) {
                    n2 = TokenUtils._getHexVal(c);
                    if (TokenUtils._isHexchar(c = string.charAt(++n))) {
                        n2 = n2 * 16 + TokenUtils._getHexVal(c);
                        if (TokenUtils._isHexchar(c = string.charAt(++n))) {
                            n2 = n2 * 16 + TokenUtils._getHexVal(c);
                            if (TokenUtils._isHexchar(c = string.charAt(++n))) {
                                n2 = n2 * 16 + TokenUtils._getHexVal(c);
                                ++n;
                                continue;
                            }
                        }
                    }
                }
                JavaCCErrors.parse_error(token, "Encountered non-hex character '" + c + "' at position " + n + " of string - Unicode escape must have 4 hex digits after it.");
                return object;
            }
            JavaCCErrors.parse_error(token, "Illegal escape sequence '\\" + c + "' at position " + n + " of string.");
            return object;
        }
        return object;
    }

    private static boolean _isHexchar(char c) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c >= 'A' && c <= 'F') {
            return true;
        }
        return c >= 'a' && c <= 'f';
    }

    private static int _getHexVal(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return c - 97 + 10;
    }
}

