/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjtree.output;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.string.StringHelper;
import com.helger.pgcc.PGVersion;
import com.helger.pgcc.jjtree.ASTNodeDescriptor;
import com.helger.pgcc.jjtree.JJTreeGlobals;
import com.helger.pgcc.jjtree.JJTreeIO;
import com.helger.pgcc.jjtree.JJTreeOptions;
import com.helger.pgcc.output.OutputFile;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.utils.OutputFileGenerator;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Immutable
public final class NodeFilesJava {
    private static final String s_nodeVersion = PGVersion.MAJOR_DOT_MINOR;
    private static final Set<String> s_nodesGenerated = new HashSet<String>();

    private NodeFilesJava() {
    }

    public static void ensure(JJTreeIO jJTreeIO, String string) {
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".java");
        if (!string.equals("Node")) {
            if (string.equals("SimpleNode")) {
                NodeFilesJava.ensure(jJTreeIO, "Node");
            } else {
                NodeFilesJava.ensure(jJTreeIO, "SimpleNode");
            }
        }
        if (!string.equals("Node") && !JJTreeOptions.isBuildNodeFiles()) {
            return;
        }
        if (file.exists() && s_nodesGenerated.contains(file.getName())) {
            return;
        }
        String[] stringArray = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        try (OutputFile outputFile = new OutputFile(file, s_nodeVersion, stringArray);){
            outputFile.setToolName("JJTree");
            s_nodesGenerated.add(file.getName());
            if (!outputFile.needToWrite()) {
                return;
            }
            if (string.equals("Node")) {
                NodeFilesJava._generateNode_java(outputFile);
            } else if (string.equals("SimpleNode")) {
                NodeFilesJava._generateSimpleNode_java(outputFile);
            } else {
                NodeFilesJava._generateMultiNode_java(outputFile, string);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    static void generatePrologue(PrintWriter printWriter) {
        if (StringHelper.isNotEmpty((String)JJTreeGlobals.s_nodePackageName)) {
            printWriter.println("package " + JJTreeGlobals.s_nodePackageName + ";");
            printWriter.println();
            if (!JJTreeGlobals.s_nodePackageName.equals(JJTreeGlobals.s_packageName)) {
                printWriter.println("import " + JJTreeGlobals.s_packageName + ".*;");
                printWriter.println();
            }
        }
    }

    public static String nodeConstants() {
        return JJTreeGlobals.s_parserName + "TreeConstants";
    }

    public static void generateTreeConstants_java() {
        String string = NodeFilesJava.nodeConstants();
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".java");
        try (OutputFile outputFile = new OutputFile(file);
             PrintWriter printWriter = outputFile.getPrintWriter();){
            String string2;
            int n;
            List<String> list = ASTNodeDescriptor.getNodeIds();
            List<String> list2 = ASTNodeDescriptor.getNodeNames();
            NodeFilesJava.generatePrologue(printWriter);
            printWriter.println("public interface " + string);
            printWriter.println("{");
            for (n = 0; n < list.size(); ++n) {
                string2 = list.get(n);
                printWriter.println("  public int " + string2 + " = " + n + ";");
            }
            printWriter.println();
            printWriter.println();
            printWriter.println("  public String[] jjtNodeName = {");
            for (n = 0; n < list2.size(); ++n) {
                string2 = list2.get(n);
                printWriter.println("    \"" + string2 + "\",");
            }
            printWriter.println("  };");
            printWriter.println("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    static String visitorClass() {
        return JJTreeGlobals.s_parserName + "Visitor";
    }

    public static void generateVisitor_java() {
        if (!JJTreeOptions.isVisitor()) {
            return;
        }
        String string = NodeFilesJava.visitorClass();
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".java");
        try (OutputFile outputFile = new OutputFile(file);
             PrintWriter printWriter = outputFile.getPrintWriter();){
            List<String> list = ASTNodeDescriptor.getNodeNames();
            NodeFilesJava.generatePrologue(printWriter);
            printWriter.println("public interface " + string);
            printWriter.println("{");
            String string2 = NodeFilesJava._mergeVisitorException();
            String string3 = StringHelper.isNotEmpty((String)JJTreeOptions.getVisitorDataType()) ? JJTreeOptions.getVisitorDataType() : "Object";
            printWriter.println("  public " + JJTreeOptions.getVisitorReturnType() + " visit(SimpleNode node, " + string3 + " data)" + string2 + ";");
            if (JJTreeOptions.isMulti()) {
                for (int i = 0; i < list.size(); ++i) {
                    String string4 = list.get(i);
                    if (string4.equals("void")) continue;
                    String string5 = JJTreeOptions.getNodePrefix() + string4;
                    printWriter.println("  public " + JJTreeOptions.getVisitorReturnType() + " " + NodeFilesJava._getVisitMethodName(string5) + "(" + string5 + " node, " + string3 + " data)" + string2 + ";");
                }
            }
            printWriter.println("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    static String defaultVisitorClass() {
        return JJTreeGlobals.s_parserName + "DefaultVisitor";
    }

    private static String _getVisitMethodName(String string) {
        StringBuilder stringBuilder = new StringBuilder("visit");
        if (Options.booleanValue("VISITOR_METHOD_NAME_INCLUDES_TYPE_NAME")) {
            stringBuilder.append(Character.toUpperCase(string.charAt(0)));
            stringBuilder.append(string.substring(1));
        }
        return stringBuilder.toString();
    }

    public static void generateDefaultVisitor_java() {
        if (!JJTreeOptions.isVisitor()) {
            return;
        }
        String string = NodeFilesJava.defaultVisitorClass();
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".java");
        try (OutputFile outputFile = new OutputFile(file);
             PrintWriter printWriter = outputFile.getPrintWriter();){
            List<String> list = ASTNodeDescriptor.getNodeNames();
            NodeFilesJava.generatePrologue(printWriter);
            printWriter.println("public class " + string + " implements " + NodeFilesJava.visitorClass() + "{");
            String string2 = NodeFilesJava._mergeVisitorException();
            String string3 = StringHelper.isNotEmpty((String)JJTreeOptions.getVisitorDataType()) ? JJTreeOptions.getVisitorDataType() : "Object";
            String string4 = JJTreeOptions.getVisitorReturnType();
            printWriter.println("  public " + string4 + " defaultVisit(final SimpleNode node, final " + string3 + " data)" + string2 + "{");
            printWriter.println("    node.childrenAccept(this, data);");
            printWriter.println("    return" + (string4.trim().equals("void") ? "" : " data") + ";");
            printWriter.println("  }");
            printWriter.println("  public " + string4 + " visit(final SimpleNode node, final " + string3 + " data)" + string2 + "{");
            printWriter.println("    " + (string4.trim().equals("void") ? "" : "return ") + "defaultVisit(node, data);");
            printWriter.println("  }");
            if (JJTreeOptions.isMulti()) {
                for (int i = 0; i < list.size(); ++i) {
                    String string5 = list.get(i);
                    if (string5.equals("void")) continue;
                    String string6 = JJTreeOptions.getNodePrefix() + string5;
                    printWriter.println("  public " + string4 + " " + NodeFilesJava._getVisitMethodName(string6) + "(" + string6 + " node, " + string3 + " data)" + string2 + "{");
                    printWriter.println("    " + (string4.trim().equals("void") ? "" : "return ") + "defaultVisit(node, data);");
                    printWriter.println("  }");
                }
            }
            printWriter.println("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private static String _mergeVisitorException() {
        Object object = JJTreeOptions.getVisitorException();
        if (StringHelper.isNotEmpty((String)object)) {
            object = " throws " + (String)object;
        }
        return object;
    }

    private static void _generateNode_java(OutputFile outputFile) throws IOException {
        try (PrintWriter printWriter = outputFile.getPrintWriter();){
            NodeFilesJava.generatePrologue(printWriter);
            Map<String, Object> map = Options.getAllOptions();
            map.put("PARSER_NAME", JJTreeGlobals.s_parserName);
            OutputFileGenerator outputFileGenerator = new OutputFileGenerator("/templates/jjtree/java/Node.template", map);
            outputFileGenerator.generate(printWriter);
        }
    }

    private static void _generateSimpleNode_java(OutputFile outputFile) throws IOException {
        try (PrintWriter printWriter = outputFile.getPrintWriter();){
            NodeFilesJava.generatePrologue(printWriter);
            Map<String, Object> map = Options.getAllOptions();
            map.put("PARSER_NAME", JJTreeGlobals.s_parserName);
            map.put("VISITOR_RETURN_TYPE_VOID", JJTreeOptions.getVisitorReturnType().equals("void"));
            OutputFileGenerator outputFileGenerator = new OutputFileGenerator("/templates/jjtree/java/SimpleNode.template", map);
            outputFileGenerator.generate(printWriter);
        }
    }

    private static void _generateMultiNode_java(OutputFile outputFile, String string) throws IOException {
        try (PrintWriter printWriter = outputFile.getPrintWriter();){
            NodeFilesJava.generatePrologue(printWriter);
            Map<String, Object> map = Options.getAllOptions();
            map.put("PARSER_NAME", JJTreeGlobals.s_parserName);
            map.put("NODE_TYPE", string);
            map.put("VISITOR_RETURN_TYPE_VOID", JJTreeOptions.getVisitorReturnType().equals("void"));
            OutputFileGenerator outputFileGenerator = new OutputFileGenerator("/templates/jjtree/java/MultiNode.template", map);
            outputFileGenerator.generate(printWriter);
        }
    }
}

