/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.output;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EOutputLanguage implements IHasID<String>
{
    JAVA("java"){

        @Override
        public String getTypeLong() {
            return "long";
        }

        @Override
        public String getLongValueSuffix() {
            return "L";
        }

        @Override
        public String getTypeBoolean() {
            return "boolean";
        }
    }
    ,
    CPP("c++"){

        @Override
        public String getTypeLong() {
            return "unsigned long long";
        }

        @Override
        public String getLongValueSuffix() {
            return "ULL";
        }

        @Override
        public String getTypeBoolean() {
            return "bool";
        }
    };

    private final String m_sID;

    private EOutputLanguage(String string2) {
        this.m_sID = string2;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public abstract String getTypeLong();

    @Nonnull
    @Nonempty
    protected abstract String getLongValueSuffix();

    @Nonnull
    public String getLongHex(long l) {
        return "0x" + Long.toHexString(l) + this.getLongValueSuffix();
    }

    @Nonnull
    public String getLongPlain(long l) {
        return "0x" + Long.toString(l) + this.getLongValueSuffix();
    }

    @Nonnull
    @Nonempty
    public abstract String getTypeBoolean();

    public boolean isJava() {
        return this == JAVA;
    }

    public boolean hasStaticsFile() {
        return this == CPP;
    }

    public boolean hasIncludeFile() {
        return this == CPP;
    }

    @Nullable
    public static EOutputLanguage getFromIDCaseInsensitiveOrNull(@Nullable String string) {
        return (EOutputLanguage)EnumHelper.getFromIDCaseInsensitiveOrNull(EOutputLanguage.class, (String)string);
    }
}

