/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.output;

import com.helger.annotation.WillCloseWhenClosed;
import com.helger.base.io.nonblocking.NonBlockingBufferedReader;
import com.helger.base.io.stream.NullOutputStream;
import com.helger.base.string.StringHex;
import com.helger.io.file.FileHelper;
import com.helger.pgcc.PGPrinter;
import com.helger.pgcc.PGVersion;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.Options;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class OutputFile
implements AutoCloseable {
    private static final String OPTIONS_PREFIX = "ParserGeneratorCCOptions";
    private static final String MD5_LINE_PART_1 = "/* ParserGeneratorCC - OriginalChecksum=";
    private static final String MD5_LINE_PART_1Q = "/\\* ParserGeneratorCC - OriginalChecksum=";
    private static final String MD5_LINE_PART_2 = " (do not edit this line) */";
    private static final String MD5_LINE_PART_2Q = " \\(do not edit this line\\) \\*/";
    private TrapClosePrintWriter m_aPW;
    private DigestOutputStream m_dos;
    private String m_sToolName;
    private final File m_aFile;
    private final String m_sCompatibleVersion;
    private final String[] m_aOptions;
    private boolean m_bNeedToWrite;

    public OutputFile(File file, String string, String[] stringArray) throws IOException {
        block30: {
            this.m_sToolName = "ParserGeneratorCC";
            this.m_bNeedToWrite = true;
            this.m_aFile = file;
            this.m_sCompatibleVersion = string;
            this.m_aOptions = stringArray;
            if (file.exists()) {
                try (NonBlockingBufferedReader nonBlockingBufferedReader = FileHelper.getBufferedReader((File)file, (Charset)Options.getOutputEncoding());){
                    MessageDigest messageDigest;
                    try {
                        messageDigest = MessageDigest.getInstance("MD5");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new IOException("No MD5 implementation", noSuchAlgorithmException);
                    }
                    try (DigestOutputStream digestOutputStream = new DigestOutputStream((OutputStream)new NullOutputStream(), messageDigest);
                         OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)digestOutputStream, Options.getOutputEncoding());
                         PrintWriter printWriter = new PrintWriter(outputStreamWriter);){
                        String string2;
                        String string3 = null;
                        while ((string2 = nonBlockingBufferedReader.readLine()) != null) {
                            if (string2.startsWith(MD5_LINE_PART_1)) {
                                string3 = string2.replaceAll(MD5_LINE_PART_1Q, "").replaceAll(MD5_LINE_PART_2Q, "");
                                continue;
                            }
                            printWriter.println(string2);
                        }
                        String string4 = StringHex.getHexEncoded((byte[])digestOutputStream.getMessageDigest().digest());
                        if (string3 == null || !string3.equals(string4)) {
                            this.m_bNeedToWrite = false;
                            if (string != null) {
                                this._checkVersion(file, string);
                            }
                            if (stringArray != null) {
                                this._checkOptions(file, stringArray);
                            }
                        } else {
                            PGPrinter.info("File \"" + file.getName() + "\" is being rebuilt.");
                            this.m_bNeedToWrite = true;
                        }
                        break block30;
                    }
                }
            }
            PGPrinter.info("File \"" + file.getName() + "\" does not exist.  Will create one.");
            this.m_bNeedToWrite = true;
        }
    }

    public OutputFile(File file) throws IOException {
        this(file, null, null);
    }

    private void _checkVersion(File file, String string) {
        String string2 = "/* " + JavaCCGlobals.getIdString(this.m_sToolName, file.getName()) + " Version ";
        try (NonBlockingBufferedReader nonBlockingBufferedReader = FileHelper.getBufferedReader((File)file, (Charset)Options.getOutputEncoding());){
            String string3;
            while ((string3 = nonBlockingBufferedReader.readLine()) != null) {
                if (!string3.startsWith(string2)) continue;
                String string4 = string3.replaceFirst(".*Version ", "").replace(" */", "");
                if (!string4.equals(string)) {
                    JavaCCErrors.warning(file.getName() + ": File is obsolete.  Please rename or delete this file so that a new one can be generated for you.");
                    JavaCCErrors.warning(file.getName() + " file   version: " + string4 + " javacc version: " + string);
                }
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JavaCCErrors.semantic_error("Could not open file " + file.getName() + " for writing.");
            throw new UncheckedIOException(fileNotFoundException);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void _checkOptions(File file, String[] stringArray) {
        try (NonBlockingBufferedReader nonBlockingBufferedReader = FileHelper.getBufferedReader((File)file, (Charset)Options.getOutputEncoding());){
            String string;
            while ((string = nonBlockingBufferedReader.readLine()) != null) {
                if (!string.startsWith("/* ParserGeneratorCCOptions:")) continue;
                String string2 = Options.getOptionsString(stringArray);
                if (string.indexOf(string2) == -1) {
                    JavaCCErrors.warning(file.getName() + ": Generated using incompatible options. Please rename or delete this file so that a new one can be generated for you.");
                }
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JavaCCErrors.semantic_error("Could not open file " + file.getName() + " for writing.");
            throw new UncheckedIOException(fileNotFoundException);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @WillCloseWhenClosed
    public PrintWriter getPrintWriter() throws IOException {
        if (this.m_aPW == null) {
            MessageDigest messageDigest = EMessageDigestAlgorithm.MD5.createMessageDigest();
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException("No MD5 implementation", noSuchAlgorithmException);
            }
            this.m_dos = new DigestOutputStream((OutputStream)FileHelper.getBufferedOutputStream((File)this.m_aFile), messageDigest);
            this.m_aPW = new TrapClosePrintWriter(this.m_dos, Options.getOutputEncoding());
            String string = this.m_sCompatibleVersion == null ? PGVersion.VERSION_NUMBER : this.m_sCompatibleVersion;
            this.m_aPW.println("/* " + JavaCCGlobals.getIdString(this.m_sToolName, this.m_aFile.getName()) + " Version " + string + " */");
            if (this.m_aOptions != null) {
                this.m_aPW.println("/* ParserGeneratorCCOptions:" + Options.getOptionsString(this.m_aOptions) + " */");
            }
        }
        return this.m_aPW;
    }

    @Override
    public void close() {
        if (this.m_aPW != null) {
            this.m_aPW.println(MD5_LINE_PART_1 + this._getMD5sum() + MD5_LINE_PART_2);
            this.m_aPW.closePrintWriter();
        }
    }

    private String _getMD5sum() {
        this.m_aPW.flush();
        byte[] byArray = this.m_dos.getMessageDigest().digest();
        return StringHex.getHexEncoded((byte[])byArray);
    }

    public String getToolName() {
        return this.m_sToolName;
    }

    public void setToolName(String string) {
        this.m_sToolName = string;
    }

    public String getPath() {
        return this.m_aFile.getAbsolutePath();
    }

    public boolean needToWrite() {
        return this.m_bNeedToWrite;
    }

    private final class TrapClosePrintWriter
    extends PrintWriter {
        public TrapClosePrintWriter(@Nonnull OutputStream outputStream, Charset charset) {
            super(new OutputStreamWriter(outputStream, charset));
        }

        void closePrintWriter() {
            super.close();
        }

        @Override
        public void close() {
            OutputFile.this.close();
        }
    }
}

