/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.pgcc.parser.CharStream;
import java.io.IOException;

public abstract class AbstractCharStream
implements CharStream {
    public static final int DEFAULT_BUF_SIZE = 4096;
    private int m_nTabSize = 1;
    protected char[] buffer;
    protected int bufsize;
    protected int bufpos;
    protected int available;
    protected int tokenBegin;
    protected int inBuf;
    protected int maxNextCharInd;
    private int[] m_aBufLine;
    private int[] m_aBufColumn;
    private int m_nLineNo;
    private int m_nColumnNo;
    private boolean m_bPrevCharIsCR;
    private boolean m_bPrevCharIsLF;
    private boolean m_bTrackLineColumn = true;

    static final int hexval(char c) throws IOException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IOException("Invalid hex char '" + c + "' (=" + c + ") provided!");
    }

    public AbstractCharStream(int n, int n2, int n3) {
        this.reInit(n, n2, n3);
    }

    public final void reInit(int n, int n2, int n3) {
        this.m_nLineNo = n;
        this.m_nColumnNo = n2 - 1;
        this.m_bPrevCharIsCR = false;
        this.m_bPrevCharIsLF = false;
        if (this.buffer == null || n3 != this.buffer.length) {
            this.bufsize = n3;
            this.available = n3;
            this.buffer = new char[n3];
            this.m_aBufLine = new int[n3];
            this.m_aBufColumn = new int[n3];
        }
        this.maxNextCharInd = 0;
        this.inBuf = 0;
        this.tokenBegin = 0;
        this.bufpos = -1;
    }

    protected abstract int streamRead(char[] var1, int var2, int var3) throws IOException;

    protected abstract void streamClose() throws IOException;

    protected int getBufSizeAfterExpansion() {
        return this.bufsize * 2;
    }

    protected void expandBuff(boolean bl) {
        int n = this.getBufSizeAfterExpansion();
        char[] cArray = new char[n];
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = this.bufsize - this.tokenBegin;
        if (bl) {
            System.arraycopy(this.buffer, this.tokenBegin, cArray, 0, n2);
            System.arraycopy(this.buffer, 0, cArray, n2, this.bufpos);
            this.buffer = cArray;
            System.arraycopy(this.m_aBufLine, this.tokenBegin, nArray, 0, n2);
            System.arraycopy(this.m_aBufLine, 0, nArray, n2, this.bufpos);
            this.m_aBufLine = nArray;
            System.arraycopy(this.m_aBufColumn, this.tokenBegin, nArray2, 0, n2);
            System.arraycopy(this.m_aBufColumn, 0, nArray2, n2, this.bufpos);
            this.m_aBufColumn = nArray2;
            this.bufpos += n2;
            this.maxNextCharInd = this.bufpos;
        } else {
            System.arraycopy(this.buffer, this.tokenBegin, cArray, 0, n2);
            this.buffer = cArray;
            System.arraycopy(this.m_aBufLine, this.tokenBegin, nArray, 0, n2);
            this.m_aBufLine = nArray;
            System.arraycopy(this.m_aBufColumn, this.tokenBegin, nArray2, 0, n2);
            this.m_aBufColumn = nArray2;
            this.bufpos -= this.tokenBegin;
            this.maxNextCharInd = this.bufpos;
        }
        this.bufsize = n;
        this.available = n;
        this.tokenBegin = 0;
    }

    protected final void internalAdjustBuffSize() {
        int n = this.bufsize / 2;
        if (this.available == this.bufsize) {
            if (this.tokenBegin < 0) {
                this.bufpos = 0;
                this.maxNextCharInd = 0;
            } else if (this.tokenBegin > n) {
                this.bufpos = 0;
                this.maxNextCharInd = 0;
                this.available = this.tokenBegin;
            } else {
                this.expandBuff(false);
            }
        } else if (this.available > this.tokenBegin) {
            this.available = this.bufsize;
        } else if (this.tokenBegin - this.available < n) {
            this.expandBuff(true);
        } else {
            this.available = this.tokenBegin;
        }
    }

    protected void fillBuff() throws IOException {
        if (this.maxNextCharInd == this.available) {
            this.internalAdjustBuffSize();
        }
        try {
            int n = this.streamRead(this.buffer, this.maxNextCharInd, this.available - this.maxNextCharInd);
            if (n == -1) {
                this.streamClose();
                throw new IOException("PGCC end of stream");
            }
            this.maxNextCharInd += n;
        }
        catch (IOException iOException) {
            --this.bufpos;
            this.backup(0);
            if (this.tokenBegin == -1) {
                this.tokenBegin = this.bufpos;
            }
            throw iOException;
        }
    }

    protected final void internalSetBufLineColumn(int n, int n2) {
        this.m_aBufLine[this.bufpos] = n;
        this.m_aBufColumn[this.bufpos] = n2;
    }

    protected final void internalUpdateLineColumn(char c) {
        ++this.m_nColumnNo;
        if (this.m_bPrevCharIsLF) {
            this.m_bPrevCharIsLF = false;
            this.m_nColumnNo = 1;
            ++this.m_nLineNo;
        } else if (this.m_bPrevCharIsCR) {
            this.m_bPrevCharIsCR = false;
            if (c == '\n') {
                this.m_bPrevCharIsLF = true;
            } else {
                this.m_nColumnNo = 1;
                ++this.m_nLineNo;
            }
        }
        switch (c) {
            case '\r': {
                this.m_bPrevCharIsCR = true;
                break;
            }
            case '\n': {
                this.m_bPrevCharIsLF = true;
                break;
            }
            case '\t': {
                --this.m_nColumnNo;
                this.m_nColumnNo += this.m_nTabSize - this.m_nColumnNo % this.m_nTabSize;
            }
        }
        this.internalSetBufLineColumn(this.m_nLineNo, this.m_nColumnNo);
    }

    @Override
    public char readChar() throws IOException {
        if (this.inBuf > 0) {
            --this.inBuf;
            ++this.bufpos;
            if (this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            return this.buffer[this.bufpos];
        }
        ++this.bufpos;
        if (this.bufpos >= this.maxNextCharInd) {
            this.fillBuff();
        }
        char c = this.buffer[this.bufpos];
        if (this.m_bTrackLineColumn) {
            this.internalUpdateLineColumn(c);
        }
        return c;
    }

    @Override
    public char beginToken() throws IOException {
        this.tokenBegin = -1;
        char c = this.readChar();
        this.tokenBegin = this.bufpos;
        return c;
    }

    @Override
    public int getBeginColumn() {
        return this.m_aBufColumn[this.tokenBegin];
    }

    @Override
    public int getBeginLine() {
        return this.m_aBufLine[this.tokenBegin];
    }

    @Override
    public int getEndColumn() {
        return this.m_aBufColumn[this.bufpos];
    }

    @Override
    public int getEndLine() {
        return this.m_aBufLine[this.bufpos];
    }

    @Override
    public void backup(int n) {
        if (n > this.bufsize) {
            throw new IllegalStateException("Cannot back " + n + " chars which is larger than the internal buffer size (" + this.bufsize + ")");
        }
        this.inBuf += n;
        this.bufpos -= n;
        if (this.bufpos < 0) {
            this.bufpos += this.bufsize;
        }
    }

    @Override
    public String getImage() {
        if (this.bufpos >= this.tokenBegin) {
            return new String(this.buffer, this.tokenBegin, this.bufpos - this.tokenBegin + 1);
        }
        return new String(this.buffer, this.tokenBegin, this.bufsize - this.tokenBegin) + new String(this.buffer, 0, this.bufpos + 1);
    }

    @Override
    public char[] getSuffix(int n) {
        char[] cArray = new char[n];
        if (this.bufpos + 1 >= n) {
            System.arraycopy(this.buffer, this.bufpos - n + 1, cArray, 0, n);
        } else {
            int n2 = n - this.bufpos - 1;
            System.arraycopy(this.buffer, this.bufsize - n2, cArray, 0, n2);
            System.arraycopy(this.buffer, 0, cArray, n2, this.bufpos + 1);
        }
        return cArray;
    }

    @Override
    public void done() {
        this.buffer = null;
        this.m_aBufLine = null;
        this.m_aBufColumn = null;
    }

    @Override
    public final int getTabSize() {
        return this.m_nTabSize;
    }

    @Override
    public final void setTabSize(int n) {
        this.m_nTabSize = n;
    }

    public final void adjustBeginLineColumn(int n, int n2) {
        int n3;
        int n4 = this.tokenBegin;
        int n5 = n;
        int n6 = this.bufpos >= this.tokenBegin ? this.bufpos - this.tokenBegin + this.inBuf + 1 : this.bufsize - this.tokenBegin + this.bufpos + 1 + this.inBuf;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (n3 = 0; n3 < n6 && this.m_aBufLine[n7 = n4 % this.bufsize] == this.m_aBufLine[n8 = ++n4 % this.bufsize]; ++n3) {
            this.m_aBufLine[n7] = n5;
            n9 = n10 + this.m_aBufColumn[n8] - this.m_aBufColumn[n7];
            this.m_aBufColumn[n7] = n2 + n10;
            n10 = n9;
        }
        if (n3 < n6) {
            this.m_aBufLine[n7] = n5++;
            this.m_aBufColumn[n7] = n2 + n10;
            while (n3++ < n6) {
                n7 = n4 % this.bufsize;
                if (this.m_aBufLine[n7] != this.m_aBufLine[++n4 % this.bufsize]) {
                    this.m_aBufLine[n7] = n5++;
                    continue;
                }
                this.m_aBufLine[n7] = n5;
            }
        }
        this.m_nLineNo = this.m_aBufLine[n7];
        this.m_nColumnNo = this.m_aBufColumn[n7];
    }

    protected final int getLine() {
        return this.m_nLineNo;
    }

    protected final int getColumn() {
        return this.m_nColumnNo;
    }

    @Override
    public final boolean isTrackLineColumn() {
        return this.m_bTrackLineColumn;
    }

    @Override
    public final void setTrackLineColumn(boolean bl) {
        this.m_bTrackLineColumn = bl;
    }
}

