/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.annotation.Nonempty;
import com.helger.base.io.nonblocking.NonBlockingBufferedReader;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringImplode;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.io.file.FileHelper;
import com.helger.pgcc.PGPrinter;
import com.helger.pgcc.PGVersion;
import com.helger.pgcc.output.UnsupportedOutputLanguageException;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.NormalProduction;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.parser.TokenProduction;
import com.helger.pgcc.parser.exp.AbstractExpRegularExpression;
import com.helger.pgcc.parser.exp.ExpAction;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JavaCCGlobals {
    public static String s_fileName;
    public static String s_origFileName;
    public static boolean s_jjtreeGenerated;
    public static List<String> s_toolNames;
    public static String s_cu_name;
    public static final ICommonsList<Token> CU_TO_INSERTION_POINT_1;
    public static final ICommonsList<Token> CU_TO_INSERTION_POINT_2;
    public static final ICommonsList<Token> CU_FROM_INSERTION_POINT_2;
    public static final List<NormalProduction> BNF_PRODUCTIONS;
    public static final Map<String, NormalProduction> PRODUCTION_TABLE;
    public static final Map<String, Integer> LEXSTATE_S2I;
    public static final Map<Integer, String> LEXSTATE_I2S;
    public static ICommonsList<Token> s_token_mgr_decls;
    public static final List<TokenProduction> REXPR_LIST;
    public static int s_tokenCount;
    public static final Map<String, AbstractExpRegularExpression> NAMED_TOKENS_TABLE;
    public static final List<AbstractExpRegularExpression> ORDERED_NAME_TOKENS;
    public static final Map<Integer, String> NAMES_OF_TOKENS;
    public static final Map<Integer, AbstractExpRegularExpression> REXPS_OF_TOKENS;
    public static final Map<String, Map<String, Map<String, AbstractExpRegularExpression>>> SIMPLE_TOKENS_TABLE;
    protected static int s_maskindex;
    protected static int s_jj2index;
    private static boolean s_bLookAheadNeeded;
    protected static final List<int[]> MASK_VALS;
    static ExpAction s_aActForEof;
    static String s_sNextStateForEof;
    private static Token s_aOtherLanguageDeclTokenBeg;
    private static Token s_aOtherLanguageDeclTokenEnd;
    public static int s_cline;
    public static int s_ccol;

    public static void bannerLine(String string, String string2) {
        PGPrinter.info("ParserGeneratorCC Version " + PGVersion.VERSION_NUMBER + " (" + string + (String)(StringHelper.isNotEmpty((String)string2) ? " Version " + string2 : "") + ")");
    }

    public static boolean isLookAheadNeeded() {
        return s_bLookAheadNeeded;
    }

    public static void setLookAheadNeeded(boolean bl) {
        s_bLookAheadNeeded = bl;
    }

    @Nullable
    public static Token getOtherLanguageDeclTokenBegin() {
        return s_aOtherLanguageDeclTokenBeg;
    }

    public static void setOtherLanguageDeclTokenBegin(@Nullable Token token) {
        s_aOtherLanguageDeclTokenBeg = token;
    }

    @Nullable
    public static Token getOtherLanguageDeclTokenEnd() {
        return s_aOtherLanguageDeclTokenEnd;
    }

    public static void setOtherLanguageDeclTokenEnd(@Nullable Token token) {
        s_aOtherLanguageDeclTokenEnd = token;
    }

    public static String getIdString(String string, String string2) {
        return JavaCCGlobals.getIdString((List<String>)new CommonsArrayList((Object)string), string2);
    }

    public static String getIdString(List<String> list, String string) {
        String string2 = "Generated by: " + StringImplode.imploder().source(list).separator('&').build() + ":";
        if (string2.length() > 200) {
            PGPrinter.error("Tool names too long.");
            throw new IllegalStateException("Tool names too long: " + string2);
        }
        return string2 + " Do not edit this line. " + JavaCCGlobals.addUnicodeEscapes(string);
    }

    public static boolean isGeneratedBy(String string, String string2) {
        List<String> list = JavaCCGlobals.getToolNames(string2);
        for (String string3 : list) {
            if (!string.equals(string3)) continue;
            return true;
        }
        return false;
    }

    private static List<String> _makeToolNameList(String string) {
        int n;
        String string2;
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = string.indexOf(10);
        if (n3 == -1) {
            n3 = 1000;
        }
        if ((n2 = string.indexOf(13)) == -1) {
            n2 = 1000;
        }
        if ((string2 = (n = n3 < n2 ? n3 : n2) == 1000 ? string : string.substring(0, n)).indexOf(58) == -1) {
            return arrayList;
        }
        if ((string2 = string2.substring(string2.indexOf(58) + 1)).indexOf(58) == -1) {
            return arrayList;
        }
        string2 = string2.substring(0, string2.indexOf(58));
        int n4 = 0;
        int n5 = 0;
        while (n5 < string2.length() && (n4 = string2.indexOf(38, n5)) != -1) {
            arrayList.add(string2.substring(n5, n4));
            n5 = n4 + 1;
        }
        if (n5 < string2.length()) {
            arrayList.add(string2.substring(n5));
        }
        return arrayList;
    }

    @Nonnull
    public static List<String> getToolNames(String string) {
        block11: {
            List<String> list;
            block10: {
                Charset charset = Options.getOutputEncoding();
                char[] cArray = new char[256];
                int n = 0;
                NonBlockingBufferedReader nonBlockingBufferedReader = FileHelper.getBufferedReader((File)new File(string), (Charset)charset);
                try {
                    int n2;
                    while ((n2 = nonBlockingBufferedReader.read(cArray, n, cArray.length - n)) != -1 && (n += n2) != cArray.length) {
                    }
                    list = JavaCCGlobals._makeToolNameList(new String(cArray, 0, n));
                    if (nonBlockingBufferedReader == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (nonBlockingBufferedReader != null) {
                            try {
                                nonBlockingBufferedReader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        break block11;
                    }
                    catch (IOException iOException) {
                        if (n <= 0) break block11;
                        return JavaCCGlobals._makeToolNameList(new String(cArray, 0, n));
                    }
                }
                nonBlockingBufferedReader.close();
            }
            return list;
        }
        return new ArrayList<String>();
    }

    public static void createOutputDir(File file) {
        if (!file.exists()) {
            JavaCCErrors.warning("Output directory \"" + String.valueOf(file) + "\" does not exist. Creating the directory.");
            if (!file.mkdirs()) {
                JavaCCErrors.semantic_error("Cannot create the output directory : " + String.valueOf(file));
                return;
            }
        }
        if (!file.isDirectory()) {
            JavaCCErrors.semantic_error("\"" + String.valueOf(file) + " is not a valid output directory.");
            return;
        }
        if (!file.canWrite()) {
            JavaCCErrors.semantic_error("Cannot write to the output output directory : \"" + String.valueOf(file) + "\"");
        }
    }

    @Nonnull
    public static String addEscapes(@Nonnull String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (char c : string.toCharArray()) {
            if (c == '\b') {
                stringBuilder.append("\\b");
                continue;
            }
            if (c == '\t') {
                stringBuilder.append("\\t");
                continue;
            }
            if (c == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (c == '\f') {
                stringBuilder.append("\\f");
                continue;
            }
            if (c == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            if (c == '\'') {
                stringBuilder.append("\\'");
                continue;
            }
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c < ' ' || c > '~') {
                String string2 = "0000" + Integer.toString(c, 16);
                stringBuilder.append("\\u").append(string2.substring(string2.length() - 4));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String addUnicodeEscapes(String string) {
        switch (Options.getOutputLanguage()) {
            case JAVA: {
                StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
                for (char c : string.toCharArray()) {
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuilder.append("\\u").append(string2.substring(string2.length() - 4));
                        continue;
                    }
                    stringBuilder.append(c);
                }
                return stringBuilder.toString();
            }
            case CPP: {
                return string;
            }
        }
        throw new UnsupportedOutputLanguageException(Options.getOutputLanguage());
    }

    public static void printTokenSetup(Token token) {
        Token token2 = token;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        s_cline = token2.beginLine;
        s_ccol = token2.beginColumn;
    }

    protected static void printTokenOnly(@Nonnull Token token, @Nonnull PrintWriter printWriter) {
        while (s_cline < token.beginLine) {
            printWriter.println();
            s_ccol = 1;
            ++s_cline;
        }
        while (s_ccol < token.beginColumn) {
            printWriter.print(" ");
            ++s_ccol;
        }
        if (token.kind == 101 || token.kind == 100) {
            printWriter.print(JavaCCGlobals.addUnicodeEscapes(token.image));
        } else {
            printWriter.print(token.image);
        }
        s_cline = token.endLine;
        s_ccol = token.endColumn + 1;
        char c = token.image.charAt(token.image.length() - 1);
        if (c == '\n' || c == '\r') {
            ++s_cline;
            s_ccol = 1;
        }
    }

    public static void printToken(@Nonnull Token token, @Nonnull PrintWriter printWriter) {
        Token token2 = token.specialToken;
        if (token2 != null) {
            while (token2.specialToken != null) {
                token2 = token2.specialToken;
            }
            while (token2 != null) {
                JavaCCGlobals.printTokenOnly(token2, printWriter);
                token2 = token2.next;
            }
        }
        JavaCCGlobals.printTokenOnly(token, printWriter);
    }

    protected static void printTokenList(@Nonnull List<Token> list, @Nonnull PrintWriter printWriter) {
        Token token2 = null;
        for (Token token2 : list) {
            JavaCCGlobals.printToken(token2, printWriter);
        }
        if (token2 != null) {
            JavaCCGlobals.printTrailingComments(token2);
        }
    }

    protected static void printLeadingComments(@Nonnull Token token, @Nonnull PrintWriter printWriter) {
        if (token.specialToken == null) {
            return;
        }
        Token token2 = token.specialToken;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        while (token2 != null) {
            JavaCCGlobals.printTokenOnly(token2, printWriter);
            token2 = token2.next;
        }
        if (s_ccol != 1 && s_cline != token.beginLine) {
            printWriter.println();
            ++s_cline;
            s_ccol = 1;
        }
    }

    @Nonnull
    public static String printTokenOnly(@Nonnull Token token) {
        StringBuilder stringBuilder = new StringBuilder(token.image.length() * 2);
        while (s_cline < token.beginLine) {
            stringBuilder.append('\n');
            s_ccol = 1;
            ++s_cline;
        }
        while (s_ccol < token.beginColumn) {
            stringBuilder.append(' ');
            ++s_ccol;
        }
        if (token.kind == 101 || token.kind == 100) {
            stringBuilder.append(JavaCCGlobals.addUnicodeEscapes(token.image));
        } else {
            stringBuilder.append(token.image);
        }
        s_cline = token.endLine;
        s_ccol = token.endColumn + 1;
        char c = token.image.charAt(token.image.length() - 1);
        if (c == '\n' || c == '\r') {
            ++s_cline;
            s_ccol = 1;
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String printToken(@Nonnull Token token) {
        StringBuilder stringBuilder = new StringBuilder();
        Token token2 = token.specialToken;
        if (token2 != null) {
            while (token2.specialToken != null) {
                token2 = token2.specialToken;
            }
            while (token2 != null) {
                stringBuilder.append(JavaCCGlobals.printTokenOnly(token2));
                token2 = token2.next;
            }
        }
        stringBuilder.append(JavaCCGlobals.printTokenOnly(token));
        return stringBuilder.toString();
    }

    @Nonnull
    protected static String printLeadingComments(@Nonnull Token token) {
        if (token.specialToken == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Token token2 = token.specialToken;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        while (token2 != null) {
            stringBuilder.append(JavaCCGlobals.printTokenOnly(token2));
            token2 = token2.next;
        }
        if (s_ccol != 1 && s_cline != token.beginLine) {
            stringBuilder.append('\n');
            ++s_cline;
            s_ccol = 1;
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String printTrailingComments(@Nonnull Token token) {
        if (token.next == null) {
            return "";
        }
        return JavaCCGlobals.printLeadingComments(token.next);
    }

    public static void reInitStatic() {
        s_fileName = null;
        s_origFileName = null;
        s_jjtreeGenerated = false;
        s_toolNames = null;
        s_cu_name = null;
        CU_TO_INSERTION_POINT_1.clear();
        CU_TO_INSERTION_POINT_2.clear();
        CU_FROM_INSERTION_POINT_2.clear();
        BNF_PRODUCTIONS.clear();
        PRODUCTION_TABLE.clear();
        LEXSTATE_S2I.clear();
        LEXSTATE_I2S.clear();
        s_token_mgr_decls = null;
        REXPR_LIST.clear();
        s_tokenCount = 0;
        NAMED_TOKENS_TABLE.clear();
        ORDERED_NAME_TOKENS.clear();
        NAMES_OF_TOKENS.clear();
        REXPS_OF_TOKENS.clear();
        SIMPLE_TOKENS_TABLE.clear();
        s_maskindex = 0;
        s_jj2index = 0;
        s_bLookAheadNeeded = false;
        MASK_VALS.clear();
        s_cline = 0;
        s_ccol = 0;
        s_aActForEof = null;
        s_sNextStateForEof = null;
    }

    @Nonnull
    @Nonempty
    static String getFileExtension() {
        switch (Options.getOutputLanguage()) {
            case JAVA: {
                return ".java";
            }
            case CPP: {
                return ".cc";
            }
        }
        throw new UnsupportedOutputLanguageException(Options.getOutputLanguage());
    }

    public static String replaceBackslash(@Nonnull String string) {
        if (string.indexOf(92) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (char c : string.toCharArray()) {
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static {
        CU_TO_INSERTION_POINT_1 = new CommonsArrayList();
        CU_TO_INSERTION_POINT_2 = new CommonsArrayList();
        CU_FROM_INSERTION_POINT_2 = new CommonsArrayList();
        BNF_PRODUCTIONS = new ArrayList<NormalProduction>();
        PRODUCTION_TABLE = new HashMap<String, NormalProduction>();
        LEXSTATE_S2I = new HashMap<String, Integer>();
        LEXSTATE_I2S = new HashMap<Integer, String>();
        REXPR_LIST = new ArrayList<TokenProduction>();
        NAMED_TOKENS_TABLE = new HashMap<String, AbstractExpRegularExpression>();
        ORDERED_NAME_TOKENS = new ArrayList<AbstractExpRegularExpression>();
        NAMES_OF_TOKENS = new HashMap<Integer, String>();
        REXPS_OF_TOKENS = new HashMap<Integer, AbstractExpRegularExpression>();
        SIMPLE_TOKENS_TABLE = new HashMap<String, Map<String, Map<String, AbstractExpRegularExpression>>>();
        s_maskindex = 0;
        s_jj2index = 0;
        s_bLookAheadNeeded = false;
        MASK_VALS = new ArrayList<int[]>();
    }
}

